/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidClarificaitonService;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidClarificaitonServiceImpl
extends BidServiceImpl
implements IBidClarificaitonService {
    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        if (bidProject == null || bidProject.get("id") == null) {
            return;
        }
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)bidProject.getLong("id"), (String)"bid_project", (String)"id,entitytypeid");
        String entityTypePre = tempObj.getString("entitytypeid").split("_")[0];
        DynamicObject bidProjectData = null;
        String selectProperties = "name,clarificaitondate,bidmode,evaluatedecideway,org,creator,doctype,setupdate";
        if ("bid".equals(entityTypePre)) {
            bidProjectData = BusinessDataServiceHelper.loadSingle((Object)bidProject.getLong("id"), (String)"bid_project", (String)selectProperties);
        } else if ("rebm".equals(entityTypePre)) {
            bidProjectData = BusinessDataServiceHelper.loadSingle((Object)bidProject.getLong("id"), (String)"rebm_project", (String)selectProperties);
        }
        if (bidProjectData == null) {
            BizLog.log((String)ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u751f\u6210\u62db\u6807\u4ea4\u5e95", (String)"BidClarificaitonServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]));
            return;
        }
        MainEntityType dynObjT = EntityMetadataCache.getDataEntityType((String)"bid_clarificaiton");
        DynamicObject bidClarificaiton = new DynamicObject((DynamicObjectType)dynObjT);
        bidClarificaiton.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHMMSSSSS");
        bidClarificaiton.set("billno", (Object)sdf.format(new Date()));
        bidClarificaiton.set("entitytypeid", (Object)(entityTypePre + "_clarificaiton"));
        bidClarificaiton.set("setupdate", bidProjectData.get("setupdate"));
        bidClarificaiton.set("doctype", bidProjectData.get("doctype"));
        bidClarificaiton.set("clarificaitontime", (Object)bidProjectData.getDate("clarificaitondate"));
        bidClarificaiton.set("clarificaitontheme", (Object)String.format(ResManager.loadKDString((String)"\u5173\u4e8e\u3010%s\u3011\u7684\u62db\u6807\u4ea4\u5e95", (String)"BidClarificaitonServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0]), bidProjectData.getLocaleString("name").getLocaleValue()));
        bidClarificaiton.set("bidproject", bidProjectData.getPkValue());
        bidClarificaiton.set("bidmode", bidProjectData.get("bidmode"));
        bidClarificaiton.set("evaluatedecideway", bidProjectData.get("evaluatedecideway"));
        bidClarificaiton.set("org", bidProjectData.get("org"));
        HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
        DynamicObject creator = creatorMap.get("18");
        bidClarificaiton.set("creator", (Object)creator);
        bidClarificaiton.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidClarificaiton});
    }

    @Override
    public void sendMessage(DynamicObject bidProjectF7, Object bidClarificaitonId) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (enable) {
            TreeSet<Long> supplierIdList = new TreeSet<Long>();
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidpublish"), (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.contactphone", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)"P")});
            DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((String)(appId + "_supplierinvitation"), (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.contactphone,supplierentry.email", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal())});
            if (bidPublish != null) {
                DynamicObjectCollection bidSectionList = bidPublish.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionList) {
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    if (supplierEntryCol == null) continue;
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        supplierIdList.add(supplier.getLong("id"));
                    }
                }
            } else if (supplierInvitation != null) {
                DynamicObjectCollection bidSectionList = supplierInvitation.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionList) {
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    if (supplierEntryCol == null) continue;
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        supplierIdList.add(supplier.getLong("id"));
                    }
                }
            } else {
                DynamicObjectCollection bidSectionCol = bidProject.getDynamicObjectCollection("bidrollsection");
                for (DynamicObject bidSection : bidSectionCol) {
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    if (supplierEntryCol == null) continue;
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        supplierIdList.add(supplier.getLong("id"));
                    }
                }
            }
            if (supplierIdList != null && supplierIdList.size() > 0) {
                this.sendMessage(supplierIdList, bidProjectF7, bidClarificaitonId);
            }
        }
    }

    public void sendMessage(Set<Long> supplierIds, DynamicObject bidProjectF7, Object bidClarificaitonId) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        for (Long supplierId : supplierIds) {
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            String notifyType = null;
            if ("bid".equals(appId)) {
                msgParam.put("formId", "ten_mytender");
                msgParam.put("msgentity", "bid_clarificaiton");
                msgParam.put("operation", "release");
                msgParam.put("appId", "bid");
            } else {
                msgParam.put("formId", "resp_mytender");
                msgParam.put("msgentity", "bid_clarificaiton");
                msgParam.put("operation", "release");
                msgParam.put("appId", "rebm");
            }
            msgParam.put("content", null);
            msgParam.put("title", null);
            msgParam.put("tplScene", "bid_clarificaiton_release");
            notifyType = MessageChannelUtil.getNotifyType((String)"bid_clarificaiton_release", (String)"bid_clarificaiton");
            msgParam.put("notifyType", notifyType);
            msgParam.put("id", bidClarificaitonId);
            msgParam.put("pkId", bidClarificaitonId);
            this.sendClarificaitionMessage(msgParam, bidProject.getPkValue(), supplierId, notifyType, appId);
        }
    }

    private void sendClarificaitionMessage(HashMap<String, Object> msgParam, Object bidProjectPk, Long currentSupplierId, String notifyTypes, String appId) {
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        boolean enable_close = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable_close) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)notifyTypes)) {
            return;
        }
        DynamicObject[] bidPublishArray = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"bidsection,bidsection.supplierentry,supplierentry,supplierentry.supplier,supplierentry.projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "=", (Object)"P")}, (String)"createtime desc");
        DynamicObject[] bidSupplierinvitationArray = BusinessDataServiceHelper.load((String)(appId + "_supplierinvitation"), (String)"bidsection,bidsection.supplierentry,supplierentry,supplierentry.supplier,supplierentry.projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "=", (Object)"C")}, (String)"createtime desc");
        if (bidPublishArray != null && bidPublishArray.length > 0) {
            DynamicObject bidPublish = bidPublishArray[0];
            DynamicObjectCollection bidSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
            HashMap<Long, Long> hasMap = new HashMap<Long, Long>();
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject projectPartner;
                    Long supplierId = supplierEntry.getLong("supplier.id");
                    if (!currentSupplierId.equals(supplierId) || (projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                    hasMap.put(supplierId, projectPartner.getLong("id"));
                }
            }
            Long supplierUserId = (Long)hasMap.get(currentSupplierId);
            msgParam.put("supplierId", currentSupplierId);
            if (supplierUserId != null) {
                msgParam.put("supplierBizUser", supplierUserId);
            }
            MessageCenterHelper.sendMessages(msgParam, (boolean)false, (String)appId, (String)notifyTypes);
        } else if (bidSupplierinvitationArray != null && bidSupplierinvitationArray.length > 0) {
            DynamicObject bidSupplierinvitation = bidSupplierinvitationArray[0];
            DynamicObjectCollection bidSectionCol = bidSupplierinvitation.getDynamicObjectCollection("bidsection");
            HashMap<Long, Long> hasMap = new HashMap<Long, Long>();
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject projectPartner;
                    Long supplierId = supplierEntry.getLong("supplier.id");
                    if (!currentSupplierId.equals(supplierId) || (projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                    hasMap.put(supplierId, projectPartner.getLong("id"));
                }
            }
            Long supplierUserId = (Long)hasMap.get(currentSupplierId);
            msgParam.put("supplierId", currentSupplierId);
            if (supplierUserId != null) {
                msgParam.put("supplierBizUser", supplierUserId);
            }
            MessageCenterHelper.sendMessages(msgParam, (boolean)false, (String)appId, (String)notifyTypes);
        } else {
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectPk, (String)(appId + "_project"));
            DynamicObjectCollection bidSectionCol = bidProject.getDynamicObjectCollection("bidrollsection");
            HashMap<Long, Long> hasMap = new HashMap<Long, Long>();
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject projectPartner;
                    Long supplierId = supplierEntry.getLong("supplier.id");
                    if (!currentSupplierId.equals(supplierId) || (projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                    hasMap.put(supplierId, projectPartner.getLong("id"));
                }
            }
            Long supplierUserId = (Long)hasMap.get(currentSupplierId);
            msgParam.put("supplierId", currentSupplierId);
            if (supplierUserId != null) {
                msgParam.put("supplierBizUser", supplierUserId);
            }
            MessageCenterHelper.sendMessages(msgParam, (boolean)false, (String)appId, (String)notifyTypes);
        }
    }

    @Override
    public String getFormId() {
        return "bid_clarificaiton";
    }

    @Override
    public void sendMessageToMember(DynamicObject bidProject) {
        DynamicObject clarification = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"clarificaiton", this.getClass()), (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())});
        String appid = clarification.getString("entitytypeid").split("_")[0];
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidClarificaitonServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("tplScene", "createbidclarificaiton");
        if ("bid".equals(appid)) {
            msgParam.put("formId", "bid_clarificaiton");
        } else {
            msgParam.put("formId", "rebm_clarificaiton");
        }
        msgParam.put("appId", appid);
        msgParam.put("id", clarification.getPkValue());
        msgParam.put("pkId", clarification.getPkValue());
        msgParam.put("title", null);
        msgParam.put("operation", "save");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        for (DynamicObject member : memberColl) {
            String[] values;
            if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
            for (int m = 0; m < values.length; ++m) {
                if (!"18".equals(values[m])) continue;
                memberSet.add(member.getDynamicObject("user"));
            }
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        msgParam.put("msgentity", "bid_clarificaiton");
        String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684<%s>\u9879\u76ee\u5df2\u8fdb\u5165\u62db\u6807\u4ea4\u5e95\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidClarificaitonServiceImpl_13", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
        msgParam.put("content", null);
        String notifyType = MessageChannelUtil.getNotifyType((String)"createbidclarificaiton", (String)"bid_clarificaiton");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
    }
}

