/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidDarkService;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.BidDarkUtil;

public class BidDarkServiceImpl
implements IBidDarkService {
    @Override
    public void saveBidDark(DynamicObject bidOpen, String appId) {
        boolean isFromReback;
        this.deleteBidDarkByOpenId(bidOpen.getPkValue());
        String projectEntityTypeId = "bid_project";
        String darkEntityTypeId = "bid_biddark";
        if (!"bid".equals(appId)) {
            projectEntityTypeId = "rebm_project";
            darkEntityTypeId = "rebm_biddark";
        }
        DynamicObject bidProject = bidOpen.getDynamicObject("bidproject");
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)projectEntityTypeId);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)darkEntityTypeId);
        DynamicObject bidDark = new DynamicObject((DynamicObjectType)mainEntityType);
        bidDark.set("entitytypeid", (Object)darkEntityTypeId);
        bidDark.set("source", (Object)"other");
        Long bidPublishId = bidOpen.getLong("bidpublishid");
        DynamicObject bidPublish = QueryServiceHelper.queryOne((String)"bid_bidpublish", (String)"shuffleorderflag, sourcepublish", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidPublishId)});
        boolean shuffleOrderFlag = true;
        if (bidPublish != null) {
            Long sourcePublish = bidPublish.getLong("sourcepublish");
            shuffleOrderFlag = sourcePublish == null || sourcePublish.toString().equals("0") ? true : bidPublish.getBoolean("shuffleorderflag");
            bidDark.set("source", (Object)"bid_bidpublish");
        }
        if (isFromReback = bidOpen.getBoolean("isfromreback")) {
            shuffleOrderFlag = bidOpen.getBoolean("rebackorderflag");
            bidDark.set("source", (Object)"bid_rebackbid");
        }
        bidDark.set("billno", bidProject.get("billno"));
        bidDark.set("billstatus", (Object)"A");
        bidDark.set("creator", (Object)RequestContext.get().getCurrUserId());
        bidDark.set("createtime", (Object)new Date());
        bidDark.set("bidproject", bidProject.getPkValue());
        bidDark.set("bidopen", bidOpen.getPkValue());
        bidDark.set("listrounds", bidOpen.get("listrounds"));
        bidDark.set("opentype", bidOpen.get("opentype"));
        bidDark.set("darktype", bidProject.get("enc_typc"));
        bidDark.set("darkopen", bidProject.get("is_enc_open"));
        bidDark.set("darkonlinebideval", bidProject.get("is_enc_online"));
        bidDark.set("darkbidevaluation", bidProject.get("is_enc_eval"));
        bidDark.set("darknameflag", (Object)BidDarkUtil.isDarkNameFlag((String)appId));
        bidDark.set("shuffleorderflag", (Object)shuffleOrderFlag);
        String openType = bidOpen.getString("opentype");
        String darkType = bidProject.getString("enc_typc");
        if (openType.equals(darkType) || "MULTI".equals(darkType)) {
            if (shuffleOrderFlag) {
                this.setNewOpenEntryData(bidDark, bidOpen, appId);
            } else {
                this.setLastOpenEntryData(bidDark, bidOpen, appId);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidDark});
    }

    @Override
    public void setNewOpenEntryData(DynamicObject bidDark, DynamicObject bidOpen, String appId) {
        int supplierSize = this.getSupplierSize(bidOpen);
        List darkSupplierNameList = BidDarkUtil.getDarkSupplierNameList((String)appId, (int)supplierSize);
        this.initOpenDark(bidDark, bidOpen, darkSupplierNameList);
        boolean isSame = bidDark.getBoolean("darknameflag");
        this.initOnlineDark(bidDark, isSame, darkSupplierNameList);
        this.initEvalDark(bidDark, isSame, darkSupplierNameList);
    }

    public int getSupplierSize(DynamicObject bidOpen) {
        DynamicObjectCollection bidSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
        HashSet supplierIdSet = new HashSet();
        bidSectionCol.stream().forEach(bidSection -> {
            DynamicObjectCollection supplierEntrys = bidSection.getDynamicObjectCollection("supplierentry");
            supplierEntrys.forEach(subRow -> {
                DynamicObject supplier = subRow.getDynamicObject("supplier");
                if (supplier != null) {
                    supplierIdSet.add(supplier.getPkValue());
                }
            });
        });
        return supplierIdSet.size();
    }

    public void initOnlineDark(DynamicObject bidDark, boolean isSame, List<String> darkSupplierNameList) {
        ArrayList<String> newDarkList = new ArrayList<String>();
        newDarkList.addAll(darkSupplierNameList);
        Collections.shuffle(newDarkList);
        HashMap<Object, String> darkMap = new HashMap<Object, String>();
        DynamicObjectCollection bidDarkOpenSectionCol = bidDark.getDynamicObjectCollection("bidopensection");
        DynamicObjectCollection onlineSection = bidDark.getDynamicObjectCollection("bidonlinesection");
        for (DynamicObject openSection : bidDarkOpenSectionCol) {
            DynamicObjectCollection openSubRows = openSection.getDynamicObjectCollection("opensupplierentry");
            DynamicObject onlineRow = onlineSection.addNew();
            onlineRow.set("onlinesectionname", openSection.get("opensectionname"));
            DynamicObjectCollection onlineSubRows = onlineRow.getDynamicObjectCollection("onlinesupplierentry");
            for (DynamicObject openSubRow : openSubRows) {
                DynamicObject onlineSubRow = onlineSubRows.addNew();
                DynamicObject supplier = openSubRow.getDynamicObject("bidopensupplier");
                onlineSubRow.set("onlinesupplier", (Object)supplier);
                onlineSubRow.set("onlinedarkname", isSame ? openSubRow.get("opendarkname") : darkMap.computeIfAbsent(supplier.getPkValue(), key -> (String)newDarkList.remove(0)));
            }
        }
    }

    public void initEvalDark(DynamicObject bidDark, boolean isSame, List<String> darkSupplierNameList) {
        ArrayList<String> newDarkList = new ArrayList<String>();
        newDarkList.addAll(darkSupplierNameList);
        Collections.shuffle(newDarkList);
        HashMap<Object, String> darkMap = new HashMap<Object, String>();
        DynamicObjectCollection bidDarkOpenSectionCol = bidDark.getDynamicObjectCollection("bidopensection");
        DynamicObjectCollection evalSection = bidDark.getDynamicObjectCollection("evaluationsection");
        for (DynamicObject openSection : bidDarkOpenSectionCol) {
            DynamicObjectCollection openSubRows = openSection.getDynamicObjectCollection("opensupplierentry");
            DynamicObject evalRow = evalSection.addNew();
            evalRow.set("evaluasectionname", openSection.get("opensectionname"));
            DynamicObjectCollection evalSubRows = evalRow.getDynamicObjectCollection("evaluasupplierentry");
            for (DynamicObject openSubRow : openSubRows) {
                DynamicObject evalSubRow = evalSubRows.addNew();
                DynamicObject supplier = openSubRow.getDynamicObject("bidopensupplier");
                evalSubRow.set("evaluationsupplier", (Object)supplier);
                evalSubRow.set("evaluationdarkname", isSame ? openSubRow.get("opendarkname") : darkMap.computeIfAbsent(supplier.getPkValue(), key -> (String)newDarkList.remove(0)));
            }
        }
    }

    public void initOpenDark(DynamicObject bidDark, DynamicObject bidOpen, List<String> darkSupplierNameList) {
        ArrayList<String> newDarkList = new ArrayList<String>();
        newDarkList.addAll(darkSupplierNameList);
        DynamicObjectCollection bidDarkOpenSectionCol = bidDark.getDynamicObjectCollection("bidopensection");
        HashMap<Object, String> darkMap = new HashMap<Object, String>();
        DynamicObjectCollection bidSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionCol) {
            DynamicObject bidDarkOpenSection = bidDarkOpenSectionCol.addNew();
            bidDarkOpenSection.set("opensectionname", (Object)bidSection.getString("sectionname"));
            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
            DynamicObjectCollection bidDarkOpenSupplierCol = bidDarkOpenSection.getDynamicObjectCollection("opensupplierentry");
            for (int i = 0; i < supplierEntryCol.size(); ++i) {
                DynamicObject supplierEntry = (DynamicObject)supplierEntryCol.get(i);
                DynamicObject bidDarkOpenSupplier = bidDarkOpenSupplierCol.addNew();
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                bidDarkOpenSupplier.set("bidopensupplier", (Object)supplier);
                bidDarkOpenSupplier.set("opendarkname", (Object)darkMap.computeIfAbsent(supplier.getPkValue(), key -> (String)newDarkList.remove(0)));
            }
        }
    }

    @Override
    public void setLastOpenEntryData(DynamicObject bidDark, DynamicObject bidOpen, String appId) {
        int supplierSize = this.getSupplierSize(bidOpen);
        boolean isSame = bidDark.getBoolean("darknameflag");
        List darkSupplierNameList = BidDarkUtil.getDarkSupplierNameList((String)appId, (int)supplierSize);
        DynamicObject lastDark = this.getLastDark(bidOpen, appId);
        if (lastDark != null) {
            HashSet<String> lastDarkNameSet = new HashSet<String>();
            Table<String, Object, String> openTableMap = this.buildLastDarkOpenMap(lastDark, "bidopensection", lastDarkNameSet);
            Table<String, Object, String> onlineTableMap = this.buildLastDarkOpenMap(lastDark, "bidonlinesection", lastDarkNameSet);
            Table<String, Object, String> evalTableMap = this.buildLastDarkOpenMap(lastDark, "evaluationsection", lastDarkNameSet);
            darkSupplierNameList.removeIf(name -> lastDarkNameSet.contains(name));
            ArrayList openDarkList = new ArrayList();
            ArrayList onlineDarkList = new ArrayList();
            ArrayList evalDarkList = new ArrayList();
            openDarkList.addAll(darkSupplierNameList);
            onlineDarkList.addAll(darkSupplierNameList);
            evalDarkList.addAll(darkSupplierNameList);
            if (!isSame) {
                Collections.shuffle(onlineDarkList);
                Collections.shuffle(evalDarkList);
            }
            HashBasedTable sametableMap = HashBasedTable.create();
            HashMap newDarkNameMap = new HashMap();
            DynamicObjectCollection openDarkSections = bidDark.getDynamicObjectCollection("bidopensection");
            DynamicObjectCollection bidSections = bidOpen.getDynamicObjectCollection("bidsection");
            bidSections.forEach(arg_0 -> BidDarkServiceImpl.lambda$setLastOpenEntryData$8(openDarkSections, openTableMap, newDarkNameMap, openDarkList, (Table)sametableMap, arg_0));
            newDarkNameMap.clear();
            DynamicObjectCollection onlineDarkSections = bidDark.getDynamicObjectCollection("bidonlinesection");
            bidSections.forEach(arg_0 -> BidDarkServiceImpl.lambda$setLastOpenEntryData$11(onlineDarkSections, onlineTableMap, isSame, (Table)sametableMap, newDarkNameMap, onlineDarkList, arg_0));
            newDarkNameMap.clear();
            DynamicObjectCollection evalDarkSections = bidDark.getDynamicObjectCollection("evaluationsection");
            bidSections.forEach(arg_0 -> BidDarkServiceImpl.lambda$setLastOpenEntryData$14(evalDarkSections, evalTableMap, isSame, (Table)sametableMap, newDarkNameMap, evalDarkList, arg_0));
        } else {
            this.setNewOpenEntryData(bidDark, bidOpen, appId);
            BizLog.log((String)"\u8bbe\u7f6e\u4e0a\u4e00\u8f6e\u4f9b\u5e94\u5546\u6697\u6807\u6807\u8bb0\uff0c\u4f46\u662f\u627e\u4e0d\u5230\u4e0a\u4e00\u8f6e\u7684\u6697\u6807\u8bb0\u5f55\uff0c\u91cd\u65b0\u65b0\u5efa");
        }
    }

    public Table<String, Object, String> buildLastDarkOpenMap(DynamicObject lastDark, String entryKey, Set<String> lastDarkNameSet) {
        String sectionNameKey = "opensectionname";
        String subEntryKey = "opensupplierentry";
        String supplierKey = "bidopensupplier";
        String darkKey = "opendarkname";
        if (entryKey.equals("bidonlinesection")) {
            sectionNameKey = "onlinesectionname";
            subEntryKey = "onlinesupplierentry";
            supplierKey = "onlinesupplier";
            darkKey = "onlinedarkname";
        } else if (entryKey.equals("evaluationsection")) {
            sectionNameKey = "evaluasectionname";
            subEntryKey = "evaluasupplierentry";
            supplierKey = "evaluationsupplier";
            darkKey = "evaluationdarkname";
        }
        HashBasedTable tableMap = HashBasedTable.create();
        DynamicObjectCollection sections = lastDark.getDynamicObjectCollection(entryKey);
        for (DynamicObject row : sections) {
            String sectionName = row.getString(sectionNameKey);
            DynamicObjectCollection subRows = row.getDynamicObjectCollection(subEntryKey);
            for (DynamicObject subRow : subRows) {
                DynamicObject supplier = subRow.getDynamicObject(supplierKey);
                String darkName = subRow.getString(darkKey);
                tableMap.put((Object)sectionName, supplier.getPkValue(), (Object)darkName);
                lastDarkNameSet.add(darkName);
            }
        }
        return tableMap;
    }

    public DynamicObject getLastOpen(DynamicObject bidOpen, String appId) {
        DynamicObjectCollection bidOpenHistoryArray;
        Object bidProjectId = bidOpen.getDynamicObject("bidproject").getPkValue();
        QFilter openFilter = new QFilter("bidproject", "=", bidProjectId).and("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal());
        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)bidOpen.getString("opentype"))) {
            openFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
        } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)bidOpen.getString("opentype"))) {
            openFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
        }
        String bidOpenForm = "bid_bidopen";
        if ("rebm".equals(appId)) {
            bidOpenForm = "rebm_bidopen";
        }
        if ((bidOpenHistoryArray = QueryServiceHelper.query((String)bidOpenForm, (String)"id", (QFilter[])openFilter.toArray(), (String)"createtime desc")).size() != 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)bidOpenHistoryArray.get(0)).getLong("id"), (String)bidOpenForm);
        }
        return null;
    }

    public DynamicObject getLastDark(DynamicObject bidOpen, String appId) {
        DynamicObject lastOpen = this.getLastOpen(bidOpen, appId);
        if (lastOpen != null) {
            return this.getBidDarkByOpenId(lastOpen.getPkValue(), appId);
        }
        return null;
    }

    @Override
    public DynamicObject getBidDarkByOpenId(Object openId, String appId) {
        return BusinessDataServiceHelper.loadSingle((String)(appId + "_biddark"), (QFilter[])new QFilter[]{new QFilter("bidopen", "=", openId)});
    }

    @Override
    public Map<String, String> getOpenSupplierDarkName(Object openId, String appId) {
        DynamicObject bidDark = this.getBidDarkByOpenId(openId, appId);
        return this.getOpenSupplierDarkName(bidDark);
    }

    public Map<String, String> getOpenSupplierDarkName(DynamicObject bidDark) {
        HashMap<String, String> supplierDarkNameMap = new HashMap<String, String>();
        if (bidDark != null) {
            DynamicObjectCollection bidOpenSectionCol = bidDark.getDynamicObjectCollection("bidopensection");
            for (DynamicObject bidOpenSection : bidOpenSectionCol) {
                String openSectionName = bidOpenSection.getString("opensectionname");
                DynamicObjectCollection openSupplierEntryCol = bidOpenSection.getDynamicObjectCollection("opensupplierentry");
                for (DynamicObject openSupplierEntry : openSupplierEntryCol) {
                    DynamicObject bidOpenSupplier = openSupplierEntry.getDynamicObject("bidopensupplier");
                    Long supplierId = bidOpenSupplier.getLong("id");
                    String openDarkName = openSupplierEntry.getString("opendarkname");
                    supplierDarkNameMap.put(openSectionName + supplierId, openDarkName);
                }
            }
        }
        return supplierDarkNameMap;
    }

    @Override
    public void setEntryDarkSupplierName(Object openId, DynamicObject dataEntity, String appId) {
        Map<String, String> openSupplierDarkName = this.getOpenSupplierDarkName(openId, appId);
        DynamicObjectCollection bidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionCol) {
            String sectionName = bidSection.getString("sectionname");
            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryCol) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                Long supplierId = supplier.getLong("id");
                String darkSupplierName = openSupplierDarkName.get(sectionName + supplierId);
                supplierEntry.set("darksuppliername", (Object)darkSupplierName);
            }
        }
    }

    @Override
    public void deleteBidDarkByOpenId(Object openId) {
        DeleteServiceHelper.delete((String)"bid_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", openId)});
    }

    private static /* synthetic */ void lambda$setLastOpenEntryData$14(DynamicObjectCollection evalDarkSections, Table evalTableMap, boolean isSame, Table sametableMap, Map newDarkNameMap, List evalDarkList, DynamicObject row) {
        DynamicObject newRow = evalDarkSections.addNew();
        String sectionName = row.getString("sectionname");
        newRow.set("evaluasectionname", (Object)sectionName);
        DynamicObjectCollection subRows = row.getDynamicObjectCollection("supplierentry");
        DynamicObjectCollection newSubRows = newRow.getDynamicObjectCollection("evaluasupplierentry");
        subRows.forEach(subRow -> {
            DynamicObject newSubRow = newSubRows.addNew();
            DynamicObject supplier = subRow.getDynamicObject("supplier");
            newSubRow.set("evaluationsupplier", (Object)supplier);
            String darkName = (String)evalTableMap.get((Object)sectionName, supplier.getPkValue());
            if (StringUtils.isEmpty((CharSequence)darkName)) {
                darkName = isSame ? (String)sametableMap.get((Object)sectionName, supplier.getPkValue()) : newDarkNameMap.computeIfAbsent(supplier.getPkValue(), key -> (String)evalDarkList.remove(0));
            }
            newSubRow.set("evaluationdarkname", (Object)darkName);
        });
    }

    private static /* synthetic */ void lambda$setLastOpenEntryData$11(DynamicObjectCollection onlineDarkSections, Table onlineTableMap, boolean isSame, Table sametableMap, Map newDarkNameMap, List onlineDarkList, DynamicObject row) {
        DynamicObject newRow = onlineDarkSections.addNew();
        String sectionName = row.getString("sectionname");
        newRow.set("onlinesectionname", (Object)sectionName);
        DynamicObjectCollection subRows = row.getDynamicObjectCollection("supplierentry");
        DynamicObjectCollection newSubRows = newRow.getDynamicObjectCollection("onlinesupplierentry");
        subRows.forEach(subRow -> {
            DynamicObject newSubRow = newSubRows.addNew();
            DynamicObject supplier = subRow.getDynamicObject("supplier");
            newSubRow.set("onlinesupplier", (Object)supplier);
            String darkName = (String)onlineTableMap.get((Object)sectionName, supplier.getPkValue());
            if (StringUtils.isEmpty((CharSequence)darkName)) {
                darkName = isSame ? (String)sametableMap.get((Object)sectionName, supplier.getPkValue()) : newDarkNameMap.computeIfAbsent(supplier.getPkValue(), key -> (String)onlineDarkList.remove(0));
            }
            newSubRow.set("onlinedarkname", (Object)darkName);
        });
    }

    private static /* synthetic */ void lambda$setLastOpenEntryData$8(DynamicObjectCollection openDarkSections, Table openTableMap, Map newDarkNameMap, List openDarkList, Table sametableMap, DynamicObject row) {
        DynamicObject newRow = openDarkSections.addNew();
        String sectionName = row.getString("sectionname");
        newRow.set("opensectionname", (Object)sectionName);
        DynamicObjectCollection subRows = row.getDynamicObjectCollection("supplierentry");
        DynamicObjectCollection newSubRows = newRow.getDynamicObjectCollection("opensupplierentry");
        subRows.forEach(subRow -> {
            DynamicObject newSubRow = newSubRows.addNew();
            DynamicObject supplier = subRow.getDynamicObject("supplier");
            newSubRow.set("bidopensupplier", (Object)supplier);
            String darkName = (String)openTableMap.get((Object)sectionName, supplier.getPkValue());
            if (StringUtils.isEmpty((CharSequence)darkName)) {
                darkName = newDarkNameMap.computeIfAbsent(supplier.getPkValue(), key -> (String)openDarkList.remove(0));
                sametableMap.put((Object)sectionName, supplier.getPkValue(), (Object)darkName);
            }
            newSubRow.set("opendarkname", (Object)darkName);
        });
    }
}

