/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidDocumentService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.EntityTypeHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.PurchaseModel;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;

public class BidDocumentServiceImpl
extends BidServiceImpl
implements IBidDocumentService {
    private IBidProjectService bidProjectService = new BidProjectServiceImpl();

    @Override
    public Boolean checkDocumentAudited(Long projectId) {
        DynamicObject document;
        String status;
        DynamicObject project = this.bidProjectService.getBidProjectAllById(projectId);
        if (project.getBoolean("biddocument") && !StringUtils.equals((CharSequence)(status = (document = this.getBidDocumentByProjectId(projectId, "id,billstatus")).getString("billstatus")), (CharSequence)BillStatusEnum.AUDITED.getVal())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Map<String, String> getTypeMapById(Long docId, Long userId, String parentFormId, String formId) {
        HashMap<String, String> map = new HashMap<String, String>();
        DynamicObject project = this.getBidDocumentById(docId, "isseparatedoc,bidproject.id,bidproject.technicaldocenddate,bidproject.commercialdocenddate,bidproject.bidpublishdate");
        if (project != null) {
            String isSeparateDoc = project.getString("isseparatedoc");
            map.put("isseparatedoc", isSeparateDoc);
            Long projectId = project.getLong("bidproject.id");
            String perId = this.getPermissionIdByProjectIdAndUserId(projectId, userId, isSeparateDoc);
            Boolean isWorkFlow = WorkflowServiceHelper.inProcess((String)docId.toString());
            if (!StringUtils.equals((CharSequence)parentFormId, (CharSequence)formId) && isWorkFlow.booleanValue() && StringUtils.equals((CharSequence)"true", (CharSequence)isSeparateDoc)) {
                perId = "E";
            } else if (!StringUtils.equals((CharSequence)parentFormId, (CharSequence)formId) && isWorkFlow.booleanValue() && StringUtils.equals((CharSequence)"false", (CharSequence)isSeparateDoc)) {
                perId = "F";
            }
            map.put("roottype", perId);
        } else {
            map.put("roottype", "D");
            map.put("isseparatedoc", "false");
        }
        return map;
    }

    @Override
    public DynamicObject transformProjectAndSave(String projectId) {
        Long queryId = Long.parseLong(projectId);
        MainEntityType projectType = EntityMetadataCache.getDataEntityType((String)"bidproject_f7");
        DynamicObject projectF7 = BusinessDataServiceHelper.loadSingle((Object)queryId, (DynamicObjectType)projectType);
        String entityType = projectF7.getString("entitytypeid");
        boolean isRebm = "rebm".equals(entityType.split("_")[0]);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
        if (isRebm) {
            type = EntityMetadataCache.getDataEntityType((String)"rebm_biddocument_edit");
            projectType = EntityMetadataCache.getDataEntityType((String)"rebm_bidproject_f7");
            projectF7 = BusinessDataServiceHelper.loadSingle((Object)queryId, (DynamicObjectType)projectType);
        }
        DynamicObject document = new DynamicObject((DynamicObjectType)type);
        DynamicObject orgnization = projectF7.getDynamicObject("org");
        document.set("bidproject", projectF7.getPkValue());
        document.set("currency", projectF7.get("currency"));
        document.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
        document.set("org", orgnization.getPkValue());
        document.set("billno", projectF7.get("billno"));
        document.set("isseparatedoc", projectF7.get("isseparatedoc"));
        HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(projectF7);
        String doctype = projectF7.getString("doctype");
        DynamicObject creator = new DynamicObject();
        creator = doctype.equals("MULTI") ? creatorMap.get("09") : (doctype.equals("BUSSINESS") ? (creatorMap.get("04") == null ? creatorMap.get("09") : creatorMap.get("04")) : (doctype.equals("TECHNICAL") ? creatorMap.get("03") : creatorMap.get("09")));
        document.set("creator", (Object)creator);
        document.set("createtime", (Object)new Date());
        document.set("sortfield", (Object)(projectF7.getString("id") + new Date().getTime()));
        DynamicObject bidproevaluatedecideway = projectF7.getDynamicObject("evaluatedecideway");
        if (bidproevaluatedecideway != null) {
            document.set("evaluatedecideway", (Object)bidproevaluatedecideway);
        }
        DynamicObjectType docSectionEntryType = this.getEntryType("biddocumententry");
        DynamicObjectType docPurDetailType = isRebm ? this.getRebmEntryType("biddocdetail") : this.getEntryType("biddocdetail");
        DynamicObjectCollection bidProjSections = projectF7.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection docSections = new DynamicObjectCollection(docSectionEntryType, (Object)document);
        document.set("biddocumententry", (Object)docSections);
        for (DynamicObject section : bidProjSections) {
            DynamicObject docSection = new DynamicObject(docSectionEntryType);
            docSections.add((Object)docSection);
            docSection.set("seq", section.get("seq"));
            docSection.set("sectionname", section.get("sectionname"));
            DynamicObjectCollection projentrys = section.getDynamicObjectCollection("projectentry");
            DynamicObjectCollection docPurDetails = new DynamicObjectCollection(docPurDetailType, (Object)docSection);
            docSection.set("biddocdetail", (Object)docPurDetails);
            for (DynamicObject projentry : projentrys) {
                DynamicObject docPurDetail = new DynamicObject(docPurDetailType);
                docPurDetails.add((Object)docPurDetail);
                docPurDetail.set("seq", projentry.get("seq"));
                docPurDetail.set("materialid", projentry.get("materialid"));
                docPurDetail.set("baseunit", projentry.get("baseunit"));
                docPurDetail.set("materialdes", (Object)projentry.getString("materialdes"));
                docPurDetail.set("qty", (Object)projentry.getString("qty"));
                docPurDetail.set("purentrycontent", projentry.get("purentrycontent"));
                docPurDetail.set("purentryproject", projentry.get("purentryproject"));
                docPurDetail.set("planamount", projentry.get("planamount"));
                docPurDetail.set("controlamount", projentry.get("controlamount"));
                docPurDetail.set("nottaxplanamount", projentry.get("nottaxplanamount"));
                if (!isRebm) continue;
                docPurDetail.set("listnumber", projentry.get("listnumber"));
                docPurDetail.set("listname", projentry.get("listname"));
                docPurDetail.set("resourceitem", projentry.get("resourceitem"));
            }
        }
        EntityTypeHelper.setEntityType(document, "bid_biddocument_edit", "bidproject");
        if (isRebm) {
            this.addListBillCardEntrys(document, projectF7);
        }
        SaveServiceHelper.save((IDataEntityType)type, (Object[])new DynamicObject[]{document});
        return document;
    }

    @Override
    public DynamicObject transformProjectAndSave(String projectId, Map<String, Object> params) {
        Long queryId = Long.parseLong(projectId);
        MainEntityType projectType = EntityMetadataCache.getDataEntityType((String)"bidproject_f7");
        DynamicObject projectF7 = BusinessDataServiceHelper.loadSingle((Object)queryId, (DynamicObjectType)projectType);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
        DynamicObject document = new DynamicObject((DynamicObjectType)type);
        DynamicObject orgnization = projectF7.getDynamicObject("org");
        document.set("bidproject", projectF7.getPkValue());
        document.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
        document.set("org", orgnization.getPkValue());
        document.set("billno", projectF7.get("billno"));
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, Object> paramMap : params.entrySet()) {
                document.set(paramMap.getKey(), paramMap.getValue());
            }
        }
        document.set("isseparatedoc", projectF7.get("isseparatedoc"));
        String uid = RequestContext.get().getUserId();
        document.set("creator", (Object)uid);
        document.set("createtime", (Object)new Date());
        DynamicObject bidproevaluatedecideway = projectF7.getDynamicObject("evaluatedecideway");
        if (bidproevaluatedecideway != null) {
            document.set("evaluatedecideway", (Object)bidproevaluatedecideway);
        }
        DynamicObjectType docSectionEntryType = this.getEntryType("biddocumententry");
        DynamicObjectType docPurDetailType = this.getEntryType("biddocdetail");
        DynamicObjectCollection bidProjSections = projectF7.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection docSections = new DynamicObjectCollection(docSectionEntryType, (Object)document);
        document.set("biddocumententry", (Object)docSections);
        for (DynamicObject section : bidProjSections) {
            DynamicObject docSection = new DynamicObject(docSectionEntryType);
            docSections.add((Object)docSection);
            docSection.set("seq", section.get("seq"));
            docSection.set("sectionname", section.get("sectionname"));
            DynamicObjectCollection projentrys = section.getDynamicObjectCollection("projectentry");
            DynamicObjectCollection docPurDetails = new DynamicObjectCollection(docPurDetailType, (Object)docSection);
            docSection.set("biddocdetail", (Object)docPurDetails);
            for (DynamicObject projentry : projentrys) {
                DynamicObject docPurDetail = new DynamicObject(docPurDetailType);
                docPurDetails.add((Object)docPurDetail);
                docPurDetail.set("seq", projentry.get("seq"));
                docPurDetail.set("materialid", projentry.get("materialid"));
                docPurDetail.set("materialdes", (Object)projentry.getString("materialdes"));
                docPurDetail.set("qty", (Object)projentry.getString("qty"));
                docPurDetail.set("purentrycontent", projentry.get("purentrycontent"));
                docPurDetail.set("purentryproject", projentry.get("purentryproject"));
                docPurDetail.set("controlamount", projentry.get("controlamount"));
                docPurDetail.set("planamount", projentry.get("planamount"));
                docPurDetail.set("nottaxplanamount", projentry.get("nottaxplanamount"));
            }
        }
        EntityTypeHelper.setEntityType(document, "bid_biddocument_edit", "bidproject");
        SaveServiceHelper.save((IDataEntityType)type, (Object[])new DynamicObject[]{document});
        return document;
    }

    public DynamicObjectType getEntryType(String entryName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
        EntityType type = (EntityType)mainType.getAllEntities().get(entryName);
        return type;
    }

    public DynamicObjectType getRebmEntryType(String entryName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"rebm_biddocument_edit");
        EntityType type = (EntityType)mainType.getAllEntities().get(entryName);
        return type;
    }

    @Override
    public DynamicObject getBidDocumentById(Long docId, String selectedFields) {
        QFilter qFilter = new QFilter("id", "=", (Object)docId);
        return BusinessDataServiceHelper.loadSingle((String)"bid_biddocument_edit", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject getBidDocumentByProjectId(Long projectId, String selectedFields) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
        QFilter qFilterOne = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal()).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.ADJUSTING.getVal()));
        return QueryServiceHelper.queryOne((String)"bid_biddocument_edit", (String)selectedFields, (QFilter[])new QFilter[]{qFilter, qFilterOne});
    }

    private String getPermissionIdByProjectIdAndUserId(Long projectId, Long userId, String isSeparateDoc) {
        Long nowId;
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()), (String)"entitytypeid");
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (isAdmin) {
            if ("true".equals(isSeparateDoc)) {
                return "C";
            }
            if ("false".equals(isSeparateDoc)) {
                return "D";
            }
        }
        DynamicObjectCollection entity = this.bidProjectService.listMemberEntryByProjectId(projectId);
        DynamicObjectCollection leaderEntity = this.bidProjectService.listLeaderEntryByProjectId(projectId);
        for (DynamicObject temp : entity) {
            boolean isBidDocument;
            nowId = (Long)temp.get("user.id");
            boolean isDir = temp.getBoolean("isDirector");
            if (nowId.longValue() != userId.longValue()) continue;
            String businesses = temp.getString("respbusiness");
            if ("true".equals(isSeparateDoc)) {
                boolean isTech = this.checkBusinessContain(businesses, RespBusiness.TechnicalDoc.getVal());
                boolean isCom = this.checkBusinessContain(businesses, RespBusiness.CommercialDoc.getVal());
                if (isDir || isTech && isCom) {
                    return "C";
                }
                if (isTech) {
                    return "A";
                }
                if (!isCom) continue;
                return "B";
            }
            if (!"false".equals(isSeparateDoc) || !(isBidDocument = this.checkBusinessContain(businesses, RespBusiness.RespCreateDoc.getVal())) && !isDir) continue;
            return "D";
        }
        for (DynamicObject temp : leaderEntity) {
            boolean isBidDocument;
            nowId = (Long)temp.get("userleader.id");
            if (nowId.longValue() != userId.longValue()) continue;
            String businesses = temp.getString("respbusinessleader");
            if ("true".equals(isSeparateDoc)) {
                boolean isTech = this.checkBusinessContain(businesses, RespBusiness.TechnicalDoc.getVal());
                boolean isCom = this.checkBusinessContain(businesses, RespBusiness.CommercialDoc.getVal());
                if (isTech && isCom) {
                    return "C";
                }
                if (isTech) {
                    return "A";
                }
                if (!isCom) continue;
                return "B";
            }
            if (!"false".equals(isSeparateDoc) || !(isBidDocument = this.checkBusinessContain(businesses, RespBusiness.RespCreateDoc.getVal()))) continue;
            return "D";
        }
        return null;
    }

    public String getBidAdminRoleID() {
        return "/FFXFSRKI73+";
    }

    private boolean checkBusinessContain(String businesses, String number) {
        String[] strs = businesses.split(",");
        for (int i = 1; i < strs.length; ++i) {
            if (!number.equals(strs[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        IBidDocumentService.super.createByLastStep(bidProject, lastStep);
        this.transformProjectAndSave(bidProject.getString("id"));
    }

    @Override
    public void createByLastStep(DynamicObject bidProject, Map<String, Object> params, BidStepEnum lastStep) {
        IBidDocumentService.super.createByLastStep(bidProject, params, lastStep);
        this.transformProjectAndSave(bidProject.getString("id"));
    }

    @Override
    public DynamicObject getBidDocumentById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    @Override
    public String checkReviseDocument(Long id) {
        DynamicObject document = this.getBidDocumentById(id, "bidproject.id");
        if (document != null) {
            Long projectId = document.getLong("bidproject.id");
            DynamicObject bidProject = this.bidProjectService.getBidProjectAllById(projectId);
            Boolean status = Boolean.TRUE;
            Boolean isBidOpen = bidProject.getBoolean("bidopen");
            Boolean isAnswer = bidProject.getBoolean("bidanswerquestion");
            Boolean isPublish = bidProject.getBoolean("bidpublish");
            Boolean isBustalk = bidProject.getBoolean("bidbustalk");
            DynamicObject decisionObj = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"decision", this.getClass()), (String)"id,bidProject.name,billstatus", (QFilter[])new QFilter[]{new QFilter("bidProject", "=", (Object)projectId)});
            if (decisionObj != null) {
                String billstatus = decisionObj.getString("billstatus");
                if (!BillStatusEnum.DISBEGIN.getVal().equals(billstatus) && !BillStatusEnum.INVALIDXX.getVal().equals(billstatus)) {
                    String projectName = ((DynamicObject)decisionObj.get("bidProject")).getString("name");
                    return String.format(ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879\uff1a%s\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6807\u4e66\u4fee\u8ba2\u3002", (String)"BidDocumentServiceImpl_5", (String)"scm-bid-business", (Object[])new Object[0]), projectName);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public String getMess(boolean isBidOpen, boolean status, String mess1, String mess2, Long projectId) {
        if (isBidOpen) {
            status = this.checkUnStarted(projectId, "bid_bidopen");
            if (status) {
                return null;
            }
            return mess1;
        }
        status = this.checkUnStarted(projectId, "bid_decision");
        if (status) {
            return null;
        }
        return mess2;
    }

    @Override
    public String getFormId() {
        return "bid_biddocument_edit";
    }

    @Override
    public QFilter[] getFilters(Object bidProjectPK) {
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPK);
        QFilter qFilterOne = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal()).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.ADJUSTING.getVal()));
        QFilter[] qFilters = new QFilter[]{qFilter, qFilterOne};
        return qFilters;
    }

    public void sendMessage(DynamicObject bidProjectF7) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        String appid = bidProject.getString("entitytypeid").split("_")[0];
        ArrayList<String> list = new ArrayList<String>();
        list.add("X");
        list.add("XX");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"biddocument_edit", this.getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", list)});
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidDocumentServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("tplScene", "createbiddocument");
        if ("bid".equals(appid)) {
            msgParam.put("formId", "bid_biddocument_edit");
        } else {
            msgParam.put("formId", "rebm_biddocument_edit");
        }
        msgParam.put("appId", appid);
        msgParam.put("id", supplier.getPkValue());
        msgParam.put("pkId", supplier.getPkValue());
        msgParam.put("title", null);
        msgParam.put("operation", "save");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        for (DynamicObject member : memberColl) {
            String[] values;
            if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
            for (int m = 0; m < values.length; ++m) {
                if (!"09".equals(values[m])) continue;
                memberSet.add(member.getDynamicObject("user"));
            }
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        msgParam.put("msgentity", "bid_biddocument_edit");
        msgParam.put("content", null);
        String notifyType = MessageChannelUtil.getNotifyType((String)"createbiddocument", (String)"bid_biddocument_edit");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
    }

    public void addListBillCardEntrys(DynamicObject documentBill, DynamicObject bidProjectF7) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)"rebm_project", (String)String.join((CharSequence)",", "purmodel", "isenablelist", "isrequiredlist", "bidsection", "sectionname"));
        if (!PurchaseModel.ProjectProcurement.getVal().equals(bidProject.getString("purmodel"))) {
            return;
        }
        if (!bidProject.getBoolean("isenablelist")) {
            return;
        }
        DynamicObject[] listBillColl = BusinessDataServiceHelper.load((String)"relis_bidlistbill", (String)String.join((CharSequence)",", "id", "bidproject", "sectionname"), (QFilter[])new QFilter[]{new QFilter("islatestversion", "=", (Object)Boolean.TRUE), new QFilter("bidproject", "=", bidProjectF7.getPkValue())});
        HashMap<String, DynamicObject> sectionListBillMap = new HashMap<String, DynamicObject>();
        if (listBillColl.length != 0) {
            for (DynamicObject listBill : listBillColl) {
                DynamicObject sectionNameObj = listBill.getDynamicObject("sectionname");
                if (sectionNameObj == null) continue;
                sectionListBillMap.put(sectionNameObj.getString("sectionname"), listBill);
            }
        }
        DynamicObjectCollection listEntrys = documentBill.getDynamicObjectCollection("listentry");
        DynamicObjectCollection bidSectionEntrys = bidProject.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidSectionEntrys.size(); ++i) {
            DynamicObject sectionEntry = (DynamicObject)bidSectionEntrys.get(i);
            String sectionName = sectionEntry.getString("sectionname");
            DynamicObject addNew = listEntrys.addNew();
            addNew.set("seq", (Object)(i + 1));
            addNew.set("listentry_sectionname", sectionEntry.get("sectionname"));
            DynamicObject listBill = (DynamicObject)sectionListBillMap.get(sectionName);
            if (null != listBill) {
                addNew.set("listentry_listbill", (Object)listBill);
                addNew.set("listentry_isauditsync", (Object)Boolean.TRUE);
                continue;
            }
            addNew.set("listentry_isauditsync", (Object)Boolean.FALSE);
        }
    }
}

