/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.IProficientService;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.basedata.serviceImpl.ProficientServiceImpl;
import kd.scm.bid.business.bill.IBidBustalkService;
import kd.scm.bid.business.bill.IBidDarkService;
import kd.scm.bid.business.bill.IBidDocumentService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IBidPublishService;
import kd.scm.bid.business.bill.IBidSupplierFileService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDarkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidPublishServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidSupplierFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.business.helper.EntityTypeHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.BidOpenUtil;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;

public class BidOpenServiceImpl
extends BidServiceImpl
implements IBidOpenService {
    private static final Log logger = LogFactory.getLog(BidOpenServiceImpl.class);
    protected IBidBustalkService bidBustalkService = new BidBustalkServiceImpl();
    protected IBidDarkService bidDarkService = new BidDarkServiceImpl();
    private static final String selectSectionString = "bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.suppliercomment,supplierentry.supplierstatistic,supplierentry.invitationstatus,supplierentry.seq, supplierentry.suppliersecdeposit,org,entitytypeid,bidproject";
    private IProficientService proficientService = new ProficientServiceImpl();
    private IBidProjectService bidProjectService = new BidProjectServiceImpl();
    private IBidPublishService bidPublishService = new BidPublishServiceImpl();
    private IBidDocumentService bidDocumentService = new BidDocumentServiceImpl();
    private ISupplierInvitationService supplierInvitation = new SupplierInvitationServiceImpl();
    private IBidSupplierFileService fileService = new BidSupplierFileServiceImpl();
    public IBidSupplierFileService bidSupplierFileService = new BidSupplierFileServiceImpl();
    private static final String[] ATTACH_FEILD_ID = new String[]{"attatech", "attacommerce", "attainvite", "attaother"};

    @Override
    public DynamicObjectCollection listProficientsByIds(Long[] ids) {
        String fields = "id,name,sex,type,majortypenames,telephone";
        return this.proficientService.listProficients(ids, fields);
    }

    @Override
    public DynamicObject getBidOpenByProjectId(Long projectId) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId).and(new QFilter("billstatus", "!=", (Object)"XX"));
        DynamicObject bidOpen = QueryServiceHelper.queryOne((String)"bid_bidopen", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (bidOpen == null) {
            return null;
        }
        if ((bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getLong("id"), (String)"bid_bidopen")) == null) {
            return null;
        }
        return bidOpen;
    }

    @Override
    public void createByLastStep(DynamicObject bidProject, Map<String, Object> params, BidStepEnum lastStep) {
        IBidOpenService.super.createByLastStep(bidProject, lastStep);
        boolean isTenNew = false;
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "!=", (Object)"XX")});
        if (bidOpen == null) {
            this.saveBidOpen(bidProject.getLong("id"), params, isTenNew);
        }
    }

    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        IBidOpenService.super.createByLastStep(bidProject, lastStep);
        boolean isTenNew = false;
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "!=", (Object)"XX")});
        if (bidOpen == null) {
            this.saveBidOpen(bidProject.getLong("id"), null, isTenNew);
        }
    }

    @Override
    public DynamicObject getProficientF7ById(Long id) {
        String fields = "id,name,sex,type,majortypenames,telephone";
        return this.proficientService.getProficient_f7(id, fields);
    }

    @Override
    public void saveBidOpen(Long projectId, boolean isTenNew) {
        this.saveBidOpen(projectId, null, isTenNew);
    }

    @Override
    public void saveBidOpen(Long projectId, Map<String, Object> params, boolean isTenNew) {
        block77: {
            boolean addSecond;
            boolean addFirst;
            DynamicObject newTwo;
            DynamicObject newOne;
            MainEntityType newOneType;
            boolean isEncEnable;
            String appId;
            block79: {
                String openTypeNewTwo;
                String openTypeNewOne;
                DynamicObject[] array;
                boolean isDelete;
                String openType;
                Date deleteThousand;
                DynamicObject creatorTec;
                DynamicObject creatorBus;
                String encTypc;
                boolean isEncOpen;
                block78: {
                    int i;
                    block80: {
                        Date addThousand;
                        block76: {
                            DynamicObject bidProjectEvaluateDecideway;
                            MainEntityType mainType;
                            boolean isProject = false;
                            Long pk = null;
                            Object bidOpenDate = null;
                            Long evaluateDecideWay = null;
                            String bidEvalMethod = null;
                            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bid_project", (String)"entitytypeid");
                            appId = bidProject.getString("entitytypeid").split("_")[0];
                            bidProject = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"rebm_project") : BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bid_project");
                            isEncEnable = bidProject.getBoolean("is_enc_enable");
                            isEncOpen = bidProject.getBoolean("is_enc_open");
                            encTypc = bidProject.getString("enc_typc");
                            bidEvalMethod = bidProject.getString("evaluatedmethod");
                            if (StringUtils.isBlank((CharSequence)bidEvalMethod)) {
                                bidEvalMethod = BidEvalMethodEnum.DL.getCode();
                            }
                            if (bidProject.getBoolean("bidpublish")) {
                                mainType = "rebm".equals(appId) ? EntityMetadataCache.getDataEntityType((String)"rebm_bidpublish") : EntityMetadataCache.getDataEntityType((String)"bid_bidpublish");
                                DynamicObject publish = this.bidPublishService.getBidPublishByProjectId(projectId, "id,sourcepublish,bidopendeadline,probidopendeadline,evaluatedecideway");
                                bidOpenDate = params != null && (Boolean)params.get("isInvalid") != false ? publish.get("probidopendeadline") : publish.get("bidopendeadline");
                                pk = publish.getLong("id");
                                evaluateDecideWay = publish.getLong("evaluatedecideway");
                            } else if (bidProject.getBoolean("supplierinvitation")) {
                                mainType = "rebm".equals(appId) ? EntityMetadataCache.getDataEntityType((String)"rebm_supplierinvitation") : EntityMetadataCache.getDataEntityType((String)"bid_supplierinvitation");
                                DynamicObject invitation = this.supplierInvitation.getSupplierInvitationByProjectId(projectId, "id");
                                pk = invitation.getLong("id");
                            } else {
                                mainType = "rebm".equals(appId) ? EntityMetadataCache.getDataEntityType((String)"rebm_project") : EntityMetadataCache.getDataEntityType((String)"bid_project");
                                pk = projectId;
                                isProject = true;
                            }
                            if (evaluateDecideWay == null && bidProject.getBoolean("biddocument")) {
                                DynamicObject document = this.bidDocumentService.getBidDocumentByProjectId(projectId, "id,evaluatedecideway");
                                evaluateDecideWay = document.getLong("evaluatedecideway");
                            }
                            if (evaluateDecideWay == null && (bidProjectEvaluateDecideway = bidProject.getDynamicObject("evaluatedecideway")) != null) {
                                evaluateDecideWay = bidProjectEvaluateDecideway.getLong("id");
                            }
                            if (evaluateDecideWay == null) {
                                evaluateDecideWay = "bid".equals(appId) ? 493255064807351296L : 500440646276878336L;
                            }
                            DynamicObject mainData = null;
                            if (mainType.equals((Object)EntityMetadataCache.getDataEntityType((String)"bid_supplierinvitation"))) {
                                QFilter filter = new QFilter("id", "=", (Object)pk);
                                mainData = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((String)"rebm_supplierinvitation", (String)selectSectionString, (QFilter[])new QFilter[]{filter}) : BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)selectSectionString, (QFilter[])new QFilter[]{filter});
                            } else {
                                mainData = BusinessDataServiceHelper.loadSingle((Object)pk, (DynamicObjectType)mainType);
                            }
                            DynamicObject[] myTenderArr = null;
                            String selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus";
                            if ("bid".equals(appId)) {
                                myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
                            } else if ("rebm".equals(appId)) {
                                myTenderArr = BusinessDataServiceHelper.load((String)"resp_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
                            }
                            ArrayList<DynamicObject> targetMyTenderArr = new ArrayList<DynamicObject>();
                            if (myTenderArr != null && myTenderArr.length > 0) {
                                for (DynamicObject aMyTender : myTenderArr) {
                                    targetMyTenderArr.add(aMyTender);
                                }
                            }
                            HashMap<String, String> myTenderEntryMap = new HashMap<String, String>();
                            for (DynamicObject aMyTender : targetMyTenderArr) {
                                for (DynamicObject aMyTenderEntry : aMyTender.getDynamicObjectCollection("entry")) {
                                    String tenderStatus = aMyTender.getString("tenderstatus");
                                    if (StringUtils.isEmpty((CharSequence)tenderStatus)) continue;
                                    myTenderEntryMap.put(aMyTenderEntry.getString("sectionname") + aMyTender.getDynamicObject("supplier").getPkValue(), tenderStatus);
                                }
                            }
                            DynamicObjectCollection bidSection = null;
                            bidSection = isProject ? mainData.getDynamicObjectCollection("bidrollsection") : mainData.getDynamicObjectCollection("bidsection");
                            newOneType = EntityMetadataCache.getDataEntityType((String)"bid_bidopen");
                            if ("rebm".equals(appId)) {
                                newOneType = EntityMetadataCache.getDataEntityType((String)"rebm_bidopen");
                            }
                            newOne = new DynamicObject((DynamicObjectType)newOneType);
                            newTwo = new DynamicObject((DynamicObjectType)newOneType);
                            EntityType newOneSectionType = (EntityType)newOneType.getAllEntities().get("bidsection");
                            newOne.set("id", (Object)ID.genLongId());
                            newTwo.set("id", (Object)ID.genLongId());
                            newOne.set("evaluatedmethod", (Object)bidProject.getString("evaluatedmethod"));
                            newTwo.set("evaluatedmethod", (Object)bidProject.getString("evaluatedmethod"));
                            newOne.set("org", (Object)mainData.getDynamicObject("org"));
                            newTwo.set("org", (Object)mainData.getDynamicObject("org"));
                            newOne.set("quotationscoresch", (Object)bidProject.getDynamicObject("quotationscoresch"));
                            newTwo.set("quotationscoresch", (Object)bidProject.getDynamicObject("quotationscoresch"));
                            newOne.set("bidprojectname", bidProject.get("name"));
                            newTwo.set("bidprojectname", bidProject.get("name"));
                            newOne.set("currency", bidProject.get("currency"));
                            newTwo.set("currency", bidProject.get("currency"));
                            newOne.set("bidopentime", bidProject.get("bidopentime"));
                            newTwo.set("bidopentime", bidProject.get("bidopentime"));
                            newOne.set("techopenbidtime", bidProject.get("techopenbidtime"));
                            newTwo.set("techopenbidtime", bidProject.get("techopenbidtime"));
                            newOne.set("busopenbidtime", bidProject.get("busopenbidtime"));
                            newTwo.set("busopenbidtime", bidProject.get("busopenbidtime"));
                            newOne.set("lbidopentime", bidProject.get("bidopentime"));
                            newTwo.set("lbidopentime", bidProject.get("bidopentime"));
                            newOne.set("ltechopenbidtime", bidProject.get("techopenbidtime"));
                            newTwo.set("ltechopenbidtime", bidProject.get("techopenbidtime"));
                            newOne.set("lbusopenbidtime", bidProject.get("techopenbidtime"));
                            newTwo.set("lbusopenbidtime", bidProject.get("techopenbidtime"));
                            DynamicObjectCollection newOneSectionCollection = new DynamicObjectCollection((DynamicObjectType)newOneSectionType, (Object)newOne);
                            DynamicObjectCollection newTwoSectionCollection = new DynamicObjectCollection((DynamicObjectType)newOneSectionType, (Object)newTwo);
                            boolean isSupplier = false;
                            boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
                            boolean isTender = false;
                            for (DynamicObject tempSection : bidSection) {
                                DynamicObject newOneSection = new DynamicObject((DynamicObjectType)newOneSectionType);
                                DynamicObject newTwoSection = new DynamicObject((DynamicObjectType)newOneSectionType);
                                newTwoSection.set("seq", tempSection.get("seq"));
                                newOneSection.set("id", (Object)ID.genLongId());
                                newTwoSection.set("id", (Object)ID.genLongId());
                                if (isProject) {
                                    newOneSection.set("sectionname", (Object)tempSection.getLocaleString("rollsectionname"));
                                    newTwoSection.set("seq", tempSection.get("seq"));
                                    newTwoSection.set("sectionname", (Object)tempSection.getLocaleString("rollsectionname"));
                                } else {
                                    newOneSection.set("sectionname", (Object)tempSection.getLocaleString("sectionname"));
                                    newTwoSection.set("seq", tempSection.get("seq"));
                                    newTwoSection.set("sectionname", (Object)tempSection.getLocaleString("sectionname"));
                                }
                                DynamicObjectCollection supplierEntry = tempSection.getDynamicObjectCollection("supplierentry");
                                EntityType supplierType = (EntityType)newOneType.getAllEntities().get("supplierentry");
                                EntityType supplierDetailType = (EntityType)newOneType.getAllEntities().get("supplierdetail");
                                DynamicObjectCollection newSupplierEntry = new DynamicObjectCollection((DynamicObjectType)supplierType, (Object)newOneSection);
                                DynamicObjectCollection newSupplierDetails = new DynamicObjectCollection((DynamicObjectType)supplierDetailType, (Object)newOneSection);
                                DynamicObjectCollection newTwoSupplierEntry = new DynamicObjectCollection((DynamicObjectType)supplierType, (Object)newTwoSection);
                                DynamicObjectCollection newTwoSupplierDetails = new DynamicObjectCollection((DynamicObjectType)supplierDetailType, (Object)newTwoSection);
                                int newseq = 0;
                                for (DynamicObject tempSupllier : supplierEntry) {
                                    BigDecimal suppliersecdeposit;
                                    Object tenderStrategy;
                                    isSupplier = true;
                                    DynamicObject newOneSupplier = new DynamicObject((DynamicObjectType)supplierType);
                                    DynamicObject newTwoSupplier = new DynamicObject((DynamicObjectType)supplierType);
                                    DynamicObject supplier = tempSupllier.getDynamicObject("supplier");
                                    if (supplier == null) continue;
                                    if (enable) {
                                        if (params != null && ((Boolean)params.get("isInvalid")).booleanValue()) {
                                            String sectionName = tempSection.getString("sectionname");
                                            String tenderStatus = (String)myTenderEntryMap.get(sectionName + supplier.getPkValue());
                                            isTender = "TENDERED".equals(tenderStatus);
                                        } else {
                                            String tenderStatus = tempSupllier.getString("tenderstatus");
                                            tenderStrategy = tempSupllier.getString("tenderstrategy");
                                            isTender = StringUtils.isEmpty((CharSequence)tenderStrategy) ? "TENDERED".equals(tenderStatus) : ("UNNEEDBID".equals(tenderStrategy) ? !"UNTENDERED".equals(tenderStatus) : false);
                                        }
                                    }
                                    if (BidModeHelper.isPublicBidding((DynamicObject)bidProject)) {
                                        newOneSupplier.set("seq", tempSupllier.get("seq"));
                                        newOneSupplier.set("supplier", (Object)supplier);
                                        newOneSupplier.set("supplier_istender", (Object)isTender);
                                        newOneSupplier.set("suppliercontact", (Object)tempSupllier.getLocaleString("suppliercontact"));
                                        newOneSupplier.set("contactphone", tempSupllier.get("contactphone"));
                                        suppliersecdeposit = tempSupllier.getBigDecimal("suppliersecdeposit");
                                        if (suppliersecdeposit.compareTo(BigDecimal.ZERO) == 0) {
                                            newOneSupplier.set("supplier_deposittype", (Object)"NOTPAY");
                                        } else {
                                            newOneSupplier.set("supplier_deposittype", (Object)"UNPAY");
                                        }
                                        newSupplierEntry.add((Object)newOneSupplier);
                                        newTwoSupplier.set("seq", tempSupllier.get("seq"));
                                        newTwoSupplier.set("supplier", (Object)supplier);
                                        newTwoSupplier.set("supplier_istender", (Object)isTender);
                                        newTwoSupplier.set("suppliercontact", (Object)tempSupllier.getLocaleString("suppliercontact"));
                                        newTwoSupplier.set("contactphone", tempSupllier.get("contactphone"));
                                        if (suppliersecdeposit.compareTo(BigDecimal.ZERO) == 0) {
                                            newTwoSupplier.set("supplier_deposittype", (Object)"NOTPAY");
                                        } else {
                                            newTwoSupplier.set("supplier_deposittype", (Object)"UNPAY");
                                        }
                                        newTwoSupplierEntry.add((Object)newTwoSupplier);
                                    } else if (mainType.equals((Object)EntityMetadataCache.getDataEntityType((String)"bid_supplierinvitation"))) {
                                        if (!"UNCONFIRM".equals(tempSupllier.get("invitationstatus")) && !"REJECTED".equals(tempSupllier.get("invitationstatus"))) {
                                            newOneSupplier.set("seq", tempSupllier.get("seq"));
                                            newOneSupplier.set("supplier", (Object)supplier);
                                            newOneSupplier.set("supplier_istender", (Object)isTender);
                                            newOneSupplier.set("suppliercontact", (Object)tempSupllier.getLocaleString("suppliercontact"));
                                            newOneSupplier.set("contactphone", tempSupllier.get("contactphone"));
                                            suppliersecdeposit = tempSupllier.getBigDecimal("suppliersecdeposit");
                                            if (suppliersecdeposit.compareTo(BigDecimal.ZERO) == 0) {
                                                newOneSupplier.set("supplier_deposittype", (Object)"NOTPAY");
                                            } else {
                                                newOneSupplier.set("supplier_deposittype", (Object)"UNPAY");
                                            }
                                            newSupplierEntry.add((Object)newOneSupplier);
                                            newTwoSupplier.set("seq", tempSupllier.get("seq"));
                                            newTwoSupplier.set("supplier", (Object)supplier);
                                            newTwoSupplier.set("supplier_istender", (Object)isTender);
                                            newTwoSupplier.set("suppliercontact", (Object)tempSupllier.getLocaleString("suppliercontact"));
                                            newTwoSupplier.set("contactphone", tempSupllier.get("contactphone"));
                                            if (suppliersecdeposit.compareTo(BigDecimal.ZERO) == 0) {
                                                newTwoSupplier.set("supplier_deposittype", (Object)"NOTPAY");
                                            } else {
                                                newTwoSupplier.set("supplier_deposittype", (Object)"UNPAY");
                                            }
                                            newTwoSupplierEntry.add((Object)newTwoSupplier);
                                        }
                                    } else {
                                        newOneSupplier.set("seq", tempSupllier.get("seq"));
                                        newOneSupplier.set("supplier", (Object)supplier);
                                        newOneSupplier.set("supplier_istender", (Object)isTender);
                                        newOneSupplier.set("suppliercontact", (Object)tempSupllier.getLocaleString("suppliercontact"));
                                        newOneSupplier.set("contactphone", tempSupllier.get("contactphone"));
                                        suppliersecdeposit = tempSupllier.getBigDecimal("suppliersecdeposit");
                                        if (suppliersecdeposit.compareTo(BigDecimal.ZERO) == 0) {
                                            newOneSupplier.set("supplier_deposittype", (Object)"NOTPAY");
                                        } else {
                                            newOneSupplier.set("supplier_deposittype", (Object)"UNPAY");
                                        }
                                        newSupplierEntry.add((Object)newOneSupplier);
                                        newTwoSupplier.set("seq", tempSupllier.get("seq"));
                                        newTwoSupplier.set("supplier", (Object)supplier);
                                        newTwoSupplier.set("supplier_istender", (Object)isTender);
                                        newTwoSupplier.set("suppliercontact", (Object)tempSupllier.getLocaleString("suppliercontact"));
                                        newTwoSupplier.set("contactphone", tempSupllier.get("contactphone"));
                                        if (suppliersecdeposit.compareTo(BigDecimal.ZERO) == 0) {
                                            newTwoSupplier.set("supplier_deposittype", (Object)"NOTPAY");
                                        } else {
                                            newTwoSupplier.set("supplier_deposittype", (Object)"UNPAY");
                                        }
                                        newTwoSupplierEntry.add((Object)newTwoSupplier);
                                    }
                                    if (isTenNew) continue;
                                    Object pSupplierDetails = null;
                                    pSupplierDetails = isProject ? this.bidProjectService.getMaDetailCollectionByProjectAndSec(bidProject, tempSection.getString("rollsectionname")) : this.bidProjectService.getMaDetailCollectionByProjectAndSec(bidProject, tempSection.getString("sectionname"));
                                    tenderStrategy = pSupplierDetails.iterator();
                                    while (tenderStrategy.hasNext()) {
                                        DynamicObject pSupplierDetail = (DynamicObject)tenderStrategy.next();
                                        DynamicObject newSupplierDetail = new DynamicObject((DynamicObjectType)supplierDetailType);
                                        DynamicObject[] newTwoSupplierDetail = new DynamicObject((DynamicObjectType)supplierDetailType);
                                        newSupplierDetail.set("seq", (Object)(++newseq));
                                        newSupplierDetail.set("pursupplier", (Object)supplier);
                                        newSupplierDetail.set("purentrycontent", pSupplierDetail.get("purentrycontent"));
                                        newSupplierDetail.set("purentryproject", pSupplierDetail.get("purentryproject"));
                                        newSupplierDetail.set("materialid", pSupplierDetail.get("materialid"));
                                        newSupplierDetail.set("baseunit", pSupplierDetail.get("baseunit"));
                                        newSupplierDetail.set("materialdes", pSupplierDetail.get("materialdes"));
                                        newSupplierDetail.set("qty", pSupplierDetail.get("qty"));
                                        if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
                                            newSupplierDetail.set("listnumber", pSupplierDetail.get("listnumber"));
                                            newSupplierDetail.set("listname", pSupplierDetail.get("listname"));
                                            newSupplierDetail.set("resourceitem", pSupplierDetail.get("resourceitem"));
                                        }
                                        newSupplierDetails.add((Object)newSupplierDetail);
                                        newTwoSupplierDetail.set("seq", (Object)(++newseq));
                                        newTwoSupplierDetail.set("pursupplier", (Object)supplier);
                                        newTwoSupplierDetail.set("purentrycontent", pSupplierDetail.get("purentrycontent"));
                                        newTwoSupplierDetail.set("purentryproject", pSupplierDetail.get("purentryproject"));
                                        newTwoSupplierDetail.set("materialid", pSupplierDetail.get("materialid"));
                                        newTwoSupplierDetail.set("baseunit", pSupplierDetail.get("baseunit"));
                                        newTwoSupplierDetail.set("materialdes", pSupplierDetail.get("materialdes"));
                                        newTwoSupplierDetail.set("qty", pSupplierDetail.get("qty"));
                                        if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
                                            newTwoSupplierDetail.set("listnumber", pSupplierDetail.get("listnumber"));
                                            newTwoSupplierDetail.set("listname", pSupplierDetail.get("listname"));
                                            newTwoSupplierDetail.set("resourceitem", pSupplierDetail.get("resourceitem"));
                                        }
                                        newTwoSupplierDetails.add((Object)newTwoSupplierDetail);
                                    }
                                }
                                newOneSection.set("supplierentry", (Object)newSupplierEntry);
                                newOneSection.set("supplierdetail", (Object)newSupplierDetails);
                                newOneSectionCollection.add((Object)newOneSection);
                                newTwoSection.set("supplierentry", (Object)newTwoSupplierEntry);
                                newTwoSection.set("supplierdetail", (Object)newTwoSupplierDetails);
                                newTwoSectionCollection.add((Object)newTwoSection);
                            }
                            if (!isSupplier) {
                                newOne.set("needflagnewsupplier", (Object)Boolean.FALSE);
                                newTwo.set("needflagnewsupplier", (Object)Boolean.FALSE);
                            } else {
                                newOne.set("needflagnewsupplier", (Object)Boolean.TRUE);
                                newTwo.set("needflagnewsupplier", (Object)Boolean.TRUE);
                            }
                            newOne.set("bidsection", (Object)newOneSectionCollection);
                            newOne.set("billno", (Object)bidProject.getString("billno"));
                            newTwo.set("bidsection", (Object)newTwoSectionCollection);
                            newTwo.set("billno", (Object)bidProject.getString("billno"));
                            if (bidOpenDate == null || "".equals(bidOpenDate)) {
                                bidOpenDate = bidProject.get("bidopendeadline");
                            }
                            if (!isProject) {
                                Object projectTemp = mainData.get("bidproject");
                                newOne.set("bidproject", projectTemp);
                                newTwo.set("bidproject", projectTemp);
                            } else {
                                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bidproject_f7");
                                DynamicObject projectF7 = BusinessDataServiceHelper.loadSingle((Object)projectId, (DynamicObjectType)type);
                                newOne.set("bidproject", (Object)projectF7);
                                newTwo.set("bidproject", (Object)projectF7);
                            }
                            newOne.set("bidopendeadline", bidOpenDate);
                            newOne.set("evaluatedecideway", (Object)evaluateDecideWay);
                            newOne.set("billstatus", (Object)"D");
                            newOne.set("evaluatedmethod", (Object)bidEvalMethod);
                            newTwo.set("bidopendeadline", bidOpenDate);
                            newTwo.set("evaluatedecideway", (Object)evaluateDecideWay);
                            newTwo.set("billstatus", (Object)"D");
                            newTwo.set("evaluatedmethod", (Object)bidEvalMethod);
                            HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreatorNew(bidProject);
                            DynamicObject creatorMul = creatorMap.get("06");
                            creatorBus = creatorMap.get("12");
                            creatorTec = creatorMap.get("11");
                            Date now = new Date();
                            newOne.set("createtime", (Object)now);
                            addThousand = new Date(now.getTime() + 1000L);
                            deleteThousand = new Date(now.getTime() - 1000L);
                            newTwo.set("createtime", (Object)new Date(now.getTime() + 1000L));
                            boolean bidProIdOnlineEval = bidProject.getBoolean("isonlineeval");
                            newOne.set("techweight", bidProject.get("techweight"));
                            newOne.set("comweight", bidProject.get("comweight"));
                            newOne.set("extractrecoid", bidProject.get("extractrecoid"));
                            DynamicObjectCollection bidProProficientEntry = bidProject.getDynamicObjectCollection("bid_proficiententry");
                            DynamicObjectCollection newOneProficientEntry = newOne.getDynamicObjectCollection("bidopen_proficient");
                            for (DynamicObject bidProProficientEntryRow : bidProProficientEntry) {
                                DynamicObject newOneProficientEntryAddNew = newOneProficientEntry.addNew();
                                newOneProficientEntryAddNew.set("proficient", bidProProficientEntryRow.get("proficient"));
                                newOneProficientEntryAddNew.set("proficient_technical", bidProProficientEntryRow.get("proficient_technical"));
                                newOneProficientEntryAddNew.set("proficient_commercial", bidProProficientEntryRow.get("proficient_commercial"));
                                newOneProficientEntryAddNew.set("proficient_comment", bidProProficientEntryRow.get("proficient_comment"));
                            }
                            newOne.set("isonlineeval", bidProject.get("isonlineeval"));
                            if (bidProIdOnlineEval && !BidEvalMethodEnum.DX.getCode().equals(bidEvalMethod)) {
                                newOne.set("bidevaltemplate", bidProject.get("bidevaltemplate"));
                                newOne.set("scoremode", bidProject.get("scoremode"));
                                newOne.set("scoretype", bidProject.get("scoretype"));
                                DynamicObjectCollection bidProOpenTypeEntry = bidProject.getDynamicObjectCollection("bid_opentypeentry");
                                DynamicObjectCollection newOneEvalItemEntryEntity = newOne.getDynamicObjectCollection("entryentity");
                                for (DynamicObject bidProOpenTypeEntryRow : bidProOpenTypeEntry) {
                                    DynamicObject newOneEvalItemEntryEntityAddNew = newOneEvalItemEntryEntity.addNew();
                                    newOneEvalItemEntryEntityAddNew.set("type1", bidProOpenTypeEntryRow.get("evalparenttype"));
                                    DynamicObjectCollection newOneEvalItemEntry = newOneEvalItemEntryEntityAddNew.getDynamicObjectCollection("bidopen_evalitementry");
                                    DynamicObjectCollection bidProOpenEvalEntry = bidProOpenTypeEntryRow.getDynamicObjectCollection("bid_openevalentry");
                                    for (DynamicObject bidProOpenEvalEntryRow : bidProOpenEvalEntry) {
                                        DynamicObject newOneEvalItemEntryAddNew = newOneEvalItemEntry.addNew();
                                        newOneEvalItemEntryAddNew.set("type", bidProOpenEvalEntryRow.get("type"));
                                        newOneEvalItemEntryAddNew.set("item", bidProOpenEvalEntryRow.get("item"));
                                        newOneEvalItemEntryAddNew.set("standard", bidProOpenEvalEntryRow.get("standard"));
                                        newOneEvalItemEntryAddNew.set("score", bidProOpenEvalEntryRow.get("score"));
                                        newOneEvalItemEntryAddNew.set("weight", bidProOpenEvalEntryRow.get("weight"));
                                        newOneEvalItemEntryAddNew.set("quotationindex", bidProOpenEvalEntryRow.get("quotationindex"));
                                    }
                                }
                            }
                            openType = bidProject.getString("bidopentype");
                            String docType = bidProject.getString("doctype");
                            if (!StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)openType) && !StringUtils.isEmpty((CharSequence)openType)) break block76;
                            EntityTypeHelper.setEntityType(newOne, "bid_bidopen", "bidproject");
                            if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
                                newOne.set("opentype", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                                newOne.set("opentypedescription", (Object)ResManager.loadKDString((String)"\u5546\u52a1\u6807", (String)"BidOpenServiceImpl_2", (String)"scm-bid-business", (Object[])new Object[0]));
                                newOne.set("creator", (Object)creatorMul);
                                int multiOpenRounds = BidOpenUtil.getOpenRounds((Object)projectId, (String)appId, (String)BidOpenTypeEnum.BUSSINESS.getValue());
                                newOne.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidOpenServiceImpl_29", (String)"scm-bid-business", (Object[])new Object[0]), BidOpenServiceImpl.toChinese(String.valueOf(multiOpenRounds))));
                            } else if (BidOpenTypeEnum.MULTI.getValue().equals(docType)) {
                                newOne.set("opentype", (Object)BidOpenTypeEnum.MULTI.getValue());
                                newOne.set("opentypedescription", (Object)ResManager.loadKDString((String)"\u6280\u672f\u6807+\u5546\u52a1\u6807", (String)"BidOpenServiceImpl_1", (String)"scm-bid-business", (Object[])new Object[0]));
                                newOne.set("creator", (Object)creatorMul);
                                int multiOpenRounds = BidOpenUtil.getOpenRounds((Object)projectId, (String)appId, (String)BidOpenTypeEnum.MULTI.getValue());
                                newOne.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidOpenServiceImpl_29", (String)"scm-bid-business", (Object[])new Object[0]), BidOpenServiceImpl.toChinese(String.valueOf(multiOpenRounds))));
                            }
                            this.setSourceBillData(newOne, appId);
                            String openTypeNewOne2 = newOne.getString("opentype");
                            if (isEncEnable && isEncOpen && (openTypeNewOne2.equals(encTypc) || "MULTI".equals(encTypc))) {
                                newOne.set("isdark", (Object)true);
                            }
                            SaveServiceHelper.save((IDataEntityType)newOneType, (Object[])new DynamicObject[]{newOne});
                            if (isEncEnable) {
                                this.bidDarkService.saveBidDark(newOne, appId);
                            }
                            break block77;
                        }
                        EntityTypeHelper.setEntityType(newOne, "bid_bidopen", "bidproject");
                        EntityTypeHelper.setEntityType(newTwo, "bid_bidopen", "bidproject");
                        isDelete = false;
                        addFirst = true;
                        addSecond = true;
                        array = this.getBidOpenArrayByProjectId(projectId);
                        if (array != null && array.length > 0) {
                            isDelete = true;
                        }
                        if (!StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)openType)) break block78;
                        newOne.set("opentype", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                        newOne.set("opentypedescription", (Object)ResManager.loadKDString((String)"\u5546\u52a1\u6807", (String)"BidOpenServiceImpl_2", (String)"scm-bid-business", (Object[])new Object[0]));
                        newOne.set("creator", (Object)creatorBus);
                        int busiOpenRounds = BidOpenUtil.getOpenRounds((Object)projectId, (String)appId, (String)BidOpenTypeEnum.BUSSINESS.getValue());
                        newOne.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidOpenServiceImpl_29", (String)"scm-bid-business", (Object[])new Object[0]), BidOpenServiceImpl.toChinese(String.valueOf(busiOpenRounds))));
                        openTypeNewOne = newOne.getString("opentype");
                        if (isEncEnable && isEncOpen && (openTypeNewOne.equals(encTypc) || "MULTI".equals(encTypc))) {
                            newOne.set("isdark", (Object)true);
                        }
                        newTwo.set("opentype", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
                        int techOpenRounds = BidOpenUtil.getOpenRounds((Object)projectId, (String)appId, (String)BidOpenTypeEnum.TECHNICAL.getValue());
                        newTwo.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidOpenServiceImpl_29", (String)"scm-bid-business", (Object[])new Object[0]), BidOpenServiceImpl.toChinese(String.valueOf(techOpenRounds))));
                        newTwo.set("opentypedescription", (Object)ResManager.loadKDString((String)"\u6280\u672f\u6807", (String)"BidOpenServiceImpl_3", (String)"scm-bid-business", (Object[])new Object[0]));
                        newTwo.set("creator", (Object)creatorTec);
                        openTypeNewTwo = newTwo.getString("opentype");
                        if (isEncEnable && isEncOpen && (openTypeNewTwo.equals(encTypc) || "MULTI".equals(encTypc))) {
                            newTwo.set("isdark", (Object)true);
                        }
                        if (!isDelete) break block79;
                        i = 0;
                        for (DynamicObject bidOpen2 : array) {
                            String billStatus = bidOpen2.getString("billstatus");
                            if (!StringUtils.equals((CharSequence)"A", (CharSequence)billStatus) && !StringUtils.equals((CharSequence)"D", (CharSequence)billStatus)) continue;
                            ++i;
                        }
                        if (i != 2) break block80;
                        addSecond = false;
                        DynamicObject secondTech = null;
                        for (DynamicObject open : array) {
                            if (!StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)open.getString("opentype"))) continue;
                            secondTech = this.getBidOpenByIdAndType(open.getLong("id"), appId);
                        }
                        if (secondTech == null) break block79;
                        secondTech.set("createtime", (Object)addThousand);
                        SaveServiceHelper.save((IDataEntityType)newOneType, (Object[])new DynamicObject[]{secondTech});
                        if (!isEncEnable) break block79;
                        this.bidDarkService.saveBidDark(secondTech, appId);
                        break block79;
                    }
                    if (i != 1) break block79;
                    addFirst = false;
                    DynamicObject firstBusiness = null;
                    for (DynamicObject open : array) {
                        if (!StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)open.getString("opentype"))) continue;
                        firstBusiness = this.getBidOpenByIdAndType(open.getLong("id"), appId);
                    }
                    if (firstBusiness == null) break block79;
                    firstBusiness.set("createtime", (Object)deleteThousand);
                    firstBusiness.set("opentype", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                    SaveServiceHelper.save((IDataEntityType)newOneType, (Object[])new DynamicObject[]{firstBusiness});
                    if (!isEncEnable) break block79;
                    this.bidDarkService.saveBidDark(firstBusiness, appId);
                    break block79;
                }
                if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)openType)) {
                    List bidOpenList;
                    newOne.set("opentype", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
                    newOne.set("opentypedescription", (Object)ResManager.loadKDString((String)"\u6280\u672f\u6807", (String)"BidOpenServiceImpl_3", (String)"scm-bid-business", (Object[])new Object[0]));
                    newOne.set("creator", (Object)creatorTec);
                    int techOpenRounds = BidOpenUtil.getOpenRounds((Object)projectId, (String)appId, (String)BidOpenTypeEnum.TECHNICAL.getValue());
                    newOne.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidOpenServiceImpl_29", (String)"scm-bid-business", (Object[])new Object[0]), BidOpenServiceImpl.toChinese(String.valueOf(techOpenRounds))));
                    openTypeNewOne = newOne.getString("opentype");
                    if (isEncEnable && isEncOpen && (openTypeNewOne.equals(encTypc) || "MULTI".equals(encTypc))) {
                        newOne.set("isdark", (Object)true);
                    }
                    newTwo.set("opentype", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                    newTwo.set("opentypedescription", (Object)ResManager.loadKDString((String)"\u5546\u52a1\u6807", (String)"BidOpenServiceImpl_2", (String)"scm-bid-business", (Object[])new Object[0]));
                    newTwo.set("creator", (Object)creatorBus);
                    int busiOpenRounds = BidOpenUtil.getOpenRounds((Object)projectId, (String)appId, (String)BidOpenTypeEnum.BUSSINESS.getValue());
                    newTwo.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidOpenServiceImpl_29", (String)"scm-bid-business", (Object[])new Object[0]), BidOpenServiceImpl.toChinese(String.valueOf(busiOpenRounds))));
                    openTypeNewTwo = newTwo.getString("opentype");
                    if (isEncEnable && isEncOpen && (openTypeNewTwo.equals(encTypc) || "MULTI".equals(encTypc))) {
                        newTwo.set("isdark", (Object)true);
                    }
                    if (isDelete && !(bidOpenList = Arrays.stream(array).filter(bidOpen -> !"XX".equals(bidOpen.getString("billstatus"))).collect(Collectors.toList())).isEmpty()) {
                        DynamicObject openTemp = null;
                        for (DynamicObject open : bidOpenList) {
                            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)open.getString("opentype"))) {
                                openTemp = this.getBidOpenByIdAndType(open.getLong("id"), appId);
                                addFirst = false;
                            }
                            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)open.getString("opentype"))) {
                                openTemp = this.getBidOpenByIdAndType(open.getLong("id"), appId);
                                addSecond = false;
                            }
                            openTemp.set("createtime", (Object)deleteThousand);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{openTemp});
                            if (!isEncEnable) continue;
                            this.bidDarkService.saveBidDark(openTemp, appId);
                        }
                    }
                }
            }
            if (addFirst) {
                this.setSourceBillData(newOne, appId);
                SaveServiceHelper.save((IDataEntityType)newOneType, (Object[])new DynamicObject[]{newOne});
                if (isEncEnable) {
                    this.bidDarkService.saveBidDark(newOne, appId);
                }
            }
            if (addSecond) {
                this.setSourceBillData(newTwo, appId);
                SaveServiceHelper.save((IDataEntityType)newOneType, (Object[])new DynamicObject[]{newTwo});
                if (isEncEnable) {
                    this.bidDarkService.saveBidDark(newTwo, appId);
                }
            }
        }
    }

    public void setTopInfo(DynamicObject bidOpen, DynamicObject oldBidOpen) {
        bidOpen.set("baseprice", oldBidOpen.get("baseprice"));
        bidOpen.set("evaluatedecideway", oldBidOpen.get("evaluatedecideway"));
        bidOpen.set("techweight", oldBidOpen.get("techweight"));
        bidOpen.set("comweight", oldBidOpen.get("comweight"));
        bidOpen.set("opentype", oldBidOpen.get("opentype"));
        bidOpen.set("needflagnewsupplier", oldBidOpen.get("needflagnewsupplier"));
        bidOpen.set("isonlineeval", oldBidOpen.get("isonlineeval"));
        bidOpen.set("bidevaltemplate", oldBidOpen.get("bidevaltemplate"));
        bidOpen.set("scoremode", oldBidOpen.get("scoremode"));
        bidOpen.set("scoretype", oldBidOpen.get("scoretype"));
        bidOpen.set("modifier", oldBidOpen.get("modifier"));
        bidOpen.set("modifytime", oldBidOpen.get("modifytime"));
        bidOpen.set("iscarry", (Object)Boolean.TRUE);
    }

    public void setProficientInfo(DynamicObject bidopen, DynamicObject oldBidopen) {
        DynamicObjectCollection oldProficientColl = oldBidopen.getDynamicObjectCollection("bidopen_proficient");
        DynamicObjectCollection proficientColl = bidopen.getDynamicObjectCollection("bidopen_proficient");
        proficientColl.clear();
        for (int i = 0; i < oldProficientColl.size(); ++i) {
            DynamicObject oldProficient = (DynamicObject)oldProficientColl.get(i);
            DynamicObject poficient = proficientColl.addNew();
            poficient.set("proficient", oldProficient.get("proficient"));
            poficient.set("proficient_technical", oldProficient.get("proficient_technical"));
            poficient.set("proficient_commercial", oldProficient.get("proficient_commercial"));
            poficient.set("proficient_comment", oldProficient.get("proficient_comment"));
            poficient.set("selectionmethod", oldProficient.get("selectionmethod"));
        }
    }

    public void setEvalItemInfo(DynamicObject bidopen, DynamicObject oldBidopen) {
        DynamicObjectCollection oldEntryEntityColl = oldBidopen.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entryEntityColl = bidopen.getDynamicObjectCollection("entryentity");
        entryEntityColl.clear();
        for (DynamicObject oldEntryEntityRow : oldEntryEntityColl) {
            DynamicObject addNew = entryEntityColl.addNew();
            addNew.set("type1", oldEntryEntityRow.get("type1"));
            addNew.set("seq", oldEntryEntityRow.get("seq"));
            DynamicObjectCollection oldEvalTtemEntryColl = oldEntryEntityRow.getDynamicObjectCollection("bidopen_evalitementry");
            DynamicObjectCollection evalItemEntryNewColl = addNew.getDynamicObjectCollection("bidopen_evalitementry");
            evalItemEntryNewColl.clear();
            for (DynamicObject oldEvalTtemEntryRow : oldEvalTtemEntryColl) {
                DynamicObject evalItemEntryAddNew = evalItemEntryNewColl.addNew();
                evalItemEntryAddNew.set("type", oldEvalTtemEntryRow.get("type"));
                evalItemEntryAddNew.set("item", oldEvalTtemEntryRow.get("item"));
                evalItemEntryAddNew.set("standard", oldEvalTtemEntryRow.get("standard"));
                evalItemEntryAddNew.set("score", oldEvalTtemEntryRow.get("score"));
                evalItemEntryAddNew.set("weight", oldEvalTtemEntryRow.get("weight"));
                evalItemEntryAddNew.set("seq", oldEvalTtemEntryRow.get("seq"));
                evalItemEntryAddNew.set("quotationindex", oldEvalTtemEntryRow.get("quotationindex"));
            }
        }
    }

    protected void setSourceBillData(DynamicObject newOne, String appId) {
        Object bidProjectId = newOne.getDynamicObject("bidproject").getPkValue();
        QFilter publishFilter = new QFilter("bidproject", "=", bidProjectId).and("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal());
        QFilter openFilter = new QFilter("bidproject", "=", bidProjectId).and("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal());
        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)newOne.getString("opentype"))) {
            openFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
        } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)newOne.getString("opentype"))) {
            openFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
        }
        String bidPublishForm = "bid_bidpublish";
        String bidOpenForm = "bid_bidopen";
        if ("rebm".equals(appId)) {
            bidPublishForm = "rebm_bidpublish";
            bidOpenForm = "rebm_bidopen";
        }
        DynamicObject[] bidPublishColl = BusinessDataServiceHelper.load((String)bidPublishForm, (String)"id,supplierinvitationid", (QFilter[])publishFilter.toArray(), (String)"createtime asc");
        DynamicObjectCollection bidOpenHistoryArray = QueryServiceHelper.query((String)bidOpenForm, (String)"id", (QFilter[])openFilter.toArray(), (String)"createtime desc");
        if (bidPublishColl.length > 0) {
            DynamicObject bidPublish = bidPublishColl[0];
            if (bidPublish.get("supplierinvitationid") != null) {
                newOne.set("supplierinvitationid", bidPublish.getDynamicObject("supplierinvitationid").getPkValue());
            }
            newOne.set("bidpublishid", bidPublish.get("id"));
        }
        if (bidOpenHistoryArray.size() != 0) {
            DynamicObject bidopenHistory = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)bidOpenHistoryArray.get(0)).getLong("id"), (String)bidOpenForm);
            newOne.set("sourcebillid", bidopenHistory.get("id"));
            this.setTenInfo(newOne, bidopenHistory, appId);
        }
    }

    protected void setTenInfo(DynamicObject newOne, DynamicObject bidOpenHistory, String appId) {
        DynamicObjectCollection bidSectionList = newOne.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bidSectionHisList = bidOpenHistory.getDynamicObjectCollection("bidsection");
        this.setTopInfo(newOne, bidOpenHistory);
        this.setProficientInfo(newOne, bidOpenHistory);
        this.setEvalItemInfo(newOne, bidOpenHistory);
        Map<String, Map<Long, Boolean>> map = this.getPublishSectionNameAndSupplierId(appId, newOne.getDynamicObject("bidproject"));
        bidSectionList.forEach(bidSection -> {
            Optional<DynamicObject> bidSectionAny = bidSectionHisList.stream().filter(item -> item.getString("sectionname").equals(bidSection.getString("sectionname"))).findAny();
            if (bidSectionAny.isPresent()) {
                String opentype = newOne.getString("opentype");
                this.updateTenInfo((DynamicObject)bidSection, bidSectionAny.get(), appId, newOne.getDynamicObject("bidproject"), opentype, map);
            }
        });
        this.setBusPriceNew(newOne, appId);
        BidOpenServiceImpl.setBottomSection(bidOpenHistory, newOne, appId);
    }

    protected void updateTenInfo(DynamicObject bidSection, DynamicObject bidSectionHis, String appId, DynamicObject bidProject, String opentype, Map<String, Map<Long, Boolean>> map) {
        DynamicObjectCollection supplierEntryList = bidSection.getDynamicObjectCollection("supplierentry");
        DynamicObjectCollection supplierEntryHisList = bidSectionHis.getDynamicObjectCollection("supplierentry");
        DynamicObjectCollection supplierDetailList = bidSection.getDynamicObjectCollection("supplierdetail");
        supplierEntryList.forEach(supplierEntry -> {
            Optional<DynamicObject> supplierEntryHisOptional = supplierEntryHisList.stream().filter(item -> item.getDynamicObject("supplier").getPkValue().equals(supplierEntry.getDynamicObject("supplier").getPkValue())).findAny();
            boolean isTender = supplierEntry.getBoolean("supplier_istender");
            if (isTender && supplierEntryHisOptional.isPresent()) {
                DynamicObject supplierEntryHis = supplierEntryHisOptional.get();
                this.setOpenPrice((DynamicObject)supplierEntry, supplierEntryHis, bidSection, bidSectionHis, appId);
                this.setQuestionPrice(bidSection, (DynamicObject)supplierEntry, appId, bidProject, supplierDetailList, opentype);
            }
        });
        String sectionName = bidSection.getString("sectionname");
        Map<Long, Boolean> supplierIdAndStrategy = map.get(sectionName);
        for (DynamicObject supplierEntry2 : supplierEntryList) {
            Object supplierId = supplierEntry2.getDynamicObject("supplier").getPkValue();
            for (DynamicObject supplierEntryHis : supplierEntryHisList) {
                if (!supplierEntryHis.getDynamicObject("supplier").getPkValue().equals(supplierId) || !supplierIdAndStrategy.containsKey(supplierId)) continue;
                supplierEntry2.set("untenderflag", supplierEntryHis.get("untenderflag"));
                supplierEntry2.set("untendertype", supplierEntryHis.get("untendertype"));
                supplierEntry2.set("untenderreason", supplierEntryHis.get("untenderreason"));
                this.copyAttach(supplierEntry2.getDynamicObjectCollection("untenderattach"), supplierEntryHis.getDynamicObjectCollection("untenderattach"));
            }
        }
    }

    public Map<String, Map<Long, Boolean>> getPublishSectionNameAndSupplierId(String appId, DynamicObject bidproject) {
        String bidpublishName = "bid_bidpublish";
        String bidopenName = "bid_bidopen";
        if (appId.equals("rebm")) {
            bidpublishName = "rebm_bidpublish";
            bidopenName = "rebm_bidopen";
        }
        HashMap<String, Map<Long, Boolean>> map = new HashMap<String, Map<Long, Boolean>>();
        QFilter publishFilter = new QFilter("bidproject", "=", bidproject.getPkValue()).and("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal());
        DynamicObject[] bidpublishColl = BusinessDataServiceHelper.load((String)bidpublishName, (String)"id,supplierinvitationid,bidsection.sectionname,supplierentry.supplier,supplierentry.supplier,supplierentry.tenderstrategy,supplierentry.tenderstatus", (QFilter[])publishFilter.toArray(), (String)"createtime asc");
        if (bidpublishColl.length > 0) {
            DynamicObject bidpublish = bidpublishColl[0];
            DynamicObjectCollection sectionColl = bidpublish.getDynamicObjectCollection("bidsection");
            for (DynamicObject section : sectionColl) {
                HashMap<Long, Boolean> supplierIdAndStrategyMap = new HashMap<Long, Boolean>();
                String sectionName = section.getString("sectionname");
                DynamicObjectCollection supplierEntryColl = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    String tenderStrategy = supplierEntry.getString("tenderstrategy");
                    String tenderStatus = supplierEntry.getString("tenderstatus");
                    Long supplierId = supplierEntry.getDynamicObject("supplier").getLong("id");
                    if (!StringUtils.isNotEmpty((CharSequence)tenderStrategy) || !StringUtils.isNotEmpty((CharSequence)tenderStatus) || !tenderStrategy.equals("UNNEEDBID") || !tenderStatus.equals("UNTENDERED")) continue;
                    supplierIdAndStrategyMap.put(supplierId, Boolean.TRUE);
                }
                map.put(sectionName, supplierIdAndStrategyMap);
            }
        }
        return map;
    }

    public static void setBottomSection(DynamicObject curOpenBill, DynamicObject targetOpen, String appId) {
        DynamicObjectCollection targetBottomSectionEntryCol = targetOpen.getDynamicObjectCollection("bottomsection");
        DynamicObjectCollection curOpenBottomSectionSectionEntryCol = curOpenBill.getDynamicObjectCollection("bottomsection");
        targetBottomSectionEntryCol.clear();
        BigDecimal basePrice = BigDecimal.ZERO;
        for (DynamicObject sourceBottomSectionSectionEntry : curOpenBottomSectionSectionEntryCol) {
            DynamicObject tempBottomSectionEntry = targetBottomSectionEntryCol.addNew();
            tempBottomSectionEntry.set("botsectionname", sourceBottomSectionSectionEntry.get("botsectionname"));
        }
        for (DynamicObject sourceBottomSectionSectionEntry : curOpenBottomSectionSectionEntryCol) {
            String curSectionName = sourceBottomSectionSectionEntry.getString("botsectionname");
            for (DynamicObject tempBottomSectionEntry : targetBottomSectionEntryCol) {
                String sectionName = tempBottomSectionEntry.getString("botsectionname");
                if (!StringUtils.equals((CharSequence)curSectionName, (CharSequence)sectionName)) continue;
                DynamicObjectCollection supplierEntry = tempBottomSectionEntry.getDynamicObjectCollection("bottomentry");
                DynamicObjectCollection sourceSupplierEntry = sourceBottomSectionSectionEntry.getDynamicObjectCollection("bottomentry");
                supplierEntry.clear();
                for (DynamicObject curSupplierEntryRow : sourceSupplierEntry) {
                    DynamicObject supplierEntryRow = supplierEntry.addNew();
                    supplierEntryRow.set("botpurentrycontent", curSupplierEntryRow.get("botpurentrycontent"));
                    supplierEntryRow.set("botpurentryproject", curSupplierEntryRow.get("botpurentryproject"));
                    supplierEntryRow.set("botmaterialid", curSupplierEntryRow.get("botmaterialid"));
                    supplierEntryRow.set("botbaseunit", curSupplierEntryRow.get("botbaseunit"));
                    supplierEntryRow.set("botcontrolamount", curSupplierEntryRow.get("botcontrolamount"));
                    supplierEntryRow.set("botcontrolvat", curSupplierEntryRow.get("botcontrolvat"));
                    supplierEntryRow.set("botctrlamtexceptvat", curSupplierEntryRow.get("botctrlamtexceptvat"));
                    supplierEntryRow.set("declareamount", curSupplierEntryRow.get("declareamount"));
                    supplierEntryRow.set("finalauditamount", curSupplierEntryRow.get("finalauditamount"));
                    supplierEntryRow.set("botqty", curSupplierEntryRow.get("botqty"));
                    supplierEntryRow.set("planamount", curSupplierEntryRow.get("planamount"));
                    supplierEntryRow.set("nottaxplanamount", curSupplierEntryRow.get("nottaxplanamount"));
                    supplierEntryRow.set("botmaterialdes", curSupplierEntryRow.get("botmaterialdes"));
                    basePrice = basePrice.add(curSupplierEntryRow.getBigDecimal("finalauditamount"));
                    if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
                    supplierEntryRow.set("botlistnumber", curSupplierEntryRow.get("botlistnumber"));
                    supplierEntryRow.set("botlistname", curSupplierEntryRow.get("botlistname"));
                    supplierEntryRow.set("botresourceitem", curSupplierEntryRow.get("botresourceitem"));
                }
            }
            targetOpen.set("baseprice", (Object)basePrice);
        }
    }

    protected void setOpenPrice(DynamicObject supplierentry, DynamicObject supplierentryHis, DynamicObject bidsection, DynamicObject bidsectionHis, String appId) {
        Object thisSupplierPK = supplierentry.getDynamicObject("supplier").getPkValue();
        supplierentry.set("supplier_deposittype", supplierentryHis.get("supplier_deposittype"));
        supplierentry.set("supplier_deposit", supplierentryHis.get("supplier_deposit"));
        supplierentry.set("supplier_tenderdate", supplierentryHis.get("supplier_tenderdate"));
        supplierentry.set("supplier_invalidreason", supplierentryHis.get("supplier_invalidreason"));
        supplierentry.set("supplier_manager", supplierentryHis.get("supplier_manager"));
        supplierentry.set("supplier_workday", supplierentryHis.get("supplier_workday"));
        this.copyAttach(supplierentry.getDynamicObjectCollection("supplier_techattach"), supplierentryHis.getDynamicObjectCollection("supplier_techattach"));
        this.copyAttach(supplierentry.getDynamicObjectCollection("supplier_comattach"), supplierentryHis.getDynamicObjectCollection("supplier_comattach"));
        this.copyAttach(supplierentry.getDynamicObjectCollection("supplier_tenattach"), supplierentryHis.getDynamicObjectCollection("supplier_tenattach"));
        this.copyAttach(supplierentry.getDynamicObjectCollection("supplier_otherattach"), supplierentryHis.getDynamicObjectCollection("supplier_otherattach"));
        supplierentry.set("supplier_tenderprice", supplierentryHis.get("supplier_tenderprice"));
        supplierentry.set("supplier_taxrate", (Object)supplierentryHis.getBigDecimal("supplier_taxrate"));
        supplierentry.set("supplier_pricevat", supplierentryHis.get("supplier_pricevat"));
        supplierentry.set("supplier_exceptvat", supplierentryHis.get("supplier_exceptvat"));
        supplierentry.set("supplier_rate", supplierentryHis.get("supplier_rate"));
        supplierentry.set("purdetail", supplierentryHis.get("purdetail"));
        supplierentry.set("supplier_illustration", supplierentryHis.get("supplier_illustration"));
        supplierentry.set("supplier_comment", supplierentryHis.get("supplier_comment"));
        DynamicObjectCollection supplierDetailHisColl = bidsectionHis.getDynamicObjectCollection("supplierdetail");
        DynamicObjectCollection supplierDetailColl = bidsection.getDynamicObjectCollection("supplierdetail");
        Iterator iterator = supplierDetailColl.iterator();
        while (iterator.hasNext()) {
            DynamicObject it = (DynamicObject)iterator.next();
            if (!it.getDynamicObject("pursupplier").getPkValue().equals(thisSupplierPK)) continue;
            iterator.remove();
        }
        for (DynamicObject supplierDetailHisRow : supplierDetailHisColl) {
            if (!supplierDetailHisRow.getDynamicObject("pursupplier").getPkValue().equals(thisSupplierPK)) continue;
            DynamicObject addNew = supplierDetailColl.addNew();
            addNew.set("seq", supplierDetailHisRow.get("seq"));
            addNew.set("pursupplier", supplierDetailHisRow.get("pursupplier"));
            addNew.set("purentrycontent", supplierDetailHisRow.get("purentrycontent"));
            addNew.set("purentryproject", supplierDetailHisRow.get("purentryproject"));
            addNew.set("materialid", supplierDetailHisRow.get("materialid"));
            addNew.set("baseunit", supplierDetailHisRow.get("baseunit"));
            addNew.set("materialdes", supplierDetailHisRow.get("materialdes"));
            addNew.set("qty", supplierDetailHisRow.get("qty"));
            addNew.set("inclutaxprice", supplierDetailHisRow.get("inclutaxprice"));
            addNew.set("inclutaxamount", supplierDetailHisRow.get("inclutaxamount"));
            addNew.set("bd_taxrate", supplierDetailHisRow.get("bd_taxrate"));
            addNew.set("taxrate", supplierDetailHisRow.get("taxrate"));
            addNew.set("taxamount", supplierDetailHisRow.get("taxamount"));
            addNew.set("excepttaxamount", supplierDetailHisRow.get("excepttaxamount"));
            addNew.set("costrate", supplierDetailHisRow.get("costrate"));
            if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
            addNew.set("listnumber", supplierDetailHisRow.get("listnumber"));
            addNew.set("listname", supplierDetailHisRow.get("listname"));
            addNew.set("resourceitem", supplierDetailHisRow.get("resourceitem"));
        }
    }

    protected void copyAttach(DynamicObjectCollection newAttachFiles, DynamicObjectCollection oldAttachFiles) {
        oldAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = newAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
    }

    public void setBusPriceNew(DynamicObject newOne, String appId) {
        DynamicObject bidProject = newOne.getDynamicObject("bidproject");
        boolean isBidBusTalk = bidProject.getBoolean("bidbustalk");
        if (!isBidBusTalk) {
            return;
        }
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProject.getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.COMPLETE.getVal())));
        qFilter.and(new QFilter("is_again_bidding", "=", (Object)"0").or(new QFilter("is_again_bidding", "=", (Object)Character.valueOf(' '))));
        DynamicObjectCollection busTalkList = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,billstatus,is_again_bidding", (QFilter[])new QFilter[]{qFilter}, (String)"judge_num asc");
        HashMap<String, Object> busSupMap = new HashMap<String, Object>();
        HashMap<String, DynamicObject> busSupDetailMap = new HashMap<String, DynamicObject>();
        if (!CollectionUtils.isEmpty((Collection)busTalkList)) {
            ArrayList<DynamicObject> allBusTalkList = new ArrayList<DynamicObject>();
            for (Object b : busTalkList) {
                DynamicObject bb = null;
                bb = StringUtils.equals((CharSequence)"rebm", (CharSequence)appId) ? BusinessDataServiceHelper.loadSingle((Object)b.getLong("id"), (String)"rebm_bustalk") : this.bidBustalkService.getBustalkById(b.getLong("id"));
                DynamicObjectCollection bidBusSections = bb.getDynamicObjectCollection("bidsection");
                if (!CollectionUtils.isEmpty((Collection)bidBusSections)) {
                    for (Iterator bidBusSection : bidBusSections) {
                        Object supplierEntry2;
                        String sectionName = bidBusSection.getString("sectionname");
                        DynamicObjectCollection supplierEntryList = bidBusSection.getDynamicObjectCollection("supplierentry");
                        for (Object supplierEntry2 : supplierEntryList) {
                            DynamicObject supplier = supplierEntry2.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            busSupMap.put(sectionName + supplier.getString("id"), supplierEntry2);
                        }
                        DynamicObjectCollection supplierDetailList = bidBusSection.getDynamicObjectCollection("supplierdetail");
                        supplierEntry2 = supplierDetailList.iterator();
                        while (supplierEntry2.hasNext()) {
                            DynamicObject supplierDetail = (DynamicObject)supplierEntry2.next();
                            String key = this.createKey((DynamicObject)bidBusSection, supplierDetail, appId);
                            busSupDetailMap.put(key, supplierDetail);
                        }
                    }
                }
                allBusTalkList.add(bb);
            }
            DynamicObjectCollection bidSectionList = newOne.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : bidSectionList) {
                String sectionName = bidSection.getString("sectionname");
                DynamicObjectCollection supplierEntryList = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryList) {
                    DynamicObject supplierEntryBus;
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    if (supplier == null || CollectionUtils.isEmpty(busSupMap) || (supplierEntryBus = (DynamicObject)busSupMap.get(sectionName + supplier.getString("id"))) == null) continue;
                    DynamicObject supplierBus = supplierEntryBus.getDynamicObject("supplier");
                    supplierEntry.set("supplier_tenderprice", (Object)supplierEntryBus.getBigDecimal("new_price"));
                    supplierEntry.set("supplier_taxrate", (Object)supplierEntryBus.getBigDecimal("taxrate"));
                    supplierEntry.set("supplier_pricevat", supplierEntryBus.get("pricevat"));
                    supplierEntry.set("supplier_exceptvat", (Object)supplierEntryBus.getBigDecimal("bus_exceptvat").longValue());
                    supplierEntry.set("supplier_rate", supplierEntryBus.get("newrate"));
                    supplierEntry.set("purdetail", supplierEntryBus.get("purdetail"));
                    this.copyAttach(supplierEntry.getDynamicObjectCollection("supplier_techattach"), supplierEntryBus.getDynamicObjectCollection("technology_new"));
                    this.copyAttach(supplierEntry.getDynamicObjectCollection("supplier_comattach"), supplierEntryBus.getDynamicObjectCollection("business_new"));
                }
                DynamicObjectCollection supplierDetailList = bidSection.getDynamicObjectCollection("supplierdetail");
                supplierDetailList.stream().forEach(item -> {
                    String key = this.createKey(bidSection, (DynamicObject)item, appId);
                    DynamicObject supplierDetailBus = (DynamicObject)busSupDetailMap.get(key);
                    this.updateSupplierDetailBusNew(supplierDetailBus, (DynamicObject)item);
                });
            }
            if (!CollectionUtils.isEmpty(allBusTalkList)) {
                for (DynamicObject b : allBusTalkList) {
                    b.set("is_again_bidding", (Object)"1");
                }
                DynamicObject[] allBusTalkArray = new DynamicObject[allBusTalkList.size()];
                allBusTalkList.toArray(allBusTalkArray);
                SaveServiceHelper.update((DynamicObject[])allBusTalkArray);
            }
        }
    }

    protected String createKey(DynamicObject bidBusSection, DynamicObject supplierDetail, String appId) {
        StringJoiner stringJoiner = new StringJoiner("|");
        stringJoiner.add(bidBusSection.getString("sectionname"));
        stringJoiner.add(supplierDetail.getDynamicObject("pursupplier") == null ? "" : supplierDetail.getDynamicObject("pursupplier").getString("id"));
        stringJoiner.add(StringUtils.isEmpty((CharSequence)supplierDetail.getString("purentrycontent")) ? "" : supplierDetail.getString("purentrycontent"));
        stringJoiner.add(supplierDetail.getDynamicObject("materialid") == null ? "" : supplierDetail.getDynamicObject("materialid").getString("id"));
        stringJoiner.add(supplierDetail.getDynamicObject("purentryproject") == null ? "" : supplierDetail.getDynamicObject("purentryproject").getString("id"));
        stringJoiner.add(supplierDetail.getString("materialdes") == null ? "" : supplierDetail.getString("materialdes"));
        if ("rebm".equals(appId)) {
            stringJoiner.add(supplierDetail.getDynamicObject("resourceitem") == null ? "" : supplierDetail.getDynamicObject("resourceitem").getString("id"));
        }
        return stringJoiner.toString();
    }

    protected void updateSupplierDetailBus(DynamicObject supplierEntryBus, DynamicObject supplierDetail) {
        supplierDetail.set("inclutaxamount", (Object)supplierEntryBus.getBigDecimal("new_price"));
        supplierDetail.set("taxrate", supplierEntryBus.get("taxrate"));
        supplierDetail.set("taxamount", supplierEntryBus.get("pricevat"));
        supplierDetail.set("excepttaxamount", (Object)supplierEntryBus.getBigDecimal("bus_exceptvat"));
        supplierDetail.set("costrate", supplierEntryBus.get("newrate"));
    }

    protected void updateSupplierDetailBusNew(DynamicObject supplierDetailBus, DynamicObject supplierDetail) {
        if (supplierDetailBus == null) {
            return;
        }
        supplierDetail.set("inclutaxprice", (Object)supplierDetailBus.getBigDecimal("inclutaxprice"));
        supplierDetail.set("inclutaxamount", (Object)supplierDetailBus.getBigDecimal("inclutaxamount"));
        supplierDetail.set("taxrate", supplierDetailBus.get("staxrate"));
        supplierDetail.set("bd_taxrate", supplierDetailBus.get("bd_taxrate"));
        supplierDetail.set("taxamount", supplierDetailBus.get("taxamount"));
        supplierDetail.set("excepttaxamount", (Object)supplierDetailBus.getBigDecimal("excepttaxamount"));
        supplierDetail.set("costrate", supplierDetailBus.get("costrate"));
    }

    protected void setQuestionPrice(DynamicObject bidsection, DynamicObject supplierEntry, String appId, DynamicObject bidproject, DynamicObjectCollection supplierDetailList, String opentype) {
        boolean isBidEvaluation = bidproject.getBoolean("bidevaluation");
        if (isBidEvaluation) {
            boolean enablemultisection = bidproject.getBoolean("enablemultisection");
            String sectionName = bidsection.getString("sectionname");
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            DynamicObject clarifyNewData = this.getDataFromlatestData(bidproject.getPkValue(), supplier.getPkValue(), enablemultisection, sectionName, opentype);
            if (clarifyNewData != null) {
                if (!"TECHNICAL".equals(opentype)) {
                    supplierEntry.set("supplier_tenderprice", (Object)clarifyNewData.getBigDecimal("tenderprice"));
                    supplierEntry.set("supplier_taxrate", (Object)clarifyNewData.getBigDecimal("pricevat"));
                    supplierEntry.set("supplier_pricevat", clarifyNewData.get("tax"));
                    supplierEntry.set("supplier_exceptvat", (Object)clarifyNewData.getBigDecimal("notaxtenderprice"));
                    supplierEntry.set("supplier_rate", clarifyNewData.get("rate"));
                    supplierEntry.set("supplier_manager", clarifyNewData.get("projectmanage"));
                    supplierEntry.set("supplier_workday", clarifyNewData.get("workday"));
                    String clarifytype = clarifyNewData.getString("clarifytype");
                    if (!"BUSSINESS".equals(clarifytype)) {
                        this.copyFileAtoB(clarifyNewData, supplierEntry, "supplier_techattach");
                    }
                    this.copyFileAtoB(clarifyNewData, supplierEntry, "supplier_comattach");
                    this.copyFileAtoB(clarifyNewData, supplierEntry, "supplier_otherattach");
                    DynamicObjectCollection clarifyBidsection = clarifyNewData.getDynamicObjectCollection("bidsection");
                    HashMap incluTaxPriceMap = new HashMap(16);
                    clarifyBidsection.forEach(section -> {
                        String sectionname = section.getString("sectionname");
                        if (!sectionname.equalsIgnoreCase(sectionName)) {
                            return;
                        }
                        DynamicObjectCollection supplierdetail = section.getDynamicObjectCollection("supplierdetail");
                        supplierdetail.forEach(sup -> {
                            String detailKey = this.getDetailKey((DynamicObject)sup, appId);
                            incluTaxPriceMap.put(sectionName + detailKey, sup);
                        });
                    });
                    supplierDetailList.stream().filter(item -> item.getDynamicObject("pursupplier").getPkValue().equals(supplier.getPkValue())).forEach(item -> this.updateSupplierDetailIncluTaxPrice((DynamicObject)item, incluTaxPriceMap, appId, sectionName));
                } else {
                    this.copyFileAtoB(clarifyNewData, supplierEntry, "supplier_techattach");
                }
                clarifyNewData.set("is_again_bidding", (Object)"1");
                SaveServiceHelper.update((DynamicObject)clarifyNewData);
            }
        }
    }

    protected void updateSupplierDetailIncluTaxPrice(DynamicObject item, Map<String, DynamicObject> incluTaxPriceMap, String appId, String sectionname) {
        String detailKey = this.getDetailKey(item, appId);
        DynamicObject entryRow = incluTaxPriceMap.get(sectionname + detailKey);
        if (entryRow != null) {
            item.set("inclutaxprice", (Object)entryRow.getBigDecimal("inclutaxprice"));
            item.set("inclutaxamount", (Object)entryRow.getBigDecimal("inclutaxamount"));
            item.set("taxrate", (Object)entryRow.getBigDecimal("taxrate"));
            item.set("bd_taxrate", entryRow.get("bd_taxrate"));
            item.set("taxamount", entryRow.get("taxamount"));
            item.set("excepttaxamount", (Object)entryRow.getBigDecimal("excepttaxamount"));
            item.set("costrate", entryRow.get("costrate"));
        }
    }

    protected String getDetailKey(DynamicObject sup, String appId) {
        DynamicObject materialid;
        DynamicObject resourceitem;
        DynamicObject purentryproject;
        DynamicObject pursupplier;
        StringBuilder sb = new StringBuilder();
        String purentrycontent = sup.getString("purentrycontent");
        if (purentrycontent != null) {
            sb.append(purentrycontent);
        }
        if ((pursupplier = sup.getDynamicObject("pursupplier")) != null) {
            sb.append(pursupplier.getPkValue());
        }
        if ((purentryproject = sup.getDynamicObject("purentryproject")) != null) {
            sb.append(purentryproject.getPkValue());
        }
        if ("rebm".equals(appId) && (resourceitem = sup.getDynamicObject("resourceitem")) != null) {
            sb.append(resourceitem.getPkValue());
        }
        if ((materialid = sup.getDynamicObject("materialid")) != null) {
            sb.append(materialid.getPkValue());
        }
        return sb.toString();
    }

    protected void copyFileAtoB(DynamicObject clarifyNewData, DynamicObject supplierEntry, String type) {
        if (clarifyNewData != null) {
            String attachment = "techattachment";
            switch (type) {
                case "supplier_techattach": {
                    attachment = "techattachment";
                    break;
                }
                case "supplier_comattach": {
                    attachment = "commercattachment";
                    break;
                }
                case "supplier_otherattach": {
                    attachment = "otherattachment";
                    break;
                }
            }
            List attachmentList = AttachmentServiceHelper.getAttachments((String)clarifyNewData.getDynamicObjectType().getName(), (Object)clarifyNewData.getPkValue(), (String)attachment);
            List<DynamicObject> attachments = BidFileHelper.copyToEntryAttachment(attachmentList);
            DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection(type);
            inviteAttachFiles.clear();
            attachments.stream().forEach(item -> {
                DynamicObject inviteAttach = inviteAttachFiles.addNew();
                inviteAttach.set("fbasedataid", item);
            });
        }
    }

    public DynamicObject getDataFromlatestData(Object bidProjectId, Object supplierId, boolean enablemultisection, String sectionName, String opentype) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProjectId);
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project");
        String entryEntity = project.getString("entitytypeid");
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        if (enablemultisection) {
            supplierFilter.and(new QFilter("clarifysupplier", "like", (Object)("%" + sectionName)));
        }
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
        QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
        if ("TECHNICAL".equals(opentype)) {
            clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
        }
        QFilter resubmisstendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        QFilter isagainBiddingFilter = new QFilter("is_again_bidding", "=", (Object)"0").or(new QFilter("is_again_bidding", "=", (Object)Character.valueOf(' ')));
        String orderBys = "submitdate desc";
        boolean top = true;
        String questionclarify = null;
        String selectProperties = "";
        if ("bid_project".equals(entryEntity)) {
            questionclarify = "bid_questionclarify";
            selectProperties = "id,tenderprice,pricevat,tax,notaxtenderprice,rate,bidsection,bidsection.sectionname,projectmanage,workday,is_again_bidding,clarifytype,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.bd_taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate";
        } else {
            questionclarify = "rebm_questionclarify";
            selectProperties = "id,tenderprice,pricevat,tax,notaxtenderprice,rate,bidsection,bidsection.sectionname,projectmanage,workday,is_again_bidding,clarifytype,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.bd_taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate,supplierdetail.resourceitem";
        }
        DynamicObject[] latestDatas = BusinessDataServiceHelper.load((String)questionclarify, (String)selectProperties, (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, billstatusFilter, clarifyTypeFilter, resubmisstendersFilter, isagainBiddingFilter}, (String)orderBys);
        if (latestDatas.length > 0) {
            return latestDatas[0];
        }
        return null;
    }

    public static String toChinese(String str) {
        String[] s1 = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"BidOpenServiceImpl_4", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"BidOpenServiceImpl_5", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"BidOpenServiceImpl_6", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"BidOpenServiceImpl_7", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"BidOpenServiceImpl_8", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"BidOpenServiceImpl_9", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"BidOpenServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"BidOpenServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"BidOpenServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"BidOpenServiceImpl_13", (String)"scm-bid-business", (Object[])new Object[0])};
        String[] s2 = new String[]{ResManager.loadKDString((String)"\u5341", (String)"BidOpenServiceImpl_14", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidOpenServiceImpl_15", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidOpenServiceImpl_16", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"BidOpenServiceImpl_17", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidOpenServiceImpl_14", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidOpenServiceImpl_15", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidOpenServiceImpl_16", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"BidOpenServiceImpl_18", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidOpenServiceImpl_14", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidOpenServiceImpl_15", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidOpenServiceImpl_16", (String)"scm-bid-business", (Object[])new Object[0])};
        StringBuilder result = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                String temp = s1[num] + s2[n - 2 - i];
                result.append(temp);
                continue;
            }
            result.append(s1[num]);
        }
        return result.toString();
    }

    public DynamicObject[] getBidOpenArrayByProjectId(Object bidProjectId) {
        return BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", this.getClass()), (String)"billstatus,createtime,opentype", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
    }

    @Override
    public DynamicObject getBidOpenById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bidopen");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    @Override
    public DynamicObject getBidOpenByIdAndType(Long id, String appId) {
        DynamicObject bidopen = QueryServiceHelper.queryOne((String)(appId + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (bidopen == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(appId + "_bidopen")));
    }

    @Override
    public DynamicObject getBidOpenById(Long id, String selectedFields) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bid_bidopen", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject getAllBidOpenById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bidopen");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    @Override
    public String getFormId() {
        return "bid_bidopen";
    }

    @Override
    public void updateFileNumber(Long id, Long sectionId, Long supplierId, String clickFieldName, int size) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bidopen");
        EntityType entityType = (EntityType)type.getAllEntities().get("supplierentry");
        Long pkId = null;
        DynamicObject mainObject = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
        if (mainObject != null) {
            DynamicObjectCollection sectionColl = mainObject.getDynamicObjectCollection("bidsection");
            block0: for (DynamicObject tempSection : sectionColl) {
                Long tempSectionId = tempSection.getLong("id");
                if (tempSectionId.longValue() != sectionId.longValue()) continue;
                DynamicObjectCollection supplierColl = tempSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject tempSupplier : supplierColl) {
                    Long tempSupplierId = tempSupplier.getLong("supplier.id");
                    if (tempSupplierId.longValue() != supplierId.longValue()) continue;
                    pkId = tempSupplier.getLong("id");
                    continue block0;
                }
            }
        }
        if (pkId != null && pkId != 0L) {
            DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)entityType);
            entry.set(clickFieldName, (Object)size);
            BusinessDataServiceHelper.save((IDataEntityType)entityType, (Object[])new Object[]{entry});
        }
    }

    @Override
    public void deleteUselessFile(Long id, Boolean enable) {
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_bidopen", (String)"id,entitytypeid");
        String entityTypePre = tempObj.getString("entitytypeid").split("_")[0];
        DynamicObject open = null;
        if ("bid".equals(entityTypePre)) {
            open = this.getBidOpenById(id);
        } else if ("rebm".equals(entityTypePre)) {
            open = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rebm_bidopen");
        }
        QFilter qFilter = null;
        if (open != null) {
            String status = open.getString("billstatus");
            ArrayList<Long> list = new ArrayList<Long>();
            ArrayList<Long> sections = new ArrayList<Long>();
            if (StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.DISBEGIN.getVal())) {
                DynamicObjectCollection openSections = open.getDynamicObjectCollection("bidsection");
                for (DynamicObject openSection : openSections) {
                    sections.add(openSection.getLong("id"));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{open});
                if (!enable.booleanValue()) {
                    qFilter = new QFilter("sectionid", "in", sections);
                }
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.SAVE.getVal())) {
                DynamicObjectCollection openSections = open.getDynamicObjectCollection("bidsection");
                for (DynamicObject openSection : openSections) {
                    Long sectionId = openSection.getLong("id");
                    sections.add(sectionId);
                    DynamicObjectCollection suppliers = openSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplier : suppliers) {
                        Long supplierId = null;
                        try {
                            supplierId = supplier.getLong("supplier.id");
                        }
                        catch (Exception e1) {
                            return;
                        }
                        DynamicObject tech = this.fileService.getOneFileRecordByIds(supplierId, sectionId, "techFile", "id");
                        DynamicObject com = this.fileService.getOneFileRecordByIds(supplierId, sectionId, "comFile", "id");
                        DynamicObject ten = this.fileService.getOneFileRecordByIds(supplierId, sectionId, "tenFile", "id");
                        DynamicObject other = this.fileService.getOneFileRecordByIds(supplierId, sectionId, "otherFile", "id");
                        if (tech != null) {
                            list.add(tech.getLong("id"));
                        }
                        if (com != null) {
                            list.add(com.getLong("id"));
                        }
                        if (ten != null) {
                            list.add(ten.getLong("id"));
                        }
                        if (other == null) continue;
                        list.add(other.getLong("id"));
                    }
                }
                qFilter = new QFilter("sectionid", "in", (Object)sections.toArray());
                qFilter.and(new QFilter("id", "not in", (Object)list.toArray()));
            }
        }
        if (qFilter != null) {
            DeleteServiceHelper.delete((String)"bid_supplier_file", (QFilter[])new QFilter[]{qFilter});
        }
    }

    @Override
    public void invalidProficients(Long projectId) {
        DynamicObject bidopen = this.getBidOpenByProjectId(projectId);
        DynamicObject project = this.bidProjectService.getBidProjectAllById(projectId);
        if (bidopen != null) {
            DynamicObjectCollection beforeColls = bidopen.getDynamicObjectCollection("bidopen_proficient");
            String billstatus = bidopen.getString("billstatus");
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.OPEN.getVal())) {
                for (DynamicObject beforeColl : beforeColls) {
                    DynamicObject tempProficient = beforeColl.getDynamicObject("proficient");
                    Long tempProfiId = tempProficient.getLong("id");
                    this.proficientService.deleteProficientProByField(tempProfiId, project);
                }
            }
        }
    }

    public void sendMessage(DynamicObject bidProject, String openType) {
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        String content = "";
        String appid = bidProject.getString("entitytypeid").split("_")[0];
        String notifyType = null;
        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.MULTI.getValue(), (CharSequence)openType)) {
            notifyType = MessageChannelUtil.getNotifyType((String)"createbidunopen", (String)"bid_bidopen");
            content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684<%s>\u9879\u76ee\u5df2\u8fdb\u5165\u5f00\u6807\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidOpenServiceImpl_25", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
            msgParam.put("tplScene", "createbidunopen");
            msgParam.put("appId", appid);
        }
        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
            notifyType = MessageChannelUtil.getNotifyType((String)"createbidbuopen", (String)"bid_bidopen");
            content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684<%s>\u9879\u76ee\u5df2\u8fdb\u5165\u5546\u52a1\u6807\u5f00\u6807\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidOpenServiceImpl_26", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
            msgParam.put("tplScene", "createbidbuopen");
            msgParam.put("appId", appid);
        }
        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
            openType = BidOpenTypeEnum.TECHNICAL.getValue();
            notifyType = MessageChannelUtil.getNotifyType((String)"createbidteopen", (String)"bid_bidopen");
            content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684<%s>\u9879\u76ee\u5df2\u8fdb\u5165\u6280\u672f\u6807\u5f00\u6807\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidOpenServiceImpl_27", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
            msgParam.put("tplScene", "createbidteopen");
            msgParam.put("appId", appid);
        }
        if ("bid".equals(appid)) {
            msgParam.put("formId", "bid_bidopen");
        } else {
            msgParam.put("formId", "rebm_bidopen");
        }
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", this.getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)openType), new QFilter("billstatus", "!=", (Object)"XX")});
        if (bidOpen != null) {
            String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidOpenServiceImpl_28", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
            msgParam.put("id", bidOpen.getPkValue());
            msgParam.put("pkId", bidOpen.getPkValue());
            msgParam.put("title", null);
            msgParam.put("operation", "save");
            msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
            DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
            HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
            ArrayList<Long> receiveUserIds = new ArrayList<Long>();
            for (DynamicObject member : memberColl) {
                String[] values;
                if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
                for (int m = 0; m < values.length; ++m) {
                    if ("06".equals(values[m]) && (openType.equals(BidOpenTypeEnum.MULTI.getValue()) || openType.equals(BidOpenTypeEnum.BUSSINESS.getValue()))) {
                        memberSet.add(member.getDynamicObject("user"));
                    }
                    if ("11".equals(values[m]) && openType.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
                        memberSet.add(member.getDynamicObject("user"));
                    }
                    if (!"12".equals(values[m]) || !openType.equals(BidOpenTypeEnum.BUSSINESS.getValue())) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!memberSet.isEmpty()) {
                for (DynamicObject set : memberSet) {
                    receiveUserIds.add(set.getLong("id"));
                }
            }
            msgParam.put("msgentity", "bid_bidopen");
            msgParam.put("content", null);
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
        }
    }

    @Override
    public void updateBidOpenByReTender(long bidOpenId, long bidPublishId, long bidProjectId) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()), (String)"bidsection,sectionname,purentrycontent,purentryproject,materialid,materialdes,qty,controlamount,controlvat,ctrlamtexceptvat,purentryworkload,purentrycomment,entitytypeid");
        String appId = "bid";
        appId = !bidProject.getString("entitytypeid").equals("bid_project") ? "rebm" : "bid";
        DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)(appId + "_" + "bidopen"), (String)"bidsection,sectionname,supplierentry,supplierentry.seq,supplier,supplier_istender,suppliercontact,contactphone,supplier_deposittype,supplierdetail,supplierdetail.seq,pursupplier,purentrycontent,purentryproject,materialid,materialdes,qty", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)bidProjectId)});
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((Object)bidPublishId, (String)(appId + "_" + "bidpublish"), (String)"bidsection,sectionname,supplierentry,supplier,suppliercontact,contactphone");
        HashMap<String, DynamicObject> bidPublishSectionMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection bidPublishSectionColl = bidPublish.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidPublishSectionRow : bidPublishSectionColl) {
            String bidPublishSectionName = bidPublishSectionRow.getLocaleString("sectionname").getLocaleValue();
            DynamicObjectCollection supplierEntry = bidPublishSectionRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntryRow : supplierEntry) {
                DynamicObject supplier = supplierEntryRow.getDynamicObject("supplier");
                bidPublishSectionMap.put(bidPublishSectionName + "###" + supplier.getPkValue(), supplierEntryRow);
            }
        }
        String mapKey = "";
        DynamicObjectCollection pSupplierDetails = null;
        for (DynamicObject bidOpen : bidOpenArray) {
            DynamicObjectCollection supplierEntry;
            String bidOpenSectionName;
            DynamicObjectCollection bidOpenSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidOpenSectionRow : bidOpenSectionColl) {
                bidOpenSectionName = bidOpenSectionRow.getLocaleString("sectionname").getLocaleValue();
                supplierEntry = bidOpenSectionRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntryRow : supplierEntry) {
                    DynamicObject supplier = supplierEntryRow.getDynamicObject("supplier");
                    mapKey = bidOpenSectionName + "###" + supplier.getPkValue();
                    bidPublishSectionMap.remove(mapKey);
                }
            }
            for (DynamicObject bidOpenSectionRow : bidOpenSectionColl) {
                bidOpenSectionName = bidOpenSectionRow.getLocaleString("sectionname").getLocaleValue();
                pSupplierDetails = this.bidProjectService.getMaDetailCollectionByProjectAndSec(bidProject, bidOpenSectionName);
                supplierEntry = bidOpenSectionRow.getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection supplierDetailEntry = bidOpenSectionRow.getDynamicObjectCollection("supplierdetail");
                for (Map.Entry entry : bidPublishSectionMap.entrySet()) {
                    String[] split = ((String)entry.getKey()).split("###");
                    DynamicObject value = (DynamicObject)entry.getValue();
                    if (!split[0].equals(bidOpenSectionName)) continue;
                    DynamicObject supplierEntryAddNew = supplierEntry.addNew();
                    supplierEntryAddNew.set("seq", (Object)supplierEntry.size());
                    supplierEntryAddNew.set("supplier", (Object)value.getDynamicObject("supplier"));
                    supplierEntryAddNew.set("supplier_istender", (Object)"0");
                    supplierEntryAddNew.set("suppliercontact", value.get("suppliercontact"));
                    supplierEntryAddNew.set("contactphone", value.get("contactphone"));
                    supplierEntryAddNew.set("supplier_deposittype", (Object)"NOTPAY");
                    for (DynamicObject pSupplierDetail : pSupplierDetails) {
                        DynamicObject supplierDetailEntryAddNew = supplierDetailEntry.addNew();
                        supplierDetailEntryAddNew.set("pursupplier", (Object)value.getDynamicObject("supplier"));
                        supplierDetailEntryAddNew.set("purentrycontent", pSupplierDetail.get("purentrycontent"));
                        supplierDetailEntryAddNew.set("purentryproject", pSupplierDetail.get("purentryproject"));
                        supplierDetailEntryAddNew.set("materialid", pSupplierDetail.get("materialid"));
                        supplierDetailEntryAddNew.set("baseunit", pSupplierDetail.get("baseunit"));
                        supplierDetailEntryAddNew.set("materialdes", pSupplierDetail.get("materialdes"));
                        supplierDetailEntryAddNew.set("qty", pSupplierDetail.get("qty"));
                        if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
                        supplierDetailEntryAddNew.set("listnumber", pSupplierDetail.get("listnumber"));
                        supplierDetailEntryAddNew.set("listname", pSupplierDetail.get("listname"));
                        supplierDetailEntryAddNew.set("resourceitem", pSupplierDetail.get("resourceitem"));
                    }
                }
            }
        }
        BizLog.log((String)("bidPublishSectionMap" + bidPublishSectionMap));
        SaveServiceHelper.save((DynamicObject[])bidOpenArray);
    }
}

