/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IMyTenderService;
import kd.scm.bid.common.enums.MyTenderStatus;

public class MyTenderServiceImpl
implements IMyTenderService {
    @Override
    public DynamicObject getMyTenderByBidProjectAndSupplier(Long bidProjectID, Long supplierID) {
        Map ten_mytender = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ten_mytender"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectID), new QFilter("supplier", "=", (Object)supplierID)});
        return ten_mytender.isEmpty() ? null : ten_mytender.values().toArray(new DynamicObject[ten_mytender.size()])[0];
    }

    @Override
    public DynamicObject[] getMyTenderByBidProjectAndSupplier(Long bidProjectID, Set<Long> supplierIDs) {
        DynamicObject[] myTenderArr = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ten_mytender"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectID), new QFilter("supplier", "in", supplierIDs)}).values().toArray(new DynamicObject[0]);
        return myTenderArr;
    }

    @Override
    public void refreshMyTenderBiddingStatus(Object projectId) {
        DynamicObjectCollection ten_mytender = ORM.create().query("ten_mytender", "id,tenderstatus,entry.id,entry.sectionstatus", new QFilter[]{new QFilter("bidproject.id", "=", projectId), new QFilter("bidproject.bidopendeadline", "<", (Object)new Date()), new QFilter("tenderstatus", "=", (Object)MyTenderStatus.PRETENDERED)});
        if (ten_mytender.isEmpty()) {
            return;
        }
        ten_mytender.forEach(myTender -> {
            myTender.set("tenderstatus", (Object)MyTenderStatus.UNTENDERED);
            for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                if (myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNINVITED.getValue())) continue;
                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNTENDERED);
            }
        });
        ORM.create().update((DynamicObject[])ten_mytender.toArray((Object[])new DynamicObject[0]));
        this.notTenderSetStatus(projectId);
    }

    public void notTenderSetStatus(Object projectId) {
        QFilter status = new QFilter("tenderstatus", "=", (Object)MyTenderStatus.UNTENDERED);
        status.or(new QFilter("tenderstatus", "=", (Object)MyTenderStatus.REJECTION));
        DynamicObjectCollection ten_mytender = ORM.create().query("ten_mytender", "id,tenderstatus,entry.id,entry.sectionstatus", new QFilter[]{new QFilter("bidproject.id", "=", projectId), new QFilter("bidproject.bidopendeadline", ">", (Object)new Date()).or("bidproject.bidopendeadline", "is null", null), status});
        if (ten_mytender.isEmpty()) {
            return;
        }
        for (DynamicObject myTender : ten_mytender) {
            DynamicObject bidProject = myTender.getDynamicObject("bidproject");
            Object bidOpenDeadline = bidProject.get("bidopendeadline");
            if (bidOpenDeadline == null) {
                this.notCreate(myTender, bidProject);
                continue;
            }
            this.create(myTender);
        }
        ORM.create().update((DynamicObject[])ten_mytender.toArray((Object[])new DynamicObject[0]));
    }

    private void create(DynamicObject myTender) {
        myTender.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
        for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
            if (myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNINVITED.getValue())) continue;
            myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
        }
    }

    private void notCreate(DynamicObject myTender, DynamicObject bidProject) {
        DynamicObject[] bidOpenArr = (DynamicObject[])ORM.create().query("bid_bidopen", new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)"O")}).toArray((Object[])new DynamicObject[0]);
        if (bidOpenArr == null || bidOpenArr.length == 0) {
            myTender.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
            for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                if (myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNINVITED.getValue())) continue;
                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
            }
        }
    }
}

