/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.scm.bid.common.util.BidFileDownLoadNameUtil;
import kd.sdk.annotation.SdkDeprecated;

public class BidFileHelper {
    private static String BIDDOCUMENT_EDIT = "_biddocument_edit";
    private static String COM_ATTACHMENTPANEL = "com_attachmentpanel";
    private static String TECH_ATTACHMENTPANELAP = "tech_attachmentpanelap";
    private static String ATTACHMENTPANEL = "attachmentpanel";

    public static void copyBidDocumentFileToBill(String appId, Object sourceBillId, String sourceAttachKey, String destinationBillType, Object destinationBillId) {
        if (StringUtils.equals((CharSequence)"all", (CharSequence)sourceAttachKey)) {
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, ATTACHMENTPANEL, destinationBillType, destinationBillId, ATTACHMENTPANEL);
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, TECH_ATTACHMENTPANELAP, destinationBillType, destinationBillId, ATTACHMENTPANEL);
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, COM_ATTACHMENTPANEL, destinationBillType, destinationBillId, ATTACHMENTPANEL);
        } else if (StringUtils.equals((CharSequence)ATTACHMENTPANEL, (CharSequence)sourceAttachKey)) {
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, ATTACHMENTPANEL, destinationBillType, destinationBillId, ATTACHMENTPANEL);
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, TECH_ATTACHMENTPANELAP, destinationBillType, destinationBillId, ATTACHMENTPANEL);
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, COM_ATTACHMENTPANEL, destinationBillType, destinationBillId, ATTACHMENTPANEL);
        }
    }

    public static void copyBidDocumentFileToBillExpComAndTech(String appId, Object sourceBillId, String sourceAttachKey, String destinationBillType, Object destinationBillId) {
        if (StringUtils.equals((CharSequence)"all", (CharSequence)sourceAttachKey)) {
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, ATTACHMENTPANEL, destinationBillType, destinationBillId, ATTACHMENTPANEL);
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, TECH_ATTACHMENTPANELAP, destinationBillType, destinationBillId, TECH_ATTACHMENTPANELAP);
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, COM_ATTACHMENTPANEL, destinationBillType, destinationBillId, COM_ATTACHMENTPANEL);
        } else if (StringUtils.equals((CharSequence)ATTACHMENTPANEL, (CharSequence)sourceAttachKey)) {
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, ATTACHMENTPANEL, destinationBillType, destinationBillId, ATTACHMENTPANEL);
        } else if (StringUtils.equals((CharSequence)TECH_ATTACHMENTPANELAP, (CharSequence)sourceAttachKey)) {
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, TECH_ATTACHMENTPANELAP, destinationBillType, destinationBillId, TECH_ATTACHMENTPANELAP);
        } else if (StringUtils.equals((CharSequence)COM_ATTACHMENTPANEL, (CharSequence)sourceAttachKey)) {
            BidFileHelper.copyFileFromAToB(appId + BIDDOCUMENT_EDIT, sourceBillId, COM_ATTACHMENTPANEL, destinationBillType, destinationBillId, COM_ATTACHMENTPANEL);
        }
    }

    public static void synFileFromAToB(String sourceBillType, Object sourceBillId, String sourceAttachKey, String destinationBillType, Object destinationBillId, String destinationAttachKey) {
        List sourceFileList = AttachmentServiceHelper.getAttachments((String)sourceBillType, (Object)sourceBillId, (String)sourceAttachKey);
        ArrayList sourceFileIdList = new ArrayList(50);
        for (Map sourceAttach : sourceFileList) {
            sourceFileIdList.add(sourceAttach.get("uid"));
        }
        List destinationFileList = AttachmentServiceHelper.getAttachments((String)destinationBillType, (Object)destinationBillId, (String)destinationAttachKey);
        for (Map destinationAttach : destinationFileList) {
            if (sourceFileIdList.contains(destinationAttach.get("uid"))) continue;
            AttachmentServiceHelper.remove((String)destinationBillType, (Object)destinationBillId, destinationAttach.get("uid"));
        }
        BidFileHelper.copyFileFromAToB(sourceBillType, sourceBillId, sourceAttachKey, destinationBillType, destinationBillId, destinationAttachKey);
    }

    @SdkDeprecated
    public static void copyFileFromAToB(String sourceBillType, Object sourceBillId, String sourceAttachKey, String destinationBillType, Object destinationBillId, String destinationAttachKey) {
        List sourceFileList = AttachmentServiceHelper.getAttachments((String)sourceBillType, (Object)sourceBillId, (String)sourceAttachKey);
        BidFileHelper.copyFileToBillByPk(destinationBillType, destinationBillId, destinationAttachKey, sourceFileList);
    }

    public static void removeAllFile(String billType, Object billId, String attachKey) {
        List fileList = AttachmentServiceHelper.getAttachments((String)billType, (Object)billId, (String)attachKey);
        for (Map sourceAttach : fileList) {
            AttachmentServiceHelper.remove((String)billType, (Object)billId, sourceAttach.get("uid"));
        }
    }

    public static void copyFileToBillByPk(String formId, Object pkId, String attachKey, List<Map<String, Object>> attachments) {
        if (pkId != null) {
            pkId = "" + pkId;
        }
        ArrayList<DynamicObject> attachmentFileList = new ArrayList<DynamicObject>();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        Date date = new Date();
        int i = 1;
        for (Map<String, Object> attach : attachments) {
            String pathParam;
            FileItem fileItem;
            String filePath;
            Long attPkId = (Long)attach.get("attPkId");
            String uid = UUID.randomUUID().toString();
            String fileName = String.valueOf(attach.get("name"));
            Long fileSize = (Long)attach.get("size");
            String fExtName = (String)attach.get("name");
            String newUid = uid;
            DynamicObject oldAttachment = BusinessDataServiceHelper.loadSingle((Object)attPkId, (String)"bos_attachment");
            String fileRelativePath = oldAttachment.getString("FFileId");
            InputStream in = fileService.getInputStream(fileRelativePath);
            RequestContext requestContext = RequestContext.get();
            String appId = "bid";
            if (formId.startsWith("rebm")) {
                appId = "rebm";
            }
            if (!StringUtils.isEmpty((CharSequence)(filePath = fileService.upload(fileItem = new FileItem(fileName, pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)appId, (String)formId, (Object)uid, (String)fileName), in))))) {
                DynamicObject newAttachment = new DynamicObject((DynamicObjectType)mainType);
                newAttachment.set("id", (Object)ID.genLongId());
                newAttachment.set("FNUMBER", (Object)newUid);
                newAttachment.set("FBillType", (Object)formId);
                newAttachment.set("FInterID", pkId);
                Timestamp lastModified = (Timestamp)attach.get("lastModified");
                if (lastModified != null) {
                    newAttachment.set("FModifyTime", (Object)new Date(lastModified.getTime()));
                } else {
                    newAttachment.set("FModifyTime", (Object)new Date());
                }
                DynamicObject creator = oldAttachment.getDynamicObject("FCREATEMEN");
                if (creator != null) {
                    newAttachment.set("FCREATEMEN", (Object)creator.getLong("id"));
                }
                newAttachment.set("fcreatetime", (Object)new Date((Long)attach.get("createdate")));
                newAttachment.set("FaliasFileName", (Object)fileName);
                newAttachment.set("FAttachmentName", (Object)fileName);
                newAttachment.set("FExtName", (Object)(fExtName != null ? fExtName.substring(fExtName.lastIndexOf(46) + 1) : ""));
                newAttachment.set("FATTACHMENTSIZE", (Object)fileSize);
                newAttachment.set("fattachmentpanel", (Object)attachKey);
                newAttachment.set("fdescription", attach.get("description"));
                newAttachment.set("FFileId", (Object)filePath);
                attachmentFileList.add(newAttachment);
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(attachmentFileList)) {
            DynamicObject[] attachmentFileArray = new DynamicObject[attachmentFileList.size()];
            attachmentFileList.toArray(attachmentFileArray);
            SaveServiceHelper.save((DynamicObject[])attachmentFileArray);
        }
    }

    public static Map<String, List<String>> copyFileFromAToBReturnMap(String sourceBillType, Object sourceBillId, String sourceAttachKey, String destinationBillType, Object destinationBillId, String destinationAttachKey) {
        List sourceFileList = AttachmentServiceHelper.getAttachments((String)sourceBillType, (Object)sourceBillId, (String)sourceAttachKey);
        return BidFileHelper.copyFileToBillByPkReturnMap(destinationBillType, destinationBillId, destinationAttachKey, sourceFileList);
    }

    public static Map<String, List<String>> copyFileToBillByPkReturnMap(String formId, Object pkId, String attachKey, List<Map<String, Object>> attachments) {
        if (pkId != null) {
            pkId = "" + pkId;
        }
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        ArrayList updateUidList = new ArrayList(attachments.size());
        ArrayList addUidList = new ArrayList(attachments.size());
        ArrayList<DynamicObject> attachmentFileList = new ArrayList<DynamicObject>();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
        for (Map<String, Object> attach : attachments) {
            String pathParam;
            FileItem fileItem;
            String filePath;
            String uid = UUID.randomUUID().toString();
            String newUid = UUID.randomUUID().toString();
            String fileName = String.valueOf(attach.get("name"));
            Long attPkId = (Long)attach.get("attPkId");
            Long fileSize = (Long)attach.get("size");
            String fExtName = (String)attach.get("name");
            DynamicObject oldAttachment = BusinessDataServiceHelper.loadSingle((Object)attPkId, (String)"bos_attachment");
            String fileRelativePath = oldAttachment.getString("FFileId");
            InputStream in = fileService.getInputStream(fileRelativePath);
            RequestContext requestContext = RequestContext.get();
            String appId = "bid";
            if (formId.startsWith("rebm")) {
                appId = "rebm";
            }
            if (!StringUtils.isEmpty((CharSequence)(filePath = fileService.upload(fileItem = new FileItem(fileName, pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)appId, (String)formId, (Object)uid, (String)fileName), in))))) {
                DynamicObject newAttachment = new DynamicObject((DynamicObjectType)mainType);
                newAttachment.set("id", (Object)ID.genLongId());
                newAttachment.set("FNUMBER", (Object)newUid);
                newAttachment.set("FBillType", (Object)formId);
                newAttachment.set("FInterID", pkId);
                Timestamp lastModified = (Timestamp)attach.get("lastModified");
                if (lastModified != null) {
                    newAttachment.set("FModifyTime", (Object)new Date(lastModified.getTime()));
                } else {
                    newAttachment.set("FModifyTime", (Object)new Date());
                }
                DynamicObject creator = oldAttachment.getDynamicObject("FCREATEMEN");
                if (creator != null) {
                    newAttachment.set("fcreatemen", (Object)creator.getLong("id"));
                }
                newAttachment.set("fcreatetime", (Object)new Date((Long)attach.get("createdate")));
                newAttachment.set("FaliasFileName", (Object)fileName);
                newAttachment.set("FAttachmentName", (Object)fileName);
                newAttachment.set("FExtName", (Object)(fExtName != null ? fExtName.substring(fExtName.lastIndexOf(46) + 1) : ""));
                newAttachment.set("FATTACHMENTSIZE", (Object)fileSize);
                newAttachment.set("fattachmentpanel", (Object)attachKey);
                newAttachment.set("fdescription", attach.get("description"));
                newAttachment.set("FFileId", (Object)filePath);
                attachmentFileList.add(newAttachment);
            }
            attach.put("createdate", attach.get("createdate"));
            attach.put("creator", attach.get("creator"));
        }
        if (!CollectionUtils.isEmpty(attachmentFileList)) {
            DynamicObject[] attachmentFileArray = new DynamicObject[attachmentFileList.size()];
            attachmentFileList.toArray(attachmentFileArray);
            SaveServiceHelper.save((DynamicObject[])attachmentFileArray);
        }
        resultMap.put("updateUidList", updateUidList);
        resultMap.put("addUidList", addUidList);
        return resultMap;
    }

    public static void removeSpecificFile(String formId, Object pkId, List<String> uidList) {
        for (String uid : uidList) {
            AttachmentServiceHelper.remove((String)formId, (Object)pkId, (Object)uid);
        }
    }

    public static List<DynamicObject> copyToEntryAttachment(List<Map<String, Object>> attachments) {
        ArrayList<DynamicObject> attachmentFileList = new ArrayList<DynamicObject>();
        if (CollectionUtils.isEmpty(attachments)) {
            return attachmentFileList;
        }
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            Date now = new Date();
            for (Map<String, Object> attachment : attachments) {
                String fileName = String.valueOf(attachment.get("name"));
                String type = fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
                DynamicObject oldAttachment = BusinessDataServiceHelper.loadSingle((Object)attachment.get("attPkId"), (String)"bos_attachment");
                String fileRelativePath = oldAttachment.getString("FFileId");
                InputStream in = fileService.getInputStream(fileRelativePath);
                RequestContext requestContext = RequestContext.get();
                String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)ID.genLongId(), (String)fileName);
                FileItem fileItem = new FileItem(fileName, pathParam, in);
                String filePath = fileService.upload(fileItem);
                if (StringUtils.isEmpty((CharSequence)filePath)) continue;
                DynamicObject newAttachment = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_attachment"));
                Long id = ID.genLongId();
                newAttachment.set("name", (Object)fileName);
                newAttachment.set("size", attachment.get("size"));
                newAttachment.set("url", (Object)filePath);
                newAttachment.set("type", (Object)type);
                newAttachment.set("description", (Object)"");
                newAttachment.set("tempfile", (Object)"1");
                newAttachment.set("pageid", (Object)"");
                newAttachment.set("number", (Object)id.toString());
                newAttachment.set("status", (Object)"B");
                newAttachment.set("createtime", oldAttachment.get("fcreatetime"));
                newAttachment.set("modifytime", oldAttachment.get("fmodifytime"));
                newAttachment.set("creator", oldAttachment.get("fcreatemen"));
                newAttachment.set("uid", (Object)id.toString());
                newAttachment.set("id", (Object)id);
                attachmentFileList.add(newAttachment);
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])attachmentFileList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    h.markRollback();
                    BizLog.log((String)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
            return null;
        }
        return attachmentFileList;
    }

    public static DynamicObject copyBdAttachment(DynamicObject attachment) {
        if (attachment == null) {
            return null;
        }
        try {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bd_attachment");
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            String fileName = attachment.getString("name");
            String fileRelativePath = attachment.getString("url");
            InputStream in = fileService.getInputStream(fileRelativePath);
            RequestContext requestContext = RequestContext.get();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)ID.genLongId(), (String)fileName);
            FileItem fileItem = new FileItem(fileName, pathParam, in);
            String filePath = fileService.upload(fileItem);
            if (!StringUtils.isEmpty((CharSequence)filePath)) {
                Long id = ID.genLongId();
                DynamicObject newAttachment = new DynamicObject((DynamicObjectType)mainType);
                DynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)newAttachment);
                newAttachment.set("id", (Object)id);
                newAttachment.set("number", (Object)id.toString());
                newAttachment.set("uid", (Object)id.toString());
                newAttachment.set("url", (Object)filePath);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAttachment});
                return newAttachment;
            }
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
            return null;
        }
        return null;
    }

    public static void entryToPanelAttachment(List<DynamicObject> attachments, String formId, Object pkId, String attachKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        Date date = new Date();
        int i = 1;
        ArrayList<DynamicObject> attachmentFileList = new ArrayList<DynamicObject>();
        for (DynamicObject attach : attachments) {
            String fileName = String.valueOf(attach.get("name"));
            String newUid = UUID.randomUUID().toString();
            String fileRelativePath = attach.getString("url");
            InputStream in = fileService.getInputStream(fileRelativePath);
            RequestContext requestContext = RequestContext.get();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)formId, (String)formId.split("_")[0], (Object)newUid, (String)fileName);
            FileItem fileItem = new FileItem(fileName, pathParam, in);
            String filePath = fileService.upload(fileItem);
            if (!StringUtils.isEmpty((CharSequence)filePath)) {
                DynamicObject newAttachment = new DynamicObject((DynamicObjectType)mainType);
                newAttachment.set("id", (Object)ID.genLongId());
                newAttachment.set("FNUMBER", (Object)newUid);
                newAttachment.set("FBillType", (Object)formId);
                newAttachment.set("FInterID", pkId);
                newAttachment.set("FModifyTime", attach.get("modifytime"));
                DynamicObject creator = attach.getDynamicObject("creator");
                if (creator != null) {
                    newAttachment.set("FCREATEMEN", (Object)creator.getLong("id"));
                }
                newAttachment.set("fcreatetime", attach.get("createtime"));
                newAttachment.set("FaliasFileName", (Object)fileName);
                newAttachment.set("FAttachmentName", (Object)fileName);
                newAttachment.set("FExtName", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
                newAttachment.set("FATTACHMENTSIZE", attach.get("size"));
                newAttachment.set("fattachmentpanel", (Object)attachKey);
                newAttachment.set("fdescription", attach.get("description"));
                newAttachment.set("FFileId", (Object)filePath);
                attachmentFileList.add(newAttachment);
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(attachmentFileList)) {
            DynamicObject[] attachmentFileArray = new DynamicObject[attachmentFileList.size()];
            attachmentFileList.toArray(attachmentFileArray);
            SaveServiceHelper.save((DynamicObject[])attachmentFileArray);
        }
    }

    public static String downloadByAttachmentIds(String fileName, ArrayList<Long> attachmentIds) {
        QFilter qFilter = new QFilter("id", "in", attachmentIds);
        DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bd_attachment", (String)"id,url", (QFilter[])new QFilter[]{qFilter});
        String[] filePaths = (String[])Arrays.stream(attachments).map(attachment -> FileServiceExtFactory.getAttachFileServiceExt().getRealPath(attachment.getString("url"))).toArray(String[]::new);
        return BidFileHelper.downloadByAttachmentUrls(fileName, filePaths);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String downloadByAttachmentUrls(String fileName, String ... attachmentUrls) {
        String attachmentUrl;
        if (attachmentUrls == null) return null;
        if (attachmentUrls.length == 0) {
            return null;
        }
        if (attachmentUrls.length > 0) {
            fileName = fileName == null ? "attachments.zip" : (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".zip") ? fileName + ".zip" : fileName);
        } else if (fileName == null && (attachmentUrl = attachmentUrls[0]).lastIndexOf(47) != -1) {
            int i = attachmentUrl.lastIndexOf(47);
            fileName = attachmentUrl.substring(i + 1);
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36";
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            if (attachmentUrls.length > 0) {
                BatchDownloadRequest bdr = BidFileHelper.getBatchDownloadRequest(attachmentUrls);
                fs.batchDownload(bdr, (OutputStream)out, userAgent);
            } else {
                String attachmentUrl2 = attachmentUrls[0];
                fs.download(attachmentUrl2, (OutputStream)out, userAgent);
            }
            out.flush();
            String string = BidFileHelper.download(fileName, out.toByteArray());
            return string;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static BatchDownloadRequest getBatchDownloadRequest(String[] attachmentUrls) {
        BatchDownloadRequest.Dir srcDir = new BatchDownloadRequest.Dir("attachments");
        ArrayList<BatchDownloadRequest.File> srcFiles = new ArrayList<BatchDownloadRequest.File>(attachmentUrls.length);
        for (String attachmentUrl : attachmentUrls) {
            if (attachmentUrl.lastIndexOf(47) == -1) continue;
            int i = attachmentUrl.lastIndexOf(47);
            String attachmentName = attachmentUrl.substring(i + 1);
            srcFiles.add(new BatchDownloadRequest.File(attachmentName, attachmentUrl));
        }
        srcDir.setFiles(srcFiles.toArray(new BatchDownloadRequest.File[0]));
        BatchDownloadRequest bdr = new BatchDownloadRequest("test-batch-download");
        bdr.setDirs(new BatchDownloadRequest.Dir[]{srcDir});
        return bdr;
    }

    public static String download(String fileName, byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return BidFileHelper.download(fileName, in);
    }

    public static String download(String fileName, InputStream in) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        return cache.saveAsUrl(fileName, in, 120);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String downAllFile(String fileName, Object formId, String formBillno, String appid, String evalType) {
        fileName = fileName == null ? "attachments.zip" : (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".zip") ? fileName + ".zip" : fileName);
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36";
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BatchDownloadRequest bdr = BidFileHelper.getBatchFile(formId, formBillno, appid, evalType);
            fs.batchDownload(bdr, (OutputStream)out, userAgent);
            out.flush();
            String string = BidFileHelper.download(fileName, out.toByteArray());
            return string;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static BatchDownloadRequest getBatchFile(Object formId, String formBillno, String appid, String evalType) {
        String secTionBillNo = "";
        String secTionNameKey = "";
        String isDarkTag = "";
        String supplierDarkTag = "";
        if (formBillno.contains("onlinebideval")) {
            secTionBillNo = "bidsectionenroll";
            secTionNameKey = "sectionname2";
            isDarkTag = "isdark";
            supplierDarkTag = "supplierdarkname_entry";
        } else if (formBillno.contains("decision")) {
            secTionBillNo = "bidsection";
            secTionNameKey = "sectionname";
        } else if (formBillno.contains("bidopen")) {
            secTionBillNo = "bidsection";
            secTionNameKey = "sectionname";
            isDarkTag = "isdark";
            supplierDarkTag = "darksuppliername";
        }
        ArrayList<BatchDownloadRequest.Dir> listDir = new ArrayList<BatchDownloadRequest.Dir>();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)formId, (String)formBillno);
        boolean isDark = false;
        if (!formBillno.contains("decision")) {
            isDark = dynamicObject.getBoolean(isDarkTag);
        }
        DynamicObject bidProject = dynamicObject.getDynamicObject("bidproject");
        DynamicObjectCollection bidsectionenrollCol = dynamicObject.getDynamicObjectCollection(secTionBillNo);
        for (DynamicObject bidsectionenroll : bidsectionenrollCol) {
            String sectionName = bidsectionenroll.getString(secTionNameKey);
            DynamicObjectCollection supplierentryCol = bidsectionenroll.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierentry : supplierentryCol) {
                String[] filePaths;
                DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                String supplierName = isDark ? supplierentry.getString(supplierDarkTag) : supplier.getString("name");
                String fileZipName = BidFileHelper.getFileZipName(bidProject.getPkValue(), sectionName, supplierName, formBillno, formId, appid);
                BatchDownloadRequest.Dir srcDir = new BatchDownloadRequest.Dir(fileZipName);
                ArrayList<Long> attachmentIds = new ArrayList<Long>();
                BidFileHelper.getFileUrl(supplierentry, evalType, attachmentIds, formBillno, bidProject.getPkValue());
                ArrayList<BatchDownloadRequest.File> srcFiles = new ArrayList<BatchDownloadRequest.File>(attachmentIds.size());
                QFilter qFilter = new QFilter("id", "in", attachmentIds);
                DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bd_attachment", (String)"id,url", (QFilter[])new QFilter[]{qFilter});
                for (String attachmentUrl : filePaths = (String[])Arrays.stream(attachments).map(attachment -> FileServiceExtFactory.getAttachFileServiceExt().getRealPath(attachment.getString("url"))).toArray(String[]::new)) {
                    if (attachmentUrl.lastIndexOf(47) == -1) continue;
                    int i = attachmentUrl.lastIndexOf(47);
                    String attachmentName = attachmentUrl.substring(i + 1);
                    srcFiles.add(new BatchDownloadRequest.File(attachmentName, attachmentUrl));
                }
                srcDir.setFiles(srcFiles.toArray(new BatchDownloadRequest.File[0]));
                listDir.add(srcDir);
            }
        }
        BatchDownloadRequest bdr = new BatchDownloadRequest("test-batch-download");
        bdr.setDirs(listDir.toArray(new BatchDownloadRequest.Dir[0]));
        return bdr;
    }

    public static String getFileZipName(Object bidprojectId, String sectionName, String supplierName, String formBillno, Object formId, String appid) {
        return new BidFileDownLoadNameUtil().fileZipName(bidprojectId, sectionName, supplierName, formBillno, formId, appid);
    }

    public static void getFileUrl(DynamicObject supplierEntry, String evalType, ArrayList<Long> attachmentIds, String formBillno, Object bidprojectId) {
        DynamicObject bidProject;
        String doctype;
        DynamicObjectCollection supplierTechattachCol;
        String tecName = "";
        String comName = "";
        if (formBillno.contains("onlinebideval")) {
            tecName = "supplier_techattach";
            comName = "supplier_comattach";
        } else if (formBillno.contains("decision")) {
            tecName = "techfile_new";
            comName = "commfile_new";
        } else if (formBillno.contains("bidopen")) {
            tecName = "supplier_techattach";
            comName = "supplier_comattach";
        }
        if ("TECHNICAL".equals(evalType)) {
            supplierTechattachCol = supplierEntry.getDynamicObjectCollection(tecName);
            if (!supplierTechattachCol.isEmpty()) {
                supplierTechattachCol.forEach(attachment -> {
                    DynamicObject fileFbasedataid = attachment.getDynamicObject("fbasedataid");
                    if (fileFbasedataid != null) {
                        Long o = (Long)fileFbasedataid.get("id");
                        attachmentIds.add(o);
                    }
                });
            }
        } else if ("BUSSINESS".equals(evalType)) {
            DynamicObjectCollection supplierComattachCol = supplierEntry.getDynamicObjectCollection(comName);
            if (!supplierComattachCol.isEmpty()) {
                supplierComattachCol.forEach(attachment -> {
                    DynamicObject fileFbasedataid = attachment.getDynamicObject("fbasedataid");
                    if (fileFbasedataid != null) {
                        Long o = (Long)fileFbasedataid.get("id");
                        attachmentIds.add(o);
                    }
                });
            }
        } else if ("MULTI".equals(evalType)) {
            DynamicObjectCollection supplierComattachCol;
            supplierTechattachCol = supplierEntry.getDynamicObjectCollection(tecName);
            if (!supplierTechattachCol.isEmpty()) {
                supplierTechattachCol.forEach(attachment -> {
                    DynamicObject fileFbasedataid = attachment.getDynamicObject("fbasedataid");
                    if (fileFbasedataid != null) {
                        Long o = (Long)fileFbasedataid.get("id");
                        attachmentIds.add(o);
                    }
                });
            }
            if (!(supplierComattachCol = supplierEntry.getDynamicObjectCollection(comName)).isEmpty()) {
                supplierComattachCol.forEach(attachment -> {
                    DynamicObject fileFbasedataid = attachment.getDynamicObject("fbasedataid");
                    if (fileFbasedataid != null) {
                        Long o = (Long)fileFbasedataid.get("id");
                        attachmentIds.add(o);
                    }
                });
            }
        }
        String entityName = "bid_project";
        if (formBillno.contains("rebm")) {
            entityName = "rebm_project";
        }
        if (formBillno.contains("bidopen") && ("BUSSINESS".equals(doctype = (bidProject = BusinessDataServiceHelper.loadSingle((Object)bidprojectId, (String)entityName)).getString("doctype")) || "TECHNICAL".equals(evalType) || "MULTI".equals(evalType))) {
            DynamicObjectCollection tenAttach = supplierEntry.getDynamicObjectCollection("supplier_tenattach");
            DynamicObjectCollection otherAttach = supplierEntry.getDynamicObjectCollection("supplier_otherattach");
            if (!tenAttach.isEmpty()) {
                tenAttach.forEach(attachment -> {
                    DynamicObject fileFbasedataid = attachment.getDynamicObject("fbasedataid");
                    if (fileFbasedataid != null) {
                        Long o = (Long)fileFbasedataid.get("id");
                        attachmentIds.add(o);
                    }
                });
            }
            if (!otherAttach.isEmpty()) {
                otherAttach.forEach(attachment -> {
                    DynamicObject fileFbasedataid = attachment.getDynamicObject("fbasedataid");
                    if (fileFbasedataid != null) {
                        Long o = (Long)fileFbasedataid.get("id");
                        attachmentIds.add(o);
                    }
                });
            }
        }
    }
}

