/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.history;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.schedule.file.uitl.PageUtil;
import kd.scm.bid.common.util.DateUtils;

public class BidProjectTimeDataUp {
    public static final Set<String> PLAN_DATE_FLAG = new HashSet<String>(16);
    private static DBRoute DBROUTE = DBRoute.of((String)"scm");
    private static final String UPDATE_OPEN_SQL = "update t_bid_bidopen set fopentime = ?, fbusiopentime = ?, ftechopentime = ? where fid = ?";
    private static final String QUERY_OPEN_SQL = "select fid,fbidprojectid,fopentime,fbusiopentime,ftechopentime from t_bid_bidopen where ";
    private static final String UPDATE_PUBLISH_SQL1 = "update t_bid_bidpublish set fplanbidopendeadline = ? where fid = ?";
    private static final String UPDATE_PUBLISH_SQL2 = "update t_bid_bidpublish_a set ftechbackbidtime = ?, fbusbackbidtime = ? where fid = ?";
    private static final String QUERY_PUBLISH_SQL = "select fid, fbidprojectid from t_bid_bidpublish where ";

    public void updateTimeDate() {
        try {
            BizLog.log((String)"hyl start invitation Upgrade  ");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bid_project", (String)"id,modifier,modifytime,entitytypeid", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)-1)});
            if (objects == null || objects.length == 0) {
                return;
            }
            String appId = "bid";
            String entitytypeid = objects[0].getString("entitytypeid");
            if (entitytypeid.startsWith("rebm")) {
                appId = "rebm";
            }
            ArrayList<DynamicObject> updateProject = new ArrayList<DynamicObject>(100);
            ArrayList<Object> bidProjectIdList = new ArrayList<Object>();
            HashMap<Long, Date> bidProjectMap = new HashMap<Long, Date>();
            for (DynamicObject object : objects) {
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)(appId + "_project"));
                String doctype = bidProject.getString("doctype");
                if (StringUtils.equals((CharSequence)doctype, (CharSequence)"BUSSINESS")) {
                    bidProject.set("backbidway", (Object)"");
                    bidProject.set("bidopentype", (Object)"");
                } else {
                    bidProject.set("backbidway", (Object)"totaltechnical");
                }
                for (String key : PLAN_DATE_FLAG) {
                    Date date = bidProject.getDate(key);
                    date = DateUtils.endOfDay((Date)date);
                    bidProject.set(key, (Object)date);
                }
                if ("rebm".equals(appId)) {
                    try {
                        Date date = bidProject.getDate("designdrawingenddate");
                        date = DateUtils.endOfDay((Date)date);
                        bidProject.set("designdrawingenddate", (Object)date);
                    }
                    catch (Exception e) {
                        BizLog.log((String)"rebm has not designdrawingenddate!");
                    }
                }
                if (bidProject.get("bidopendeadline") != null) {
                    Object[] param;
                    BizLog.log((String)("bidopendeadline: " + bidProject.get("bidopendeadline")));
                    Date bidopendeadline = bidProject.getDate("bidopendeadline");
                    String dateStr = simpleDateFormat.format(bidopendeadline);
                    HashSet idSet = new HashSet();
                    DB.query((DBRoute)DBROUTE, (String)("select fid from t_bid_project_b where fid = " + bidProject.getPkValue().toString()), null, rs -> {
                        while (rs.next() && idSet.size() <= 0) {
                            idSet.add(rs.getLong(1));
                        }
                        return 0;
                    });
                    BizLog.log((String)("idSet.size(): " + idSet.size()));
                    Date date = simpleDateFormat.parse(dateStr);
                    if (idSet.size() == 0) {
                        param = new Object[]{bidProject.getPkValue(), date, date, date, date, date};
                        this.dealBidProject1(param);
                        BizLog.log((String)"idSet.size(): 0");
                    } else {
                        param = new Object[]{date, date, date, date, date, bidProject.getPkValue()};
                        this.dealBidProject(param);
                        BizLog.log((String)"idSet.size(): 1");
                    }
                    bidProjectMap.put(bidProject.getLong("id"), simpleDateFormat.parse(dateStr));
                    bidProjectIdList.add(bidProject.getPkValue());
                }
                updateProject.add(bidProject);
                if (updateProject.size() < 100) continue;
                SaveServiceHelper.save((DynamicObject[])updateProject.toArray(new DynamicObject[0]));
                updateProject.clear();
            }
            if (updateProject.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateProject.toArray(new DynamicObject[0]));
            }
            if (!bidProjectMap.isEmpty()) {
                Map<Integer, List<?>> listMap = PageUtil.listPage(bidProjectIdList, 1000);
                for (Map.Entry<Integer, List<?>> listMapData : listMap.entrySet()) {
                    List<Object> currentProjectIdList = listMapData.getValue();
                    this.dealBidOpenData(currentProjectIdList, bidProjectMap);
                    this.dealBidPublishData(currentProjectIdList, bidProjectMap);
                }
            }
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
        }
    }

    public void dealBidProject1(Object[] param) {
        DB.execute((DBRoute)DBROUTE, (String)"insert into t_bid_project_b(fid,ftechbackbidtime,fbusbackbidtime,fbidopentime,ftechopenbidtime,fbusopenbidtime)  values(?, ?, ?, ?, ?, ?)", (Object[])param);
    }

    public void dealBidProject(Object[] param) {
        DB.execute((DBRoute)DBROUTE, (String)"update t_bid_project_b set  fbusbackbidtime = ?, ftechbackbidtime = ?, fbidopentime = ?, ftechopenbidtime = ?, fbusopenbidtime = ? where fid = ? ", (Object[])param);
    }

    public void dealBidOpenData(List<Object> bidProjectIdList, Map<Long, Date> bidProjectMap) {
        ArrayList paramsList = new ArrayList(1000);
        SqlBuilder sb = new SqlBuilder();
        sb.append(QUERY_OPEN_SQL, new Object[0]);
        sb.appendIn("fbidprojectid", bidProjectIdList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
            while (rs.next()) {
                Date data;
                Long fid = rs.getLong(1);
                Long fBidProjectId = rs.getLong(2);
                Object[] param = new Object[4];
                if (fBidProjectId == null || (data = (Date)bidProjectMap.getOrDefault(fBidProjectId, null)) == null) continue;
                param[0] = data;
                param[1] = data;
                param[2] = data;
                param[3] = fid;
                paramsList.add(param);
            }
            return null;
        });
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)UPDATE_OPEN_SQL, paramsList);
        }
    }

    public void dealBidPublishData(List<Object> bidProjectIdList, Map<Long, Date> bidProjectMap) {
        ArrayList paramsList1 = new ArrayList(1000);
        ArrayList paramsList2 = new ArrayList(1000);
        SqlBuilder sb = new SqlBuilder();
        sb.append(QUERY_PUBLISH_SQL, new Object[0]);
        sb.appendIn("fbidprojectid", bidProjectIdList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
            while (rs.next()) {
                Date data;
                Long fid = rs.getLong(1);
                Long fBidProjectId = rs.getLong(2);
                Object[] param1 = new Object[2];
                Object[] param2 = new Object[3];
                if (fBidProjectId == null || (data = (Date)bidProjectMap.getOrDefault(fBidProjectId, null)) == null) continue;
                param1[0] = data;
                param1[1] = fid;
                paramsList1.add(param1);
                param2[0] = data;
                param2[1] = data;
                param2[2] = fid;
                paramsList2.add(param2);
            }
            return null;
        });
        if (paramsList1.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)UPDATE_PUBLISH_SQL1, paramsList1);
        }
        if (paramsList2.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)UPDATE_PUBLISH_SQL2, paramsList2);
        }
    }

    static {
        PLAN_DATE_FLAG.add("supplierinvienddate");
        PLAN_DATE_FLAG.add("technicaldocenddate");
        PLAN_DATE_FLAG.add("commercialdocenddate");
        PLAN_DATE_FLAG.add("bidpublishdate");
        PLAN_DATE_FLAG.add("answercomplete");
        PLAN_DATE_FLAG.add("clarificaitondate");
        PLAN_DATE_FLAG.add("bidbottommakedate");
        PLAN_DATE_FLAG.add("bidevaluationdate");
        PLAN_DATE_FLAG.add("bidbustalkdate");
        PLAN_DATE_FLAG.add("biddecisiondate");
        PLAN_DATE_FLAG.add("approachdate");
    }
}

