/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.history;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.bid.business.history.call.BidingUpCall;
import kd.scm.bid.business.history.call.MyTenderUpDataCall;

public class TenBidingUpdate {
    private static final ThreadPool exec = ThreadPools.getOrCreateFixedThreadPool((String)"TenBidingUpdate", (int)10);

    public void historyUpdateBusiness(String appIdAppName) {
        BizLog.log((String)"TenBidingUpdate updata start!");
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"ten_online_bid", (String)"id", (QFilter[])new QFilter[]{new QFilter("ishistory", "=", (Object)"1"), new QFilter("bidproject.entitytypeid", "=", (Object)(appIdAppName + "_project"))});
        if (loads != null && loads.length > 0) {
            try {
                Set collect = Arrays.stream(loads).map(load -> load.getPkValue()).collect(Collectors.toSet());
                DeleteServiceHelper.delete((String)"ten_online_bid_detail", (QFilter[])new QFilter[]{new QFilter("onlinebidid", "in", collect)});
                DeleteServiceHelper.delete((String)"ten_online_bid", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
            }
            catch (Exception e) {
                String message = e.getMessage();
                BizLog.log((String)message);
            }
        }
        String tempAppId = "ten";
        QFilter entityIdQFilter = new QFilter("bidproject.entitytypeid", "=", (Object)"bid_project");
        if (!StringUtils.equals((CharSequence)appIdAppName, (CharSequence)"bid")) {
            entityIdQFilter = new QFilter("bidproject.entitytypeid", "=", (Object)"rebm_project");
            tempAppId = "resp";
        }
        BidingUpCall bidingUpCall = new BidingUpCall();
        bidingUpCall.setAppIdAppName(appIdAppName);
        try {
            bidingUpCall.call();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BizLog.log((String)exception.getMessage());
            throw new KDBizException(exception.getMessage());
        }
        MyTenderUpDataCall myTenderUpDataCall = new MyTenderUpDataCall();
        myTenderUpDataCall.setTempAppId(tempAppId);
        myTenderUpDataCall.setEntityIdQFilter(entityIdQFilter);
        try {
            myTenderUpDataCall.call();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BizLog.log((String)exception.getMessage());
            throw new KDBizException(exception.getMessage());
        }
        BizLog.log((String)"TenBidingUpdate updata end!");
    }
}

