/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.history.call;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.schedule.BidScanAllAndExcuteSchedule;
import kd.scm.bid.business.schedule.file.uitl.PageUtil;
import kd.scm.bid.common.util.BidDynamicObjectUtil;

public class BidingUpCall
implements Callable {
    private String appIdAppName;
    public static final String BIDING_TALBE_PREFIX = "_bidding";
    public static final String NEW_BIDMAIN_PREFIX = "_online_bid";
    public static final String NEW_BIDDEFAIL_PREFIX = "_online_bid_detail";

    public Object call() throws Exception {
        BizLog.log((String)"BidingUpCall start");
        boolean isexcuteFlag = true;
        String tempAppId = "ten";
        QFilter entityIdQFilter = new QFilter("bidproject.entitytypeid", "=", (Object)"bid_project");
        if (!StringUtils.equals((CharSequence)this.appIdAppName, (CharSequence)"bid")) {
            entityIdQFilter = new QFilter("bidproject.entitytypeid", "=", (Object)"rebm_project");
            tempAppId = "resp";
        }
        QFilter billstatusQFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "X", "XX"});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)(tempAppId + BIDING_TALBE_PREFIX), (String)"fid", (QFilter[])new QFilter[]{entityIdQFilter, billstatusQFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        BizLog.log((String)("BidingUpCall dynamicObjects\u5927\u5c0f:" + dynamicObjects.length));
        Map<Integer, List<?>> groupListMap = PageUtil.listPageByDynamicObject(dynamicObjects, 1000);
        for (Map.Entry<Integer, List<?>> listData : groupListMap.entrySet()) {
            List<?> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            Object[] collect = currentList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet()).toArray();
            MainEntityType bidMainType = EntityMetadataCache.getDataEntityType((String)(tempAppId + BIDING_TALBE_PREFIX));
            DynamicObject[] oldTenBings = BusinessDataServiceHelper.load((Object[])collect, (DynamicObjectType)bidMainType);
            BizLog.log((String)("BidingUpCall oldTenBings\u5927\u5c0f:" + oldTenBings.length));
            Object[] bidprojects = Arrays.stream(oldTenBings).map(d -> d.getDynamicObject("bidproject").getPkValue()).collect(Collectors.toSet()).toArray();
            bidMainType = EntityMetadataCache.getDataEntityType((String)(this.appIdAppName + "_project"));
            DynamicObject[] bidprojecArr = BusinessDataServiceHelper.load((Object[])bidprojects, (DynamicObjectType)bidMainType);
            Map<String, DynamicObject> bidprojectMap = Arrays.stream(bidprojecArr).collect(Collectors.toMap(d -> d.getPkValue().toString(), d -> d));
            ArrayList<DynamicObject> newMainData = new ArrayList<DynamicObject>(110);
            ArrayList<DynamicObject> newDetailData = new ArrayList<DynamicObject>(110);
            for (DynamicObject oldTenBing : oldTenBings) {
                try {
                    DynamicObject newBidingData = this.makeMainInfo(oldTenBing, tempAppId, bidprojectMap);
                    List<DynamicObject> detailInfoList = this.makeDetailInfo(newBidingData, oldTenBing, tempAppId);
                    BizLog.log((String)("BidingUpCall detailInfoList\u5927\u5c0f:" + detailInfoList.size()));
                    newMainData.add(newBidingData);
                    newDetailData.addAll(detailInfoList);
                    if (newMainData.size() <= 100) continue;
                    SaveServiceHelper.save((DynamicObject[])newMainData.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])newDetailData.toArray(new DynamicObject[0]));
                    BizLog.log((String)"save 100");
                    newMainData.clear();
                    newDetailData.clear();
                }
                catch (Throwable e) {
                    String message = e.getMessage();
                    BizLog.log((String)message);
                    BizLog.log((String)("BidingUpCall error: " + message));
                    isexcuteFlag = false;
                }
            }
            if (newMainData.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])newMainData.toArray(new DynamicObject[0]));
                BizLog.log((String)"save newMainData");
            }
            if (newDetailData.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])newDetailData.toArray(new DynamicObject[0]));
            BizLog.log((String)"save newDetailData");
        }
        new BidScanAllAndExcuteSchedule().updateScheduleState(this.appIdAppName + "_TenBidingUpdate", isexcuteFlag);
        BizLog.log((String)"BidingUpCall end");
        return null;
    }

    public DynamicObject makeMainInfo(DynamicObject biding, String appId, Map<String, DynamicObject> bidprojectMap) {
        MainEntityType bidMainType = EntityMetadataCache.getDataEntityType((String)(appId + NEW_BIDMAIN_PREFIX));
        DynamicObject bidMainRecord = new DynamicObject((DynamicObjectType)bidMainType);
        long genLongId = ID.genLongId();
        bidMainRecord.set("id", (Object)genLongId);
        bidMainRecord.set("ishistory", (Object)"1");
        DynamicObject bidprojectF7 = biding.getDynamicObject("bidproject");
        DynamicObject bidproject = null;
        bidproject = bidprojectMap.get(bidprojectF7.getPkValue().toString());
        if (bidproject == null) {
            bidproject = StringUtils.equals((CharSequence)"ten", (CharSequence)appId) ? BusinessDataServiceHelper.loadSingle((Object)bidprojectF7.getPkValue(), (String)"bid_project") : BusinessDataServiceHelper.loadSingle((Object)bidprojectF7.getPkValue(), (String)"rebm_project");
        }
        DynamicObject supplier = biding.getDynamicObject("supplier");
        String billstatus = biding.getString("billstatus");
        DynamicObject mytender = biding.getDynamicObject("mytender");
        mytender = BusinessDataServiceHelper.loadSingle((Object)mytender.getPkValue(), (String)(appId + "_mytender"));
        String tenderBillStatus = mytender.getString("tenderstatus");
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"A")) {
            if (StringUtils.equals((CharSequence)tenderBillStatus, (CharSequence)"TENDERED")) {
                bidMainRecord.set("billstatus", (Object)"B");
                bidMainRecord.set("tenderstatus", (Object)"TENDERED");
            } else {
                bidMainRecord.set("billstatus", (Object)"A");
                bidMainRecord.set("tenderstatus", (Object)"PRETENDERED");
            }
        } else if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"B") || StringUtils.equals((CharSequence)billstatus, (CharSequence)"C")) {
            if (StringUtils.equals((CharSequence)tenderBillStatus, (CharSequence)"PRETENDERED")) {
                bidMainRecord.set("billstatus", (Object)"A");
                bidMainRecord.set("tenderstatus", (Object)"PRETENDERED");
            } else {
                bidMainRecord.set("billstatus", (Object)"B");
                bidMainRecord.set("tenderstatus", (Object)"TENDERED");
            }
        } else if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"X")) {
            bidMainRecord.set("billstatus", (Object)"X");
            bidMainRecord.set("tenderstatus", (Object)"UNTENDERED");
        } else {
            bidMainRecord.set("billstatus", (Object)"XX");
            bidMainRecord.set("tenderstatus", (Object)"TENDERED");
        }
        bidMainRecord.set("bidproject", (Object)bidprojectF7);
        bidMainRecord.set("supplier", (Object)supplier);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(mytender.getPkValue().toString()), (String)(appId + "_mytender_f7"));
        bidMainRecord.set("mytender", (Object)dynamicObject);
        bidMainRecord.set("billno", biding.get("billno"));
        bidMainRecord.set("rounds", biding.get("rounds"));
        bidMainRecord.set("listrounds", biding.get("listrounds"));
        bidMainRecord.set("sourcebillid", biding.get("sourcebillid"));
        bidMainRecord.set("bidpublishid", biding.get("bidpublishid"));
        bidMainRecord.set("revokebidnumber", biding.get("revokebidnumber"));
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"B")) {
            bidMainRecord.set("biddate", mytender.get("modifytime"));
        } else {
            bidMainRecord.set("biddate", mytender.get("auditdate"));
        }
        String doctype = bidproject.getString("doctype");
        if (StringUtils.equals((CharSequence)doctype, (CharSequence)"BUSSINESS")) {
            bidMainRecord.set("backbidway", (Object)"");
            bidMainRecord.set("backbidtype", (Object)"BUSSINESS");
        } else {
            bidMainRecord.set("backbidway", (Object)"totaltechnical");
            bidMainRecord.set("backbidtype", (Object)"TECHANDBUSS");
        }
        StringBuilder sectionNameBuild = new StringBuilder();
        DynamicObjectCollection bidsection = mytender.getDynamicObjectCollection("entry");
        DynamicObjectCollection sectionentry = bidMainRecord.getDynamicObjectCollection("sectionentry");
        boolean enablemultisection = bidproject.getBoolean("enablemultisection");
        for (DynamicObject row : bidsection) {
            String sectionname = row.getString("sectionname");
            sectionNameBuild.append(sectionname).append(';');
            DynamicObject newSectionRow = sectionentry.addNew();
            newSectionRow.set("projectsectionid", (Object)row.getDynamicObject("projectsection").getPkValue().toString());
            newSectionRow.set("sectionname", (Object)sectionname);
            newSectionRow.set("sectionstatus", (Object)billstatus);
            newSectionRow.set("enablemultisection", (Object)enablemultisection);
            newSectionRow.set("currentroundflag", (Object)Boolean.TRUE);
        }
        String substring = sectionNameBuild.substring(0, sectionNameBuild.length() - 1);
        bidMainRecord.set("sectionnamelist", (Object)substring);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidMainRecord});
        DynamicObjectCollection entry = mytender.getDynamicObjectCollection("entry");
        String attachmentPanel = "";
        for (DynamicObject section : entry) {
            attachmentPanel = String.format("%s%s", "attainvite", section.getPkValue());
            String bosAttachmentProperties = BidDynamicObjectUtil.getAllSelectProperties((String)"bos_attachment");
            DynamicObject[] attachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "=", (Object)biding.getString("id")), new QFilter("fattachmentpanel", "=", (Object)attachmentPanel)});
            if (attachmentArray == null || attachmentArray.length <= 0) continue;
            TXHandle h = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    List<DynamicObject> copyAttachmentList = this.copyFile(appId + NEW_BIDMAIN_PREFIX, genLongId, "inviteattachment", attachmentArray);
                    if (copyAttachmentList == null || copyAttachmentList.size() <= 0) continue;
                    SaveServiceHelper.save((DynamicObject[])copyAttachmentList.toArray(new DynamicObject[0]));
                }
                catch (Throwable ex) {
                    h.markRollback();
                    throw ex;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
        bidMainRecord.set("modifier", biding.get("modifier"));
        bidMainRecord.set("auditdate", biding.get("auditdate"));
        bidMainRecord.set("createtime", biding.get("createtime"));
        bidMainRecord.set("modifytime", biding.get("modifytime"));
        bidMainRecord.set("creator", biding.get("creator"));
        bidMainRecord.set("auditor", biding.get("auditor"));
        return bidMainRecord;
    }

    public List<DynamicObject> makeDetailInfo(DynamicObject newMainBiding, DynamicObject biding, String appId) {
        ArrayList<DynamicObject> newDetailList = new ArrayList<DynamicObject>();
        DynamicObjectCollection oldBidingEntry = biding.getDynamicObjectCollection("entry");
        if (oldBidingEntry == null || oldBidingEntry.size() == 0) {
            return newDetailList;
        }
        Map<String, Object> setId = this.getSetId(biding.getDynamicObject("mytender"), appId);
        Map<String, String> projectSetId = this.getProjectSetId(biding.getDynamicObject("mytender"), appId);
        for (DynamicObject purSection : oldBidingEntry) {
            MainEntityType bidDetailType = EntityMetadataCache.getDataEntityType((String)(appId + NEW_BIDDEFAIL_PREFIX));
            DynamicObject bidDetailRecord = new DynamicObject((DynamicObjectType)bidDetailType);
            this.makeDetailBaseinfo(bidDetailRecord, newMainBiding, purSection);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidDetailRecord});
            Object purtSectionId = setId.get(purSection.getString("sectionname"));
            this.copyFileAndNumber(bidDetailRecord, biding.getPkValue(), appId, purtSectionId);
            this.makeSupplierdetail(bidDetailRecord, purSection);
            bidDetailRecord.set("modifier", newMainBiding.get("modifier"));
            bidDetailRecord.set("auditdate", newMainBiding.get("auditdate"));
            bidDetailRecord.set("createtime", newMainBiding.get("createtime"));
            bidDetailRecord.set("modifytime", newMainBiding.get("modifytime"));
            bidDetailRecord.set("creator", newMainBiding.get("creator"));
            bidDetailRecord.set("auditor", newMainBiding.get("auditor"));
            bidDetailRecord.set("billno", (Object)bidDetailRecord.get("id").toString());
            bidDetailRecord.set("bidproject", newMainBiding.get("bidproject"));
            bidDetailRecord.set("onlinebidid", newMainBiding.getPkValue());
            bidDetailRecord.set("mytenderid", newMainBiding.getDynamicObject("mytender").getPkValue());
            String projectSetIdStr = projectSetId.get(purSection.getString("sectionname"));
            bidDetailRecord.set("projectsectionid", (Object)projectSetIdStr);
            newDetailList.add(bidDetailRecord);
        }
        return newDetailList;
    }

    public Map<String, Object> getSetId(DynamicObject mytender, String appId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)mytender.getPkValue(), (String)(appId + "_mytender"));
        HashMap<String, Object> setNameAndId = new HashMap<String, Object>(16);
        DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            String sectionname = row.getString("sectionname");
            String pk = row.getPkValue().toString();
            setNameAndId.put(sectionname, pk);
        }
        return setNameAndId;
    }

    public Map<String, String> getProjectSetId(DynamicObject mytender, String appId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)mytender.getPkValue(), (String)(appId + "_mytender"));
        HashMap<String, String> setNameAndId = new HashMap<String, String>(16);
        DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            String sectionname = row.getString("sectionname");
            String pk = row.getDynamicObject("projectsection").getPkValue().toString();
            setNameAndId.put(sectionname, pk);
        }
        return setNameAndId;
    }

    public void makeDetailBaseinfo(DynamicObject bidDetailRecord, DynamicObject newMainBiding, DynamicObject purSection) {
        long longId = ID.genLongId();
        bidDetailRecord.set("id", (Object)longId);
        bidDetailRecord.set("billstatus", newMainBiding.get("billstatus"));
        bidDetailRecord.set("sectionname", (Object)purSection.getString("sectionname"));
        bidDetailRecord.set("tenderprice", purSection.get("tenderprice"));
        bidDetailRecord.set("pricevat", purSection.get("pricevat"));
        bidDetailRecord.set("tax", purSection.get("tax"));
        bidDetailRecord.set("notaxtenderprice", purSection.get("notaxtenderprice"));
        bidDetailRecord.set("rate", purSection.get("rate"));
        bidDetailRecord.set("projectmanage", purSection.get("projectmanage"));
        bidDetailRecord.set("workday", purSection.get("workday"));
        bidDetailRecord.set("sectionstatus", newMainBiding.get("tenderstatus"));
        bidDetailRecord.set("backbidway", newMainBiding.get("backbidway"));
        bidDetailRecord.set("backbidtype", newMainBiding.get("backbidtype"));
        bidDetailRecord.set("illustration", purSection.get("tenderstate"));
    }

    public void copyFileAndNumber(DynamicObject bidDetailRecord, Object bidingPk, String appId, Object sectionId) {
        try (TXHandle h = TX.requiresNew();){
            try {
                List<DynamicObject> copyOtherAttachmentList;
                DynamicObject[] otherAttachmentArray;
                List<DynamicObject> copyComAttachmentList;
                DynamicObject[] comAttachmentArray;
                List<DynamicObject> copyTechAttachmentList;
                Long bidDetailRecordId = bidDetailRecord.getLong("id");
                String formId = appId + NEW_BIDDEFAIL_PREFIX;
                String bosAttachmentProperties = BidDynamicObjectUtil.getAllSelectProperties((String)"bos_attachment");
                DynamicObject[] techAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "=", (Object)String.valueOf(bidingPk)), new QFilter("fattachmentpanel", "=", (Object)("attatech" + sectionId))});
                if (techAttachmentArray != null && techAttachmentArray.length > 0 && (copyTechAttachmentList = this.copyFile(formId, bidDetailRecordId, "techattachment", techAttachmentArray)) != null && copyTechAttachmentList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])copyTechAttachmentList.toArray(new DynamicObject[0]));
                }
                if ((comAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "=", (Object)String.valueOf(bidingPk)), new QFilter("fattachmentpanel", "=", (Object)("attacommerce" + sectionId))})) != null && comAttachmentArray.length > 0 && (copyComAttachmentList = this.copyFile(formId, bidDetailRecordId, "busattachment", comAttachmentArray)) != null && copyComAttachmentList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])copyComAttachmentList.toArray(new DynamicObject[0]));
                }
                if ((otherAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "=", (Object)String.valueOf(bidingPk)), new QFilter("fattachmentpanel", "=", (Object)("attaother" + sectionId))})) != null && otherAttachmentArray.length > 0 && (copyOtherAttachmentList = this.copyFile(formId, bidDetailRecordId, "otherattachment", comAttachmentArray)) != null && copyOtherAttachmentList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])copyOtherAttachmentList.toArray(new DynamicObject[0]));
                }
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public void makeSupplierdetail(DynamicObject bidDetailRecord, DynamicObject purSection) {
        DynamicObjectCollection supplierdetail = purSection.getDynamicObjectCollection("supplierdetail");
        DynamicObjectCollection newSupplierdetail = bidDetailRecord.getDynamicObjectCollection("supplierdetail");
        for (DynamicObject oldDetail : supplierdetail) {
            DynamicObject addNew = newSupplierdetail.addNew();
            addNew.set("purentrycontent", oldDetail.get("purentrycontent"));
            addNew.set("purentryproject", oldDetail.get("purentryproject"));
            if (!StringUtils.equals((CharSequence)this.appIdAppName, (CharSequence)"bid")) {
                addNew.set("resourceitem", oldDetail.get("resourceitem"));
            }
            addNew.set("materialid", oldDetail.get("materialid"));
            addNew.set("materialdes", oldDetail.get("materialdes"));
            addNew.set("qty", oldDetail.get("qty"));
            addNew.set("inclutaxprice", oldDetail.get("inclutaxprice"));
            addNew.set("inclutaxamount", oldDetail.get("inclutaxamount"));
            addNew.set("bd_taxrate", oldDetail.get("bd_taxrate"));
            addNew.set("taxrate", oldDetail.get("taxrate"));
            addNew.set("taxamount", oldDetail.get("taxamount"));
            addNew.set("excepttaxamount", oldDetail.get("excepttaxamount"));
            addNew.set("costrate", oldDetail.get("costrate"));
        }
    }

    public String getAppIdAppName() {
        return this.appIdAppName;
    }

    public void setAppIdAppName(String appIdAppName) {
        this.appIdAppName = appIdAppName;
    }

    public List<DynamicObject> copyFile(String formId, Long pkId, String attachKey, DynamicObject[] attachmentArray) {
        ArrayList<DynamicObject> attachmentList = new ArrayList<DynamicObject>(10);
        DynamicObject newAttachment = null;
        for (DynamicObject attach : attachmentArray) {
            newAttachment = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            DynamicObjectUtils.copy((DynamicObject)attach, (DynamicObject)newAttachment);
            newAttachment.set("id", (Object)ID.genLongId());
            newAttachment.set("fbilltype", (Object)formId);
            newAttachment.set("finterid", (Object)pkId);
            newAttachment.set("fattachmentpanel", (Object)attachKey);
            attachmentList.add(newAttachment);
        }
        return attachmentList;
    }
}

