/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.history.unit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.schedule.file.uitl.PageUtil;

public class BidBaseUnitHistoryUpdateServiceImpl {
    private static final String MATERIAL_ENTITY = "bd_material";
    private static final String PROJECT_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_projectentry where fmaterialid > 0";
    private static final String PROJECT_UPDATE_UNIT_SQL = "update t_bid_projectentry set fbaseunitid = ? where fmaterialid = ?";
    private static final String DOCDETAIL_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_biddocdetail where fmaterialid > 0";
    private static final String DOCDETAIL_UPDATE_UNIT_SQL = "update t_bid_biddocdetail set fbaseunitid = ? where fmaterialid = ?";
    private static final String PUBLISH_SELECT_UNIT_SQL = "select distinct fmaterialid from t_bid_projectdetail where fmaterialid > 0";
    private static final String PUBLISH_UPDATE_UNIT_SQL = "update t_bid_projectdetail set fbaseunitid = ? where fmaterialid = ?";

    public UpgradeResult updateData() {
        UpgradeResult upgradeResult = new UpgradeResult();
        try {
            BizLog.log((String)"BidBaseUnitHistoryUpdateServiceImpl \uff1astart");
            int pageNum = 200;
            BizLog.log((String)"bidproject \uff1astart");
            this.updateBaseUnitData(pageNum, PROJECT_SELECT_UNIT_SQL, PROJECT_UPDATE_UNIT_SQL);
            BizLog.log((String)"bidproject \uff1aend");
            BizLog.log((String)"DOC \uff1astart");
            this.updateBaseUnitData(pageNum, DOCDETAIL_SELECT_UNIT_SQL, DOCDETAIL_UPDATE_UNIT_SQL);
            BizLog.log((String)"DOC \uff1aend");
            BizLog.log((String)"PUBLISH \uff1astart");
            this.updateBaseUnitData(pageNum, PUBLISH_SELECT_UNIT_SQL, PUBLISH_UPDATE_UNIT_SQL);
            BizLog.log((String)"PUBLISH \uff1aend");
            BizLog.log((String)"BidBaseUnitHistoryUpdateServiceImpl \uff1asuccess");
            upgradeResult.setSuccess(true);
        }
        catch (Exception e) {
            BizLog.log((String)"BidBaseUnitHistoryUpdateServiceImpl \uff1aerror");
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                BizLog.log((String)(stackTrace[0].getClassName() + stackTrace[0].getMethodName() + stackTrace[0].getLineNumber()));
            }
            BizLog.log((String)e.getMessage());
            upgradeResult.setSuccess(false);
        }
        return upgradeResult;
    }

    public void updateBaseUnitData(int pageNum, String querySql, String updateSql) {
        ArrayList materialIdList = new ArrayList(16);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)querySql, rs -> {
            while (rs.next()) {
                materialIdList.add(rs.getLong(1));
            }
            return null;
        });
        BizLog.log((String)("updateBaseUnitData size\uff1a" + materialIdList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(materialIdList, pageNum);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            paramsList.clear();
            List<?> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            DynamicObject[] materialArray = BusinessDataServiceHelper.load((String)MATERIAL_ENTITY, (String)"id,baseunit", (QFilter[])new QFilter[]{new QFilter("id", "in", currentList)});
            if (materialArray != null && materialArray.length > 0) {
                for (DynamicObject material : materialArray) {
                    DynamicObject baseUnit = material.getDynamicObject("baseunit");
                    if (baseUnit == null) continue;
                    Object[] param = new Object[]{baseUnit.getLong("id"), material.getLong("id")};
                    paramsList.add(param);
                }
            }
            if (paramsList == null || paramsList.size() <= 0) continue;
            BizLog.log((String)("DB.executeBatch1\uff1a" + paramsList.size()));
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, paramsList);
            BizLog.log((String)("DB.executeBatch2\uff1a" + paramsList.size()));
        }
    }
}

