/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidDecipurdetailshowSchedule
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String names = "";
        names = this.getAppId().equals("bid") ? "BidDecipurdetailshowSchedule" : "DecipurdetailshowTask";
        try {
            DynamicObject[] biddecisions;
            BizLog.log((String)"\u5b9a\u6807\u62a5\u4ef7\u660e\u7ec6\u5c55\u793a\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            QFilter qFilter = new QFilter("isexcutflag", "=", (Object)Boolean.TRUE);
            QFilter billNoQFilter = new QFilter("billno", "=", (Object)names);
            DynamicObject bidFileHistoryDataUp = BusinessDataServiceHelper.loadSingle((String)(this.getAppId() + "_scan_schedule"), (String)"id,billno,serviceclassname,mmethodname,excuterouds,executedate,appid", (QFilter[])new QFilter[]{qFilter, billNoQFilter});
            if (bidFileHistoryDataUp != null) {
                BizLog.log((String)"\u5b9a\u6807\u62a5\u4ef7\u660e\u7ec6\u5c55\u793a\u5386\u53f2\u6570\u636e\u5df2\u7ecf\u6210\u529f");
                return;
            }
            QFilter qFilte = new QFilter("entitytypeid", "=", (Object)(this.getAppId() + "_decision"));
            for (DynamicObject biddecision : biddecisions = BusinessDataServiceHelper.load((String)(this.getAppId() + "_decision"), (String)"bidproject,bidsection,sectionname,supplierentry,supplier,techrounds,bussrounds", (QFilter[])new QFilter[]{qFilte})) {
                List<DynamicObject> value;
                ArrayList<DynamicObject> saveToShow = new ArrayList<DynamicObject>();
                DynamicObject bidproject = biddecision.getDynamicObject("bidproject");
                if (bidproject == null) continue;
                this.createTenToDeciPurDetailShow(bidproject, saveToShow);
                this.createQueToDeciPurDetailShow(bidproject, saveToShow);
                this.createBudToDeciPurDetailShow(bidproject, saveToShow);
                this.createcloseBudToDeciPurDetailShow(bidproject, saveToShow);
                Map<String, List<DynamicObject>> supDataMap = saveToShow.stream().collect(Collectors.groupingBy(o -> o.getDynamicObject("supplier").getString("id") + o.getString("sectionname")));
                for (Map.Entry<String, List<DynamicObject>> entry : supDataMap.entrySet()) {
                    value = entry.getValue();
                    value.sort(new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            return o2.getDate("datetimefield").compareTo(o1.getDate("datetimefield"));
                        }
                    });
                }
                for (Map.Entry<String, List<DynamicObject>> entry : supDataMap.entrySet()) {
                    value = entry.getValue();
                    for (int i = 0; i < value.size() - 1; ++i) {
                        DynamicObject dynamicObject = value.get(i);
                        DynamicObject nextdynamicObject = value.get(i + 1);
                        if (nextdynamicObject.getBigDecimal("inclutaxamount").compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal decline = dynamicObject.getBigDecimal("inclutaxamount").subtract(nextdynamicObject.getBigDecimal("inclutaxamount")).divide(nextdynamicObject.getBigDecimal("inclutaxamount"), 4, 4);
                            DecimalFormat df = new DecimalFormat("0.00");
                            String declineStr = df.format(decline.multiply(new BigDecimal("100")));
                            declineStr = declineStr.replaceAll("-", "");
                            if (decline.compareTo(BigDecimal.ZERO) > 0) {
                                dynamicObject.set("decline_dec", (Object)(declineStr + "% \u2191"));
                                continue;
                            }
                            if (decline.compareTo(BigDecimal.ZERO) < 0) {
                                dynamicObject.set("decline_dec", (Object)(declineStr + "% \u2193"));
                                continue;
                            }
                            dynamicObject.set("decline_dec", (Object)"0.00%");
                            continue;
                        }
                        dynamicObject.set("decline_dec", (Object)"0.00%");
                    }
                    if (value.size() <= 0) continue;
                    DynamicObject dynamicObject = value.get(value.size() - 1);
                    dynamicObject.set("decline_dec", (Object)"0.00%");
                }
                if (saveToShow.size() <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])saveToShow.toArray(new DynamicObject[0]));
            }
            BizLog.log((String)"\u5b9a\u6807\u62a5\u4ef7\u660e\u7ec6\u5c55\u793a\u5386\u53f2\u6570\u636e\u5347\u7ea7\u7ed3\u675f");
            this.updateScheduleState(names, true);
        }
        catch (Exception e) {
            BizLog.log((String)"\u5b9a\u6807\u62a5\u4ef7\u660e\u7ec6\u5c55\u793a\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f02\u5e38");
            this.updateScheduleState(names, false);
            throw e;
        }
    }

    public void createTenToDeciPurDetailShow(DynamicObject bidProject, List<DynamicObject> saveToShow) {
        String bidappid = this.getAppId();
        String tenappid = bidappid.equals("bid") ? "ten" : "resp";
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter quotesourcefilter = new QFilter("quotesource", "=", (Object)"tenonline");
        QFilter backtypeqfilter = new QFilter("backbidtype", "!=", (Object)"TECHNICAL");
        QFilter secqfilter = new QFilter("sectionstatus", "=", (Object)"TENDERED");
        DeleteServiceHelper.delete((String)(bidappid + "_decipurdetailshow"), (QFilter[])new QFilter[]{bidqfilter, quotesourcefilter});
        DynamicObject[] online_bid_details = BusinessDataServiceHelper.load((String)(tenappid + "_online_bid_detail"), (String)"onlinebidid,tenderprice,pricevat,tax,notaxtenderprice,sectionname", (QFilter[])new QFilter[]{bidqfilter, backtypeqfilter, secqfilter});
        DynamicObject[] online_bids = BusinessDataServiceHelper.load((String)(tenappid + "_online_bid"), (String)"biddate,supplier,rounds,listrounds,sectionentry,sectionname,currentroundflag,fromrebackflag,modifytime", (QFilter[])bidqfilter.toArray());
        HashMap iddetailmap = new HashMap(online_bid_details.length);
        Arrays.stream(online_bid_details).forEach(o -> iddetailmap.put((Long)o.getPkValue(), o.getLong("onlinebidid")));
        HashMap idbidsup = new HashMap(online_bids.length);
        Arrays.stream(online_bids).forEach(o -> idbidsup.put((Long)o.getPkValue(), o));
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(bidappid + "_decipurdetailshow"));
        for (int i = 0; i < online_bid_details.length; ++i) {
            DynamicObject online_bid_detail = online_bid_details[i];
            Long onlineId = (Long)iddetailmap.get(online_bid_detail.getPkValue());
            DynamicObject online_bid = (DynamicObject)idbidsup.get(onlineId);
            if (online_bid == null) continue;
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainType);
            dynamicObject.set("inclutaxamount", online_bid_detail.get("tenderprice"));
            dynamicObject.set("taxrate", (Object)online_bid_detail.getBigDecimal("pricevat").multiply(new BigDecimal("100")));
            dynamicObject.set("taxamount", online_bid_detail.get("tax"));
            dynamicObject.set("excepttaxamount", online_bid_detail.get("notaxtenderprice"));
            dynamicObject.set("quotesource", (Object)"tenonline");
            String sectionname = online_bid_detail.getString("sectionname");
            if (sectionname == null) continue;
            DynamicObjectCollection sectionentrys = online_bid.getDynamicObjectCollection("sectionentry");
            for (DynamicObject sectionentry : sectionentrys) {
                boolean currentroundflag;
                String sectionnametry = sectionentry.getString("sectionname");
                if (sectionnametry == null || !(currentroundflag = sectionentry.getBoolean("currentroundflag")) || !sectionname.equals(sectionnametry)) continue;
                dynamicObject.set("datetimefield", online_bid.get("biddate"));
                if (online_bid.get("biddate") == null) {
                    dynamicObject.set("datetimefield", online_bid.get("modifytime"));
                }
                dynamicObject.set("supplier", online_bid.get("supplier"));
                dynamicObject.set("sectionname", online_bid_detail.get("sectionname"));
                dynamicObject.set("bidproject", (Object)bidProject);
                dynamicObject.set("sourceid", (Object)online_bid_detail.getPkValue().toString());
                dynamicObject.set("entitytype", (Object)tenappid);
                dynamicObject.set("rounds", online_bid.get("rounds"));
                dynamicObject.set("listrounds", online_bid.get("listrounds"));
                saveToShow.add(dynamicObject);
            }
        }
    }

    public void createQueToDeciPurDetailShow(DynamicObject bidProject, List<DynamicObject> saveToShow) {
        String bidappid = this.getAppId();
        String tenappid = bidappid.equals("bid") ? "ten" : "resp";
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter quotesourcefilter = new QFilter("quotesource", "=", (Object)"questionclarify");
        QFilter resubmisstenders = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        QFilter replystatus = new QFilter("replystatus", "=", (Object)"C");
        QFilter clarifytype = new QFilter("clarifytype", "!=", (Object)"TECHNICAL");
        DeleteServiceHelper.delete((String)(bidappid + "_decipurdetailshow"), (QFilter[])new QFilter[]{bidqfilter, quotesourcefilter});
        DynamicObject[] questionclarifys = BusinessDataServiceHelper.load((String)(tenappid + "_questionclarify"), (String)"tenderprice,pricevat,tax,notaxtenderprice,submitdate,bidsection,sectionname,supplierdetail,pursupplier,modifytime", (QFilter[])new QFilter[]{bidqfilter, resubmisstenders, replystatus, clarifytype});
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(bidappid + "_decipurdetailshow"));
        for (int i = 0; i < questionclarifys.length; ++i) {
            DynamicObject bidsection;
            DynamicObjectCollection supplierdetail;
            DynamicObject questionclarify = questionclarifys[i];
            DynamicObjectCollection bidsections = questionclarify.getDynamicObjectCollection("bidsection");
            if (bidsections.size() <= 0) continue;
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainType);
            dynamicObject.set("inclutaxamount", questionclarify.get("tenderprice"));
            dynamicObject.set("taxrate", (Object)questionclarify.getBigDecimal("pricevat").multiply(new BigDecimal("100")));
            dynamicObject.set("taxamount", questionclarify.get("tax"));
            dynamicObject.set("excepttaxamount", questionclarify.get("notaxtenderprice"));
            dynamicObject.set("quotesource", (Object)"questionclarify");
            dynamicObject.set("datetimefield", questionclarify.get("submitdate"));
            if (questionclarify.get("submitdate") == null) {
                dynamicObject.set("datetimefield", questionclarify.get("modifytime"));
            }
            if ((supplierdetail = (bidsection = (DynamicObject)bidsections.get(0)).getDynamicObjectCollection("supplierdetail")).size() > 0) {
                dynamicObject.set("supplier", ((DynamicObject)supplierdetail.get(0)).get("pursupplier"));
            }
            dynamicObject.set("sectionname", bidsection.get("sectionname"));
            dynamicObject.set("bidproject", (Object)bidProject);
            dynamicObject.set("sourceid", (Object)questionclarify.getPkValue().toString());
            dynamicObject.set("entitytype", (Object)tenappid);
            saveToShow.add(dynamicObject);
        }
    }

    public void createBudToDeciPurDetailShow(DynamicObject bidProject, List<DynamicObject> saveToShow) {
        String bidappid = this.getAppId();
        String tenappid = bidappid.equals("bid") ? "ten" : "resp";
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter quotesourcefilter = new QFilter("quotesource", "=", (Object)"bustalk");
        QFilter billstatusfilter = new QFilter("billstatus", "=", (Object)"B");
        DeleteServiceHelper.delete((String)(bidappid + "_decipurdetailshow"), (QFilter[])new QFilter[]{bidqfilter, quotesourcefilter});
        DynamicObject[] onlie_bustalks = BusinessDataServiceHelper.load((String)(tenappid + "_onlie_bustalk"), (String)"entry,tenderprice,notaxtenderprice,pricevat,tax,sectionname,submittime,supplier,bidproject", (QFilter[])new QFilter[]{bidqfilter, billstatusfilter});
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(bidappid + "_decipurdetailshow"));
        for (int i = 0; i < onlie_bustalks.length; ++i) {
            DynamicObject onlie_bustalk = onlie_bustalks[i];
            DynamicObjectCollection entrys = onlie_bustalk.getDynamicObjectCollection("entry");
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject object = (DynamicObject)entrys.get(j);
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainType);
                dynamicObject.set("inclutaxamount", object.get("tenderprice"));
                dynamicObject.set("taxrate", (Object)object.getBigDecimal("pricevat").multiply(new BigDecimal("100")));
                dynamicObject.set("taxamount", object.get("tax"));
                dynamicObject.set("excepttaxamount", object.get("notaxtenderprice"));
                dynamicObject.set("quotesource", (Object)"bustalk");
                dynamicObject.set("datetimefield", (Object)onlie_bustalk.getDate("submittime"));
                dynamicObject.set("supplier", onlie_bustalk.get("supplier"));
                dynamicObject.set("sectionname", object.get("sectionname"));
                dynamicObject.set("bidproject", onlie_bustalk.get("bidproject"));
                dynamicObject.set("sourceid", (Object)onlie_bustalk.getPkValue().toString());
                dynamicObject.set("entitytype", (Object)tenappid);
                saveToShow.add(dynamicObject);
            }
        }
    }

    public void createcloseBudToDeciPurDetailShow(DynamicObject bidProject, List<DynamicObject> saveToShow) {
        DynamicObject[] bustalkDynamicObjects;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(this.getAppId() + "_decipurdetailshow"));
        String bidappid = this.getAppId();
        ArrayList<String> stuList = new ArrayList<String>();
        stuList.add("C");
        stuList.add("F");
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter billstatusfilter = new QFilter("billstatus", "in", stuList);
        QFilter openonlinesynergy = new QFilter("openonlinesynergy", "=", (Object)Boolean.FALSE);
        for (DynamicObject bustalkDynamicObject : bustalkDynamicObjects = BusinessDataServiceHelper.load((String)(bidappid + "_bustalk"), (String)"bidsection,sectionname,supplierentry,supplier,new_price,taxrate,pricevat,bus_exceptvat,auditdate,bidproject", (QFilter[])new QFilter[]{bidqfilter, billstatusfilter, openonlinesynergy})) {
            DynamicObjectCollection bidsectionCol = bustalkDynamicObject.getDynamicObjectCollection("bidsection");
            DynamicObject bidproject = bustalkDynamicObject.getDynamicObject("bidproject");
            if (bidproject == null) continue;
            for (DynamicObject bidsection : bidsectionCol) {
                String bidsectionName = bidsection.getString("sectionname");
                DynamicObjectCollection supplierentryCol = bidsection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierentry : supplierentryCol) {
                    DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                    if (supplier == null) continue;
                    DynamicObject decipurdetailshow = new DynamicObject((DynamicObjectType)mainType);
                    decipurdetailshow.set("inclutaxamount", supplierentry.get("new_price"));
                    decipurdetailshow.set("taxrate", (Object)supplierentry.getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                    decipurdetailshow.set("taxamount", supplierentry.get("pricevat"));
                    decipurdetailshow.set("excepttaxamount", supplierentry.get("bus_exceptvat"));
                    decipurdetailshow.set("quotesource", (Object)"bustalk");
                    decipurdetailshow.set("decline_dec", (Object)"0.00%");
                    if (bustalkDynamicObject.getDate("auditdate") == null) continue;
                    decipurdetailshow.set("datetimefield", (Object)bustalkDynamicObject.getDate("auditdate"));
                    decipurdetailshow.set("supplier", (Object)supplier);
                    decipurdetailshow.set("sectionname", (Object)bidsectionName);
                    decipurdetailshow.set("bidproject", (Object)bidproject);
                    decipurdetailshow.set("sourceid", (Object)bustalkDynamicObject.getString("id"));
                    decipurdetailshow.set("entitytype", (Object)this.getAppId());
                    saveToShow.add(decipurdetailshow);
                }
            }
        }
    }

    public String getAppId() {
        return "bid";
    }

    public void updateScheduleState(String billno, boolean isExcutFlag) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)(this.getAppId() + "_scan_schedule"), (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (schedules == null || schedules.length == 0) {
            return;
        }
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)schedules[0].getPkValue(), (String)(this.getAppId() + "_scan_schedule"));
        int excuteRouds = loadSingle.getInt("excuterouds") + 1;
        loadSingle.set("isexcutflag", (Object)isExcutFlag);
        loadSingle.set("executedate", (Object)new Date());
        loadSingle.set("excuterouds", (Object)excuteRouds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loadSingle});
    }
}

