/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.RespBusiness;

public class BidPayHistoryUpdateSchedule
extends AbstractTask {
    private static DBRoute DBROUTE = DBRoute.of((String)"scm");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String appId = this.getAppId();
        String taleFlag = appId + "_pay_list";
        this.updateMethod(taleFlag, appId);
    }

    public String getAppId() {
        return "bid";
    }

    public void updateMethod(String tableFlag, String appId) {
        HashSet<String> statusQfilter = new HashSet<String>(16);
        statusQfilter.add("2");
        statusQfilter.add("3");
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)tableFlag, (String)"id,bidproject,status,bidproject,type,creator", (QFilter[])new QFilter[]{new QFilter("status", "in", statusQfilter), new QFilter("entitytypeid", "=", (Object)tableFlag)});
        ArrayList<DynamicObject> payList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> refunList = new ArrayList<DynamicObject>(16);
        String releasTable = appId + "_playrecord_playlist";
        for (DynamicObject load : loads) {
            boolean exists = this.jumpConfirmEdit(load.getPkValue());
            if (exists) continue;
            String status = load.getString("status");
            DynamicObject newData = null;
            if (StringUtils.equals((CharSequence)status, (CharSequence)"2") && !this.checkHashRecord(load.getPkValue().toString(), "01") && (newData = this.makeNewDataByPay(load, appId)) != null) {
                payList.add(newData);
            }
            if (StringUtils.equals((CharSequence)status, (CharSequence)"3") && !this.checkHashRecord(load.getPkValue().toString(), "02") && (newData = this.makeNewDataByRefun(load, appId)) != null) {
                refunList.add(newData);
            }
            if (newData == null) {
                BizLog.log((String)("update paydata,the id " + load.getPkValue() + ", has exist!"));
            }
            if (payList.size() >= 100) {
                SaveServiceHelper.save((DynamicObject[])payList.toArray(new DynamicObject[payList.size()]));
                payList.clear();
            }
            if (refunList.size() < 100) continue;
            SaveServiceHelper.save((DynamicObject[])refunList.toArray(new DynamicObject[refunList.size()]));
            refunList.clear();
        }
        if (payList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])payList.toArray(new DynamicObject[payList.size()]));
        }
        if (refunList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])refunList.toArray(new DynamicObject[refunList.size()]));
        }
    }

    public boolean jumpConfirmEdit(Object rowPk) {
        String sql = String.format("select fplaylistid,frecordid from t_bidpay_refrenentity where fplaylistid in ( %s ) ", rowPk);
        ArrayList payConfirmRecordSet = new ArrayList();
        DB.query((DBRoute)DBROUTE, (String)sql, null, rs -> {
            while (rs.next()) {
                payConfirmRecordSet.add(Long.parseLong(rs.getString(2)));
            }
            return 0;
        });
        return payConfirmRecordSet.size() != 0;
    }

    public boolean checkHashRecord(String id, String type) {
        String sql = String.format("select fplaylistid,frecordid from t_bidpay_refrenentity where fplaylistid in ( %s ) and fcombofield = '%s'", id, type);
        ArrayList payConfirmRecordSet = new ArrayList();
        DB.query((DBRoute)DBROUTE, (String)sql, null, rs -> {
            while (rs.next()) {
                payConfirmRecordSet.add(Long.parseLong(rs.getString(2)));
            }
            return 0;
        });
        return payConfirmRecordSet.size() > 0;
    }

    public DynamicObject makeNewDataByPay(DynamicObject data, String appId) {
        MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)(appId + "_pay"));
        DynamicObject payRecord = new DynamicObject((DynamicObjectType)payMainType);
        long genLongId = ID.genLongId();
        payRecord.set("id", (Object)genLongId);
        String billno = String.valueOf(genLongId);
        String billstatus = "C";
        payRecord.set("billno", (Object)billno);
        payRecord.set("billstatus", (Object)billstatus);
        DynamicObject bidproject = data.getDynamicObject("bidproject");
        bidproject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)(appId + "_project"));
        String type = data.getString("type");
        this.generBasicInfo(payRecord, bidproject, appId, type, "01");
        long listId = data.getLong("id");
        this.generPayMsg(payRecord, bidproject, appId, listId);
        this.generOtherInfo(payRecord, data);
        this.generRecordRelease(payRecord, appId, genLongId, "01");
        return payRecord;
    }

    public DynamicObject makeNewDataByRefun(DynamicObject data, String appId) {
        MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)(appId + "_refund_pay"));
        DynamicObject payRecord = new DynamicObject((DynamicObjectType)payMainType);
        long genLongId = ID.genLongId();
        payRecord.set("id", (Object)genLongId);
        String billno = String.valueOf(genLongId);
        String billstatus = "C";
        payRecord.set("billno", (Object)billno);
        payRecord.set("billstatus", (Object)billstatus);
        DynamicObject bidproject = data.getDynamicObject("bidproject");
        bidproject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)(appId + "_project"));
        String type = data.getString("type");
        this.generBasicInfo(payRecord, bidproject, appId, type, "02");
        long listId = data.getLong("id");
        this.generPayMsg(payRecord, bidproject, appId, listId);
        this.generOtherInfo(payRecord, data);
        this.generRecordRelease(payRecord, appId, genLongId, "02");
        return payRecord;
    }

    public void generBasicInfo(DynamicObject dataEntity, DynamicObject bProject, String appId, String type, String costtype) {
        String respbusiness = this.getBidProjectRespbusiness(bProject);
        if (StringUtils.equals((CharSequence)"bid", (CharSequence)appId)) {
            dataEntity.set("bidproject", (Object)BusinessDataServiceHelper.loadSingle((Object)bProject.getPkValue(), (String)"bidproject_f7"));
        } else {
            dataEntity.set("bidproject", (Object)BusinessDataServiceHelper.loadSingle((Object)bProject.getPkValue(), (String)"rebm_bidproject_f7"));
        }
        dataEntity.set("org", bProject.get("org"));
        dataEntity.set("respbusiness", (Object)respbusiness);
        dataEntity.set("isOpen", (Object)Boolean.TRUE);
        if (StringUtils.equals((CharSequence)"01", (CharSequence)costtype)) {
            dataEntity.set("entitytypeid", (Object)(appId + "_pay"));
        } else {
            dataEntity.set("entitytypeid", (Object)(appId + "_refund_pay"));
        }
        dataEntity.set("type", (Object)type);
        dataEntity.set("costtype", (Object)costtype);
    }

    public void generPayMsg(DynamicObject dataEntity, DynamicObject bidProject, String appId, Long listId) {
        ArrayList<Long> paylistids = new ArrayList<Long>();
        paylistids.add(listId);
        String selectStr = "id,status,type,sectionname,supplier,suresum,realsum,paytime,certificate,explain,payback,payback.freason,payback.backuser,payback.backtime";
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)(appId + "_pay_list"), (String)selectStr, (QFilter[])new QFilter[]{new QFilter("id", "in", paylistids)});
        Map<String, List<DynamicObject>> sectionList = Arrays.stream(loads).collect(Collectors.groupingBy(item -> {
            String sectionname = item.getString("sectionname");
            if (StringUtils.isBlank((CharSequence)sectionname)) {
                return ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidPayHistoryUpdateSchedule_0", (String)"scm-bid-business", (Object[])new Object[0]);
            }
            return sectionname;
        }));
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        if (enablemultisection) {
            for (Map.Entry<String, List<DynamicObject>> entry : sectionList.entrySet()) {
                String key = entry.getKey();
                bidsection.addNew().set("sectionname", (Object)key);
            }
        } else {
            bidsection.addNew().set("sectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidPayHistoryUpdateSchedule_0", (String)"scm-bid-business", (Object[])new Object[0]));
        }
        for (DynamicObject section : bidsection) {
            List<DynamicObject> payList = sectionList.get(section.getString("sectionname"));
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject payRecord : payList) {
                DynamicObject row = supplierentry.addNew();
                row.set("status", payRecord.get("status"));
                row.set("entrytype", payRecord.get("type"));
                row.set("supplier", payRecord.get("supplier"));
                row.set("suresum", payRecord.get("suresum"));
                row.set("realsum", payRecord.get("realsum"));
                row.set("paytime", payRecord.get("paytime"));
                row.set("explain", payRecord.get("explain"));
                row.set("paylistid", (Object)listId);
            }
        }
    }

    public void generOtherInfo(DynamicObject dataEntity, DynamicObject list) {
        DynamicObject creator = list.getDynamicObject("creator");
        dataEntity.set("creator", (Object)creator);
        dataEntity.set("createtime", (Object)new Date());
        dataEntity.set("modifier", (Object)creator);
        dataEntity.set("modifytime", (Object)new Date());
        dataEntity.set("auditor", (Object)creator);
        dataEntity.set("auditdate", (Object)new Date());
    }

    public void generRecordRelease(DynamicObject data, String appId, Long id, String type) {
        MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)(appId + "_playrecord_playlist"));
        DynamicObject typeRecord = new DynamicObject((DynamicObjectType)payMainType);
        typeRecord.set("id", (Object)id);
        typeRecord.set("entitytypeid", (Object)(appId + "_playrecord_playlist"));
        typeRecord.set("playrecordtype", (Object)type);
        DynamicObjectCollection entryentity = typeRecord.getDynamicObjectCollection("refrenceentity");
        DynamicObjectCollection bidsection = data.getDynamicObjectCollection("bidsection");
        for (DynamicObject supplierEntry : bidsection) {
            DynamicObjectCollection supplierentry = supplierEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                Object paylistid = row.get("paylistid");
                DynamicObject addNew = entryentity.addNew();
                addNew.set("playlistid", paylistid);
                addNew.set("recordid", (Object)id);
                addNew.set("entitytype", (Object)type);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{typeRecord});
    }

    public String getBidProjectRespbusiness(DynamicObject bidProject) {
        String temp = "";
        StringBuilder sb = new StringBuilder();
        if (null != bidProject) {
            DynamicObjectCollection memberEntry = bidProject.getDynamicObjectCollection("memberentity");
            RespBusiness rb = RespBusiness.valueOf((String)"BidPay");
            for (int i = 0; i < memberEntry.size(); ++i) {
                DynamicObject member = (DynamicObject)memberEntry.get(i);
                DynamicObject user = member.getDynamicObject("user");
                String respbusiness = member.getString("respbusiness");
                if (respbusiness.indexOf(rb.getVal()) < 0) continue;
                sb.append(user.getPkValue());
                sb.append(',');
            }
            if (sb.length() > 0) {
                temp = sb.substring(0, sb.length() - 1);
            }
        }
        return temp;
    }
}

