/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidPurProjectLongNameTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.updateBidPurProjectLongName();
    }

    public void updateBidPurProjectLongName() {
        String names = "";
        names = this.getAppID().equals("bid") ? "BidPurProjectLongNameTask" : "RebmPurProjectLongNameTask";
        try {
            BizLog.log((String)"\u91c7\u8d2d\u9879\u76ee\u957f\u540d\u79f0\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            QFilter qFilter = new QFilter("isexcutflag", "=", (Object)Boolean.TRUE);
            QFilter billNoQFilter = new QFilter("billno", "=", (Object)names);
            DynamicObject bidFileHistoryDataUp = BusinessDataServiceHelper.loadSingle((String)(this.getAppID() + "_scan_schedule"), (String)"id,billno,serviceclassname,mmethodname,excuterouds,executedate,appid", (QFilter[])new QFilter[]{qFilter, billNoQFilter});
            if (bidFileHistoryDataUp != null) {
                BizLog.log((String)"\u91c7\u8d2d\u9879\u76ee\u957f\u540d\u79f0\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5df2\u7ecf\u6210\u529f");
                return;
            }
            DynamicObject[] projectDynamicObjects = BusinessDataServiceHelper.load((String)(this.getAppID() + "_project"), (String)"id,purprojectset,bidsection,,bidsection.projectentry,projectentry.purentryproject", (QFilter[])new QFilter[]{new QFilter("entitytypeid", "=", (Object)(this.getAppID() + "_project"))});
            ArrayList<DynamicObject> saveProjectList = new ArrayList<DynamicObject>();
            for (DynamicObject bidProject : projectDynamicObjects) {
                String purprojectset = bidProject.getString("purprojectset");
                if (purprojectset == null || "".equals(purprojectset) || " ".equals(purprojectset)) continue;
                String purProjectSet = bidProject.getDynamicObjectCollection("bidsection").stream().flatMap(section -> section.getDynamicObjectCollection("projectentry").stream()).map(purDetail -> purDetail.getDynamicObject("purentryproject")).filter(purProject -> purProject != null).map(purProject -> purProject.getString("fullname")).distinct().collect(Collectors.joining(","));
                if (purProjectSet != null && purProjectSet.length() > 1999) {
                    purProjectSet = purProjectSet.substring(0, 1999);
                }
                if (purprojectset.equals(purProjectSet)) continue;
                bidProject.set("purprojectset", (Object)purProjectSet);
                saveProjectList.add(bidProject);
                if (saveProjectList.size() <= 1000) continue;
                SaveServiceHelper.save((DynamicObject[])saveProjectList.toArray(new DynamicObject[0]));
                saveProjectList.clear();
                BizLog.log((String)"\u91c7\u8d2d\u9879\u76ee\u957f\u540d\u79f0\u5386\u53f2\u6570\u636e\u5347\u7ea7\u4fdd\u5b581000\u6761\u6570\u636e");
            }
            SaveServiceHelper.save((DynamicObject[])saveProjectList.toArray(new DynamicObject[0]));
            BizLog.log((String)("\u91c7\u8d2d\u9879\u76ee\u957f\u540d\u79f0\u5386\u53f2\u6570\u636e\u5347\u7ea7\u4fdd\u5b58" + saveProjectList.size() + "\u6761\u6570\u636e"));
            BizLog.log((String)"\u91c7\u8d2d\u9879\u76ee\u957f\u540d\u79f0\u5386\u53f2\u6570\u636e\u5347\u7ea7\u6210\u529f");
            this.updateScheduleState(names, true);
        }
        catch (Exception e) {
            BizLog.log((String)("\u91c7\u8d2d\u9879\u76ee\u957f\u540d\u79f0\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f02\u5e38" + e.getMessage()));
            this.updateScheduleState(names, false);
        }
    }

    public void updateScheduleState(String billno, boolean isExcutFlag) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)(this.getAppID() + "_scan_schedule"), (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (schedules == null || schedules.length == 0) {
            return;
        }
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)schedules[0].getPkValue(), (String)(this.getAppID() + "_scan_schedule"));
        int excuteRouds = loadSingle.getInt("excuterouds") + 1;
        loadSingle.set("isexcutflag", (Object)isExcutFlag);
        loadSingle.set("executedate", (Object)new Date());
        loadSingle.set("excuterouds", (Object)excuteRouds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loadSingle});
    }

    public String getAppID() {
        return "bid";
    }
}

