/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.bid.business.schedule.bidcall.ReportBidDetailCall;

public class BidReportDataTask
extends AbstractTask {
    public static final Integer LIMIT_UPDATE_SIZE = 300;
    private static DBRoute DBROUTE = DBRoute.of((String)"scm");
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"reportSyncData", (int)300);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.syncMeta();
    }

    public void clearData() {
        DeleteServiceHelper.delete((String)(this.getAppId() + "_report_data"), (QFilter[])new QFilter[]{new QFilter("entitytypeid", "=", (Object)(this.getAppId() + "_report_data"))});
    }

    public void syncMeta() {
        StringBuilder projectFormId = new StringBuilder();
        projectFormId.append(this.getAppId()).append("_project");
        QFilter[] projectQFilter = this.getProjectQFilter();
        String s = "reportdata projectfilter log = " + this.getAppId() + "_project";
        BizLog.log((String)s);
        DynamicObject[] projectArray = BusinessDataServiceHelper.load((String)projectFormId.toString(), (String)"id", (QFilter[])projectQFilter);
        long currUserId = RequestContext.get().getCurrUserId();
        if (projectArray != null && projectArray.length > 0) {
            List projectIdList = Arrays.stream(projectArray).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            this.deleteEntityData();
            ArrayList<Object> batchId = new ArrayList<Object>(16);
            for (Object object : projectIdList) {
                batchId.clear();
                batchId.add(object);
                Callable callable = this.getCallable(batchId, currUserId);
                try {
                    callable.call();
                }
                catch (Throwable e) {
                    BizLog.log((String)("reportdata exception log = " + e.getMessage()));
                }
            }
        }
    }

    public void deleteEntityData() {
        DeleteServiceHelper.delete((String)(this.getAppId() + "_report_data"), (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)-1)});
    }

    public Callable getCallable(List<Object> batchId, long currUserId) {
        ReportBidDetailCall reportBidDetailCall = new ReportBidDetailCall();
        reportBidDetailCall.setAppId(this.getAppId());
        reportBidDetailCall.setBatchId(batchId);
        reportBidDetailCall.setCurrUserId(currUserId);
        BizLog.log((String)("reportdata set batchId log = " + batchId));
        return reportBidDetailCall;
    }

    public QFilter[] getProjectQFilter() {
        QFilter qFilter = new QFilter("entitytypeid", "=", (Object)(this.getAppId() + "_project"));
        return new QFilter[]{qFilter};
    }

    public static List<List<Object>> getBatchProjectIdList(List<Object> projectIdList) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        if (projectIdList == null || projectIdList.size() == 0) {
            return result;
        }
        if (projectIdList.size() <= LIMIT_UPDATE_SIZE) {
            result.add(projectIdList);
        } else {
            int splitNum = projectIdList.size() % LIMIT_UPDATE_SIZE == 0 ? projectIdList.size() / LIMIT_UPDATE_SIZE : projectIdList.size() / LIMIT_UPDATE_SIZE + 1;
            List<Object> value = null;
            for (int i = 0; i < splitNum; ++i) {
                value = i < splitNum - 1 ? projectIdList.subList(i * LIMIT_UPDATE_SIZE, (i + 1) * LIMIT_UPDATE_SIZE) : projectIdList.subList(i * LIMIT_UPDATE_SIZE, projectIdList.size());
                result.add(value);
            }
        }
        return result;
    }

    public String getAppId() {
        return "bid";
    }
}

