/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidScanAllAndExcuteSchedule
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String format = this.getCurrendDate();
        QFilter qFilter = new QFilter("isexcutflag", "=", (Object)Boolean.FALSE).or(new QFilter("excuterouds", "=", (Object)0));
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)this.getTable(), (String)"id,billno,serviceclassname,mmethodname,excuterouds,executedate,appid", (QFilter[])new QFilter[]{qFilter});
        if (schedules == null || schedules.length == 0) {
            BizLog.log((String)("BidScanAllAndExcuteSchedule Excute Date = " + format + ",has not data is excute!"));
            return;
        }
        String code = "";
        String className = "";
        String methodName = "";
        for (DynamicObject schedule : schedules) {
            boolean isexcuteFlag = true;
            try {
                code = schedule.getString("billno");
                className = schedule.getString("serviceclassname");
                methodName = schedule.getString("mmethodname");
                this.invokeMethod(className, methodName, code);
            }
            catch (Exception e) {
                isexcuteFlag = false;
                BizLog.log((String)("BidScanAllAndExcuteSchedule code = " + code + ",e.message = " + e.getMessage()));
            }
            this.updateScheduleState(code, isexcuteFlag);
        }
    }

    public void invokeMethod(String className, String method, String code) throws Exception {
        Class<?> clazz = Class.forName(className);
        if (code.endsWith("BidingUpdate")) {
            Method excuteMethod = clazz.getMethod(method, String.class);
            excuteMethod.invoke(clazz.newInstance(), this.getAppId());
        } else {
            Method excuteMethod = clazz.getMethod(method, new Class[0]);
            excuteMethod.invoke(clazz.newInstance(), new Object[0]);
        }
    }

    public String getTable() {
        return "bid_scan_schedule";
    }

    public String getAppId() {
        return "bid";
    }

    public String getCurrendDate() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = dateFormat.format(date);
        return format;
    }

    public void updateScheduleState(String billno, boolean isexcutflag) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)this.getTable(), (String)"id", (QFilter[])new QFilter[]{qFilter});
        String format = this.getCurrendDate();
        if (schedules == null || schedules.length == 0) {
            BizLog.log((String)("BidScanAllAndExcuteSchedule has null billno = " + billno + ",Date = " + format));
            return;
        }
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)schedules[0].getPkValue(), (String)this.getTable());
        int excuterouds = loadSingle.getInt("excuterouds") + 1;
        loadSingle.set("isexcutflag", (Object)isexcutflag);
        loadSingle.set("executedate", (Object)new Date());
        loadSingle.set("excuterouds", (Object)excuterouds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loadSingle});
    }
}

