/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.helper.BidFileHelper;

public class MultipleChoiceQuestionClarifyDataTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            this.dealTotalData(true);
            this.dealTotalData(false);
        }
        catch (Exception e) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8d28\u7591\u6f84\u6e05\u5386\u53f2\u6570\u636e\u5347\u7ea7\u51fa\u9519\uff1a%s\u3002", (String)"MultipleChoiceQuestionClarifyDataTask_0", (String)"scm-bid-business", (Object[])new Object[0]), e));
        }
    }

    public void dealTotalData(boolean flag) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"UNCLARIFIED");
        if (!flag) {
            qFilter = new QFilter("billstatus", "!=", (Object)"UNCLARIFIED");
        }
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)(this.getAppId() + "_multiquestclarify"), (String)"id", (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (loads == null || loads.length <= 0) {
            return;
        }
        for (DynamicObject load : loads) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)load.getPkValue(), (String)(this.getAppId() + "_multiquestclarify"));
            String billno = dynamicObject.getString("billno");
            if (StringUtils.isBlank((CharSequence)billno)) {
                String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                dynamicObject.set("billno", (Object)uuid);
            }
            if (flag) {
                dynamicObject.set("billstatus", (Object)"A");
                dynamicObject.set("publicstatis", (Object)"S");
            } else {
                String billstatus = dynamicObject.getString("billstatus");
                QFilter qFilter1 = new QFilter("multiquestclarifyid", "=", dynamicObject.getPkValue());
                boolean hasExists = QueryServiceHelper.exists((String)(this.getAppId() + "_questionclarify"), (QFilter[])new QFilter[]{qFilter1});
                DynamicObject bidproject = dynamicObject.getDynamicObject("bidproject");
                String bidprojectString = bidproject.getString("billstatus");
                if ("X".equals(bidprojectString) || StringUtils.equals((CharSequence)billstatus, (CharSequence)"INVALID") || StringUtils.equals((CharSequence)billstatus, (CharSequence)"INVALIDXX")) {
                    dynamicObject.set("billstatus", (Object)"INVALID");
                    if (hasExists) {
                        dynamicObject.set("publicstatis", (Object)"S");
                    } else {
                        dynamicObject.set("publicstatis", (Object)"B");
                    }
                } else if (!hasExists) {
                    dynamicObject.set("publicstatis", (Object)"B");
                } else {
                    HashSet<String> proStatus = new HashSet<String>();
                    proStatus.add("UNCLARIFIED");
                    proStatus.add("CLARIFIED");
                    proStatus.add("NOCLARIFIED");
                    proStatus.add("SUBMITTED");
                    QFilter qFilter2 = new QFilter("billstatus", "in", proStatus);
                    boolean exists = QueryServiceHelper.exists((String)(this.getAppId() + "_questionclarify"), (QFilter[])new QFilter[]{qFilter1, qFilter2});
                    if (exists) {
                        dynamicObject.set("billstatus", (Object)"A");
                        dynamicObject.set("publicstatis", (Object)"S");
                    } else {
                        dynamicObject.set("publicstatis", (Object)"B");
                    }
                }
            }
            dynamicObject = this.dealHistory(dynamicObject);
            if (dynamicObject == null) continue;
            this.dealSpecialStatus(dynamicObject);
            list.add(dynamicObject);
        }
        if (list != null && list.size() > 0) {
            DynamicObject[] dataEntities = list.toArray(new DynamicObject[list.size()]);
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
    }

    public void dealSpecialStatus(DynamicObject mul) {
        long bidevaluationid = mul.getLong("bidevaluationid");
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getAppId()).append("_bidevaluation");
        DynamicObject bidevalution = null;
        try {
            bidevalution = BusinessDataServiceHelper.loadSingle((Object)bidevaluationid, (String)buffer.toString());
        }
        catch (Exception e) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8d28\u7591\u6f84\u6e05\u5386\u53f2\u6570\u636e\u5347\u7ea7\u51fa\u9519\uff1a%1$s%2$s\u3002", (String)"MultipleChoiceQuestionClarifyDataTask_2", (String)"scm-bid-business", (Object[])new Object[0]), bidevaluationid, e));
        }
        String billstatus = "";
        if (bidevalution != null) {
            if (bidevalution != null && (billstatus = bidevalution.getString("billstatus")).equals("XX")) {
                mul.set("billstatus", (Object)"INVALIDXX");
                return;
            }
            DynamicObject bidproject = mul.getDynamicObject("bidproject");
            String bidprojectString = bidproject.getString("billstatus");
            if ("X".equals(bidprojectString)) {
                mul.set("billstatus", (Object)"INVALID");
                return;
            }
        }
        if ("UNSENT".equals(billstatus = mul.getString("billstatus"))) {
            mul.set("billstatus", (Object)"A");
        }
    }

    public DynamicObject dealHistory(DynamicObject multip) {
        Iterator iterator;
        DynamicObjectCollection multiclarifyentry = multip.getDynamicObjectCollection("multiclarifyentry");
        if (multiclarifyentry == null || multiclarifyentry.size() <= 0) {
            return null;
        }
        DynamicObjectCollection bidsections = multip.getDynamicObjectCollection("bidsection");
        boolean flag = false;
        if (!bidsections.isEmpty() && bidsections.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < bidsections.size(); ++i) {
                DynamicObject bidRow = (DynamicObject)bidsections.get(i);
                buffer.append(bidRow.getPkValue()).append(',');
                bidRow.getDynamicObjectCollection("supplierentry").clear();
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)(this.getAppId() + "_multiquestclarify"));
            String dbRouteKey = dataEntityType.getDBRouteKey();
            String substring = buffer.toString().substring(0, buffer.toString().length() - 1);
            StringBuilder sql = new StringBuilder();
            sql.append("delete from t_query_supplierentry where fentryid in (").append(substring).append(')');
            DB.execute((DBRoute)new DBRoute(dbRouteKey), (String)sql.toString());
            sql.setLength(0);
            sql.append("delete from t_query_sections where fid in (").append(multip.getPkValue()).append(')');
            DB.execute((DBRoute)new DBRoute(dbRouteKey), (String)sql.toString());
            flag = true;
        }
        if (flag) {
            multip = BusinessDataServiceHelper.loadSingle((Object)multip.getPkValue(), (String)(this.getAppId() + "_multiquestclarify"));
            multiclarifyentry = multip.getDynamicObjectCollection("multiclarifyentry");
            bidsections = multip.getDynamicObjectCollection("bidsection");
        }
        DynamicObject bidproject = multip.getDynamicObject("bidproject");
        boolean aBoolean = bidproject.getBoolean("enablemultisection");
        String entitytypeid = bidproject.getString("entitytypeid");
        String bidprojectString = bidproject.getString("billstatus");
        if ("X".equals(bidprojectString)) {
            multip.set("billstatus", (Object)"INVALID");
        }
        if (!aBoolean) {
            iterator = multiclarifyentry.iterator();
            DynamicObject bidSectionRow = bidsections.addNew();
            bidSectionRow.set("sectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"MultipleChoiceQuestionClarifyDataTask_1", (String)"scm-bid-business", (Object[])new Object[0]));
            DynamicObjectCollection newSupplierEntry = bidSectionRow.getDynamicObjectCollection("supplierentry");
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                DynamicObject newSupplierRow = newSupplierEntry.addNew();
                this.setSupplierRowValue(newSupplierRow, row, entitytypeid);
            }
        } else {
            iterator = multiclarifyentry.iterator();
            HashMap mapRow = new HashMap(16);
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                String clarifysupplier = row.getString("clarifysupplier1");
                String sectionName = clarifysupplier.split("&&")[2];
                List list1 = (List)mapRow.get(sectionName);
                if (list1 != null) {
                    list1.add(row);
                    continue;
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                list.add(row);
                mapRow.put(sectionName, list);
            }
            for (Map.Entry entry : mapRow.entrySet()) {
                String section = (String)entry.getKey();
                DynamicObject bidSectionRow = bidsections.addNew();
                bidSectionRow.set("sectionname", (Object)ResManager.loadKDString((String)section, (String)"MultipleChoiceQuestionClarifyDataTask_1", (String)"scm-bid-business", (Object[])new Object[0]));
                DynamicObjectCollection newSupplierEntry = bidSectionRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject row : (List)entry.getValue()) {
                    DynamicObject newSupplierRow = newSupplierEntry.addNew();
                    this.setSupplierRowValue(newSupplierRow, row, entitytypeid);
                }
            }
        }
        return multip;
    }

    public void setSupplierRowValue(DynamicObject newSupplierRow, DynamicObject row, String entitytypeid) {
        String clarifysupplier = row.getString("clarifysupplier1");
        String supplierId = clarifysupplier.split("&&")[0];
        DynamicObject supplier = new DynamicObject();
        supplier = entitytypeid.equals("rebm_project") ? BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(supplierId), (String)"resm_official_supplier") : BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(supplierId), (String)"bd_supplier");
        long id = ID.genLongId();
        newSupplierRow.set("id", (Object)id);
        newSupplierRow.set("clarifysupplier", (Object)supplier);
        newSupplierRow.set("questiondescription", (Object)row.getString("questiondescription1"));
        newSupplierRow.set("resubmisstenders", row.get("resubmisstenders1"));
        DynamicObjectCollection newAttachFiles = newSupplierRow.getDynamicObjectCollection("multiclarifyattach");
        DynamicObjectCollection oldAttachFiles = row.getDynamicObjectCollection("multiclarifyattach");
        newAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = oldAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
        Object questclarifyid = row.get("questclarifyidbak");
        if (questclarifyid != null) {
            newSupplierRow.set("questclarifyid", row.get("questclarifyidbak"));
        }
    }

    public DynamicObject makeFileObj(Long entitryPk) {
        StringBuilder formId = new StringBuilder();
        formId.append(this.getAppId()).append("_multiclatifyfile");
        QFilter[] qFilters = new QFilter[]{new QFilter("clarifyentryid", "=", (Object)entitryPk)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)formId.toString(), (String)"id", (QFilter[])qFilters);
        if (loads != null && loads.length > 0) {
            return loads[0];
        }
        MainEntityType fileType = EntityMetadataCache.getDataEntityType((String)formId.toString());
        DynamicObject fileDyn = new DynamicObject((DynamicObjectType)fileType);
        long id = ID.genLongId();
        fileDyn.set("id", (Object)id);
        fileDyn.set("clarifyentryid", (Object)entitryPk);
        return fileDyn;
    }

    protected void copyFileAtoBOfClarify(String formId, DynamicObject oldFile, DynamicObject newFile) {
        try (TXHandle h = TX.requiresNew();){
            try {
                BidFileHelper.copyFileFromAToB(formId, oldFile.get("id"), "attachmentpanelap", formId, newFile.getPkValue(), "attachmentpanelap");
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public String getAppId() {
        return "bid";
    }
}

