/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PublicHistoryDataDeal
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u53d1\u6807\u5546\u52a1\u4f19\u4f34\u7528\u6237\u5386\u53f2\u6570\u636e\uff01", (String)"PublicHistoryDataDeal_0", (String)"scm-bid-business", (Object[])new Object[0]));
            this.updateData();
            BizLog.log((String)ResManager.loadKDString((String)"\u5904\u7406\u53d1\u6807\u5546\u52a1\u4f19\u4f34\u7528\u6237\u5386\u53f2\u6570\u636e\u7ed3\u675f\uff01", (String)"PublicHistoryDataDeal_1", (String)"scm-bid-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u53d1\u6807\u5546\u52a1\u4f19\u4f34\u7528\u6237\u5386\u53f2\u5347\u7ea7\u51fa\u9519\uff1a%s", (String)"PublicHistoryDataDeal_2", (String)"scm-bid-business", (Object[])new Object[0]), e));
        }
    }

    public void updateData() {
        String publicFormId = this.getPublicFormId();
        String tenderFormId = this.getMytenderFormId();
        HashSet<String> statusSet = new HashSet<String>();
        statusSet.add("X");
        statusSet.add("XX");
        QFilter qFilter = new QFilter("billstatus", "not in", statusSet);
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)publicFormId, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (loads == null || loads.length == 0) {
            return;
        }
        ArrayList<DynamicObject> updateTender = new ArrayList<DynamicObject>();
        HashMap<String, DynamicObject> tenderMap = new HashMap<String, DynamicObject>();
        for (DynamicObject tempLoad : loads) {
            DynamicObject readLoad = BusinessDataServiceHelper.loadSingle((Object)tempLoad.getPkValue(), (String)publicFormId);
            DynamicObject bidproject = readLoad.getDynamicObject("bidproject");
            if (bidproject == null) continue;
            QFilter bidQFilter = new QFilter("bidproject", "=", bidproject.getPkValue());
            DynamicObject[] mytenders = BusinessDataServiceHelper.load((String)tenderFormId, (String)"id,bidproject,supplier,tenderer", (QFilter[])new QFilter[]{bidQFilter});
            if (mytenders == null || mytenders.length == 0) continue;
            for (DynamicObject mytender : mytenders) {
                DynamicObject supplierDy = mytender.getDynamicObject("supplier");
                String supplier = "";
                if (supplierDy == null) continue;
                supplier = mytender.getDynamicObject("supplier").getPkValue().toString();
                DynamicObject tenderUser = mytender.getDynamicObject("tenderer");
                if (tenderUser == null) continue;
                tenderUser = BusinessDataServiceHelper.loadSingle((Object)tenderUser.getPkValue(), (String)"bos_user");
                tenderMap.put(supplier, tenderUser);
            }
            DynamicObjectCollection bidsections = readLoad.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSectionRow : bidsections) {
                DynamicObjectCollection supplierentry = bidSectionRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject next : supplierentry) {
                    DynamicObject partnerUser;
                    DynamicObject supplierDyn = next.getDynamicObject("supplier");
                    String supplier = "";
                    if (supplierDyn == null || (partnerUser = (DynamicObject)tenderMap.get(supplier = next.getDynamicObject("supplier").getPkValue().toString())) == null) continue;
                    String fullName = partnerUser.getString("name");
                    String phone = partnerUser.getString("phone");
                    next.set("suppliercontact", (Object)new LocaleString(fullName));
                    next.set("contactphone", (Object)phone);
                    QFilter userQfilter = new QFilter("user", "=", partnerUser.getPkValue());
                    DynamicObject[] bos_bizpartnerusers = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"id,isadmin,user", (QFilter[])new QFilter[]{userQfilter});
                    if (bos_bizpartnerusers == null || bos_bizpartnerusers.length == 0) continue;
                    if (!bos_bizpartnerusers[0].getBoolean("isadmin")) {
                        next.set("projectpartner", (Object)partnerUser);
                        continue;
                    }
                    next.set("projectpartner", null);
                }
            }
            updateTender.add(readLoad);
            if (updateTender.size() <= 500) continue;
            DynamicObject[] dataEntities = updateTender.toArray(new DynamicObject[updateTender.size()]);
            SaveServiceHelper.update((DynamicObject[])dataEntities);
            updateTender.clear();
        }
        if (updateTender.size() > 0) {
            DynamicObject[] dataEntities = updateTender.toArray(new DynamicObject[updateTender.size()]);
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        }
    }

    public String getAppId() {
        return "bid";
    }

    public String getPublicFormId() {
        return this.getAppId() + "_bidpublish";
    }

    public String getMytenderFormId() {
        if ("bid".equals(this.getAppId())) {
            return "ten_mytender";
        }
        return "resp_mytender";
    }
}

