/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule.bidcall;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.ReportUtil;

public class ReportBidDetailCall
implements Callable {
    private static final Log logger = LogFactory.getLog(ReportBidDetailCall.class);
    private static final Integer INDEX0 = 0;
    private static final Integer INDEX1 = 1;
    private String appId;
    private List<Object> batchId;
    private static DBRoute DBROUTE = DBRoute.of((String)"scm");
    private long currUserId;

    public ReportBidDetailCall() {
    }

    public ReportBidDetailCall(String appId, List<Object> batchId, long currUserId) {
        this.appId = appId;
        this.batchId = batchId;
        this.currUserId = currUserId;
    }

    public Object call() throws Exception {
        StringBuilder projectFormId = new StringBuilder();
        projectFormId.append(this.getAppId()).append("_project");
        StringBuilder reportFormIdbuilder = new StringBuilder();
        reportFormIdbuilder.append(this.getAppId()).append("_report_data");
        String reportFormId = reportFormIdbuilder.toString();
        MainEntityType reportMainType = EntityMetadataCache.getDataEntityType((String)(this.getAppId() + "_report_data"));
        DynamicObject[] projectData = BusinessDataServiceHelper.load((Object[])this.batchId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)projectFormId.toString()));
        ArrayList<DynamicObject> saveReportDataList = new ArrayList<DynamicObject>(16);
        for (DynamicObject project : projectData) {
            DynamicObject reportData = new DynamicObject((DynamicObjectType)reportMainType);
            QFilter[] reportDataQFilter = this.getReportDataQFilter(project);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)reportFormId, (String)"id", (QFilter[])reportDataQFilter);
            if (ids != null && ids.length > 0) {
                reportData = BusinessDataServiceHelper.loadSingle((Object)ids[0].getPkValue(), (String)reportFormId);
            } else {
                long metaId = ID.genLongId();
                reportData.set("id", (Object)metaId);
                reportData.set("billno", project.getPkValue());
                reportData.set("creator", (Object)this.currUserId);
                reportData.set("bidproject", (Object)project);
                reportData.set("entitytypeid", (Object)(this.getAppId() + "_report_data"));
                reportData.set("name", project.get("name"));
                reportData.set("currency", project.get("currency"));
            }
            if (project == null || project.getPkValue() == null) {
                BizLog.log((String)("reportdata has null = " + project));
                continue;
            }
            reportData.set("entrustmentorgunit", project.get("entrustmentorgunit"));
            reportData.set("projectnumber", project.get("billno"));
            this.syncMetaByProjectBasic(project, reportData);
            String billstatus = project.getString("billstatus");
            if (!StringUtils.equals((CharSequence)billstatus, (CharSequence)"C") && !StringUtils.equals((CharSequence)billstatus, (CharSequence)"XX")) {
                reportData.set("decisionstatus", (Object)"fail");
                saveReportDataList.add(reportData);
                continue;
            }
            this.syncBidDocumentEdit(project, reportData);
            this.syncBidSupplierInvitation(project, reportData);
            this.syncBidClarificaition(project, reportData);
            this.syncBidBottomMake(project, reportData);
            this.syncBidSupplierInvitation(project, reportData);
            this.syncDy(project, reportData);
            this.syncBidPublish(project, reportData);
            this.syncBidOpen(project, reportData);
            this.syncBidEvaluation(project, reportData);
            this.syncSwtp(project, reportData);
            this.syncDecision(project, reportData);
            this.syncMetaByProcessBaseData(project, reportData);
            this.syncMetaByProjectAndDeciation(project, reportData);
            this.syncMetaByExtend(project, reportData);
            saveReportDataList.add(reportData);
        }
        if (saveReportDataList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveReportDataList.toArray(new DynamicObject[saveReportDataList.size()]));
        }
        return null;
    }

    public void syncMetaByProjectBasic(DynamicObject project, DynamicObject reportData) {
        Date setupdate;
        DynamicObject org = project.getDynamicObject("org");
        reportData.set("org", (Object)org);
        DynamicObject purtype = project.getDynamicObject("purtype");
        reportData.set("purtype", (Object)purtype);
        DynamicObject bidmode = project.getDynamicObject("bidmode");
        reportData.set("purmode", (Object)bidmode);
        String purmodel = project.getString("purmodel");
        reportData.set("purmodel", (Object)purmodel);
        String billstatus = project.getString("billstatus");
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"X")) {
            reportData.set("bidstatus", (Object)0);
        } else {
            reportData.set("bidstatus", (Object)1);
        }
        reportData.set("setupdate", project.get("setupdate"));
        DynamicObject contact = project.getDynamicObject("contact");
        DynamicObjectCollection memberentitys = project.getDynamicObjectCollection("memberentity");
        if (memberentitys != null) {
            for (DynamicObject next : memberentitys) {
                boolean isdirector = next.getBoolean("isdirector");
                if (!isdirector) continue;
                contact = next.getDynamicObject("user");
                break;
            }
        }
        Date createTime = project.getDate("createtime");
        Date auditTime = project.getDate("auditdate");
        if (createTime != null && auditTime != null) {
            Long nodeTime = auditTime.getTime() - createTime.getTime();
            reportData.set("projecttime", (Object)nodeTime);
        }
        reportData.set("projectuser", (Object)contact);
        reportData.set("bidvaluation", project.get("bidvaluation"));
        reportData.set("doctype", project.get("doctype"));
        Date biddecisiondate = project.getDate("biddecisiondate");
        if (biddecisiondate != null && (setupdate = project.getDate("setupdate")) != null) {
            int days = ReportBidDetailCall.differentDaysByMillisecond(setupdate, biddecisiondate) + 1;
            reportData.set("planprojectperiod", (Object)days);
        }
    }

    public static int differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public void syncBidDocumentEdit(DynamicObject project, DynamicObject reportData) {
        DynamicObject[] bidDocumentEdit = BusinessDataServiceHelper.load((String)(this.getAppId() + "_biddocument_edit"), (String)"id,createtime,submittime,auditdate,modifytime,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal())});
        long nodeTime = ReportUtil.getNodeTime((DynamicObject[])bidDocumentEdit, (String)"bsbz");
        reportData.set("documenttime", (Object)nodeTime);
    }

    public void syncBidSupplierInvitation(DynamicObject project, DynamicObject reportData) {
        DynamicObject[] bidSupplierInvitation = BusinessDataServiceHelper.load((String)(this.getAppId() + "_supplierinvitation"), (String)"id,createtime,submittime,auditdate,modifytime,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal())});
        long nodeTime = ReportUtil.getNodeTime((DynamicObject[])bidSupplierInvitation, (String)"gfrw");
        reportData.set("supplierinvitatiotime", (Object)nodeTime);
    }

    public void syncBidBottomMake(DynamicObject project, DynamicObject reportData) {
        DynamicObject[] bottomMakeArray = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bottom_make"), (String)"id,createtime,submittime,auditdate,modifytime,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal())});
        long nodeTime = ReportUtil.getNodeTime((DynamicObject[])bottomMakeArray, (String)"bdbz");
        reportData.set("bottommaketime", (Object)nodeTime);
    }

    public void syncBidClarificaition(DynamicObject project, DynamicObject reportData) {
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)(this.getAppId() + "_clarificaiton"), (String)"id,createtime,submittime,auditdate,modifytime,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal())});
        long nodeTime = ReportUtil.getNodeTime((DynamicObject[])dataArray, (String)"zbjd");
        reportData.set("clarificaitontime", (Object)nodeTime);
    }

    public void syncBidPublish(DynamicObject project, DynamicObject reportData) {
        String selectProperties = "id,createtime,auditdate,submittime,realbidpublishdate,billstatus";
        DynamicObject[] publishData = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidpublish"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue())});
        long nodeTime = ReportUtil.getNodeTime((DynamicObject[])publishData, (String)"fb");
        reportData.set("publishtime", (Object)nodeTime);
    }

    public void syncBidOpen(DynamicObject project, DynamicObject reportData) {
        String selectProperties = "id,createtime,rounds,auditdate,submittime,realbidopendate,modifytime,billstatus,opentype";
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidopen"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal())});
        String bidOpenType = project.getString("bidopentype");
        long nodeTime = 0L;
        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidOpenType)) {
            nodeTime = ReportUtil.getNodeTime((DynamicObject[])dataArray, (String)"kb");
        } else {
            String type = null;
            if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                type = BidOpenSelectTypeEnum.TECHBUSINESS.getValue();
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
                type = BidOpenSelectTypeEnum.BUSSINESSTECH.getValue();
            }
            nodeTime = ReportBidDetailCall.getOpenOrEvalNodeTime(dataArray, type, "kb");
        }
        reportData.set("opentime", (Object)nodeTime);
    }

    public void syncDy(DynamicObject project, DynamicObject reportData) {
        DynamicObject[] bidAnswerQuestionRecoCol = BusinessDataServiceHelper.load((String)"bid_answerquestion_reco", (String)"id,createtime,auditdate,submittime,realanswertime,modifytime,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue())});
        long bzIntervalTime = 0L;
        long spIntervalTime = 0L;
        if (bidAnswerQuestionRecoCol != null && bidAnswerQuestionRecoCol.length > 0) {
            for (DynamicObject bidAnswerQuestionReco : bidAnswerQuestionRecoCol) {
                Date submitTime = bidAnswerQuestionReco.getDate("submittime");
                Date createTime = bidAnswerQuestionReco.getDate("createtime");
                Date auditTime = bidAnswerQuestionReco.getDate("auditdate");
                if (submitTime != null && createTime != null) {
                    bzIntervalTime += submitTime.getTime() - createTime.getTime();
                }
                if (auditTime == null || submitTime == null) continue;
                spIntervalTime += auditTime.getTime() - submitTime.getTime();
            }
        }
        long jdIntervalTime = bzIntervalTime + spIntervalTime;
        reportData.set("dytime", (Object)jdIntervalTime);
    }

    public void syncBidEvaluation(DynamicObject project, DynamicObject reportData) {
        String selectProperties = "id,createtime,rounds,auditdate,submittime,modifytime,billstatus,evaltype";
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidevaluation"), (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal())});
        String bidOpenType = project.getString("bidopentype");
        long nodeTime = 0L;
        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidOpenType)) {
            nodeTime = ReportUtil.getNodeTime((DynamicObject[])dataArray, (String)"pb");
        } else {
            String typeValue = null;
            if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                typeValue = BidOpenSelectTypeEnum.TECHBUSINESS.getValue();
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
                typeValue = BidOpenSelectTypeEnum.BUSSINESSTECH.getValue();
            }
            nodeTime = ReportBidDetailCall.getOpenOrEvalNodeTime(dataArray, typeValue, "pb");
        }
        reportData.set("evaluationtime", (Object)nodeTime);
    }

    public void syncSwtp(DynamicObject project, DynamicObject reportData) {
        String selectSwtpProps = "id,createtime,submittime,auditdate,modifytime,billstatus";
        DynamicObject[] swtpCol = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bustalk"), (String)selectSwtpProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
        if (swtpCol != null && swtpCol.length > 0) {
            long jdIntervalTime = 0L;
            long bzIntervalTime = 0L;
            long spIntervalTime = 0L;
            Date submitTime = null;
            Date auditTime = null;
            Date createTime = null;
            for (DynamicObject swtp : swtpCol) {
                submitTime = swtp.getDate("submittime");
                auditTime = swtp.getDate("auditdate");
                createTime = swtp.getDate("createtime");
                if (auditTime != null && submitTime != null) {
                    spIntervalTime += auditTime.getTime() - submitTime.getTime();
                }
                if (submitTime == null || createTime == null) continue;
                bzIntervalTime += submitTime.getTime() - createTime.getTime();
            }
            jdIntervalTime = bzIntervalTime + spIntervalTime;
            reportData.set("swtptime", (Object)jdIntervalTime);
        }
    }

    public void syncDecision(DynamicObject project, DynamicObject reportData) {
        String selectDecisionProps = "id,createtime,submittime,auditdate,modifytime,billstatus";
        DynamicObject[] currentData = BusinessDataServiceHelper.load((String)(this.getAppId() + "_decision"), (String)selectDecisionProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal())});
        long nodeTime = ReportUtil.getNodeTime((DynamicObject[])currentData, (String)"db");
        reportData.set("decisiontime", (Object)nodeTime);
    }

    public void syncMetaByProcessBaseData(DynamicObject project, DynamicObject reportData) {
        QFilter projectId = new QFilter("bidproject", "=", project.getPkValue());
        StringBuilder formId = new StringBuilder();
        formId.append(this.getAppId()).append("_bidpublish");
        QFilter statusQFilter = new QFilter("billstatus", "=", (Object)"P");
        QFilter isnewbillQFilter = new QFilter("isnewbill", "=", (Object)Boolean.TRUE);
        DynamicObject[] sureopendates = BusinessDataServiceHelper.load((String)formId.toString(), (String)"realbidpublishdate", (QFilter[])new QFilter[]{projectId, statusQFilter, isnewbillQFilter});
        if (sureopendates != null && sureopendates.length > 0) {
            reportData.set("newpuiblicdate", sureopendates[0].get("realbidpublishdate"));
        }
        statusQFilter = new QFilter("billstatus", "=", (Object)"X");
        isnewbillQFilter = new QFilter("rounds", "=", (Object)1);
        sureopendates = BusinessDataServiceHelper.load((String)formId.toString(), (String)"realbidpublishdate", (QFilter[])new QFilter[]{projectId, statusQFilter, isnewbillQFilter});
        if (sureopendates != null && sureopendates.length > 0) {
            reportData.set("oldpuiblicdate", sureopendates[0].get("realbidpublishdate"));
        }
        statusQFilter = new QFilter("billstatus", "=", (Object)"O");
        formId.setLength(0);
        formId.append(this.getAppId()).append("_bidopen");
        DynamicObject[] openproject = BusinessDataServiceHelper.load((String)formId.toString(), (String)"opentype,realbidopendate", (QFilter[])new QFilter[]{projectId, statusQFilter});
        if (openproject != null && openproject.length > 0) {
            for (int i = 0; i < openproject.length; ++i) {
                String opentype = openproject[i].getString("opentype");
                if ("TECHNICAL".equals(opentype)) {
                    reportData.set("techdate", openproject[i].get("realbidopendate"));
                    continue;
                }
                if ("BUSSINESS".equals(opentype)) {
                    reportData.set("comdate", openproject[i].get("realbidopendate"));
                    continue;
                }
                reportData.set("techdate", openproject[i].get("realbidopendate"));
                reportData.set("comdate", openproject[i].get("realbidopendate"));
            }
        }
        HashSet<String> billstatusSet = new HashSet<String>();
        billstatusSet.add("C");
        billstatusSet.add("S");
        billstatusSet.add("R");
        statusQFilter = new QFilter("billstatus", "in", billstatusSet);
        formId.setLength(0);
        formId.append(this.getAppId()).append("_decision");
        DynamicObject[] publicproject = BusinessDataServiceHelper.load((String)formId.toString(), (String)"auditdate", (QFilter[])new QFilter[]{projectId, statusQFilter});
        if (publicproject != null && publicproject.length > 0) {
            reportData.set("decisiondate", publicproject[0].get("auditdate"));
            reportData.set("decisionstatus", (Object)"crs");
        } else {
            reportData.set("decisionstatus", (Object)"other");
        }
    }

    public void syncMetaByProjectAndDeciation(DynamicObject project, DynamicObject reportData) {
        Date setupdate;
        this.calPurDetailInfo(project, reportData);
        HashSet<String> statusFilter = new HashSet<String>();
        statusFilter.add("C");
        statusFilter.add("S");
        statusFilter.add("R");
        DynamicObject[] currentData = BusinessDataServiceHelper.load((String)(this.getAppId() + "_decision"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "in", statusFilter)});
        DynamicObject decision = null;
        if (currentData != null && currentData.length > 0) {
            decision = BusinessDataServiceHelper.loadSingle((Object)currentData[0].getPkValue(), (String)(this.getAppId() + "_decision"));
        }
        if (decision == null) {
            return;
        }
        String decisionStatus = decision.getString("billstatus");
        reportData.set("signstatus", (Object)decisionStatus);
        Date auditdate = decision.getDate("auditdate");
        if (auditdate != null && (setupdate = project.getDate("setupdate")) != null) {
            int days = ReportBidDetailCall.differentDaysByMillisecond(setupdate, auditdate) + 1;
            reportData.set("realprojectperiod", (Object)days);
            long planprojectperiod = reportData.getLong("planprojectperiod");
            long realprojectperiod = (long)days - planprojectperiod;
            reportData.set("projectreach", (Object)realprojectperiod);
        }
        this.calDicisionProject(decision, reportData);
    }

    public void calPurDetailInfo(DynamicObject project, DynamicObject reportData) {
        DynamicObjectCollection bidsection = project.getDynamicObjectCollection("bidsection");
        Iterator bidIterator = bidsection.iterator();
        DynamicObjectCollection reportBidsection = reportData.getDynamicObjectCollection("bidsection");
        BigDecimal totalplanamount = BigDecimal.ZERO;
        BigDecimal totalcontrolamount = BigDecimal.ZERO;
        TreeSet<String> totalSectionName = new TreeSet<String>();
        TreeSet<String> totalPurName = new TreeSet<String>();
        while (bidIterator.hasNext()) {
            DynamicObject bidSectionRow = (DynamicObject)bidIterator.next();
            DynamicObject bidSectionBidRow = reportBidsection.addNew();
            bidSectionBidRow.set("sectionname", bidSectionRow.get("sectionname"));
            totalSectionName.add(bidSectionRow.getString("sectionname"));
            Object planamount = BigDecimal.ZERO;
            BigDecimal controlamount = BigDecimal.ZERO;
            DynamicObjectCollection projectentry = bidSectionRow.getDynamicObjectCollection("projectentry");
            for (DynamicObject supplierEntity : projectentry) {
                DynamicObject reportSupplierRow = bidSectionBidRow.getDynamicObjectCollection("projectentry").addNew();
                reportSupplierRow.set("purentrycontent", supplierEntity.get("purentrycontent"));
                reportSupplierRow.set("purentryproject", supplierEntity.get("purentryproject"));
                if (supplierEntity.get("purentryproject") != null) {
                    DynamicObject p = supplierEntity.getDynamicObject("purentryproject");
                    totalPurName.add(p.getString("fullname"));
                }
                BigDecimal planamount1 = supplierEntity.getBigDecimal("planamount");
                planamount = ((BigDecimal)planamount).add(planamount1);
                reportSupplierRow.set("planamount", (Object)planamount1);
                reportSupplierRow.set("planamountceptvat", supplierEntity.get("nottaxplanamount"));
                reportSupplierRow.set("purentryproject", supplierEntity.get("purentryproject"));
                BigDecimal controlamount1 = supplierEntity.getBigDecimal("controlamount");
                controlamount = controlamount.add(controlamount1);
                reportSupplierRow.set("controlamount", (Object)controlamount1);
                reportSupplierRow.set("ctrlamtexceptvat", supplierEntity.get("ctrlamtexceptvat"));
                this.getPurplan(project, reportSupplierRow, supplierEntity);
            }
            bidSectionBidRow.set("sectplanamount", planamount);
            bidSectionBidRow.set("sectcontrolamount", (Object)controlamount);
            totalplanamount = totalplanamount.add((BigDecimal)planamount);
            totalcontrolamount = totalcontrolamount.add(controlamount);
        }
        if (totalSectionName != null && totalSectionName.size() > 0) {
            boolean enablemultisection = project.getBoolean("enablemultisection");
            if (enablemultisection) {
                StringBuilder builder = new StringBuilder();
                for (String s : totalSectionName) {
                    String value = s + ";";
                    builder.append(value);
                }
                String substring = builder.substring(0, builder.toString().length() - 1);
                if (substring.length() > 255) {
                    reportData.set("totalsectionname", (Object)substring.substring(0, 255));
                } else {
                    reportData.set("totalsectionname", (Object)substring);
                }
                reportData.set("totalsectionname_tag", (Object)substring);
            } else {
                reportData.set("totalsectionname", (Object)"");
            }
        }
        if (totalPurName != null && totalPurName.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String s : totalPurName) {
                String value = s + ";";
                builder.append(value);
            }
            String substring = builder.substring(0, builder.toString().length() - 1);
            if (builder.length() > 255) {
                reportData.set("totalpurentryname", (Object)substring.substring(0, 255));
            } else {
                reportData.set("totalpurentryname", (Object)substring);
            }
            reportData.set("totalpurentryname_tag", (Object)substring);
        }
        reportData.set("toltalplanamount", (Object)totalplanamount);
        reportData.set("toltalcontrolamount", (Object)totalcontrolamount);
    }

    public void getPurplan(DynamicObject project, DynamicObject reportSupplierRow, DynamicObject supplierEntity) {
    }

    public void calDicisionProject(DynamicObject decision, DynamicObject reportData) {
        DynamicObjectCollection bottomsections = decision.getDynamicObjectCollection("bottomsection");
        DynamicObjectCollection bidsections = decision.getDynamicObjectCollection("bidsection");
        BigDecimal toltalfinalprice = BigDecimal.ZERO;
        BigDecimal totalsignamount = BigDecimal.ZERO;
        BigDecimal sectfinalprice = BigDecimal.ZERO;
        BigDecimal sectsignamount = BigDecimal.ZERO;
        HashSet<String> supplierNameBuilder = new HashSet<String>();
        reportData.set("baseprice", decision.get("baseprice"));
        Map<String, DynamicObject> basepriceMapByDecision = this.getBasepriceMapByDecision(bottomsections);
        DynamicObjectCollection bidsection = reportData.getDynamicObjectCollection("bidsection");
        for (DynamicObject next : bidsection) {
            String sectionname = next.getString("sectionname");
            DynamicObject baseSection = basepriceMapByDecision.get(sectionname);
            if (baseSection == null) continue;
            next.set("sfinalauditamount", baseSection.get("totalfinalauditamount"));
        }
        for (DynamicObject bidSectionRow : bidsections) {
            DynamicObject reportSections = reportData.getDynamicObjectCollection("descisection").addNew();
            String sectionname = bidSectionRow.getString("sectionname");
            reportSections.set("desectionname", (Object)sectionname);
            String signstatus = bidSectionRow.getString("signstatus");
            reportSections.set("sectsignstatus", (Object)signstatus);
            sectfinalprice = BigDecimal.ZERO;
            sectsignamount = BigDecimal.ZERO;
            DynamicObjectCollection supplierentry = bidSectionRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject biddeRow : supplierentry) {
                DynamicObject reportEntryRow = reportSections.getDynamicObjectCollection("decistiondetaentry").addNew();
                DynamicObject supplier = biddeRow.getDynamicObject("supplier");
                reportEntryRow.set("supplier", (Object)supplier);
                boolean isrecommended = biddeRow.getBoolean("isrecommended");
                if (!isrecommended) continue;
                reportEntryRow.set("isrecommended", (Object)isrecommended);
                supplierNameBuilder.add(supplier.getString("name"));
                BigDecimal finalprice = biddeRow.getBigDecimal("finalprice");
                sectfinalprice = sectfinalprice.add(finalprice).setScale(2, 4);
                reportEntryRow.set("finalprice", (Object)finalprice);
                if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getAppId()) || !(isrecommended = biddeRow.getBoolean("issign"))) continue;
                reportEntryRow.set("signmenoy", (Object)finalprice);
                sectsignamount = sectsignamount.add(finalprice).setScale(2, 4);
            }
            reportSections.set("sectfinalprice", (Object)sectfinalprice);
            reportSections.set("sectsignmenoy", (Object)sectsignamount);
            toltalfinalprice = toltalfinalprice.add(sectfinalprice).setScale(2, 4);
            totalsignamount = totalsignamount.add(sectsignamount).setScale(2, 4);
        }
        if (supplierNameBuilder != null && supplierNameBuilder.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String s : supplierNameBuilder) {
                String value = s + ";";
                builder.append(value);
            }
            String substring = builder.toString().substring(0, builder.toString().length() - 1);
            reportData.set("totalbidsupplier", (Object)substring);
        }
        reportData.set("toltalfinalprice", (Object)toltalfinalprice);
        reportData.set("totalsignamount", (Object)totalsignamount);
    }

    public Map<String, DynamicObject> getBasepriceMapByDecision(DynamicObjectCollection bottomsections) {
        HashMap<String, DynamicObject> basepriceMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject bidSectionRow : bottomsections) {
            String botsectionname = bidSectionRow.getString("botsectionname");
            basepriceMap.put(botsectionname, bidSectionRow);
        }
        return basepriceMap;
    }

    public void syncMetaByExtend(DynamicObject project, DynamicObject reportData) {
    }

    public QFilter[] getReportDataQFilter(DynamicObject bidProject) {
        QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter entitytypeidQFilter = new QFilter("entitytypeid", "=", (Object)(this.getAppId() + "_report_data"));
        qFilter.and(entitytypeidQFilter);
        return new QFilter[]{qFilter};
    }

    public static long getOpenOrEvalNodeTime(DynamicObject[] dataArray, String bidOpenType, String key) {
        long nodeTime = 0L;
        HashMap<Integer, ArrayList<Object>> dataMap = new HashMap<Integer, ArrayList<Object>>(16);
        if (dataArray != null && dataArray.length > 0) {
            for (DynamicObject data : dataArray) {
                int rounds = data.getInt("rounds");
                ArrayList<Object> roundsList = (ArrayList<Object>)dataMap.get(rounds);
                if (CollectionUtils.isEmpty((Collection)roundsList)) {
                    roundsList = new ArrayList<Object>();
                    roundsList.add(data);
                    dataMap.put(rounds, roundsList);
                    continue;
                }
                roundsList.add(data);
                dataMap.put(rounds, roundsList);
            }
        }
        if (!CollectionUtils.isEmpty(dataMap)) {
            for (Map.Entry entry : dataMap.entrySet()) {
                List dealObj = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)dealObj)) continue;
                DynamicObject[] dealArray = new DynamicObject[dealObj.size()];
                dealObj.toArray(dealArray);
                nodeTime += ReportBidDetailCall.getSeparateOpenNodeTime(dealArray, bidOpenType, key);
            }
        }
        return nodeTime;
    }

    public static long getSeparateOpenNodeTime(DynamicObject[] dealObj, String bidOpenType, String key) {
        long nodeTime = 0L;
        if (dealObj != null && dealObj.length > 0) {
            Date auditTime1;
            Date submitTime;
            Date index1SubmitTime;
            String firstType;
            String lastType;
            boolean dealObjectLengthFLag;
            boolean flag0 = false;
            boolean flag1 = false;
            boolean bl = dealObjectLengthFLag = dealObj.length > 1;
            if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidOpenType)) {
                lastType = BidOpenTypeEnum.BUSSINESS.getValue();
                firstType = BidOpenTypeEnum.TECHNICAL.getValue();
            } else {
                lastType = BidOpenTypeEnum.TECHNICAL.getValue();
                firstType = BidOpenTypeEnum.BUSSINESS.getValue();
            }
            String typeProperties = null;
            if ("kb".equals(key)) {
                typeProperties = "opentype";
            } else if ("pb".equals(key)) {
                typeProperties = "evaltype";
            }
            Date firstCreateTime = null;
            Date firstSubmitTime = null;
            Date firstAuditTime = null;
            for (DynamicObject deal : dealObj) {
                if (!firstType.equals(deal.getString(typeProperties))) continue;
                firstCreateTime = deal.getDate("createtime");
                firstSubmitTime = deal.getDate("submittime");
                firstAuditTime = deal.getDate("auditdate");
            }
            long bzIntervalTime = 0L;
            long spIntervalTime = 0L;
            Date submitTime0 = dealObj[INDEX0].getDate("submittime");
            if (submitTime0 != null) {
                flag0 = true;
            }
            if (dealObjectLengthFLag && (index1SubmitTime = dealObj[INDEX1].getDate("submittime")) != null) {
                flag1 = true;
            }
            DynamicObject currentObj = null;
            if (flag0 && flag1) {
                currentObj = dealObj[INDEX0];
                if (dealObjectLengthFLag && !lastType.equals(currentObj.getString(typeProperties))) {
                    currentObj = dealObj[INDEX1];
                }
            } else if (flag0) {
                currentObj = dealObj[INDEX0];
            } else if (flag1) {
                currentObj = dealObj[INDEX1];
            }
            if (currentObj != null && (submitTime = currentObj.getDate("submittime")) != null && firstCreateTime != null) {
                bzIntervalTime = submitTime.getTime() - firstCreateTime.getTime();
            }
            currentObj = null;
            flag0 = false;
            flag1 = false;
            Date auditTime0 = dealObj[INDEX0].getDate("auditdate");
            if (auditTime0 != null) {
                flag0 = true;
            }
            if (dealObjectLengthFLag && (auditTime1 = dealObj[INDEX1].getDate("auditdate")) != null) {
                flag1 = true;
            }
            if (flag0 && flag1) {
                currentObj = dealObj[INDEX0];
                if (dealObjectLengthFLag && !lastType.equals(currentObj.getString(typeProperties))) {
                    currentObj = dealObj[INDEX1];
                }
            } else if (flag0) {
                currentObj = dealObj[INDEX0];
            } else if (flag1) {
                currentObj = dealObj[INDEX1];
            }
            if (currentObj != null) {
                Date auditTime = currentObj.getDate("auditdate");
                if (auditTime == null) {
                    auditTime = firstAuditTime;
                }
                if (auditTime != null && firstSubmitTime != null) {
                    spIntervalTime = auditTime.getTime() - firstSubmitTime.getTime();
                }
            }
            currentObj = null;
            flag0 = false;
            flag1 = false;
            if ("kb".equals(key)) {
                Date realBidOpenDate;
                Date openDateTime1;
                Date openDateTime0 = dealObj[INDEX0].getDate("realbidopendate");
                if (openDateTime0 != null) {
                    flag0 = true;
                }
                if (dealObjectLengthFLag && (openDateTime1 = dealObj[INDEX1].getDate("realbidopendate")) != null) {
                    flag1 = true;
                }
                if (flag0 && flag1) {
                    currentObj = dealObj[INDEX0];
                    if (dealObjectLengthFLag && !lastType.equals(currentObj.getString(typeProperties))) {
                        currentObj = dealObj[INDEX1];
                    }
                } else if (flag0) {
                    currentObj = dealObj[INDEX0];
                } else if (flag1) {
                    currentObj = dealObj[INDEX1];
                }
                if (currentObj != null && (realBidOpenDate = currentObj.getDate("realbidopendate")) != null && firstCreateTime != null) {
                    nodeTime = realBidOpenDate.getTime() - firstCreateTime.getTime();
                }
            } else {
                nodeTime = spIntervalTime + bzIntervalTime;
            }
        }
        return nodeTime;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public List<Object> getBatchId() {
        return this.batchId;
    }

    public void setBatchId(List<Object> batchId) {
        this.batchId = batchId;
    }

    public long getCurrUserId() {
        return this.currUserId;
    }

    public void setCurrUserId(long currUserId) {
        this.currUserId = currUserId;
    }
}

