/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.bid.business.util.BidUtils;
import kd.scm.bid.common.util.OrgUnitHelper;

public class OrgViewUtils {
    private static final Log log = LogFactory.getLog(OrgViewUtils.class);

    public static List<Long> getAllOrgId(String orgViewType, boolean isAllEnable, boolean isUnFreeze) {
        String selectFields = "org";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        if (isAllEnable) {
            viewFilter = viewFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
            viewFilter = viewFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if (isUnFreeze) {
            viewFilter = viewFilter.and(new QFilter("isfreeze", "=", (Object)Boolean.FALSE));
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"level");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (BidUtils.isListEmpty((List)orgCol)) {
            return orgIds;
        }
        for (DynamicObject org : orgCol) {
            orgIds.add(org.getLong("org"));
        }
        return orgIds;
    }

    public static List<Long> getSubOrgId(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, boolean isIncludeGrand, QFilter otherFilter) {
        if (isIncludeGrand) {
            return OrgViewUtils.getSubOrgIdIncludeGrand(orgViewType, orgIds, isIncludeCurOrg, otherFilter);
        }
        return OrgViewUtils.getSubOrgId(orgViewType, orgIds, isIncludeCurOrg, otherFilter);
    }

    public static List<Long> getSubOrgId(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (BidUtils.isListEmpty(orgIds)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        QFilter parentFilter = new QFilter("parent", "in", orgIds);
        if (otherFilter != null) {
            parentFilter = parentFilter.and(otherFilter);
        }
        OrgViewUtils.queryOrgId(subOrgList, orgViewType, parentFilter);
        if (isIncludeCurOrg) {
            subOrgList.addAll(orgIds);
        }
        return subOrgList;
    }

    private static void queryOrgId(List<Long> subOrgList, String orgViewType, QFilter filter) {
        QFilter[] filters;
        DynamicObjectCollection orgCol;
        String selectFields = "org";
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter == null ? OrgViewUtils.getOrgViewFilter(orgViewType) : filter.and(OrgViewUtils.getOrgViewFilter(orgViewType));
        }
        if (BidUtils.isListNotEmpty((List)(orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])(filters = new QFilter[]{filter}), (String)"level")))) {
            for (DynamicObject org : orgCol) {
                subOrgList.add(org.getLong("org"));
            }
        }
    }

    public static List<Long> getSubOrgIdIncludeGrand(String orgViewType, List<Long> orgIds, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (BidUtils.isListEmpty(orgIds)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        return OrgViewUtils.getSubOrgIdByLongNumber(orgViewType, OrgViewUtils.getOrgLongNumberById(orgViewType, orgIds), isIncludeCurOrg, otherFilter);
    }

    private static List<String> getOrgLongNumberById(String orgViewType, List<Long> orgIds) {
        String selectFields = "longnumber";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            orgFilter.and(OrgViewUtils.getOrgViewFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        ArrayList<String> longNumberList = new ArrayList<String>();
        if (BidUtils.isListEmpty((List)orgCol)) {
            return longNumberList;
        }
        ArrayList<String> tempLongNumberList = new ArrayList<String>();
        for (DynamicObject org : orgCol) {
            String longNumber = org.getString("longnumber");
            if (!StringUtils.isNotBlank((CharSequence)longNumber)) continue;
            longNumberList.add(longNumber);
            tempLongNumberList.add(longNumber);
        }
        ArrayList duplicateList = new ArrayList();
        for (String longNumber : longNumberList) {
            for (String tempLongNumber : tempLongNumberList) {
                if (!longNumber.startsWith(tempLongNumber + "!")) continue;
                ((List)duplicateList).add(longNumber);
            }
        }
        longNumberList.removeAll(duplicateList);
        return longNumberList;
    }

    public static List<Long> getSubOrgIdByLongNumber(String orgViewType, List<String> longNumberList, boolean isIncludeCurOrg, QFilter otherFilter) {
        ArrayList<Long> subOrgList = new ArrayList<Long>();
        if (BidUtils.isListEmpty(longNumberList)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u957f\u7f16\u7801\u53c2\u6570\u4e3a\u7a7a");
            return subOrgList;
        }
        QFilter filter = OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
        if (otherFilter != null) {
            filter = filter == null ? otherFilter : filter.and(otherFilter);
        }
        OrgViewUtils.queryOrgId(subOrgList, orgViewType, filter);
        return subOrgList;
    }

    public static QFilter genSoleLongNumberFilter(List<String> longNumberList, boolean isIncludeCurOrg) {
        if (BidUtils.isListEmpty(longNumberList)) {
            return null;
        }
        ArrayList<String> tempLongNumberList = new ArrayList<String>();
        tempLongNumberList.addAll(longNumberList);
        ArrayList<String> duplicateList = new ArrayList<String>();
        for (String longNumber : longNumberList) {
            for (String tempLongNumber : tempLongNumberList) {
                if (!longNumber.startsWith(tempLongNumber + "!")) continue;
                duplicateList.add(longNumber);
            }
        }
        longNumberList.removeAll(duplicateList);
        return OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
    }

    public static QFilter genLongNumberFilter(List<String> longNumberList, boolean isIncludeCurOrg) {
        QFilter filter = null;
        if (BidUtils.isListEmpty(longNumberList)) {
            return filter;
        }
        QFilter curFilter = null;
        boolean isFirst = true;
        for (String longNumber : longNumberList) {
            String longNumberFilter = longNumber + "!%";
            if (isFirst) {
                isFirst = false;
                filter = new QFilter("longnumber", "like", (Object)longNumberFilter);
                curFilter = new QFilter("longnumber", "=", (Object)longNumber);
                continue;
            }
            filter = filter != null ? filter.or(new QFilter("longnumber", "like", (Object)longNumberFilter)) : new QFilter("longnumber", "like", (Object)longNumberFilter);
            if (curFilter != null) {
                curFilter = curFilter.or(new QFilter("longnumber", "=", (Object)longNumber));
                continue;
            }
            curFilter = new QFilter("longnumber", "=", (Object)longNumber);
        }
        if (isIncludeCurOrg) {
            filter = filter == null ? curFilter : filter.or(curFilter);
        }
        return filter;
    }

    public static DynamicObject[] getSubOrg(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg, boolean isIncludeGrand) {
        if (isIncludeGrand) {
            return OrgViewUtils.getSubOrgIncludeGrand(orgViewType, orgIds, selectProperties, orderBy, isIncludeCurOrg);
        }
        return OrgViewUtils.getSubOrg(orgViewType, orgIds, selectProperties, orderBy, isIncludeCurOrg);
    }

    public static DynamicObject[] getSubOrg(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        DynamicObject[] orgArr;
        if (BidUtils.isListEmpty(orgIds)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("parent", "in", orgIds);
        if (isIncludeCurOrg) {
            filter = filter.or(new QFilter("org", "in", orgIds));
        }
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter.and(OrgViewUtils.getOrgViewFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{filter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = "level";
        }
        if ((orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters, (String)orderBy)) == null) {
            return new DynamicObject[0];
        }
        return orgArr;
    }

    public static DynamicObject[] getSubOrgIncludeGrand(String orgViewType, List<Long> orgIds, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        if (BidUtils.isListEmpty(orgIds)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        return OrgViewUtils.getSubOrgByLongNumber(orgViewType, OrgViewUtils.getOrgLongNumberById(orgViewType, orgIds), selectProperties, orderBy, isIncludeCurOrg);
    }

    public static DynamicObject[] getSubOrgByLongNumber(String orgViewType, List<String> longNumberList, String selectProperties, String orderBy, boolean isIncludeCurOrg) {
        DynamicObject[] subOrgArr;
        if (BidUtils.isListEmpty(longNumberList)) {
            log.warn("\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u7684ID\u53c2\u6570\u4e3a\u7a7a");
            return new DynamicObject[0];
        }
        QFilter filter = OrgViewUtils.genLongNumberFilter(longNumberList, isIncludeCurOrg);
        if (StringUtils.isNotBlank((CharSequence)orgViewType)) {
            filter = filter == null ? OrgViewUtils.getOrgViewFilter(orgViewType) : filter.and(OrgViewUtils.getOrgViewFilter(orgViewType));
        }
        QFilter[] filters = new QFilter[]{filter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = "level";
        }
        if ((subOrgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters, (String)orderBy)) == null) {
            return new DynamicObject[0];
        }
        return subOrgArr;
    }

    public static Map<Long, String> getOrgYzjFullname(List<Long> orgIds) {
        if (BidUtils.isListEmpty(orgIds)) {
            return new HashMap<Long, String>(0);
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("01");
        QFilter orgFilter = new QFilter("org", "=", (Object)OrgUnitHelper.getRootOrgId());
        String selectProperties = "id,org,fullname";
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter = orgFilter.or(new QFilter("org", "in", orgIds))};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters, (String)"longnumber");
        if (BidUtils.isListEmpty((List)orgCol)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> fullNameMap = new HashMap<Long, String>();
        if (orgCol.size() == 1) {
            fullNameMap.put(OrgUnitHelper.getRootOrgId(), "\\");
            return fullNameMap;
        }
        String rootFullname = "";
        for (DynamicObject org : orgCol) {
            Long curOrgId = org.getLong("org");
            String fullName = org.getString("fullname");
            if (curOrgId == OrgUnitHelper.getRootOrgId()) {
                rootFullname = fullName;
                if (!orgIds.contains(curOrgId)) continue;
                fullNameMap.put(curOrgId, "\\");
                continue;
            }
            String orgFullname = "";
            orgFullname = (fullName = fullName.replaceFirst(rootFullname + "_", "")).indexOf(95) > 0 ? fullName.replace('_', '\\') : fullName;
            fullNameMap.put(curOrgId, orgFullname);
        }
        return fullNameMap;
    }

    public static Map<Long, String> getOrgYzjId(List<Long> orgIds) {
        if (BidUtils.isListEmpty(orgIds)) {
            return new HashMap<Long, String>(0);
        }
        QFilter viewFilter = OrgUnitServiceHelper.getBizOrgFilter((String)"01");
        QFilter orgFilter = new QFilter("id", "in", orgIds);
        String selectProperties = "id,fyzjorgid";
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)selectProperties, (QFilter[])filters);
        if (BidUtils.isListEmpty((List)orgCol)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> yzjorgIdMap = new HashMap<Long, String>();
        for (DynamicObject org : orgCol) {
            yzjorgIdMap.put(org.getLong("id"), org.getString("fyzjorgid"));
        }
        return yzjorgIdMap;
    }

    public static void updateParentIsLeaf(List<Long> orgIds) {
        String selectFields = "id,parent";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject[] orgList = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (orgList == null || orgList.length == 0) {
            return;
        }
        int parentCount = orgList.length;
        ArrayList<Long> parentIdList = new ArrayList<Long>(parentCount);
        for (DynamicObject org : orgList) {
            DynamicObject parentOrg = org.getDynamicObject("parent");
            if (parentOrg == null) continue;
            parentIdList.add(parentOrg.getLong("id"));
        }
        OrgViewUtils.updateParentIsLeaf(parentIdList, orgIds, false);
    }

    public static void updateParentIsLeaf(List<Long> parentIds, List<Long> orgIds, boolean isIncludeCurOrg) {
        QFilter[] filters;
        String selectFields;
        DynamicObject[] allSubOrgList;
        if (parentIds == null || parentIds.size() == 0) {
            return;
        }
        if (orgIds == null || orgIds.size() == 0) {
            return;
        }
        QFilter parentFilter = new QFilter("parent", "in", parentIds);
        if (!isIncludeCurOrg) {
            QFilter curOrgFilter = new QFilter("org", "not in", orgIds);
            parentFilter.and(curOrgFilter);
        }
        if ((allSubOrgList = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)(selectFields = "id,parent"), (QFilter[])(filters = new QFilter[]{parentFilter}))) != null && allSubOrgList.length > 0) {
            for (DynamicObject org : allSubOrgList) {
                DynamicObject parentOrg = org.getDynamicObject("parent");
                if (parentOrg == null) continue;
                parentIds.remove(parentOrg.getLong("id"));
                if (parentIds.size() != 0) continue;
                return;
            }
        }
        OrgViewUtils.doUpdateParentIsLeaf(parentIds, true);
    }

    public static void doUpdateParentIsLeaf(List<Long> parentIds, boolean isLeaf) {
        if (BidUtils.isListEmpty(parentIds)) {
            return;
        }
        String selectFields = "id,org,isleaf";
        QFilter updateParentFilter = new QFilter("org", "in", parentIds);
        QFilter[] filters = new QFilter[]{updateParentFilter};
        DynamicObject[] updateOrgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (updateOrgArr == null || updateOrgArr.length == 0) {
            return;
        }
        for (DynamicObject updateOrg : updateOrgArr) {
            updateOrg.set("isleaf", (Object)isLeaf);
        }
        SaveServiceHelper.save((DynamicObject[])updateOrgArr);
    }

    private static DynamicObject[] queryAllFreezeOrg(List<Long> orgIdList) {
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("01");
        QFilter isFreezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        isFreezeFilter.or(QFilter.isNull((String)"isfreeze"));
        QFilter[] filters = new QFilter[]{orgFilter, viewFilter, isFreezeFilter};
        String selectFields = "id,org,isfreeze,sealuptime";
        DynamicObject[] orgStructureArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        return orgStructureArr;
    }

    private static void deleteYzjInfoOfOrg(List<Long> orgIdList) {
        String selectFields = "id,fyzjorgid,fyzjimorted,fisadministrative";
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (orgArr == null || orgArr.length == 0) {
            return;
        }
        for (DynamicObject org : orgArr) {
            org.set("fyzjorgid", (Object)"");
            org.set("fyzjimorted", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
    }

    private static boolean deleteUserPosition(List<Long> orgIdList) {
        String selectProperties = "id,entryentity,entryentity.dpt";
        QFilter orgFilter = new QFilter("entryentity.dpt", "in", orgIdList);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)selectProperties, (QFilter[])filters);
        if (userArr == null || userArr.length == 0) {
            return true;
        }
        for (DynamicObject user : userArr) {
            DynamicObjectCollection entityCol = user.getDynamicObjectCollection("entryentity");
            if (BidUtils.isListEmpty((List)entityCol)) continue;
            Iterator entityItr = entityCol.iterator();
            while (entityItr.hasNext()) {
                DynamicObject entity = (DynamicObject)entityItr.next();
                DynamicObject org = entity.getDynamicObject("dpt");
                if (org == null || !orgIdList.contains(org.getLong("id"))) continue;
                entityItr.remove();
            }
        }
        SaveServiceHelper.save((DynamicObject[])userArr);
        return true;
    }

    public static void updateOrgName(List<Long> orgIds, Map<Long, String> newNameMap) {
        if (BidUtils.isListEmpty(orgIds)) {
            log.error("\u7ec4\u7ec7ID\u7684\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        if (newNameMap == null || newNameMap.size() == 0) {
            log.error("\u7ec4\u7ec7\u540d\u79f0\u96c6\u5408\u7684\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        String selectProperties = "id,name";
        QFilter idFilter = new QFilter("id", "in", orgIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] orgNameArr = BusinessDataServiceHelper.load((String)"bos_org", (String)selectProperties, (QFilter[])filters);
        if (orgNameArr != null && orgNameArr.length > 0) {
            for (DynamicObject org : orgNameArr) {
                String orgName = newNameMap.get(org.getLong("id"));
                if (!StringUtils.isNotBlank((CharSequence)orgName)) continue;
                org.set("name", (Object)orgName);
            }
            SaveServiceHelper.save((DynamicObject[])orgNameArr);
        }
        OrgViewUtils.updateOrgFullName(orgIds, newNameMap);
    }

    public static void updateOrgFullName(List<Long> orgIds, Map<Long, String> newNameMap) {
        if (BidUtils.isListEmpty(orgIds)) {
            log.error("\u7ec4\u7ec7ID\u7684\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        if (newNameMap == null || newNameMap.size() == 0) {
            log.error("\u7ec4\u7ec7\u540d\u79f0\u96c6\u5408\u7684\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        String selectProperties = "id,view,org,parent,name,fullname";
        DynamicObject[] orgArr = OrgViewUtils.getSubOrg(null, orgIds, selectProperties, null, true, true);
        if (orgArr == null || orgArr.length == 0) {
            return;
        }
        HashMap parentFullNameMap = new HashMap();
        for (DynamicObject orgObj : orgArr) {
            DynamicObject view = orgObj.getDynamicObject("view");
            if (view == null) continue;
            long viewType = view.getLong("id");
            HashMap<Long, String> fullNameMap = null;
            HashMap<Long, String> value = (HashMap<Long, String>)parentFullNameMap.get(viewType);
            if (!CollectionUtils.isEmpty((Map)value)) {
                fullNameMap = value;
            } else {
                fullNameMap = new HashMap<Long, String>(1);
                parentFullNameMap.put(viewType, fullNameMap);
            }
            DynamicObject org = orgObj.getDynamicObject("org");
            if (org == null) continue;
            long orgId = org.getLong("id");
            String fullName = orgObj.getString("fullname");
            DynamicObject parent = orgObj.getDynamicObject("parent");
            if (parent != null) {
                String name = "";
                boolean isNewName = false;
                String newName = newNameMap.get(orgId);
                if (StringUtils.isNotBlank((CharSequence)newName)) {
                    isNewName = true;
                    name = newName;
                } else {
                    name = org.getString("name");
                }
                long parentId = parent.getLong("id");
                String value2 = (String)fullNameMap.get(parentId);
                if (!StringUtils.isEmpty((CharSequence)value2)) {
                    String parentFullName = value2;
                    fullName = parentFullName + "_" + name;
                } else if (isNewName) {
                    String curFullName = orgObj.getString("fullname");
                    if (StringUtils.isNotBlank((CharSequence)curFullName)) {
                        int curNameIndex = curFullName.lastIndexOf(95);
                        if (curNameIndex == -1) {
                            fullName = name;
                        } else {
                            String parentFullName = curFullName.substring(0, curNameIndex);
                            fullName = parentFullName + "_" + name;
                        }
                    }
                } else {
                    fullName = orgObj.getString("fullname");
                }
                orgObj.set("name", (Object)name);
                orgObj.set("fullname", (Object)fullName);
            }
            fullNameMap.put(orgId, fullName);
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
    }

    public static void updateAdminOrgStructure(List<Long> orgIds, Map<Long, DynamicObject> newParentMap) {
        ArrayList<Long> oldParentIds = new ArrayList<Long>(orgIds.size());
        oldParentIds.addAll(orgIds);
        ArrayList<DynamicObject> subOrgList = new ArrayList<DynamicObject>();
        OrgViewUtils.querySubAdminOrgList(subOrgList, orgIds, newParentMap);
        int count = subOrgList.size();
        if (count > 0) {
            SaveServiceHelper.save((DynamicObject[])subOrgList.toArray(new DynamicObject[count]));
            OrgViewUtils.doUpdateParentIsLeaf(oldParentIds, false);
        }
    }

    private static void querySubAdminOrgList(List<DynamicObject> subOrgList, List<Long> orgIds, Map<Long, DynamicObject> newParentMap) {
        QFilter parentFilter;
        if (BidUtils.isListEmpty(orgIds)) {
            return;
        }
        String selectFields = "id,org,parent,yzjorgid,yzjparentorgid,longnumber,fullname,level,isleaf";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("01");
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter = new QFilter("parent", "in", orgIds)};
        DynamicObject[] orgCol = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (orgCol == null || orgCol.length == 0) {
            return;
        }
        ArrayList<Long> parentIds = new ArrayList<Long>(orgCol.length);
        for (DynamicObject subOrg : orgCol) {
            long orgId;
            DynamicObject org = subOrg.getDynamicObject("org");
            if (org == null || newParentMap.containsKey(orgId = org.getLong("id"))) continue;
            DynamicObject parentOrg = null;
            DynamicObject parent = subOrg.getDynamicObject("parent");
            if (parent != null) {
                parentOrg = newParentMap.get(parent.getLong("id"));
            }
            OrgViewUtils.generateNewOrgStructure(subOrg, parentOrg, org);
            subOrgList.add(subOrg);
            parentIds.add(orgId);
            newParentMap.put(orgId, subOrg);
        }
        OrgViewUtils.querySubAdminOrgList(subOrgList, parentIds, newParentMap);
    }

    public static void generateNewOrgStructure(DynamicObject saveOrg, DynamicObject parentOrg, DynamicObject org) {
        String name = org.getString("name");
        saveOrg.set("name", (Object)name);
        if (parentOrg == null) {
            saveOrg.set("parent", (Object)0);
            saveOrg.set("yzjparentorgid", (Object)"");
            saveOrg.set("longnumber", (Object)saveOrg.getString("number"));
            saveOrg.set("fullname", (Object)saveOrg.getString("fullname"));
            saveOrg.set("level", (Object)1);
            saveOrg.set("isleaf", (Object)Boolean.FALSE);
        } else {
            saveOrg.set("parent", (Object)parentOrg.getDynamicObject("org"));
            saveOrg.set("yzjparentorgid", (Object)parentOrg.getString("yzjorgid"));
            saveOrg.set("longnumber", (Object)(parentOrg.getString("longnumber") + "!" + org.getString("number")));
            saveOrg.set("fullname", (Object)(parentOrg.getString("fullname") + "_" + name));
            saveOrg.set("level", (Object)(parentOrg.getInt("level") + 1));
            parentOrg.set("isleaf", (Object)Boolean.FALSE);
            saveOrg.set("isleaf", (Object)Boolean.TRUE);
        }
    }

    public static QFilter getOrgViewFilter(String orgViewType) {
        QFilter filter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("view.treetype", "=", (Object)orgViewType));
        return filter;
    }

    public static String getRootOrgFullName() {
        QFilter orgFilter = new QFilter("id", "=", (Object)OrgUnitHelper.getRootOrgId());
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,name", (QFilter[])filters);
        if (org == null) {
            return OrgViewUtils.getRootOrgFullNameByParentId();
        }
        return org.getString("name");
    }

    public static String getRootOrgFullNameByParentId() {
        QFilter orgFilter = new QFilter("parent", "=", (Object)0);
        orgFilter.or(QFilter.isNull((String)"parent"));
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,fullname", (QFilter[])filters);
        if (org == null) {
            return "";
        }
        return org.getString("fullname");
    }

    public static int getOrgSortCode(int level, int sort) {
        int sortCode = level * 1000000 + sort;
        return sortCode;
    }

    public static void genCommonField(DynamicObject obj, boolean isHasCreator) {
        if (obj == null) {
            return;
        }
        if (isHasCreator) {
            String userId = RequestContext.get().getUserId();
            obj.set("creator", (Object)userId);
            obj.set("modifier", (Object)userId);
        }
        Date dateTime = new Date();
        obj.set("createtime", (Object)dateTime);
        obj.set("enable", (Object)1);
        obj.set("status", (Object)"C");
        obj.set("modifytime", (Object)dateTime);
    }

    public static DynamicObject getOrgBiz(String orgViewType) {
        String selectFields = "id,fnumber,fname,ffieldname,propertyname,fuserdefine,isbasetype";
        QFilter defaultFilter = new QFilter("isbasetype", "=", (Object)Boolean.TRUE);
        QFilter viewFilter = new QFilter("fnumber", "=", (Object)orgViewType);
        QFilter[] filters = new QFilter[]{defaultFilter, viewFilter};
        DynamicObject orgBiz = QueryServiceHelper.queryOne((String)"bos_org_biz", (String)selectFields, (QFilter[])filters);
        return orgBiz;
    }

    public static String getOrgBizProName(String orgViewType) {
        DynamicObject orgBiz = OrgViewUtils.getOrgBiz(orgViewType);
        if (orgBiz == null) {
            return "";
        }
        return orgBiz.getString("propertyname");
    }

    public static void updateViewParent(String orgViewType) {
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            return;
        }
        String viewProName = OrgViewUtils.getOrgBizProName(orgViewType);
        LinkedHashMap<Long, DynamicObject> viewMap = new LinkedHashMap<Long, DynamicObject>();
        OrgViewUtils.getOrgLevelMap(orgViewType, viewProName, viewMap);
        if (viewMap.size() == 0) {
            return;
        }
        LinkedHashMap<Long, DynamicObject> orgUnitMap = new LinkedHashMap<Long, DynamicObject>();
        OrgViewUtils.getOrgLevelMap("15", viewProName, orgUnitMap);
        if (orgUnitMap.size() == 0) {
            return;
        }
        int viewCount = viewMap.size();
        ArrayList<DynamicObject> orgList = new ArrayList<DynamicObject>(viewCount);
        for (Map.Entry entry : viewMap.entrySet()) {
            long parentId;
            DynamicObject org = (DynamicObject)entry.getValue();
            orgList.add(org);
            DynamicObject parent = org.getDynamicObject("parent");
            if (parent == null || (parentId = parent.getLong("id")) == 0L) continue;
            OrgViewUtils.genOrgViewParent(viewProName, parentId, orgUnitMap, viewMap, org);
        }
        SaveServiceHelper.save((DynamicObject[])orgList.toArray(new DynamicObject[viewCount]));
    }

    private static void getOrgLevelMap(String orgViewType, String viewProName, Map<Long, DynamicObject> viewMap) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("id,org,parent,yzjorgid,yzjparentorgid,level,longnumber,fullname,isleaf");
        if (StringUtils.isNotBlank((CharSequence)viewProName)) {
            selectFields.append(',');
            selectFields.append(viewProName);
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields.toString(), (QFilter[])filters, (String)"longnumber");
        if (orgArr == null || orgArr.length == 0) {
            return;
        }
        for (DynamicObject orgObj : orgArr) {
            DynamicObject org = orgObj.getDynamicObject("org");
            if (org == null) continue;
            long orgId = org.getLong("id");
            viewMap.put(orgId, orgObj);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void genOrgViewParent(String viewProName, long parentId, Map<Long, DynamicObject> orgUnitMap, Map<Long, DynamicObject> viewMap, DynamicObject org) {
        if (parentId == 0L) {
            DynamicObject rootOrg = viewMap.get(OrgUnitHelper.getRootOrgId());
            if (rootOrg == null) {
                OrgViewUtils.genOrgViewNewParent(OrgUnitHelper.getRootOrgId(), rootOrg, org);
                return;
            }
            OrgViewUtils.genOrgViewNewParent(parentId, rootOrg, org);
            return;
        }
        DynamicObject levelOrg = orgUnitMap.get(parentId);
        if (levelOrg == null) {
            return;
        }
        DynamicObject orgUnit = levelOrg.getDynamicObject("org");
        boolean isSelectedView = orgUnit.getBoolean(viewProName);
        if (!isSelectedView) {
            DynamicObject levelParent = levelOrg.getDynamicObject("parent");
            OrgViewUtils.genOrgViewParent(viewProName, levelParent.getLong("id"), orgUnitMap, viewMap, org);
            return;
        }
        DynamicObject parent = viewMap.get(parentId);
        if (parent == null) {
            DynamicObject levelParent = levelOrg.getDynamicObject("parent");
            OrgViewUtils.genOrgViewParent(viewProName, levelParent.getLong("id"), orgUnitMap, viewMap, org);
            return;
        }
        OrgViewUtils.genOrgViewNewParent(parentId, parent, org);
    }

    private static void genOrgViewNewParent(long parentId, DynamicObject parentObj, DynamicObject orgObj) {
        DynamicObject org = orgObj.getDynamicObject("org");
        orgObj.set("isleaf", (Object)Boolean.TRUE);
        orgObj.set("parent", (Object)parentId);
        if (parentObj != null) {
            parentObj.set("isleaf", (Object)Boolean.FALSE);
            orgObj.set("yzjparentorgid", parentObj.get("yzjorgid"));
            orgObj.set("level", (Object)(parentObj.getInt("level") + 1));
            orgObj.set("longnumber", (Object)(parentObj.getString("longnumber") + "!" + org.getString("number")));
            orgObj.set("fullname", (Object)(parentObj.getString("fullname") + "_" + org.getString("name")));
        }
    }

    public static boolean isOrgNameValid(IFormView view, String str) {
        String msg = OrgViewUtils.isOrgNameValid(str);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            view.showErrorNotification(msg + "\u3002");
            return false;
        }
        return true;
    }

    public static String isOrgNameValid(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrgViewUtils_4", (String)"scm-bid-business", (Object[])new Object[0]);
        }
        String tempStr = str.toLowerCase(Locale.getDefault());
        if ("null".equals(tempStr)) {
            return String.format(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u540d\u79f0\u201d\u4e0d\u80fd\u662f%s", (String)"OrgViewUtils_5", (String)"scm-bid-business", (Object[])new Object[0]), str);
        }
        if (str.indexOf(95) > 0) {
            return String.format(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u540d\u79f0\u201d\u4e0d\u80fd\u5305\u542b\"%s\"\u5b57\u7b26", (String)"OrgViewUtils_6", (String)"scm-bid-business", (Object[])new Object[0]), "_");
        }
        if (str.indexOf(92) > 0) {
            return String.format(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u540d\u79f0\u201d\u4e0d\u80fd\u5305\u542b\"%s\"\u5b57\u7b26", (String)"OrgViewUtils_6", (String)"scm-bid-business", (Object[])new Object[0]), "\\");
        }
        return "";
    }
}

