/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.mservice.BidBackBidUpdateService;

public class BidBackBidUpdateServiceImpl
implements BidBackBidUpdateService,
IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        try {
            this.updateOpenRounds();
            this.updateBidProjectName();
            BizLog.log((String)"BidBackBidUpdateServiceImpl \uff1asuccess\uff01");
            upgradeResult.setSuccess(true);
        }
        catch (Exception e) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                BizLog.log((String)(stackTrace[0].getClassName() + stackTrace[0].getMethodName() + stackTrace[0].getLineNumber()));
            }
            BizLog.log((String)e.getMessage());
        }
        return upgradeResult;
    }

    public void updateOpenRounds() {
        DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"rounds,listrounds,bidproject,opentype", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L), new QFilter("billstatus", "!=", (Object)"XX")});
        if (bidOpens == null || bidOpens.length == 0) {
            return;
        }
        String sql = "select fbidprojectid,fopentype from t_bid_bidopen where fbillstatus = ?";
        Map openHistoryMap = (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)sql, (Object[])new Object[]{"XX"}, rs -> {
            HashMap<String, Integer> innerMap = new HashMap<String, Integer>(16);
            long bidprojectid = rs.getLong("fbidprojectid");
            String openType = rs.getString("fopentype");
            Integer rounds = innerMap.getOrDefault(bidprojectid + openType, 1);
            rounds = rounds + 1;
            innerMap.put(bidprojectid + openType, rounds);
            return innerMap;
        });
        for (DynamicObject bidOpen : bidOpens) {
            String k = this.getKey(bidOpen);
            Integer rounds = (Integer)openHistoryMap.get(k);
            if (rounds == null) {
                bidOpen.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidBackBidUpdateServiceImpl_0", (String)"scm-bid-mservice", (Object[])new Object[0]), BidOpenServiceImpl.toChinese((String)"1")));
                continue;
            }
            bidOpen.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidBackBidUpdateServiceImpl_0", (String)"scm-bid-mservice", (Object[])new Object[0]), BidOpenServiceImpl.toChinese((String)String.valueOf(rounds))));
        }
        SaveServiceHelper.save((DynamicObject[])bidOpens);
    }

    protected void updateBidProjectName() {
        this.updateName("t_bid_bidopen");
        this.updateName("t_bid_bidevaluation");
        this.updateName("t_bid_onlinebideval");
    }

    public void updateName(String tableName) {
        String sql = "select t1.fid as id,t2.fname as bidprojectname from " + tableName + " t1 left join t_bid_project_l t2 on t1.fbidprojectid = t2.fid and t2.flocaleid = 'zh_CN'";
        Map reMap = (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)sql, rs -> {
            HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
            while (rs.next()) {
                long id = rs.getLong("id");
                String bidprojectname = rs.getString("bidprojectname");
                if (bidprojectname == null) continue;
                resultMap.put(id, bidprojectname);
            }
            return resultMap;
        });
        if (reMap == null || reMap.isEmpty()) {
            return;
        }
        String insertSql = "insert into " + tableName + "_l(fpkid,fid,flocaleid,fbidprojectname)values(?,?,'zh_CN',?)";
        ArrayList paramList = new ArrayList();
        ArrayList uParamList = new ArrayList();
        reMap.forEach((key, value) -> {
            String pkid = Uuid16.create().toString();
            paramList.add(new Object[]{pkid, key, value});
            uParamList.add(new Object[]{value, key});
        });
        if (paramList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)insertSql, paramList);
        }
        if (uParamList.size() > 0) {
            String updateSql = "update " + tableName + " set fbidprojectname = ? where fid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, uParamList);
        }
    }

    protected String getKey(DynamicObject bidOpen) {
        DynamicObject bidproject = bidOpen.getDynamicObject("bidproject");
        if (bidproject == null) {
            return null;
        }
        String opentype = bidOpen.getString("opentype");
        if (opentype == null) {
            return null;
        }
        return bidproject.getPkValue() + opentype;
    }
}

