/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.BizLog;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.scm.bid.mservice.BidInvitationOrgUpdateService;

public class BidInvitationOrgUpdateServiceImpl
implements BidInvitationOrgUpdateService,
IUpgradeService {
    private static final String QUERY_SQL = "select a.fid, b.forgid from t_bid_invitation a left join t_bid_project b on a.fbidprojectid = b.fid ";
    private static final String UPDATE_SQL = "update t_bid_invitation set forgid = ? where fid= ? ";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            long start = System.currentTimeMillis();
            BizLog.log((String)"start invitation Upgrade  ");
            HashMap ret = new HashMap(16);
            Map invitationMap = (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)QUERY_SQL, (Object[])new Object[0], rs -> {
                while (rs.next()) {
                    ret.put(rs.getLong(1), rs.getLong(2));
                }
                return ret;
            });
            if (CollectionUtils.isEmpty((Map)invitationMap)) {
                result.setLog("invitation data not exist");
                result.setSuccess(true);
                return result;
            }
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
            for (Map.Entry invitationData : invitationMap.entrySet()) {
                if (invitationData.getValue() == null) continue;
                Object[] paramArr = new Object[]{invitationData.getValue(), invitationData.getKey()};
                paramsList.add(paramArr);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)UPDATE_SQL, paramsList);
            long time = System.currentTimeMillis() - start;
            BizLog.log((String)("end hao shi ms: " + time));
            result.setLog("success");
            result.setSuccess(true);
            BizLog.log((String)"success\uff01");
            return result;
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
            return result;
        }
    }
}

