/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.mservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.mservice.IBidOpenRoundsUpdateService;

public class BidOpenRoundsUpdateServiceImpl
extends AbstractTask
implements IBidOpenRoundsUpdateService {
    protected void updateOpenRounds() {
        DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"rounds,listrounds,bidproject,opentype", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L), new QFilter("billstatus", "!=", (Object)"XX")});
        if (bidOpens == null || bidOpens.length == 0) {
            return;
        }
        String sql = "select fbidprojectid,fopentype from t_bid_bidopen where fbillstatus = ?";
        Map openHistoryMap = (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)sql, (Object[])new Object[]{"XX"}, rs -> {
            HashMap<String, Integer> innerMap = new HashMap<String, Integer>(16);
            long bidprojectid = rs.getLong("fbidprojectid");
            String openType = rs.getString("fopentype");
            Integer rounds = innerMap.getOrDefault(bidprojectid + openType, 1);
            rounds = rounds + 1;
            innerMap.put(bidprojectid + openType, rounds);
            return innerMap;
        });
        for (DynamicObject bidOpen : bidOpens) {
            String k = this.getKey(bidOpen);
            Integer rounds = (Integer)openHistoryMap.get(k);
            if (rounds == null) {
                bidOpen.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidBackBidUpdateServiceImpl_0", (String)"scm-bid-mservice", (Object[])new Object[0]), BidOpenServiceImpl.toChinese((String)"1")));
                continue;
            }
            bidOpen.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidBackBidUpdateServiceImpl_0", (String)"scm-bid-mservice", (Object[])new Object[0]), BidOpenServiceImpl.toChinese((String)String.valueOf(rounds))));
        }
        SaveServiceHelper.save((DynamicObject[])bidOpens);
    }

    protected String getKey(DynamicObject bidOpen) {
        DynamicObject bidproject = bidOpen.getDynamicObject("bidproject");
        if (bidproject == null) {
            return null;
        }
        String opentype = bidOpen.getString("opentype");
        if (opentype == null) {
            return null;
        }
        return bidproject.getPkValue() + opentype;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            this.updateOpenRounds();
            BizLog.log((String)"BidBackBidUpdateServiceImpl \uff1asuccess\uff01");
        }
        catch (Exception e) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                BizLog.log((String)(stackTrace[0].getClassName() + stackTrace[0].getMethodName() + stackTrace[0].getLineNumber()));
            }
            BizLog.log((String)e.getMessage());
        }
    }
}

