/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.scm.bid.business.basedata.IBidModeService;
import kd.scm.bid.business.basedata.serviceImpl.BidModeServiceImpl;
import kd.scm.bid.common.constant.BidCommonConstant;

public class BidModeEdit
extends AbstractBillPlugIn {
    protected IBidModeService bidModeService = new BidModeServiceImpl();

    public List<Long> getPreDataId() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(445449820128189440L);
        list.add(445450193379302400L);
        return list;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List<Long> list = this.getPreDataId();
        Long id = (Long)this.getModel().getValue("id");
        boolean isPre = false;
        for (Long now : list) {
            if (id.longValue() != now.longValue()) continue;
            isPre = true;
            break;
        }
        if (isPre) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)operationStatus)) {
            String bidModeId = ((BillShowParameter)formShowParameter).getPkId().toString();
            String selectFields = "id, enable";
            DynamicObject bidMode = this.bidModeService.getBidMode(Long.valueOf(bidModeId), selectFields);
            boolean enable = bidMode.getBoolean("enable");
            if (enable) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "save": {
                this.setBidModeSteps();
            }
        }
    }

    private void setBidModeSteps() {
        IDataModel dataModel = this.getModel();
        if (((Boolean)dataModel.getValue("isbid")).booleanValue()) {
            Boolean isNeedSupplierInvitation = (Boolean)dataModel.getValue("supplierinvitation");
            Boolean isNeedBidDocument = (Boolean)dataModel.getValue("biddocument");
            Boolean isNeedBidPublish = (Boolean)dataModel.getValue("bidpublish");
            Boolean isNeedBidAnswerQuestion = (Boolean)dataModel.getValue("bidanswerquestion");
            Boolean isNeedBidOpen = (Boolean)dataModel.getValue("bidopen");
            Boolean isNeedBidEvaluation = (Boolean)dataModel.getValue("bidevaluation");
            Boolean isNeedBidbustalk = (Boolean)dataModel.getValue("bidbustalk");
            BidCommonConstant bidCommonConstant = new BidCommonConstant();
            StringBuilder steps = new StringBuilder();
            steps.append(bidCommonConstant.getBidProjectCn());
            if (Boolean.TRUE.equals(isNeedSupplierInvitation)) {
                steps.append(" \u25cf ");
                steps.append(bidCommonConstant.getSupplierInvitationCn());
            }
            if (Boolean.TRUE.equals(isNeedBidDocument)) {
                steps.append(" \u25cf ");
                steps.append(bidCommonConstant.getBidDocumentCn());
            }
            if (Boolean.TRUE.equals(isNeedBidPublish)) {
                steps.append(" \u25cf ");
                steps.append(bidCommonConstant.getBidPublishCn());
            }
            if (Boolean.TRUE.equals(isNeedBidAnswerQuestion)) {
                steps.append(" \u25cf ");
                steps.append(bidCommonConstant.getAnswerQuestionCn());
            }
            if (Boolean.TRUE.equals(isNeedBidOpen)) {
                steps.append(" \u25cf ");
                steps.append(bidCommonConstant.getBidOpenCn());
            }
            if (Boolean.TRUE.equals(isNeedBidEvaluation)) {
                steps.append(" \u25cf ");
                steps.append(bidCommonConstant.getBidEvaluationCn());
            }
            if (Boolean.TRUE.equals(isNeedBidbustalk)) {
                steps.append(" \u25cf ");
                steps.append(bidCommonConstant.getBidBusTalkCn());
            }
            steps.append(" \u25cf ");
            steps.append(bidCommonConstant.getBidDecisionCn());
            dataModel.setValue("steps", (Object)steps.toString());
        }
    }
}

