/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.util.OrgTreeUtils;
import kd.scm.bid.business.util.OrgViewUtils;

public class BidOrgProjectTreeListF7Plugin
extends StandardTreeListPlugin {
    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        String rootIdStr = this.getView().getFormShowParameter().getCustomParam("orgId").toString();
        TreeNode root = OrgTreeUtils.genRootNodeByNodeId((String)rootIdStr, (String)"02");
        if (root != null) {
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            this.getTreeModel().getRoot().setChildren(this.getChildNodes(rootIdStr));
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String nodeId = e.getNodeId().toString();
        e.setChildNodes(this.getChildNodes(nodeId));
    }

    public void expendTreeNode(TreeNodeEvent e) {
        super.expendTreeNode(e);
        String nodeId = (String)e.getNodeId();
        if (this.getNode(nodeId) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    private TreeNode getNode(Object nodeId) {
        return OrgTreeUtils.getNode((Object)nodeId, (ITreeModel)this.getTreeModel());
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (this.getNode(nodeId) == null) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
        this.refreshBillList();
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        e.setCancel(true);
        e.addQFilter(this.genRefreshFilter(e.getNodeId().toString()));
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        filters.add(this.genRefreshFilter(this.getTreeModel().getRoot().getId()));
        super.setFilter(e);
    }

    private QFilter genRefreshFilter(String nodeId) {
        String[] selePurPlanIdAttr;
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)"rebm_purplan", (String)"47150e89000000ac");
        QFilter permOrgFilter = new QFilter("org", "in", (Object)hasPermOrgs);
        QFilter otherFilter = freezeFilter.and(permOrgFilter);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(Long.valueOf(nodeId));
        List lstChildOrgs = OrgViewUtils.getSubOrgIdIncludeGrand((String)"02", orgIds, (boolean)true, (QFilter)otherFilter);
        QFilter qFilter = new QFilter("purplan.org", "in", (Object)lstChildOrgs);
        qFilter.and(new QFilter("planstatus", "=", (Object)"unused"));
        qFilter.and(new QFilter("purplan.billstatus", "=", (Object)"C"));
        String selePurPlanIdStr = (String)this.getView().getFormShowParameter().getCustomParam("selePurPlanIdStr");
        if (StringUtils.isNotBlank((CharSequence)selePurPlanIdStr) && (selePurPlanIdAttr = selePurPlanIdStr.split(",")) != null && selePurPlanIdAttr.length > 0) {
            qFilter.and(new QFilter("id", "not in", (Object)selePurPlanIdAttr));
        }
        return qFilter;
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(0));
        billList.refresh();
    }

    private List<TreeNode> getChildNodes(String nodeId) {
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)"rebm_purplan", (String)"47150e89000000ac");
        QFilter permOrgFilter = new QFilter("org", "in", (Object)hasPermOrgs);
        QFilter otherFilter = freezeFilter.and(permOrgFilter);
        List treeNodes = OrgTreeUtils.queryChildNodes((String)nodeId, (String)"02", (QFilter)otherFilter, (String)"level, sortcode, longnumber");
        return treeNodes;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String nodeId = String.valueOf(this.treeListView.getTreeModel().getCurrentNodeId());
        e.getParameter().setCustomParam("orgId", (Object)nodeId);
    }
}

