/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.scm.bid.business.util.OrgTreeUtils;
import kd.scm.bid.business.util.OrgViewUtils;

public class BidOrgTreeListF7Plugin
extends StandardTreeListPlugin {
    private static final String orgViewType = "01";
    private boolean quickSearch = false;

    public void initializeTree(EventObject e) {
        TreeNode root = OrgTreeUtils.queryRootNode((String)"", (String)orgViewType);
        if (root != null) {
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        QFilter freezeFilter;
        String nodeId = e.getNodeId().toString();
        QFilter otherFilter = freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        List treeNodes = OrgTreeUtils.queryChildNodes((String)nodeId, (String)orgViewType, (QFilter)otherFilter, (String)"level,sortcode,longnumber");
        e.setChildNodes(treeNodes);
    }

    public void expendTreeNode(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        if (this.getNode(nodeId) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    private TreeNode getNode(Object nodeId) {
        return OrgTreeUtils.getNode((Object)nodeId, (ITreeModel)this.getTreeModel());
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (this.getNode(nodeId) == null) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
        this.refreshBillList();
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        e.addQFilter(this.genRefreshFilter(e.getNodeId().toString()));
    }

    public void setFilter(SetFilterEvent e) {
        String id;
        TreeNode root;
        List filters = e.getQFilters();
        filters.add(new QFilter("isLeaf", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")));
        if (this.quickSearch && (root = this.getTreeModel().getRoot()) != null && !StringUtils.isBlank((CharSequence)(id = root.getId()))) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(Long.valueOf(id));
            List lstChildOrgs = OrgViewUtils.getSubOrgIdIncludeGrand((String)orgViewType, orgIds, (boolean)true, null);
            QFilter qFilter = new QFilter("costcenter", "in", (Object)lstChildOrgs);
            filters.add(qFilter);
        }
        super.setFilter(e);
    }

    private QFilter genRefreshFilter(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        QFilter qFilter = null;
        if (Boolean.parseBoolean(this.getModel().getValue("chkincludechild").toString())) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(Long.valueOf(nodeId));
            List lstChildOrgs = OrgViewUtils.getSubOrgIdIncludeGrand((String)orgViewType, orgIds, (boolean)true, null);
            qFilter = new QFilter("costcenter", "in", (Object)lstChildOrgs);
        } else {
            qFilter = new QFilter("costcenter", "=", (Object)Long.valueOf(nodeId));
        }
        return qFilter;
    }

    private void refreshListView() {
        ((IListView)this.getView()).refresh();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.quickSearch = true;
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(0));
        billList.refresh();
    }

    public void afterCreateNewData(EventObject e) {
        boolean isIncludeAllSub = false;
        if (this.getView().getFormShowParameter().getCustomParam("isIncludeAllSub") != null && (isIncludeAllSub = Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("isIncludeAllSub").toString()))) {
            this.getView().getModel().setValue("chkincludechild", (Object)Boolean.TRUE);
            this.getView().updateView("chkincludechild");
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"qingview"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"bar_share"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("chkincludechild".equals(e.getProperty().getName())) {
            this.refreshListView();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String nodeId = String.valueOf(this.treeListView.getTreeModel().getCurrentNodeId());
        e.getParameter().setCustomParam("orgId", (Object)nodeId);
    }
}

