/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.basedata.IProficientService;
import kd.scm.bid.business.basedata.serviceImpl.ProficientServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.DefaultOrgReg;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.DefaultOrgUtil;

public class ProficientEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    protected IProficientService proficientService = new ProficientServiceImpl();

    public void preOpenForm(PreOpenFormEventArgs e) {
        BillShowParameter billShowParameter;
        Long proficientId;
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)operationStatus) && (proficientId = (Long)(billShowParameter = (BillShowParameter)formShowParameter).getPkId()) != null) {
            String selectFields = "id, billstatus";
            DynamicObject proficient = this.proficientService.getProficient(proficientId, selectFields);
            String billStatus = proficient.getString("billstatus");
            if (BillStatusEnum.AUDITING.getVal().equals(billStatus)) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel dataModel = this.getModel();
        String type = (String)dataModel.getValue("type");
        String billStatus = (String)dataModel.getValue("billstatus");
        if (BillStatusEnum.AUDITING.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "save": {
                this.setMajorTypeNames();
                break;
            }
            case "submit": {
                this.setMajorTypeNames();
            }
        }
    }

    public boolean validateIsCanDelete() {
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        Long proficientId = (Long)dataModel.getValue("id");
        boolean isRefByBill = this.proficientService.checkRefByBill(proficientId);
        if (isRefByBill) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ProficientEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setMajorTypeNames() {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection majorTypeColl = (DynamicObjectCollection)dataModel.getValue("majortype");
        String majorTypeNames = this.proficientService.getMajorTypeNames(majorTypeColl);
        dataModel.setValue("majortypenames", (Object)majorTypeNames);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit proficientname = (BasedataEdit)this.getView().getControl("proficientname");
        proficientname.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            List<Long> pos = this.getHasPermOrgs();
            if (pos == null) {
                return;
            }
            QFilter qFilter = new QFilter("id", "in", pos);
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
        if ("proficientname".equals(fieldKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String type = dataEntity.getString("type");
            ArrayList<Long> filterparm = new ArrayList<Long>();
            filterparm.add(1869613648826100736L);
            if ("externalExperts".equals(type)) {
                QFilter qFilter = new QFilter("usertypes.fbasedataid.id", "in", filterparm);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                QFilter qFilter = new QFilter("usertypes.fbasedataid.id", "not in", filterparm);
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    private List<Long> getHasPermOrgs() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)this.getView().getEntityId(), (String)"47156aff000000ac");
        return hasPermOrgs;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = this.getModel().getDataEntity(true).getDynamicObject("org");
        if (org == null) {
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            String formId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
            DefaultOrgReg defaultOrgReg = new DefaultOrgReg(appId, "02", formId);
            Long orgId = DefaultOrgUtil.getEditUIDefaultOrg((DefaultOrgReg)defaultOrgReg);
            this.getModel().setValue("org", (Object)orgId);
        }
    }
}

