/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.basedata.IPurProjectService;
import kd.scm.bid.business.basedata.serviceImpl.PurProjectServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.DefaultOrgReg;
import kd.scm.bid.common.util.DefaultOrgUtil;

public class PurProjectEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected IPurProjectService purProjectService = new PurProjectServiceImpl();
    public static final String BID_PURPROJECT = "bid_purproject";
    public static final String BD_PROJECT = "bd_project";
    public static final String REBM_PURPROJECT = "rebm_purproject";
    public static final String IMPORTSYSPROJECT = "importsysproject";
    public static final String CACHECLOSESETCANCEL = "cacheclosesetcancel";
    public static final String CACHEORGIDQFILTER = "cacheorgidqfilter";
    public static final String CACHENOTUPBELONGMO = "cachenotupbelongmo";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)operationStatus)) {
            String id = ((BillShowParameter)formShowParameter).getPkId().toString();
            String selectFields = String.join((CharSequence)",", "id", "enable", "projectsource", "org");
            DynamicObject purProject = this.purProjectService.getPurProject((Object)id, selectFields);
            boolean enable = purProject.getBoolean("enable");
            if (enable) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus openStatus = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)openStatus) || dataEntity.getLong("id") == 0L) {
            Object parentId = formShowParameter.getCustomParam("parentId");
            if (parentId != null) {
                this.getModel().setValue("parent", parentId);
                DynamicObject parentPro = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)BID_PURPROJECT, (String)"org,belongmanageorg");
                DynamicObject purOrg = parentPro.getDynamicObject("org");
                DynamicObject manageOrg = parentPro.getDynamicObject("belongmanageorg");
                this.getModel().setValue("org", (Object)purOrg);
                this.getModel().setValue("belongmanageorg", (Object)manageOrg);
                this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
            } else {
                boolean purchaseOrgFlag;
                IPageCache parentViewPageCache;
                IFormView parentView;
                Object selectOrgId = this.getView().getFormShowParameter().getCustomParam("selectOrgId");
                if (selectOrgId == null && (parentView = this.getView().getParentView()) != null && (parentViewPageCache = parentView.getPageCache()) != null) {
                    selectOrgId = parentViewPageCache.get(CACHEORGIDQFILTER);
                }
                long orgId = RequestContext.get().getOrgId();
                if (selectOrgId != null) {
                    orgId = Long.parseLong(selectOrgId.toString());
                }
                if (purchaseOrgFlag = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"02")) {
                    this.getModel().setValue("org", (Object)orgId);
                    this.getModel().setValue("belongmanageorg", (Object)this.getOrgHasCuByOrgId(orgId));
                }
            }
        } else if (dataEntity.getDynamicObject("parent") != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        DynamicObject belongManageOrg;
        Object isCopy;
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean enable = dataEntity.getBoolean("enable");
        DynamicObject purOrg = dataEntity.getDynamicObject("org");
        String projectSource = dataEntity.getString("projectsource");
        if (!enable) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object onlyEditCommon = formShowParameter.getCustomParam("onlyEditCommon");
            if (onlyEditCommon != null) {
                if (StringUtils.equals((CharSequence)"true", (CharSequence)onlyEditCommon.toString())) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"comment"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", "parent", "belongmanageorg", "org"});
                }
            } else if (!StringUtils.isEmpty((CharSequence)projectSource) && !"addnew".equals(projectSource)) {
                if (purOrg == null) {
                    this.getPageCache().put(CACHENOTUPBELONGMO, "not");
                    this.getView().setEnable(Boolean.TRUE, new String[]{"org"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"comment"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", "parent", "belongmanageorg"});
            }
        }
        if ((isCopy = this.getView().getFormShowParameter().getCustomParam("iscopy")) != null && ((Boolean)isCopy).booleanValue()) {
            this.getModel().setValue("fullname", null);
            this.getModel().setValue("longnumber", null);
            this.getModel().setValue("bdproject", null);
            this.getModel().setValue("parent", null);
            this.getModel().setValue("projectsource", null);
        }
        if ((belongManageOrg = dataEntity.getDynamicObject("belongmanageorg")) == null && projectSource != null && purOrg != null && StringUtils.equals((CharSequence)projectSource, (CharSequence)"addnew")) {
            this.getModel().setValue("belongmanageorg", (Object)this.getOrgHasCuByOrgId(purOrg.getLong("id")));
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String cacheNotUpBelongMo;
        DynamicObject org;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity == null) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        if (newVal != null && StringUtils.equals((CharSequence)"org", (CharSequence)fieldKey) && (org = this.getModel().getDataEntity().getDynamicObject("org")) != null && (cacheNotUpBelongMo = this.getPageCache().get(CACHENOTUPBELONGMO)) == null) {
            this.getModel().setValue("belongmanageorg", (Object)this.getOrgHasCuByOrgId(org.getLong("id")));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ORM createOrm;
        boolean existsSysProjectName;
        DynamicObject parent;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        OperationStatus openStatus = this.getView().getFormShowParameter().getStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            String number = dataEntity.getString("number");
            String name = dataEntity.getLocaleString("name").getLocaleValue();
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject belongManageOrg = dataEntity.getDynamicObject("belongmanageorg");
            if (StringUtils.isEmpty((CharSequence)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u91c7\u8d2d\u9879\u76ee\u7f16\u7801\u3002", (String)"PurProjectEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u91c7\u8d2d\u9879\u76ee\u540d\u79f0\u3002", (String)"PurProjectEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5f52\u5c5e\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurProjectEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (belongManageOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e3b\u6570\u636e\u89c6\u56fe\u4e2d\u7ef4\u62a4\u7ba1\u63a7\u5355\u5143\u3002", (String)"PurProjectEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) && OperationStatus.ADDNEW.equals((Object)openStatus) && (parent = dataEntity.getDynamicObject("parent")) == null && (existsSysProjectName = (createOrm = ORM.create()).exists(BD_PROJECT, new QFilter[]{new QFilter("name", "=", (Object)dataEntity.getLocaleString("name").getLocaleValue())}))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(IMPORTSYSPROJECT, (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u5728\u7cfb\u7edf\u4e91-\u9879\u76ee\u4e2d\u5efa\u7acb\uff0c\u662f\u5426\u5f15\u5165\u5230\u91c7\u8d2d\u9879\u76ee\u4e2d\uff1f", (String)"PurProjectEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        DynamicObject bdProject;
        super.confirmCallBack(messageBoxClosedEvent);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)IMPORTSYSPROJECT, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && (bdProject = BusinessDataServiceHelper.loadSingle((String)BD_PROJECT, (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)dataEntity.getLocaleString("name").getLocaleValue())})) != null) {
            String appId = this.getModel().getDataEntityType().getAppId();
            this.purProjectService.importBdProjectById(bdProject.getPkValue(), null, appId, "sys");
            this.getPageCache().put(CACHECLOSESETCANCEL, "true");
            this.getView().invokeOperation("close");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgF7 = (BasedataEdit)this.getView().getControl("org");
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit belongManageOrgF7 = (BasedataEdit)this.getView().getControl("belongmanageorg");
        belongManageOrgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()), (String)"02", (String)this.getModel().getDataEntityType().getAppId(), (String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()), (String)"47156aff000000ac");
            if (!allPermOrgs.hasAllOrgPerm()) {
                ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
                QFilter qFilter = new QFilter("id", "in", (Object)allPermOrgs.getHasPermOrgs());
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"belongmanageorg")) {
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5f52\u5c5e\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurProjectEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", (Object)this.getOrgHasCuByOrgId(org.getLong("id")));
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String cacheCloseSetCancel = this.getPageCache().get(CACHECLOSESETCANCEL);
        if (cacheCloseSetCancel != null && StringUtils.equals((CharSequence)"true", (CharSequence)cacheCloseSetCancel)) {
            e.setCheckDataChange(false);
        }
    }

    public Long getOrgHasCuByOrgId(long orgId) {
        Long ctrlUnitByOrgId = OrgServiceHelper.getCtrlUnitByOrgId((Long)Long.parseLong("16"), (Long)orgId);
        return ctrlUnitByOrgId;
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = this.getModel().getDataEntity(true).getDynamicObject("org");
        if (org == null) {
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            DefaultOrgReg defaultOrgReg = new DefaultOrgReg(appId, "02", appId + "_purproject");
            Long orgId = DefaultOrgUtil.getEditUIDefaultOrg((DefaultOrgReg)defaultOrgReg);
            this.getModel().setValue("org", (Object)orgId);
        }
    }
}

