/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.bid.common.enums.EvaluationBasePriceEnum;
import kd.scm.bid.common.enums.QuoteLimitBaseEnum;

public class QuotationScoreSchEditPlugin
extends AbstractBillPlugIn {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter formShowParameter = (BillShowParameter)e.getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)operationStatus)) {
            Object id = formShowParameter.getPkId();
            String selectFields = "id,enable";
            QFilter qFilter = new QFilter("id", "=", id);
            String entityId = formShowParameter.getFormConfig().getEntityTypeId();
            DynamicObject quotationScoreSchInfo = QueryServiceHelper.queryOne((String)entityId, (String)selectFields, (QFilter[])qFilter.toArray());
            boolean enable = quotationScoreSchInfo.getBoolean("enable");
            if (enable) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("entitytypeid", (Object)this.getView().getEntityId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("evaluationbaseprice".equals(propertyName)) {
            this.evaluationBasePriceChange();
        }
        if ("quoteupperlimitbase".equals(propertyName) || "quoteupperlimitcoef".equals(propertyName)) {
            this.setQuoteUpperLimit(e);
        }
        if ("quotelowerlimitbase".equals(propertyName) || "quotelowerlimitcoef".equals(propertyName)) {
            this.setQuoteLowerLimit(e);
        }
    }

    protected void setQuoteLowerLimit(PropertyChangedArgs e) {
        String quotelowerlimit = null;
        String lowerlimitbase = (String)this.getModel().getValue("quotelowerlimitbase");
        BigDecimal lowerlimitcoef = (BigDecimal)this.getModel().getValue("quotelowerlimitcoef");
        if (StringUtils.isNotEmpty((String)lowerlimitbase) && lowerlimitcoef != null) {
            quotelowerlimit = QuoteLimitBaseEnum.getAliasByVal((String)lowerlimitbase) + "*" + lowerlimitcoef;
        }
        this.getModel().setValue("quotelowerlimit", quotelowerlimit);
    }

    protected void setQuoteUpperLimit(PropertyChangedArgs e) {
        String quoteUpperLimit = null;
        String upperlimitbase = (String)this.getModel().getValue("quoteupperlimitbase");
        BigDecimal upperlimitcoef = (BigDecimal)this.getModel().getValue("quoteupperlimitcoef");
        if (StringUtils.isNotEmpty((String)upperlimitbase) && upperlimitcoef != null) {
            quoteUpperLimit = QuoteLimitBaseEnum.getAliasByVal((String)upperlimitbase) + "*" + upperlimitcoef;
        }
        this.getModel().setValue("quoteupperlimit", quoteUpperLimit);
    }

    protected void evaluationBasePriceChange() {
        String evaluationbaseprice = (String)this.getModel().getValue("evaluationbaseprice");
        if (EvaluationBasePriceEnum.RANGEAVG.getValue().equals(evaluationbaseprice)) {
            TextEdit edit = (TextEdit)this.getView().getControl("range");
            edit.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"range"});
            this.getModel().setValue("range", (Object)"[1,n]");
        } else {
            TextEdit edit = (TextEdit)this.getView().getControl("range");
            edit.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"range"});
            this.getModel().setValue("range", null);
        }
    }
}

