/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.basedata.ITemplateMangeService;
import kd.scm.bid.business.basedata.serviceImpl.TemplateMangeServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;

public class TemplateMangeF7List
extends StandardTreeListPlugin {
    protected ITemplateMangeService templateMangeService = new TemplateMangeServiceImpl();
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter orgFilter = null;
        boolean isOrg = false;
        if (!CollectionUtils.isEmpty((Collection)qFilters)) {
            List orgIds;
            Optional<QFilter> of = qFilters.stream().filter(filter -> "org.name".equals(filter.getProperty())).findFirst();
            if (of.isPresent()) {
                isOrg = true;
                QFilter f = of.get();
                qFilters.remove(f);
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", f.getCP(), f.getValue())});
                Set orgIds2 = orgs.stream().map(org -> org.get("id")).collect(Collectors.toSet());
                orgFilter = new QFilter("org", "in", orgIds2);
            }
            if ((orgIds = ((ListView)this.getView()).getSelectedMainOrgIds()) != null && orgIds.size() != 0 && !isOrg) {
                orgFilter = new QFilter("org", "in", (Object)orgIds);
            }
            if (orgFilter != null) {
                qFilters.add(orgFilter);
            }
            qFilters.add(new QFilter("entitytypeid", "=", (Object)FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass())));
        }
    }

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TREEBUTTONPANEL});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            e.setChildNodes(currNode.getChildren());
        } else if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
            List<TreeNode> roots = this.getNodes();
            e.setChildNodes(roots);
        } else {
            e.setChildNodes(new ArrayList());
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String currentNode = e.getNodeId().toString();
        QFilter filter = this.buildAppQFilter("type", currentNode);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private List<TreeNode> getNodes() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (modelType == null) {
            modelType = "";
        }
        List rootNodes = this.templateMangeService.listNodes(modelType, 1);
        List notRootNodes = this.templateMangeService.listNodes(modelType, 0);
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(rootNodes.size() + notRootNodes.size());
        for (TreeNode node : rootNodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : notRootNodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return rootNodes;
    }

    private QFilter buildAppQFilter(String appIdFldKey, String currentNodeId) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (modelType == null && currentNodeId.equals(this.getTreeModel().getRoot().getId())) {
            return new QFilter("name", "is not null", (Object)"");
        }
        TreeNode selectNode = null;
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        if (modelType != null && currentNodeId.equals(this.getTreeModel().getRoot().getId())) {
            List nodesByModelType = this.templateMangeService.getTypeByModelType(modelType);
            List<Long> nodesByModelTypeIds = nodesByModelType.stream().map(c -> Long.valueOf(c.getId())).collect(Collectors.toList());
            return new QFilter(appIdFldKey, "in", (Object)nodesByModelTypeIds.toArray(new Long[nodesByModelTypeIds.size()]));
        }
        List nodes = this.templateMangeService.listAllNodes();
        for (TreeNode node : nodes) {
            allNodes.put(node.getId(), node);
        }
        selectNode = (TreeNode)allNodes.get(currentNodeId);
        if (selectNode != null && selectNode.getParentid().equals("0")) {
            return new QFilter(appIdFldKey, "=", (Object)Long.valueOf(currentNodeId));
        }
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(currentNodeId);
        String curParentId = selectNode != null ? selectNode.getParentid() : "0";
        do {
            parentIds.add(curParentId);
        } while (!(curParentId = ((TreeNode)allNodes.get(curParentId)).getParentid()).equals("0"));
        List<Long> parentLongIds = parentIds.stream().map(c -> Long.valueOf(c)).collect(Collectors.toList());
        return new QFilter(appIdFldKey, "in", (Object)parentLongIds.toArray(new Long[parentLongIds.size()]));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Boolean isCopy = (Boolean)e.getParameter().getCustomParam("iscopy");
        if (isCopy != null) {
            if (isCopy.booleanValue()) {
                ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
                Object id = sr.getPrimaryKeyValue();
                e.getParameter().setCustomParam("sourceTemplateId", id);
            }
            return;
        }
        String currentNode = this.getTreeModel().getCurrentNodeId().toString();
        if (currentNode.equals(this.getTreeModel().getRoot().getId())) {
            return;
        }
        e.getParameter().setCustomParam("type", (Object)currentNode);
    }
}

