/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.ITemplateMangeService;
import kd.scm.bid.business.basedata.serviceImpl.TemplateMangeServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.DefaultOrgReg;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.DefaultOrgUtil;
import kd.scm.bid.common.util.ReWfUtil;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;

public class TemplateMangeList
extends StandardTreeListPlugin {
    protected ITemplateMangeService templateMangeService = new TemplateMangeServiceImpl();
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";
    private static final String SUBMIT_AUDIT = "submitaudit";

    public void initialize() {
        this.createTemplateType();
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String appId = e.getFormShowParameter().getServiceAppId();
        long orgId = RequestContext.get().getOrgId();
        String formId = FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter orgFilter = null;
        boolean isOrg = false;
        if (!CollectionUtils.isEmpty((Collection)qFilters)) {
            List orgIds;
            Optional<QFilter> of = qFilters.stream().filter(filter -> "org.name".equals(filter.getProperty())).findFirst();
            if (of.isPresent()) {
                isOrg = true;
                QFilter f = of.get();
                qFilters.remove(f);
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", f.getCP(), f.getValue())});
                Set orgIds2 = orgs.stream().map(org -> org.get("id")).collect(Collectors.toSet());
                orgFilter = new QFilter("org", "in", orgIds2);
            }
            if ((orgIds = ((ListView)this.getView()).getSelectedMainOrgIds()) != null && orgIds.size() != 0 && !isOrg) {
                orgFilter = new QFilter("org", "in", (Object)orgIds);
            }
            if (orgFilter != null) {
                qFilters.add(orgFilter);
            }
            qFilters.add(new QFilter("entitytypeid", "=", (Object)FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass())));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ListSelectedRowCollection src;
        super.beforeItemClick(evt);
        String operateKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"setdefault") && (src = ((IListView)this.getView()).getSelectedRows()) != null && src.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"TemplateMangeList_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow"});
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TREEBUTTONPANEL});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            e.setChildNodes(currNode.getChildren());
        } else if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
            List<TreeNode> roots = this.getNodes();
            e.setChildNodes(roots);
        } else {
            e.setChildNodes(new ArrayList());
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String currentNode = e.getNodeId().toString();
        QFilter filter = this.buildAppQFilter("type", currentNode);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private List<TreeNode> getNodes() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (modelType == null) {
            modelType = "";
        }
        List rootNodes = this.templateMangeService.listNodes(modelType, 1);
        List notRootNodes = this.templateMangeService.listNodes(modelType, 0);
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(rootNodes.size() + notRootNodes.size());
        for (TreeNode node : rootNodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : notRootNodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return rootNodes;
    }

    private QFilter buildAppQFilter(String appIdFldKey, String currentNodeId) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (modelType == null && currentNodeId.equals(this.getTreeModel().getRoot().getId())) {
            return new QFilter("name", "is not null", (Object)"");
        }
        TreeNode selectNode = null;
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        if (modelType != null && currentNodeId.equals(this.getTreeModel().getRoot().getId())) {
            List nodesByModelType = this.templateMangeService.getTypeByModelType(modelType);
            List<Long> nodesByModelTypeIds = nodesByModelType.stream().map(c -> Long.valueOf(c.getId())).collect(Collectors.toList());
            return new QFilter(appIdFldKey, "in", (Object)nodesByModelTypeIds.toArray(new Long[nodesByModelTypeIds.size()]));
        }
        List nodes = this.templateMangeService.listAllNodes();
        for (TreeNode node : nodes) {
            allNodes.put(node.getId(), node);
        }
        selectNode = (TreeNode)allNodes.get(currentNodeId);
        if (selectNode != null && selectNode.getParentid().equals("0")) {
            return new QFilter(appIdFldKey, "=", (Object)Long.valueOf(currentNodeId));
        }
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(currentNodeId);
        String curParentId = selectNode != null ? selectNode.getParentid() : "0";
        do {
            parentIds.add(curParentId);
        } while (!(curParentId = ((TreeNode)allNodes.get(curParentId)).getParentid()).equals("0"));
        List<Long> parentLongIds = parentIds.stream().map(c -> Long.valueOf(c)).collect(Collectors.toList());
        return new QFilter(appIdFldKey, "in", (Object)parentLongIds.toArray(new Long[parentLongIds.size()]));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Boolean isCopy = (Boolean)e.getParameter().getCustomParam("iscopy");
        if (isCopy != null) {
            if (isCopy.booleanValue()) {
                ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
                Object id = sr.getPrimaryKeyValue();
                e.getParameter().setCustomParam("sourceTemplateId", id);
            }
            return;
        }
        String currentNode = this.getTreeModel().getCurrentNodeId().toString();
        if (currentNode.equals(this.getTreeModel().getRoot().getId())) {
            return;
        }
        e.getParameter().setCustomParam("type", (Object)currentNode);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BillList billList;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"setdefault")) {
            billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)SUBMIT_AUDIT)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u5ba1\u6838\u6210\u529f\u3002", (String)"TemplateMangeList_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection listSelectedRowColl = ((IListView)this.getView()).getSelectedRows();
        String tipMsg = this.checkPermisstion(operateKey, listSelectedRowColl);
        if (!StringUtils.isBlank((CharSequence)tipMsg)) {
            this.getView().showConfirm(tipMsg, MessageBoxOptions.OK);
            args.setCancel(true);
            return;
        }
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        String formId = FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass());
        DefaultOrgReg defaultOrgReg = new DefaultOrgReg(appId, "02", formId, this.getControlFilters(), "org.id");
        Long orgId = DefaultOrgUtil.getListUIDefaultOrg((DefaultOrgReg)defaultOrgReg);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"new") && orgId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"TemplateMangeList_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)SUBMIT_AUDIT)) {
            DynamicObject[] datas;
            boolean flag = ReWfUtil.hasEableProcess((String)formId);
            if (flag) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u542f\u52a8\u5ba1\u6279\u6d41\uff0c\u65e0\u6cd5\u64cd\u4f5c\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"TemplateMangeList_19", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                args.setCancel(true);
                return;
            }
            for (DynamicObject data : datas = BusinessDataServiceHelper.load((Object[])listSelectedRowColl.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId))) {
                String status = data.getString("status");
                String enable = data.getString("enable");
                if (!BillStatusEnum.AUDITED.getVal().equals(status) || !"1".equals(enable)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u70b9\u51fb\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"TemplateMangeList_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public String checkPermisstion(String opkey, ListSelectedRowCollection listSelectedRowColl) {
        boolean haspermission;
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        String formId = FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass());
        long orgId = this.getOrgId();
        if ("new".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0002", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u65b0\u589e\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_20", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("save".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0196", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4fdd\u5b58\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_21", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("modify".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0003", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4fee\u6539\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_22", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("submit".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0009", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_23", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("unsubmit".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0010", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u64a4\u9500\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_24", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("enable".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0008", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u542f\u7528\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_32", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("disable".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0010", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u7981\u7528\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_26", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("setdefault".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("setdefault", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u8bbe\u4e3a\u9ed8\u8ba4\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_27", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("delete".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0004", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5220\u9664\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_28", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("audit".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0006", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_29", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("unaudit".equals(opkey) && !(haspermission = PermissionUtils.checkPermission("QXX0007", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u53cd\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_30", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if (SUBMIT_AUDIT.equals(opkey) && !(haspermission = PermissionUtils.checkPermission("SubmitAudit", orgId, appId, formId))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u5e76\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TemplateMangeList_31", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private long getOrgId() {
        long orgId = -1L;
        List mainOrgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
        orgId = mainOrgIds != null && mainOrgIds.size() != 0 ? ((Long)mainOrgIds.get(0)).longValue() : RequestContext.get().getOrgId();
        return orgId;
    }

    public void createTemplateType() {
        QFilter qFilter;
        String billKey = FormTypeConstants.getFormConstant((String)"templatetype", ((Object)((Object)this)).getClass());
        if (!QueryServiceHelper.exists((String)billKey, (QFilter[])(qFilter = new QFilter("modeltype", "=", (Object)"bidassinvite")).toArray())) {
            DynamicObject templateType = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)billKey));
            String name = ResManager.loadKDString((String)"\u8bc4\u6807\u9080\u8bf7\u51fd", (String)"TemplateMangeList_18", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            ORM orm = ORM.create();
            long genLongId = orm.genLongId((IDataEntityType)EntityMetadataCache.getDataEntityType((String)billKey));
            templateType.set("id", (Object)genLongId);
            templateType.set("number", (Object)name);
            templateType.set("name", (Object)name);
            templateType.set("longnumber", (Object)name);
            templateType.set("fullname", (Object)name);
            templateType.set("isleaf", (Object)Boolean.TRUE);
            templateType.set("modeltype", (Object)"bidassinvite");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{templateType});
        } else {
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)billKey, (String)"id,number,name,longnumber,fullname", (QFilter[])qFilter.toArray());
            DynamicObject data = ids[0];
            String name = ResManager.loadKDString((String)"\u8bc4\u6807\u9080\u8bf7\u51fd", (String)"TemplateMangeList_18", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            data.set("number", (Object)name);
            data.set("name", (Object)name);
            data.set("longnumber", (Object)name);
            data.set("fullname", (Object)name);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        }
    }
}

