/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.RespBusiness;

public class BidAdjustpromsgEditUI
extends AbstractFormPlugin {
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private IBidAnswerQuestionService answerQuestionService = new BidAnswerQuestionServiceImpl();
    private ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();
    private IBidDecisionService bidDecisionService = new BidDecisionServiceImpl();
    private IBidProjectService bidProjectService = new BidProjectServiceImpl();

    public void beforeBindData(EventObject e) {
        Object answerQuestionBillStatus;
        DynamicObject answerQuestion;
        super.beforeBindData(e);
        Long pkvalue = this.getModel().getDataEntity().getPkValue() != null ? Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()) : 0L;
        String billStatus = this.annocumentService.getBillStatus((Object)pkvalue, (Object)"bidproject");
        if (billStatus == null || billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
            // empty if block
        }
        if ((answerQuestion = this.answerQuestionService.getAnswerByProjectId(pkvalue, "billstatus")) != null && (answerQuestionBillStatus = answerQuestion.get("billstatus")) != null && answerQuestionBillStatus.toString().equals(BillStatusEnum.COMPLETE.getVal())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"answerquestiontime"});
        }
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)pkvalue), new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.OPEN.getVal(), "P"})});
        DynamicObject bidDecision = this.bidDecisionService.getBidDecisionByProjectId(pkvalue, "billstatus");
        if (bidOpen != null) {
            String bidOpenStatus = bidOpen.getString("billstatus");
            if (BillStatusEnum.OPEN.getVal().equals(bidOpenStatus) || "P".equals(bidOpenStatus)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bidopendeadline"});
            }
        } else if (bidDecision != null) {
            String bidDecisionStatus = bidDecision.getString("billstatus");
            if (BillStatusEnum.AUDITED.getVal().equals(bidDecisionStatus)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bidopendeadline"});
            }
        }
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)pkvalue);
        DynamicObject bidInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"billstatus", (QFilter[])new QFilter[]{qFilter});
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"billstatus", (QFilter[])new QFilter[]{qFilter});
        if (bidInvitation != null) {
            if (this.setBooleanBillstatus(bidInvitation.getString("billstatus"))) {
                this.setViewToEnable();
                return;
            }
        } else if (bidPublish != null) {
            if (this.setBooleanBillstatus(bidPublish.getString("billstatus"))) {
                this.setViewToEnable();
                return;
            }
        } else if (bidOpen != null) {
            if (this.setBooleanBillstatus(bidOpen.getString("billstatus"))) {
                this.setViewToEnable();
                return;
            }
        } else if (bidDecision != null && this.setBooleanBillstatus(bidDecision.getString("billstatus"))) {
            this.setViewToEnable();
            return;
        }
    }

    private void setViewToEnable() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"invitationdeadline", "enrolldeadline"});
    }

    private boolean setBooleanBillstatus(String billstatus) {
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.DISBEGIN.getVal())) {
            return false;
        }
        return !StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SAVE.getVal());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object pkvalue = this.getModel().getDataEntity().getPkValue();
        DynamicObject bidAnnouncement = BusinessDataServiceHelper.loadSingle((String)"bid_announcement", (String)"publishstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()), new QFilter("publishstatus", "=", (Object)"L"), new QFilter("bidproject", "=", (Object)String.valueOf(pkvalue)), new QFilter("annotype", "=", (Object)"bidproject")});
        String fieldKey = ((FormOperate)args.getSource()).getOperateKey();
        Date enrolldeadline = (Date)this.getModel().getValue("enrolldeadline");
        DynamicObject invitation = this.supplierInvitationService.getInvitationByProjectId(Long.valueOf(pkvalue.toString()));
        Date invitationdeadline = (Date)this.getModel().getValue("invitationdeadline");
        if (StringUtils.equals((CharSequence)"save", (CharSequence)fieldKey)) {
            DynamicObject dataEntity;
            boolean b;
            if (bidAnnouncement != null && enrolldeadline != null) {
                this.annocumentService.newChangeAnnoComAndDate(Long.valueOf(bidAnnouncement.getLong("id")), enrolldeadline);
            }
            if (invitation != null && invitationdeadline != null) {
                this.supplierInvitationService.changeInvitationDeadLine(pkvalue, invitationdeadline);
            }
            if (b = this.validateRespBusiness(dataEntity = this.getModel().getDataEntity(true))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62db\u6807\u5c0f\u7ec4\u6210\u5458\u5361\u7247\u4e2d\u5b58\u5728\u672a\u8bbe\u7f6e\u7ecf\u529e\u4eba\u7684\u4e1a\u52a1\u6b65\u9aa4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BidAdjustpromsgEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private boolean validateRespBusiness(DynamicObject dataEntity) {
        boolean isBidProject = dataEntity.getBoolean("bidproject");
        boolean isSupplierInvitation = dataEntity.getBoolean("supplierinvitation");
        boolean isBidDocument = dataEntity.getBoolean("biddocument");
        boolean isBidPublish = dataEntity.getBoolean("bidpublish");
        boolean isBidOpen = dataEntity.getBoolean("bidopen");
        boolean isBidEvaluation = dataEntity.getBoolean("bidevaluation");
        boolean isBidBustalk = dataEntity.getBoolean("bidbustalk");
        boolean isBidDecision = dataEntity.getBoolean("biddecision");
        boolean isSeparateDoc = dataEntity.getBoolean("isseparatedoc");
        boolean isBidAnwser = dataEntity.getBoolean("bidanswerquestion");
        String bidOpenType = dataEntity.getString("bidopentype");
        String docTypeStr = dataEntity.getString("doctype");
        LinkedHashMap<String, Boolean> mapping = new LinkedHashMap<String, Boolean>();
        mapping.put("BidProject", isBidProject);
        mapping.put("SupplierInvitation", isSupplierInvitation);
        mapping.put("BidDocument", isBidDocument);
        mapping.put("BidPublish", isBidPublish);
        mapping.put("BidOpen", isBidOpen);
        mapping.put("BidEvaluation", isBidEvaluation);
        mapping.put("BidBustalk", isBidBustalk);
        mapping.put("BidDecision", isBidDecision);
        mapping.put("BidAnswerQuestion", isBidAnwser);
        String[] rbs = mapping.entrySet().stream().filter(Map.Entry::getValue).map(entry -> {
            String rp = null;
            String k = (String)entry.getKey();
            if ("BidDocument".equals(k)) {
                if (isSeparateDoc) {
                    if (BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) {
                        rp = RespBusiness.TechnicalDoc.getVal() + "," + RespBusiness.CommercialDoc.getVal();
                    } else if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr)) {
                        rp = RespBusiness.TechnicalDoc.getVal();
                    } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr)) {
                        rp = RespBusiness.CommercialDoc.getVal();
                    }
                } else {
                    rp = RespBusiness.RespCreateDoc.getVal();
                }
                return rp;
            }
            if ("BidOpen".equals(k)) {
                rp = !BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType) && StringUtils.isNotBlank((CharSequence)bidOpenType) ? RespBusiness.TechnicalOpen.getVal() + "," + RespBusiness.BusinessOpen.getVal() : RespBusiness.BidOpen.getVal();
                return rp;
            }
            if ("BidEvaluation".equals(k)) {
                rp = !BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType) && StringUtils.isNotBlank((CharSequence)bidOpenType) ? RespBusiness.TechnicalEval.getVal() + "," + RespBusiness.BusinessEval.getVal() : RespBusiness.BidEvaluation.getVal();
                return rp;
            }
            return RespBusiness.valueOf((String)k).getVal();
        }).collect(Collectors.joining(",")).split(",");
        Set rb4Pro = Arrays.stream(rbs).distinct().collect(Collectors.toSet());
        DynamicObjectCollection members = dataEntity.getDynamicObjectCollection("memberentity");
        Set memberRb4Pro = Arrays.stream(members.stream().map(member -> member.getString("respbusiness")).collect(Collectors.joining(",")).split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        for (String num : rb4Pro) {
            if (memberRb4Pro.contains(num)) continue;
            return true;
        }
        DynamicObject bProject = this.bidProjectService.getBidProjectAllById((Long)dataEntity.get("id"));
        BigDecimal tenderfee = bProject.getBigDecimal("tenderfee");
        BigDecimal deposit = bProject.getBigDecimal("deposit");
        boolean isdeposit = bProject.getBoolean("isdeposit");
        if (isdeposit) {
            DynamicObjectCollection bidSection = bProject.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSection.size(); ++i) {
                DynamicObject section = (DynamicObject)bidSection.get(i);
                BigDecimal secdeposit = section.getBigDecimal("secdeposit");
                if (secdeposit.compareTo(BigDecimal.ZERO) == 0) continue;
                deposit = secdeposit;
                break;
            }
        }
        if (tenderfee.compareTo(BigDecimal.ZERO) > 0 || deposit.compareTo(BigDecimal.ZERO) > 0) {
            boolean b = false;
            RespBusiness rb = RespBusiness.valueOf((String)"BidPay");
            for (int i = 0; i < members.size(); ++i) {
                DynamicObject member2 = (DynamicObject)members.get(i);
                String respbusiness = member2.getString("respbusiness");
                if (!StringUtils.isNotEmpty((CharSequence)respbusiness) || respbusiness.indexOf(rb.getVal()) < 0) continue;
                b = true;
                break;
            }
            if (!b) {
                return true;
            }
        }
        return false;
    }
}

