/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidBottomMakeEditUI
extends AbstractBillPlugIn
implements UploadListener,
ClickListener {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentpanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentpanel.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.setPurTypeModelStatus();
        this.setButtonVisible(dataEntity);
    }

    protected void setButtonVisible(DynamicObject dataEntity) {
        String billStatus = dataEntity.getString("billstatus");
        if (BillStatusEnum.INVALID.getVal().equals(billStatus) || BillStatusEnum.AUDITING.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_del", "bar_submit", "bar_audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"comment", "attachmentpanelap"});
            DynamicObjectCollection bidSections = dataEntity.getDynamicObjectCollection("bidsection");
            Optional.ofNullable(bidSections).ifPresent(list -> list.forEach(item -> {
                AtomicInteger i = new AtomicInteger();
                DynamicObjectCollection proEntry = item.getDynamicObjectCollection("projectentry");
                Optional.ofNullable(proEntry).ifPresent(entry -> entry.forEach(pro -> this.getView().setEnable(Boolean.FALSE, i.getAndIncrement(), new String[]{"declareamount"})));
            }));
        }
    }

    private void setPurTypeModelStatus() {
        DynamicObject projectF7 = (DynamicObject)this.getModel().getValue("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)projectF7.getString("id"), (String)"bid_project");
        int bidtype = bidProject.getInt("bidtype");
        boolean isMultisection = bidProject.getBoolean("enablemultisection");
        if (!isMultisection) {
            SplitContainer splitContainer = (SplitContainer)this.getControl("purdetailsplitcontainer");
            splitContainer.changeFlexStatus(SplitDirection.left, true);
        }
        if (bidtype == 1 || bidtype == 2) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"workload", "purentryworkload"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseunit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialdes"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"qty"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection porEntry;
        DynamicObjectCollection bidSections;
        BigDecimal countAmt;
        int rowIndex;
        ChangeData changeData;
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeDataArr = e.getChangeSet();
        if (StringUtils.equals((CharSequence)"declareamount", (CharSequence)fieldKey) && changeDataArr != null && changeDataArr.length > 0) {
            changeData = changeDataArr[0];
            rowIndex = changeData.getRowIndex();
            this.getModel().setValue("finalauditamount", changeData.getNewValue(), rowIndex);
            countAmt = new BigDecimal(0);
            bidSections = this.getModel().getEntryEntity("bidsection");
            for (DynamicObject item : bidSections) {
                porEntry = item.getDynamicObjectCollection("projectentry");
                for (DynamicObject pro : porEntry) {
                    BigDecimal declareAmount = pro.getBigDecimal("declareamount");
                    countAmt = countAmt.add(declareAmount);
                }
            }
            this.getModel().setValue("bidbottomamount", (Object)countAmt);
        }
        if (StringUtils.equals((CharSequence)"finalauditamount", (CharSequence)fieldKey) && changeDataArr != null && changeDataArr.length > 0) {
            changeData = changeDataArr[0];
            rowIndex = changeData.getRowIndex();
            this.getModel().setValue("finalauditamount", changeData.getNewValue(), rowIndex);
            countAmt = new BigDecimal(0);
            bidSections = this.getModel().getEntryEntity("bidsection");
            for (DynamicObject item : bidSections) {
                porEntry = item.getDynamicObjectCollection("projectentry");
                for (DynamicObject pro : porEntry) {
                    BigDecimal finalAuditAmount = pro.getBigDecimal("finalauditamount");
                    countAmt = countAmt.add(finalAuditAmount);
                }
            }
            this.getModel().setValue("bidbottomamount", (Object)countAmt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void click(EventObject eventobject) {
        super.click(eventobject);
    }

    protected String getAppId() {
        return this.getModel().getDataEntityType().getAppId();
    }
}

