/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.BidOpenConstant;

public class BidBustalkSupplierDetailEdit
extends AbstractFormPlugin {
    private IBidProjectService projectService = new BidProjectServiceImpl();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()), (CharSequence)parentFormId)) {
            int entryCurrentRowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("entryCurrentRowIndex");
            DynamicObject currencySection = this.getView().getParentView().getModel().getEntryRowEntity("bidsection", entryCurrentRowIndex);
            DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            DynamicObject bidProjectData = this.projectService.getBidProjectAllById(Long.valueOf(bidProject.getLong("id")));
            String supplierid = (String)this.getView().getFormShowParameter().getCustomParam("supplierid");
            String sectionId = (String)this.getView().getFormShowParameter().getCustomParam("sectionId");
            IDataModel model = this.getView().getModel();
            model.setValue("currency", bidProjectData.get("currency"));
            DynamicObjectCollection purDetails = null;
            DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
            if (bidsection != null && bidsection.size() > 0) {
                for (int k = 0; k < bidsection.size(); ++k) {
                    if (entryCurrentRowIndex != k) continue;
                    purDetails = ((DynamicObject)bidsection.get(k)).getDynamicObjectCollection("supplierdetail");
                }
            }
            DynamicObject currencySupplier = null;
            if (purDetails != null && purDetails.size() > 0) {
                String[] keys = StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getView().getParentView().getModel().getDataEntityType().getAppId()) ? BidOpenConstant.getCcFields() : BidOpenConstant.getFields();
                for (int i = 0; i < purDetails.size(); ++i) {
                    currencySupplier = ((DynamicObject)purDetails.get(i)).getDynamicObject("pursupplier");
                    if (!StringUtils.equals((CharSequence)currencySupplier.getString("id"), (CharSequence)supplierid)) continue;
                    int index = model.createNewEntryRow("entryentity");
                    model.setValue("sectionId", (Object)sectionId, index);
                    model.setValue("supplier", (Object)currencySupplier, index);
                    for (String key : keys) {
                        model.setValue(key, ((DynamicObject)purDetails.get(i)).get(key), index);
                    }
                    model.setValue("taxrate", ((DynamicObject)purDetails.get(i)).get("staxrate"), index);
                    model.setValue("bd_taxrate", ((DynamicObject)purDetails.get(i)).get("bd_taxrate"), index);
                    DynamicObject baseUnit = ((DynamicObject)purDetails.get(i)).getDynamicObject("baseunit");
                    Long baseUnitId = 0L;
                    if (baseUnit != null) {
                        baseUnitId = baseUnit.getLong("id");
                    }
                    model.setValue("baseunit", (Object)baseUnitId, index);
                }
            } else {
                DynamicObjectCollection pSupplierDetails = this.projectService.getMaDetailCollectionByProjectAndSec(bidProjectData, currencySection.getString("sectionname"));
                if (pSupplierDetails != null && pSupplierDetails.size() > 0) {
                    String[] keys = StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getView().getParentView().getModel().getDataEntityType().getAppId()) ? BidOpenConstant.lessCcFields() : BidOpenConstant.lessFields();
                    for (int j = 0; j < pSupplierDetails.size(); ++j) {
                        int index = model.createNewEntryRow("entryentity");
                        model.setValue("sectionId", (Object)sectionId, index);
                        model.setValue("supplier", (Object)supplierid, index);
                        for (String key : keys) {
                            model.setValue(key, ((DynamicObject)pSupplierDetails.get(j)).get(key), index);
                        }
                        DynamicObject baseUnit = ((DynamicObject)pSupplierDetails.get(j)).getDynamicObject("baseunit");
                        Long baseUnitId = 0L;
                        if (baseUnit != null) {
                            baseUnitId = baseUnit.getLong("id");
                        }
                        model.setValue("baseunit", (Object)baseUnitId, index);
                    }
                }
            }
            if (this.getView().getFormShowParameter().getStatus().getValue() == OperationStatus.VIEW.getValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isMaterialpur = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMaterialpur");
        boolean isratebidding = (Boolean)this.getView().getFormShowParameter().getCustomParam("isratebidding");
        int bidType = (Integer)this.getView().getFormShowParameter().getCustomParam("bidType");
        if (bidType != 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"costrate"});
            EntryGrid detailGrid = (EntryGrid)this.getControl("entryentity");
            detailGrid.setColumnProperty("inclutaxamount", "l", (Object)55);
            this.getView().setEnable(Boolean.FALSE, new String[]{"inclutaxamount"});
            detailGrid.setColumnProperty("taxrate", "l", (Object)55);
            if (StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getView().getParentView().getModel().getDataEntityType().getAppId())) {
                if (bidType == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resitemname"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourcemodel"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourceunit"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialid"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"unit"});
                }
            }
            FieldEdit purTypeControl = (FieldEdit)this.getView().getControl("inclutaxamount");
            purTypeControl.setMustInput(false);
        } else if (bidType == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialdes"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseunit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"qty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxprice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resitemname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resourcemodel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resourceunit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bd_taxrate"});
            if (!isratebidding) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"costrate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"excepttaxamount"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] datas = e.getChangeSet();
        String keyname = e.getProperty().getName();
        ChangeData changedata = datas[0];
        Object oldVal = changedata.getOldValue();
        int rowIndex = changedata.getRowIndex();
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
        BigDecimal inclutaxamount = BigDecimal.ZERO;
        BigDecimal taxamount = BigDecimal.ZERO;
        BigDecimal excepttaxamount = BigDecimal.ZERO;
        int bidType = (Integer)this.getView().getFormShowParameter().getCustomParam("bidType");
        BigDecimal taxRateObj = new BigDecimal(1).add(taxRate.divide(new BigDecimal("100")));
        if (bidType != 0) {
            if (keyname.equals("inclutaxprice")) {
                BigDecimal inCluTaxPrice = (BigDecimal)this.getModel().getValue("inclutaxprice", rowIndex);
                inclutaxamount = qty.multiply(inCluTaxPrice).setScale(10, 4);
                this.getModel().setValue("inclutaxamount", (Object)inclutaxamount, rowIndex);
                taxamount = inclutaxamount.multiply(taxRate.divide(new BigDecimal("100"))).divide(taxRateObj, 10, 4);
                excepttaxamount = inclutaxamount.subtract(taxamount);
                this.getModel().setValue("taxamount", (Object)taxamount, rowIndex);
                this.getModel().setValue("excepttaxamount", (Object)excepttaxamount, rowIndex);
            }
        } else if (keyname.equals("inclutaxamount")) {
            inclutaxamount = (BigDecimal)this.getModel().getValue("inclutaxamount", rowIndex);
            taxamount = inclutaxamount.multiply(taxRate.divide(new BigDecimal("100"))).divide(taxRateObj, 10, 4);
            excepttaxamount = inclutaxamount.subtract(taxamount);
            this.getModel().setValue("taxamount", (Object)taxamount, rowIndex);
            this.getModel().setValue("excepttaxamount", (Object)excepttaxamount, rowIndex);
        }
        if (keyname.equals("taxrate")) {
            inclutaxamount = (BigDecimal)this.getModel().getValue("inclutaxamount", rowIndex);
            taxamount = inclutaxamount.multiply(taxRate.divide(new BigDecimal("100"))).divide(taxRateObj, 10, 4);
            excepttaxamount = inclutaxamount.subtract(taxamount);
            this.getModel().setValue("taxamount", (Object)taxamount, rowIndex);
            this.getModel().setValue("excepttaxamount", (Object)excepttaxamount, rowIndex);
        } else if (keyname.equals("bd_taxrate")) {
            Object newVal = changedata.getNewValue();
            if (newVal == null) {
                this.getModel().setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
            } else {
                DynamicObject bdTaxRate = (DynamicObject)newVal;
                this.getModel().setValue("taxrate", (Object)bdTaxRate.getBigDecimal("taxrate"), rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"callbacksave")) {
            DynamicObject bustalk;
            String billstatus;
            Object id = this.getView().getFormShowParameter().getCustomParam("id");
            if (!(id == null || id.equals(0) || (billstatus = (bustalk = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()))).getString("billstatus")).equals("A") || billstatus.equals("D"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BidBustalkSupplierDetailEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            int entryCurrentRowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("entryCurrentRowIndex");
            String supplierid = (String)this.getView().getFormShowParameter().getCustomParam("supplierid");
            resultMap.put("entryCurrentRowIndex", entryCurrentRowIndex);
            resultMap.put("supplierid", supplierid);
            DynamicObject purdetailmain = this.getModel().getDataEntity(true);
            Object[] resultObject = new Object[1];
            ArrayList resultList = new ArrayList();
            DynamicObjectCollection sonPurDetails = purdetailmain.getDynamicObjectCollection("entryentity");
            int bidType = (Integer)this.getView().getFormShowParameter().getCustomParam("bidType");
            for (DynamicObject sonPurDetail : sonPurDetails) {
                HashMap<String, Object> resultDetailMap = new HashMap<String, Object>();
                resultDetailMap.put("purentrycontent", sonPurDetail.getString("purentrycontent") == null ? "" : sonPurDetail.getString("purentrycontent"));
                resultDetailMap.put("purentryprojectid", sonPurDetail.getDynamicObject("purentryproject") == null ? "" : sonPurDetail.getDynamicObject("purentryproject").getString("id"));
                resultDetailMap.put("materialid", sonPurDetail.getDynamicObject("materialid") == null ? "" : sonPurDetail.getDynamicObject("materialid").getString("id"));
                resultDetailMap.put("materialdes", sonPurDetail.getString("materialdes") == null ? "" : sonPurDetail.getString("materialdes"));
                resultDetailMap.put("inclutaxprice", sonPurDetail.get("inclutaxprice"));
                resultDetailMap.put("inclutaxamount", sonPurDetail.get("inclutaxamount"));
                resultDetailMap.put("bd_taxrate", sonPurDetail.get("bd_taxrate"));
                resultDetailMap.put("staxrate", sonPurDetail.get("taxrate"));
                resultDetailMap.put("taxamount", sonPurDetail.get("taxamount"));
                resultDetailMap.put("excepttaxamount", sonPurDetail.get("excepttaxamount"));
                resultDetailMap.put("costrate", sonPurDetail.get("costrate"));
                if (bidType == 2) {
                    resultDetailMap.put("resourceitem", sonPurDetail.getDynamicObject("resourceitem") == null ? "" : sonPurDetail.getDynamicObject("resourceitem").getString("id"));
                }
                resultList.add(resultDetailMap);
            }
            resultMap.put("resultList", resultList);
            resultObject[0] = resultMap;
            this.getView().returnDataToParent((Object)resultObject);
            this.getView().showMessage(ResManager.loadKDString((String)"\u62a5\u4ef7\u660e\u7ec6\u4fdd\u5b58\u6210\u529f\u3002", (String)"BidBustalkSupplierDetailEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }
}

