/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidDecisionContPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("createcontract".equals(key)) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            if (listSelectedRowCollection.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u751f\u6210\u5408\u540c\uff0c\u8bf7\u5355\u9009\u64cd\u4f5c\u3002", (String)"BidDecisionContPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            String billStatus = listSelectedRowCollection.get(0).getBillStatus();
            Object decisionPk = listSelectedRowCollection.get(0).getPrimaryKeyValue();
            if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)billStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5b9a\u6807\u5355\u624d\u80fd\u751f\u6210\u5408\u540c\u3002", (String)"BidDecisionContPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter pkFilter = new QFilter("id", "=", decisionPk);
            DynamicObject[] decisionArr = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id,bidproject.name,bidproject.number", (QFilter[])new QFilter[]{pkFilter});
            if (decisionArr == null || decisionArr.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u518d\u64cd\u4f5c\u3002", (String)"BidDecisionContPlugin_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject decision = decisionArr[0];
            String bidBillId = String.valueOf(decision.getPkValue());
            DynamicObject bidProject = decision.getDynamicObject("bidproject");
            String projectName = bidProject.getString("name");
            QFilter contractNameFilter = new QFilter("billname", "like", (Object)("%" + projectName + "%"));
            boolean isCreated = QueryServiceHelper.exists((String)"ec_out_contract", (QFilter[])new QFilter[]{contractNameFilter});
            if (isCreated) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u6807\u5355\u5df2\u7ecf\u751f\u6210\u8fc7\u5408\u540c\uff0c\u4e0d\u80fd\u91cd\u65b0\u751f\u6210\u3002", (String)"BidDecisionContPlugin_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            this.createBills(bidBillId, bidProject);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u5408\u540c\u6210\u529f\u3002", (String)"BidDecisionContPlugin_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    private void createBills(String bidBillId, DynamicObject project) {
        this.getPageCache().put("contCount", "1");
        this.getPageCache().put("contListingCount", "1");
        DynamicObject bid = BusinessDataServiceHelper.loadSingle((Object)bidBillId, (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
        DynamicObjectCollection sectionCol = bid.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < sectionCol.size(); ++i) {
            DynamicObject section = (DynamicObject)sectionCol.get(i);
            DynamicObjectCollection supplierEntryCol = section.getDynamicObjectCollection("supplierentry");
            DynamicObjectCollection supfinaldetailCol = section.getDynamicObjectCollection("supfinaldetail");
            for (int j = 0; j < supplierEntryCol.size(); ++j) {
                DynamicObject supplierEntryInfo = (DynamicObject)supplierEntryCol.get(j);
                String curSupplierId = supplierEntryInfo.getDynamicObject("supplier").getString("id");
                boolean isAim = supplierEntryInfo.getBoolean("isrecommended");
                if (!isAim) continue;
                DynamicObjectCollection curSupFinalDetailCol = new DynamicObjectCollection();
                for (int k = 0; k < supfinaldetailCol.size(); ++k) {
                    DynamicObject curSupFinalDetail = (DynamicObject)supfinaldetailCol.get(k);
                    String supplierId = curSupFinalDetail.getDynamicObject("lpursupplier").getString("id");
                    if (!supplierId.equals(curSupplierId)) continue;
                    curSupFinalDetailCol.add((Object)curSupFinalDetail);
                }
                this.createContract(project, supplierEntryInfo, curSupFinalDetailCol);
            }
        }
    }

    private void createContract(DynamicObject project, DynamicObject supplierEntryInfo, DynamicObjectCollection curSupFinalDetailCol) {
        MainEntityType contractDt = EntityMetadataCache.getDataEntityType((String)"ec_out_contract");
        ORM orm = ORM.create();
        Long contractId = orm.genLongId("ec_out_contract");
        DynamicObject contract = new DynamicObject((DynamicObjectType)contractDt);
        contract.set("id", (Object)contractId);
        QFilter filter = new QFilter("number", "=", (Object)"dc001");
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] contTypeArr = BusinessDataServiceHelper.load((String)"ec_conttype", (String)"number,name", (QFilter[])new QFilter[]{filter});
        if (contTypeArr.length <= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5408\u540c\u7c7b\u578b\u3002", (String)"BidDecisionContPlugin_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = sdf.format(new Date());
        String countStr = this.getPageCache().get("contCount");
        String billNo = "CGHT" + format + countStr;
        int count = Integer.parseInt(countStr) + 1;
        this.getPageCache().put("contCount", String.valueOf(count));
        contract.set("contracttype", (Object)contTypeArr[0]);
        contract.set("billno", (Object)billNo);
        contract.set("billname", (Object)String.format(ResManager.loadKDString((String)"%1$s\u91c7\u8d2d\u5408\u540c", (String)"BidDecisionContPlugin_6", (String)"scm-bid-formplugin", (Object[])new Object[0]), project.getString("name")));
        contract.set("paydirection", (Object)"out");
        contract.set("billstatus", (Object)"A");
        contract.set("isonlist", (Object)Boolean.TRUE);
        contract.set("stdcurrency", this.getCurrency());
        contract.set("taxamount", (Object)supplierEntryInfo.getBigDecimal("finalvat"));
        contract.set("originalamount", (Object)supplierEntryInfo.getBigDecimal("finalexceptvat"));
        contract.set("originaloftaxamount", (Object)supplierEntryInfo.getBigDecimal("finalprice"));
        contract.set("ismultirate", (Object)Boolean.FALSE);
        BigDecimal supplierTaxRate = supplierEntryInfo.getBigDecimal("finaltaxrate");
        String taxRateId = this.getTaxRateId(supplierTaxRate);
        contract.set("taxrate", (Object)taxRateId);
        long orgId = RequestContext.get().getOrgId();
        String userId = RequestContext.get().getUserId();
        this.getPageCache().put("orgId", String.valueOf(orgId));
        this.getPageCache().put("userId", String.valueOf(userId));
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)project.getString("id"), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"org");
        contract.set("parta", (Object)bidProject.getDynamicObject("org"));
        DynamicObject supplier = supplierEntryInfo.getDynamicObject("supplier");
        supplier = BusinessDataServiceHelper.loadSingle((Object)supplier.getString("id"), (String)"bd_supplier");
        if (supplier.getDynamicObject("bizpartner") != null) {
            String partnerid = supplier.getDynamicObject("bizpartner").getString("id");
            DynamicObject bizParner = BusinessDataServiceHelper.loadSingle((Object)partnerid, (String)"bd_bizpartner", (String)"number");
            contract.set("partb", (Object)bizParner);
        }
        contract.set("org", (Object)orgId);
        contract.set("creator", (Object)userId);
        contract.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
        this.createContractListing(String.valueOf(contractId), curSupFinalDetailCol);
    }

    private void createContractListing(String contId, DynamicObjectCollection curSupFinalDetailCol) {
        if (curSupFinalDetailCol == null || curSupFinalDetailCol.size() == 0) {
            return;
        }
        MainEntityType outContListingDt = EntityMetadataCache.getDataEntityType((String)"ec_outcontractlisting");
        ORM orm = ORM.create();
        DynamicObject outContListing = new DynamicObject((DynamicObjectType)outContListingDt);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = sdf.format(new Date());
        String countStr = this.getPageCache().get("contListingCount");
        String billNo = "CGLS" + format + countStr;
        int count = Integer.parseInt(countStr) + 1;
        this.getPageCache().put("contListingCount", String.valueOf(count));
        Long outContListId = orm.genLongId("ec_outcontractlisting");
        outContListing.set("id", (Object)outContListId);
        outContListing.set("contract", (Object)contId);
        outContListing.set("billno", (Object)billNo);
        outContListing.set("paydirection", (Object)"out");
        outContListing.set("billstatus", (Object)"A");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contId, (String)"ec_out_contract");
        outContListing.set("conttaxrate", (Object)contract.getDynamicObject("taxrate").getBigDecimal("taxrate"));
        DynamicObject contAttr = contract.getDynamicObject("contracttype").getDynamicObject("contattr");
        outContListing.set("contattr", (Object)contAttr.getString("name"));
        contAttr = BusinessDataServiceHelper.loadSingle((Object)contAttr.get("id").toString(), (String)"ec_contattr");
        outContListing.set("contattr", (Object)contAttr.getString("name"));
        if (contract.get("currency") != null) {
            DynamicObject currency = (DynamicObject)contract.get("currency");
            outContListing.set("currency", currency.get("id"));
        }
        DynamicObjectType listingModelDt = BidDecisionContPlugin.getEntryDynamicObjectType("ec_outcontractlisting", "listmodelentry");
        DynamicObject listingModel = new DynamicObject(listingModelDt);
        Long listingModelId = orm.genLongId((IDataEntityType)listingModelDt);
        this.getPageCache().put("modelId", String.valueOf(listingModelId));
        DynamicObjectCollection listConfigs = contAttr.getDynamicObjectCollection("listconfigentry");
        DynamicObject listConfig = (DynamicObject)listConfigs.get(0);
        listingModel.set("id", (Object)String.valueOf(listingModelId));
        listingModel.set("modelname", (Object)listConfig.getString("tabname"));
        listingModel.set("listmodelid", (Object)listConfig.getDynamicObject("listmodel").getString("id"));
        String modelId = listConfig.getDynamicObject("listmodel").getString("id");
        String cmpRule = listConfig.getString("computerule");
        if ("00".equals(cmpRule)) {
            listingModel.set("cmptype", (Object)"(+)");
        } else if ("01".equals(cmpRule)) {
            listingModel.set("cmptype", (Object)"(-)");
        } else if ("02".equals(cmpRule)) {
            listingModel.set("cmptype", (Object)"(0)");
        }
        DynamicObjectCollection modelCol = new DynamicObjectCollection();
        modelCol.add((Object)listingModel);
        outContListing.set("listmodelentry", (Object)modelCol);
        DynamicObject[] listingArr = this.createListing(contId, modelId, curSupFinalDetailCol);
        List<DynamicObject> list = Arrays.asList(listingArr);
        double totalAmount = list.stream().collect(Collectors.summingDouble(obj -> {
            BigDecimal amt = obj.getBigDecimal("amount");
            if (amt == null || BigDecimal.ZERO.compareTo(amt) == 0) {
                return 0.0;
            }
            return amt.doubleValue();
        }));
        double totalTax = list.stream().collect(Collectors.summingDouble(obj -> {
            BigDecimal tax = obj.getBigDecimal("tax");
            if (tax == null || BigDecimal.ZERO.compareTo(tax) == 0) {
                return 0.0;
            }
            return tax.doubleValue();
        }));
        double totalOfTax = list.stream().collect(Collectors.summingDouble(obj -> {
            BigDecimal ofTax = obj.getBigDecimal("ofTax");
            if (ofTax == null || BigDecimal.ZERO.compareTo(ofTax) == 0) {
                return 0.0;
            }
            return ofTax.doubleValue();
        }));
        BigDecimal taxrate = contract.getDynamicObject("taxrate").getBigDecimal("taxrate");
        listingModel.set("totalamount", (Object)totalAmount);
        listingModel.set("totaltax", (Object)totalTax);
        listingModel.set("totaloftaxamount", (Object)totalOfTax);
        listingModel.set("rowtaxrate", (Object)taxrate);
        outContListing.set("conttaxrate", (Object)taxrate);
        outContListing.set("listtotalamount", (Object)totalAmount);
        outContListing.set("listtotaltax", (Object)totalTax);
        outContListing.set("listtotaloftax", (Object)totalOfTax);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{outContListing});
    }

    private DynamicObject[] createListing(String contId, String modelId, DynamicObjectCollection curSupFinalDetailCol) {
        MainEntityType listingDt = EntityMetadataCache.getDataEntityType((String)"ec_outlisting");
        DynamicObject[] listingArr = new DynamicObject[curSupFinalDetailCol.size()];
        for (int i = 0; i < curSupFinalDetailCol.size(); ++i) {
            DynamicObject listing;
            listingArr[i] = listing = new DynamicObject((DynamicObjectType)listingDt);
            listing.set("contract", (Object)contId);
            listing.set("listingmodel", (Object)modelId);
            listing.set("paydirection", (Object)"out");
            listing.set("status", (Object)"A");
            listing.set("enable", (Object)Character.valueOf('1'));
            DynamicObject entryInfo = (DynamicObject)curSupFinalDetailCol.get(i);
            DynamicObject material = entryInfo.getDynamicObject("lmaterialid");
            if (material != null) {
                String materialId = material.getString("id");
                QFilter filter = new QFilter("relationid", "=", (Object)materialId);
                DynamicObject resItem = BusinessDataServiceHelper.loadSingle((String)"ecbd_resourceitem", (String)"number", (QFilter[])new QFilter[]{filter});
                listing.set("resourceitem", (Object)resItem);
                listing.set("number", (Object)material.getString("number"));
                listing.set("name", (Object)material.getString("name"));
                listing.set("measureunit", (Object)material.getDynamicObject("baseunit"));
                listing.set("qty", (Object)entryInfo.getBigDecimal("lqty"));
                listing.set("totalqty", (Object)entryInfo.getBigDecimal("lqty"));
                listing.set("taxprice", (Object)entryInfo.getBigDecimal("linclutaxprice"));
                BigDecimal oneAddRate = BigDecimal.ONE.add(entryInfo.getBigDecimal("ltaxrate"));
                BigDecimal price = entryInfo.getBigDecimal("linclutaxprice").divide(oneAddRate, 4);
                listing.set("price", (Object)price);
                listing.set("curtaxprice", (Object)entryInfo.getBigDecimal("linclutaxprice"));
                listing.set("avgtaxprice", (Object)entryInfo.getBigDecimal("linclutaxprice"));
            } else if (entryInfo.getDynamicObject("lpurentryproject") != null) {
                listing.set("number", (Object)entryInfo.getDynamicObject("lpurentryproject").getString("number"));
                listing.set("name", (Object)entryInfo.getDynamicObject("lpurentryproject").getString("name"));
            }
            listing.set("currency", this.getCurrency());
            listing.set("amount", (Object)entryInfo.getBigDecimal("lexcepttaxamount"));
            listing.set("lstoftaxamount", (Object)entryInfo.getBigDecimal("linclutaxamount"));
            listing.set("tax", (Object)entryInfo.getBigDecimal("ltaxamount"));
            listing.set("oftax", (Object)entryInfo.getBigDecimal("linclutaxamount"));
            listing.set("taxrate", (Object)entryInfo.getBigDecimal("ltaxrate").multiply(BigDecimal.valueOf(100L)));
        }
        SaveServiceHelper.save((DynamicObject[])listingArr);
        return listingArr;
    }

    private String getTaxRateId(BigDecimal supplierTaxRate) {
        int rate = supplierTaxRate.multiply(BigDecimal.valueOf(100L)).setScale(0, 4).intValue();
        QFilter filter = new QFilter("taxrate", "=", (Object)rate);
        DynamicObject[] taxRateArr = BusinessDataServiceHelper.load((String)"ec_taxrate", (String)"number,name,taxrate", (QFilter[])new QFilter[]{filter});
        if (taxRateArr.length > 0) {
            return taxRateArr[0].getString("id");
        }
        MainEntityType taxRateDt = EntityMetadataCache.getDataEntityType((String)"ec_taxrate");
        ORM orm = ORM.create();
        Long taxRateId = orm.genLongId("ec_taxrate");
        DynamicObject taxRateInfo = new DynamicObject((DynamicObjectType)taxRateDt);
        taxRateInfo.set("id", (Object)String.valueOf(taxRateId));
        taxRateInfo.set("number", (Object)String.valueOf(rate));
        taxRateInfo.set("name", (Object)String.valueOf(rate));
        taxRateInfo.set("taxrate", (Object)(rate * 100));
        taxRateInfo.set("status", (Object)"C");
        taxRateInfo.set("enable", (Object)Character.valueOf('1'));
        taxRateInfo.set("taxrate", (Object)rate);
        taxRateInfo.set("creator", (Object)this.getPageCache().get("userId"));
        taxRateInfo.set("createtime", (Object)new Date());
        taxRateInfo.set("modifier", (Object)this.getPageCache().get("userId"));
        taxRateInfo.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taxRateInfo});
        return String.valueOf(taxRateId);
    }

    private Object getCurrency() {
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"name", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"BidDecisionContPlugin_7", (String)"scm-bid-formplugin", (Object[])new Object[0]))});
        return currency;
    }

    public static DynamicObjectType getEntryDynamicObjectType(String parentBillId, String entryId) {
        MainEntityType parentDT = EntityMetadataCache.getDataEntityType((String)parentBillId);
        DynamicObject parent = new DynamicObject((DynamicObjectType)parentDT);
        DynamicObjectType subDT = parent.getDynamicObjectCollection(entryId).getDynamicObjectType();
        return subDT;
    }
}

