/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidDocumentService;
import kd.scm.bid.business.bill.serviceImpl.BidDocumentServiceImpl;
import kd.scm.bid.business.util.BidUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.formplugin.bill.util.BidHistoryUtil;
import kd.scm.bid.formplugin.bill.util.OperationLogUtil;

public class BidDocumentListUI
extends AbstractListPlugin {
    private IBidDocumentService bidDocumentService = new BidDocumentServiceImpl();

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        if (StringUtils.isEmpty((CharSequence)viewhistory)) {
            filters.add(BidHistoryUtil.getDocumentListQFilter());
        } else {
            Object bidProjectId = parameter.getCustomParam("bidProjectId");
            filters.add(BidHistoryUtil.getDocumentHistoryQFilter(bidProjectId));
        }
        super.setFilter(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        Boolean enable = StringUtils.isNotEmpty((CharSequence)viewhistory);
        if (enable.booleanValue()) {
            List CommonFilter2 = args.getCommonFilterColumns();
            for (int i = 0; i < CommonFilter2.size(); ++i) {
                if (!"org.name".equals(((FilterColumn)CommonFilter2.get(i)).getFieldName())) continue;
                CommonFilter2.remove(i);
            }
            List SchemeFilterColumn = args.getSchemeFilterColumns();
            for (int i = 0; i < SchemeFilterColumn.size(); ++i) {
                if (!"org.name".equals(((FilterColumn)SchemeFilterColumn.get(i)).getFieldName())) continue;
                SchemeFilterColumn.remove(i);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        if (StringUtils.isNotEmpty((CharSequence)viewhistory)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbledit", "tbldel", "tblsubmit", "tblcheck", "tblrevise", "viewhistory", "lookproess"});
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columnList = args.getListColumns();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        Boolean enable = StringUtils.isNotEmpty((CharSequence)viewhistory);
        for (IListColumn item : columnList) {
            String fieldName = item.getListFieldKey();
            if ("modifytime".equals(fieldName)) {
                item.setVisible(enable != false ? 63 : 0);
            }
            if (!"listcurrentstep".equals(fieldName) && !"billstatus".equals(fieldName)) continue;
            item.setVisible(enable != false ? 0 : 63);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        BillList list = (BillList)this.getView().getControl("billlistap");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "doc");
        if ("edit".equals(key)) {
            ListSelectedRowCollection rows = list.getSelectedRows();
            if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidDocumentListUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (rows.size() == 1) {
                Long editId = (Long)rows.get(0).getPrimaryKeyValue();
                DynamicObject document = this.bidDocumentService.getBidDocumentById(editId, "id,billno,bidproject.id,billstatus");
                String billStatus = document.getString("billstatus");
                String billno = document.getString("billno");
                if (billno != null && !StringUtils.equals((CharSequence)billno, (CharSequence)"")) {
                    billno = billno + "\uff1a";
                }
                if (!billStatus.equals("D") && !billStatus.equals("A")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u53ea\u80fd\u7f16\u5236\u672a\u5f00\u59cb\u548c\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"BidDocumentListUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                    args.setCancel(true);
                    return;
                }
                this.getView().invokeOperation("modify");
            }
        } else if ("revise".equals(key)) {
            ListSelectedRowCollection rows = list.getSelectedRows();
            if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u4e66\u4fee\u8ba2\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidDocumentListUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.addLog(ResManager.loadKDString((String)"\u6807\u4e66\u4fee\u8ba2", (String)"BidDocumentListUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6807\u4e66\u4fee\u8ba2\u5931\u8d25\u3002", (String)"BidDocumentListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (rows.size() == 1) {
                String isRevise;
                Object id = rows.get(0).getPrimaryKeyValue();
                IListView view = (IListView)this.getView();
                DynamicObject before = this.bidDocumentService.getBidDocumentById((Long)id);
                Long projectId = before.getLong("bidproject.id");
                String projectName = before.getString("bidproject.name");
                ILocaleString bid = before.getLocaleString("biddocsummary");
                ILocaleString tech = before.getLocaleString("tech_biddocsummary");
                ILocaleString com = before.getLocaleString("com_biddocsummary");
                Long evaluate = before.getLong("evaluatedecideway.id");
                Long org = before.getLong("org.id");
                Boolean isSeperate = before.getBoolean("isseparatedoc");
                Long parent = before.getLong("id");
                Long bidfilenum = before.getLong("biddoc_num");
                Long techfilenum = before.getLong("tech_docnum");
                Long comfilenum = before.getLong("com_docnum");
                String billno = before.getString("billno");
                HashMap<String, String> reviseMap = new HashMap<String, String>();
                reviseMap.put("formId", this.getOpenFormId("biddocument_edit"));
                OperationStatus reviseStatus = OperationStatus.ADDNEW;
                FormShowParameter revisePara = BillShowParameter.createFormShowParameter(reviseMap);
                OpenStyle openStyle = revisePara.getOpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                revisePara.setCustomParam("billno", (Object)billno);
                revisePara.setCustomParam("isList", (Object)"true");
                if (billno != null && !StringUtils.equals((CharSequence)billno, (CharSequence)"")) {
                    billno = billno + "\uff1a";
                }
                if ((isRevise = this.bidDocumentService.checkReviseDocument((Long)id)) != null) {
                    this.getView().showTipNotification(billno + isRevise);
                    args.setCancel(true);
                    return;
                }
                DynamicObject[] bidDocObj = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidProject", "=", (Object)projectId)}, (String)"createtime desc");
                if (bidDocObj.length > 0 && !bidDocObj[0].getString("id").equals(id.toString())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879\uff1a%s\u6b63\u5728\u4fee\u8ba2\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u53d1\u8d77\u3002", (String)"BidDocumentListUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
                    args.setCancel(true);
                    return;
                }
                if (!before.getString("billstatus").equals(BillStatusEnum.AUDITED.getVal())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u6807\u4e66\u4fee\u8ba2\u3002", (String)"BidDocumentListUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                    this.addLog(ResManager.loadKDString((String)"\u6807\u4e66\u4fee\u8ba2", (String)"BidDocumentListUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6807\u4e66\u4fee\u8ba2\u5931\u8d25\u3002", (String)"BidDocumentListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Long currencyId = 0L;
                DynamicObject currency = before.getDynamicObject("currency");
                if (currency != null) {
                    currencyId = currency.getLong("id");
                }
                revisePara.setCustomParam("currency", (Object)currencyId);
                revisePara.setCustomParam("bidsum", (Object)bid.getLocaleValue());
                revisePara.setCustomParam("techsum", (Object)tech.getLocaleValue());
                revisePara.setCustomParam("comsum", (Object)com.getLocaleValue());
                revisePara.setCustomParam("bidproject", (Object)projectId);
                revisePara.setCustomParam("evaluatedecideway", (Object)evaluate);
                revisePara.setCustomParam("org", (Object)org);
                revisePara.setCustomParam("isseparatedoc", (Object)isSeperate);
                revisePara.setCustomParam("documentModify", (Object)Boolean.TRUE);
                revisePara.setCustomParam("parent", (Object)parent);
                revisePara.setCustomParam("biddoc_num", (Object)bidfilenum);
                revisePara.setCustomParam("tech_docnum", (Object)techfilenum);
                revisePara.setCustomParam("com_docnum", (Object)comfilenum);
                revisePara.setCustomParam("isrevise", (Object)Boolean.TRUE);
                revisePara.setStatus(reviseStatus);
                CloseCallBack closeCallBack2 = new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()));
                revisePara.setCloseCallBack(closeCallBack2);
                this.getView().showForm(revisePara);
            }
        } else if (!"submit".equals(key)) {
            if ("audit".equals(key)) {
                ListSelectedRowCollection rows = list.getSelectedRows();
                if (rows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u4e66\u5ba1\u6838\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidDocumentListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (rows.size() == 1) {
                    Object id = rows.get(0).getPrimaryKeyValue();
                    IListView view = (IListView)this.getView();
                    DynamicObject before = this.bidDocumentService.getBidDocumentById((Long)id);
                    Long projectId = before.getLong("bidproject.id");
                    DynamicObject decisionObj = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id,bidProject.name,billstatus", (QFilter[])new QFilter[]{new QFilter("bidProject", "=", (Object)projectId)});
                    if (decisionObj != null) {
                        String billstatus = decisionObj.getString("billstatus");
                        if (!BillStatusEnum.DISBEGIN.getVal().equals(billstatus) && !BillStatusEnum.INVALIDXX.getVal().equals(billstatus)) {
                            String projectName = ((DynamicObject)decisionObj.get("bidProject")).getString("name");
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879\uff1a%s\u5df2\u51c6\u5907\u5b9a\u6807\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u3002", (String)"BidDocumentListUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
                            args.setCancel(true);
                            return;
                        }
                    }
                }
            } else if ("unaudit".equals(key)) {
                ListSelectedRowCollection rows = list.getSelectedRows();
                if (rows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u4e66\u53cd\u5ba1\u6838\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidDocumentListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (rows.size() == 1) {
                    Object id = rows.get(0).getPrimaryKeyValue();
                    IListView view = (IListView)this.getView();
                    DynamicObject before = this.bidDocumentService.getBidDocumentById((Long)id);
                    Long projectId = before.getLong("bidproject.id");
                    DynamicObject[] bidDocColl = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidProject", "=", (Object)projectId)}, (String)"createtime desc");
                    if (bidDocColl.length > 0 && !bidDocColl[0].getString("id").equals(id.toString())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u65b0\u7684\u6807\u4e66\u7f16\u5236\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u539f\u5355\u636e\u3002", (String)"BidDocumentListUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    DynamicObject[] bidDocObj = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidProject", "=", (Object)projectId), new QFilter("id", "!=", id)}, (String)"  createtime desc");
                    if (bidDocObj.length > 0) {
                        DynamicObject old = bidDocObj[0];
                        old.set("billstatus", (Object)"C");
                        DynamicObject[] saveArr = new DynamicObject[]{old};
                        SaveServiceHelper.save((DynamicObject[])saveArr);
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        ListSelectedRow sr;
        Object id;
        DynamicObject document;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if ("viewhistory".equals(operateKey) && (document = this.bidDocumentService.getBidDocumentById((Long)(id = (sr = ((IListView)this.getView()).getCurrentSelectedRowInfo()).getPrimaryKeyValue()), "id,bidproject.id")) != null) {
            Object bidProjectId = document.get("bidproject.id");
            Boolean flag = BidHistoryUtil.haveDocumentHistory(this.getAppId(), bidProjectId);
            if (flag.booleanValue()) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("bidProjectId", bidProjectId);
                listShowParameter.setCustomParam("viewhistory", (Object)"viewhistory");
                listShowParameter.setMultiSelect(false);
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setStatus(OperationStatus.VIEW);
                listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"biddocument_history", ((Object)((Object)this)).getClass()));
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6807\u4e66\u4fee\u8ba2\u8bb0\u5f55\u3002", (String)"BidDocumentListUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"doc", (CharSequence)actionId)) {
            this.getModel().updateCache();
            this.getView().updateView("billlistap");
        } else if (StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()), (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("listcurrentstep".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            DynamicObject document = this.bidDocumentService.getBidDocumentById((Long)id, "id,bidproject.id");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getOpenFormId("projectprocess"));
            showParameter.setCustomParam("bidProjectId", document.get("bidproject.id"));
            showParameter.setCustomParam("showFormType", (Object)"bsbz");
            showParameter.setCustomParam("nowId", id);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "biddocument_edit": {
                return "bid_biddocument_edit";
            }
            case "projectprocess": {
                return "bid_projectprocess";
            }
        }
        return null;
    }

    private void addLog(String operation, String tip) {
        LogServiceHelper logServiceHelper = new LogServiceHelper();
        AppLogInfo appLogInfo = OperationLogUtil.buildLogInfo(operation, tip, this.getAppId(), this.getView().getEntityId());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    private String getAppId() {
        String formID = ((IListView)this.getView()).getBillFormId();
        return BidUtils.getAppID((String)formID);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        if (StringUtils.isEmpty((CharSequence)viewhistory)) {
            args.setListDataProvider((IListDataProvider)new MyListDataProvider());
        } else {
            args.setListDataProvider((IListDataProvider)new MyListHisDataProvider());
        }
    }

    static class MyListHisDataProvider
    extends ListDataProvider {
        MyListHisDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            for (DynamicObject row : rows) {
                row.set("bidprojectname", (Object)row.getString("bidproject.name"));
                row.set("listcurrentstep", row.get("bidproject.currentstep"));
            }
            return rows;
        }
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            for (DynamicObject row : rows) {
                String billstatus = row.getString("billstatus");
                String currentstep = row.getString("bidproject.currentstep");
                if (billstatus.equals(BillStatusEnum.SAVE.getVal()) || billstatus.equals(BillStatusEnum.SUBMIT.getVal())) {
                    if (currentstep.contains("Clarificaiton")) {
                        row.set("listcurrentstep", (Object)",BidDocument,Clarificaiton,");
                    } else {
                        row.set("listcurrentstep", (Object)",BidDocument,");
                    }
                } else {
                    row.set("listcurrentstep", (Object)row.getString("bidproject.currentstep"));
                }
                Object id = row.getPkValue();
                DynamicObject newDoc = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "=", id)});
                String bidprojectName = row.getString("bidproject.name");
                if (newDoc != null) {
                    if (bidprojectName == null) continue;
                    bidprojectName = bidprojectName + ResManager.loadKDString((String)"\uff08\u4fee\u8ba2\u4e2d\uff09", (String)"BidDocumentListUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                    row.set("bidprojectname", (Object)bidprojectName);
                    continue;
                }
                row.set("bidprojectname", (Object)bidprojectName);
            }
            return rows;
        }
    }
}

