/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.IBidSupplierFileService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidSupplierFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.enums.ScoreMethod;
import kd.scm.bid.common.enums.ScoreType;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.BidBillEdit;
import kd.scm.bid.formplugin.bill.BidEvaluationScoreList;
import kd.scm.bid.formplugin.bill.util.BidEvaluationUtil;
import kd.scm.bid.formplugin.bill.util.BidHistoryUtil;
import kd.scm.bid.formplugin.bill.util.ExpertGradingUtil;
import kd.scm.bid.formplugin.bill.util.QuestionClarifyUtil;
import kd.scm.bid.formplugin.bill.util.SupplierInvalUtil;
import kd.scm.bid.formplugin.bill.util.TenderGradingUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidEvaluationEdit
extends BidBillEdit
implements RowClickEventListener,
CellClickListener {
    protected BidEvaluationUtil bidEvaluationUtil = new BidEvaluationUtil();
    protected IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    protected QuestionClarifyUtil questionClarifyUtil = new QuestionClarifyUtil();
    protected IBidSupplierFileService bidSupplierFileService = new BidSupplierFileServiceImpl();
    public static final String TECHNICAL = "TECHNICAL";
    public static final String BUSSINESS = "BUSSINESS";
    public static final String MULTI = "MULTI";
    protected static String BTN_QUESTION_CLARIFY = "btn_question_clarify";
    protected static String QUESTIONCLARIFY = "questionclarify";
    protected static String QUESTIONCLARIFYLIST = "questionclarifylist";

    protected String getAppId() {
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        return appName;
    }

    public void beforeBindData(EventObject e) {
        String status;
        super.beforeBindData(e);
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewhistory"});
        }
        if (StringUtils.equals((CharSequence)(status = (String)this.getModel().getValue("billstatus")), (CharSequence)BillStatusEnum.INVALID.getVal())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rebackbid", "bar_submit", "bar_unsubmit", "bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bidevalrpttmpl"});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        BillShowParameter billShowParameter;
        String bidEvaluationId;
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)operationStatus) && StringUtils.isNotEmpty((CharSequence)(bidEvaluationId = (billShowParameter = (BillShowParameter)formShowParameter).getPkId().toString()))) {
            DynamicObject bidEvaluation = this.bidEvaluationService.getBidEvaluation(Long.valueOf(bidEvaluationId));
            String billStatus = bidEvaluation.getString("billstatus");
            if (BillStatusEnum.AUDITING.getVal().equals(billStatus)) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("bidsection");
        sectionEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("evaltendersection");
        sectionGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid bidsectionenrollSectionGrid = (EntryGrid)this.getView().getControl("bidsectionenroll");
        bidsectionenrollSectionGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel dataModel = this.getModel();
        String scoreMethod = (String)dataModel.getValue("scoremethod");
        if (ScoreMethod.SPECIAL.getVal().equals(scoreMethod)) {
            this.changeEvalCtlTipsBySpecial();
        }
        this.setTenderInfoEntry();
        this.clickFristRows();
        String viewSource = (String)this.getView().getFormShowParameter().getCustomParam("viewSource");
        if ("bid_decision".equals(viewSource)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_print", "bar_modify"});
        }
        boolean isOnlineEval = (Boolean)dataModel.getValue("isonlineeval");
        String scoretype = (String)dataModel.getValue("scoretype");
        if (isOnlineEval && ScoreType.SUM.getVal().equals(scoretype)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"techweight"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"commweight"});
        }
    }

    protected void clickFristRows() {
        int BidsectionenrollRowCount;
        int sectionTenderRowCount;
        IDataModel dataModel = this.getModel();
        int sectionRowCount = dataModel.getEntryRowCount("bidsection");
        if (sectionRowCount > 0) {
            EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("bidsection");
            sectionEntryGrid.addRowClickListener((RowClickEventListener)this);
            sectionEntryGrid.selectRows(0, true);
            sectionEntryGrid.entryRowClick(Integer.valueOf(0));
        }
        if ((sectionTenderRowCount = dataModel.getEntryRowCount("evaltendersection")) > 0) {
            EntryGrid tenderSectionEntryGrid = (EntryGrid)this.getControl("evaltendersection");
            tenderSectionEntryGrid.addRowClickListener((RowClickEventListener)this);
            tenderSectionEntryGrid.selectRows(0, true);
            tenderSectionEntryGrid.entryRowClick(Integer.valueOf(0));
        }
        if ((BidsectionenrollRowCount = dataModel.getEntryRowCount("bidsectionenroll")) > 0) {
            EntryGrid BidsectionenrollEntryGrid = (EntryGrid)this.getControl("bidsectionenroll");
            BidsectionenrollEntryGrid.addRowClickListener((RowClickEventListener)this);
            BidsectionenrollEntryGrid.selectRows(0, true);
            BidsectionenrollEntryGrid.entryRowClick(Integer.valueOf(0));
        }
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        String evalType;
        int BidsectionenrollRowCount;
        int rowIndex;
        super.entryRowClick(evt);
        IDataModel dataModel = this.getModel();
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String appId = this.getAppId();
        if ("bidsectionenroll".equals(entryGrid.getKey())) {
            int sectionTenderRowCount;
            rowIndex = evt.getRow();
            int sectionRowCount = dataModel.getEntryRowCount("bidsection");
            if (sectionRowCount > 0) {
                EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("bidsection");
                sectionEntryGrid.entryRowClick(Integer.valueOf(rowIndex));
                sectionEntryGrid.selectRows(rowIndex, true);
            }
            if ((sectionTenderRowCount = dataModel.getEntryRowCount("evaltendersection")) > 0) {
                EntryGrid tenderSectionEntryGrid = (EntryGrid)this.getControl("evaltendersection");
                tenderSectionEntryGrid.selectRows(rowIndex, true);
                tenderSectionEntryGrid.entryRowClick(Integer.valueOf(rowIndex));
            }
        }
        if ("bidsection".equals(entryGrid.getKey())) {
            rowIndex = evt.getRow();
            BidsectionenrollRowCount = dataModel.getEntryRowCount("bidsectionenroll");
            if (BidsectionenrollRowCount > 0) {
                EntryGrid BidsectionenrollEntryGrid = (EntryGrid)this.getControl("bidsectionenroll");
                BidsectionenrollEntryGrid.selectRows(rowIndex, true);
            }
            DynamicObject evalProject = dataModel.getDataEntity();
            evalType = evalProject.getString("evaltype");
            Object bidProjectId = evalProject.getDynamicObject("bidproject").getPkValue();
            DynamicObject section = dataModel.getEntryRowEntity("bidsection", rowIndex);
            if (section != null) {
                String cacheExpertGradingCollStr;
                DynamicObject decide;
                Long sectionId = section.getLong("id");
                String sectionName = section.getString("sectionname");
                String cacheSectionId = this.getPageCache().get("sectionId");
                if (cacheSectionId != null) {
                    String isRefresh = this.getView().getPageCache().get("isRefresh");
                    if (cacheSectionId.equals(sectionId.toString()) && StringUtils.isEmpty((CharSequence)isRefresh)) {
                        return;
                    }
                    this.getView().getPageCache().put("isRefresh", null);
                    String childPageId = this.getPageCache().get("childPageId");
                    IFormView childFormView = this.getView().getView(childPageId);
                    try {
                        DynamicObjectCollection expertGradingColl = childFormView.getModel().getEntryEntity("expertgrading");
                        this.getPageCache().put(cacheSectionId, SerializationUtils.toJsonString((Object)expertGradingColl));
                    }
                    catch (Exception e) {
                        return;
                    }
                    childFormView.close();
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setParentFormId(this.getModel().getDataEntity().getPkValue().toString());
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.InContainer);
                openStyle.setTargetKey("expertgradingap");
                formShowParameter.setOpenStyle(openStyle);
                formShowParameter.setFormId(this.getOpenFormId("expertgrading"));
                Object id = dataModel.getValue("id");
                long bidopenid = evalProject.getLong("bidopenid");
                DynamicObject bidOpen = null;
                if (bidopenid != 0L) {
                    bidOpen = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"isonlineeval,scoretype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidopenid)});
                } else {
                    DynamicObject bidproject = evalProject.getDynamicObject("bidproject");
                    bidOpen = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"isonlineeval,scoretype", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidproject.getPkValue()), new QFilter("billstatus", "!=", (Object)"XX")});
                }
                if (bidOpen == null) {
                    formShowParameter.setCustomParam("weightScoreVisiable", (Object)Boolean.TRUE);
                } else {
                    boolean isonlineeval = bidOpen.getBoolean("isonlineeval");
                    String scoretype = bidOpen.getString("scoretype");
                    if (isonlineeval && "sum".equals(scoretype)) {
                        formShowParameter.setCustomParam("weightScoreVisiable", (Object)Boolean.FALSE);
                    } else {
                        formShowParameter.setCustomParam("weightScoreVisiable", (Object)Boolean.TRUE);
                    }
                }
                formShowParameter.setCustomParam("bidEvaluationId", id);
                formShowParameter.setCustomParam("sectionId", (Object)sectionId);
                formShowParameter.setCustomParam("opensrcsectionid", (Object)section.getLong("opensrcsectionid"));
                formShowParameter.setCustomParam("isOnlineEval", dataModel.getValue("isonlineeval"));
                formShowParameter.setCustomParam("evalType", (Object)evalType);
                DynamicObject[] load = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"bidsection,sectionname", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
                if (load != null && load.length > 1) {
                    DynamicObject BidProject = evalProject.getDynamicObject("bidproject");
                    String openType = BidProject.getString("bidopentype");
                    if (openType.equals(BidOpenSelectTypeEnum.TECHBUSINESS.getValue())) {
                        if (StringUtils.equals((CharSequence)BUSSINESS, (CharSequence)evalType)) {
                            formShowParameter.setCustomParam("hasTwo", (Object)"true");
                            DynamicObject[] businessLoads = null;
                            if (StringUtils.equals((CharSequence)"XX", (CharSequence)evalProject.getString("billstatus"))) {
                                String listrounds = evalProject.getString("listrounds");
                                businessLoads = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"bidsection,sectionname,listrounds", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("evaltype", "=", (Object)TECHNICAL), new QFilter("listrounds", "=", (Object)listrounds)}, (String)"id desc", (int)1);
                            }
                            if (businessLoads == null || businessLoads.length == 0) {
                                businessLoads = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"bidsection,sectionname", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("evaltype", "=", (Object)TECHNICAL)}, (String)"id desc", (int)1);
                            }
                            if (businessLoads != null && businessLoads.length > 0) {
                                DynamicObjectCollection thisBidSection = businessLoads[0].getDynamicObjectCollection("bidsection");
                                for (DynamicObject sectionNameAndId : thisBidSection) {
                                    if (!StringUtils.equals((CharSequence)sectionName, (CharSequence)sectionNameAndId.getString("sectionname"))) continue;
                                    formShowParameter.setCustomParam("secondSectionId", sectionNameAndId.getPkValue());
                                }
                            }
                        }
                    } else if (openType.equals(BidOpenSelectTypeEnum.BUSSINESSTECH.getValue()) && StringUtils.equals((CharSequence)TECHNICAL, (CharSequence)evalType)) {
                        formShowParameter.setCustomParam("hasTwo", (Object)"true");
                        for (DynamicObject eval : load) {
                            if (eval.getPkValue().equals(id)) continue;
                            DynamicObjectCollection thisBidSection = eval.getDynamicObjectCollection("bidsection");
                            for (DynamicObject sectionNameAndId : thisBidSection) {
                                if (!StringUtils.equals((CharSequence)sectionName, (CharSequence)sectionNameAndId.getString("sectionname"))) continue;
                                formShowParameter.setCustomParam("secondSectionId", sectionNameAndId.getPkValue());
                            }
                        }
                    }
                }
                if ((decide = (DynamicObject)this.getModel().getValue("evaluatedecideway")) != null) {
                    String nameCh;
                    Lang lang = RequestContext.get().getLang();
                    if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                        nameCh = decide.getLocaleString("name").getLocaleValue_en();
                        if (StringUtils.equals((CharSequence)nameCh, (CharSequence)"Comprehensive scoring method")) {
                            formShowParameter.setCustomParam("evaluatedecideway", (Object)"true");
                        }
                    } else {
                        nameCh = decide.getLocaleString("name").getLocaleValue_zh_CN();
                        if (!StringUtils.equals((CharSequence)nameCh, (CharSequence)ResManager.loadKDString((String)"\u7efc\u5408\u8bc4\u5206\u6cd5", (String)"BidEvaluationEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]))) {
                            formShowParameter.setCustomParam("evaluatedecideway", (Object)"true");
                        }
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(cacheExpertGradingCollStr = this.getPageCache().get(sectionId.toString())))) {
                    formShowParameter.setCustomParam("cacheData", (Object)cacheExpertGradingCollStr);
                }
                String billstatus = (String)dataModel.getValue("billstatus");
                if (BillStatusEnum.DISBEGIN.getVal().equals(billstatus) || BillStatusEnum.SAVE.getVal().equals(billstatus)) {
                    if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                        formShowParameter.setStatus(OperationStatus.VIEW);
                    } else {
                        formShowParameter.setStatus(OperationStatus.EDIT);
                    }
                } else {
                    formShowParameter.setStatus(OperationStatus.VIEW);
                }
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bid_expertgrading"));
                this.getView().showForm(formShowParameter);
                String pageId = formShowParameter.getPageId();
                this.getPageCache().put("childPageId", pageId);
                this.getPageCache().put("sectionId", sectionId.toString());
            }
        } else if ("evaltendersection".equals(entryGrid.getKey())) {
            rowIndex = evt.getRow();
            BidsectionenrollRowCount = dataModel.getEntryRowCount("bidsectionenroll");
            if (BidsectionenrollRowCount > 0) {
                EntryGrid BidsectionenrollEntryGrid = (EntryGrid)this.getControl("bidsectionenroll");
                BidsectionenrollEntryGrid.selectRows(rowIndex, true);
            }
            DynamicObject dataEntity = dataModel.getDataEntity(true);
            evalType = dataEntity.getString("evaltype");
            DynamicObject section = dataModel.getEntryRowEntity("evaltendersection", rowIndex);
            if (section != null) {
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getDynamicObject("bidproject").getPkValue(), (String)(appId + "_project"));
                String sectionName = section.getString("evalsectionname");
                Long sectionId = section.getLong("id");
                Long openSectionId = section.getLong("opensectionid");
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setParentFormId(this.getModel().getDataEntity().getPkValue().toString());
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.InContainer);
                openStyle.setTargetKey("tendergradingap");
                formShowParameter.setOpenStyle(openStyle);
                String formid = appId + "_tendergrading";
                formShowParameter.setFormId(formid);
                String cacheTenderGradingCollStr = this.getPageCache().get(sectionId.toString());
                if (StringUtils.isNotEmpty((CharSequence)cacheTenderGradingCollStr)) {
                    formShowParameter.setCustomParam("cacheData", (Object)cacheTenderGradingCollStr);
                }
                formShowParameter.setCustomParam("bidEvaluationId", dataModel.getValue("id"));
                formShowParameter.setCustomParam("openSectionId", (Object)openSectionId);
                formShowParameter.setCustomParam("sectionName", (Object)sectionName);
                formShowParameter.setCustomParam("isOnlineEval", dataModel.getValue("isonlineeval"));
                formShowParameter.setCustomParam("evalType", (Object)evalType);
                formShowParameter.setCustomParam("appId", (Object)appId);
                formShowParameter.setCustomParam("bidOpenId", dataModel.getValue("bidopenid"));
                formShowParameter.setCustomParam("bidProject", bidProject.getPkValue());
                formShowParameter.setCustomParam("bidtype", (Object)bidProject.getInt("bidtype"));
                formShowParameter.setCustomParam("isRateBidding", (Object)bidProject.getBoolean("isratebidding"));
                formShowParameter.setCustomParam("isMaterialPur", (Object)bidProject.getBoolean("ismaterialpur"));
                formShowParameter.setCustomParam("enableMultiSection", (Object)bidProject.getBoolean("enablemultisection"));
                formShowParameter.setCustomParam("selectSectionRow", (Object)rowIndex);
                formShowParameter.setCustomParam("evaluatedMethod", dataModel.getValue("evaluatedmethod"));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bid_tendergrading"));
                this.getView().showForm(formShowParameter);
                String pageId = formShowParameter.getPageId();
                this.getPageCache().put("tenderGradingChildPageId", pageId);
            }
        }
    }

    @Override
    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        this.setListPriceComparisonVisible();
        this.setQuestionClarifyBtnLook();
        this.controlListBtnStatus();
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        String docType = bidProject.getString("doctype");
        if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"commweight"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"techweight"});
        }
        this.setSectionEntryVisible();
        this.setAdvconapAndTenderInfoVisiable();
        EntryGrid tenderSectionEntryGrid = (EntryGrid)this.getControl("evaltendersection");
        tenderSectionEntryGrid.selectRows(0, true);
        this.getView().getModel().setDataChanged(false);
    }

    public void setAdvconapAndTenderInfoVisiable() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        if (BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1", "techweight", "commweight", "scoremethod", "evaluatedecideway"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tenderinfo"});
        } else if (BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tenderinfo"});
        } else if (BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap1", "tenderinfo"});
        }
    }

    protected void controlListBtnStatus() {
        DynamicObject src = this.getModel().getDataEntity();
        String billStatus = src.getString("billstatus");
        IFormView view = this.getView();
        if (BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_del"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
        }
        if (BillStatusEnum.SAVE.getVal().equals(billStatus) || BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) {
            view.setEnable(Boolean.TRUE, new String[]{"btn_question_clarify"});
        } else {
            view.setEnable(Boolean.FALSE, new String[]{"btn_question_clarify"});
        }
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_question_clarify"});
        }
    }

    public void setTenderInfoEntry() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection evalSectionCol = dataEntity.getDynamicObjectCollection("evaltendersection");
        Long bidOpenId = dataEntity.getLong("bidopenid");
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
        DynamicObjectCollection bidOpenSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
        HashMap<String, DynamicObjectCollection> purDetailMap = new HashMap<String, DynamicObjectCollection>();
        for (DynamicObject bidOpenSection : bidOpenSectionCol) {
            DynamicObjectCollection purDetails = bidOpenSection.getDynamicObjectCollection("supplierdetail");
            if (CollectionUtils.isEmpty((Collection)purDetails)) continue;
            purDetailMap.put(bidOpenSection.getString("id"), purDetails);
        }
        if (CollectionUtils.isEmpty((Collection)evalSectionCol) || evalSectionCol.size() == 0) {
            for (DynamicObject bidOpenSection : bidOpenSectionCol) {
                DynamicObject evalSection = evalSectionCol.addNew();
                evalSection.set("seq", bidOpenSection.get("seq"));
                evalSection.set("evalsectionname", bidOpenSection.get("sectionname"));
                evalSection.set("opensectionid", (Object)bidOpenSection.getLong("id"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        }
        for (DynamicObject evalSection : evalSectionCol) {
            String key = evalSection.getString("opensectionid");
            DynamicObjectCollection purDetails = (DynamicObjectCollection)purDetailMap.get(key);
            DynamicObjectCollection evalSupplierDetailCol = evalSection.getDynamicObjectCollection("supplierdetail");
            evalSupplierDetailCol.clear();
            if (purDetails == null || purDetails.size() <= 0) continue;
            for (int k = 0; k < purDetails.size(); ++k) {
                DynamicObject supplierDetailRow = (DynamicObject)purDetails.get(k);
                DynamicObject evalSupplierDetail = evalSupplierDetailCol.addNew();
                evalSupplierDetail.set("pursupplier", (Object)supplierDetailRow.getDynamicObject("pursupplier"));
                evalSupplierDetail.set("purentrycontent", (Object)supplierDetailRow.getString("purentrycontent"));
                evalSupplierDetail.set("purentryproject", (Object)supplierDetailRow.getDynamicObject("purentryproject"));
                evalSupplierDetail.set("materialid", (Object)supplierDetailRow.getDynamicObject("materialid"));
                evalSupplierDetail.set("baseunit", (Object)supplierDetailRow.getDynamicObject("baseunit"));
                evalSupplierDetail.set("materialdes", (Object)supplierDetailRow.getString("materialdes"));
                evalSupplierDetail.set("qty", (Object)supplierDetailRow.getBigDecimal("qty"));
                evalSupplierDetail.set("inclutaxprice", (Object)supplierDetailRow.getBigDecimal("inclutaxprice"));
                evalSupplierDetail.set("inclutaxamount", (Object)supplierDetailRow.getBigDecimal("inclutaxamount"));
                evalSupplierDetail.set("bd_taxrate", supplierDetailRow.get("bd_taxrate"));
                evalSupplierDetail.set("taxrate", (Object)supplierDetailRow.getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                evalSupplierDetail.set("taxamount", (Object)supplierDetailRow.getBigDecimal("taxamount"));
                evalSupplierDetail.set("excepttaxamount", (Object)supplierDetailRow.getBigDecimal("excepttaxamount"));
                evalSupplierDetail.set("costrate", (Object)supplierDetailRow.getBigDecimal("costrate").multiply(new BigDecimal("100")));
                if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getAppId())) continue;
                evalSupplierDetail.set("listnumber", supplierDetailRow.get("listnumber"));
                evalSupplierDetail.set("listname", supplierDetailRow.get("listname"));
                evalSupplierDetail.set("resourceitem", supplierDetailRow.get("resourceitem"));
            }
        }
        String evalType = dataEntity.getString("evaltype");
        DynamicObject[] clarifyDataArray = this.getQuestionClarify(dataEntity.getPkValue(), this.getAppId(), evalType);
        if (clarifyDataArray != null && clarifyDataArray.length > 0) {
            this.setClarifyNewDataToSupplierEntry(dataEntity, clarifyDataArray);
        }
        this.getView().updateView("evaltendersection");
        if (evalSectionCol.size() > 0) {
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex("evaltendersection", 0);
        }
    }

    public void setClarifyNewDataToSupplierEntry(DynamicObject dataEntity, DynamicObject[] clarifyDataArray) {
        DynamicObjectCollection evalTenderSectionCol = dataEntity.getDynamicObjectCollection("evaltendersection");
        HashMap<String, DynamicObject> supplierDetailMap = new HashMap<String, DynamicObject>();
        for (DynamicObject clarifyData : clarifyDataArray) {
            DynamicObjectCollection clarifyBidSectionCol = clarifyData.getDynamicObjectCollection("bidsection");
            for (DynamicObject clarifyBidSection : clarifyBidSectionCol) {
                String clarifySectionName = clarifyBidSection.getString("sectionname");
                DynamicObjectCollection clarifySupplierDetailCol = clarifyBidSection.getDynamicObjectCollection("supplierdetail");
                for (DynamicObject supplierDetail : clarifySupplierDetailCol) {
                    DynamicObject supplier = supplierDetail.getDynamicObject("pursupplier");
                    DynamicObject biddingDetailMaterial = supplierDetail.getDynamicObject("materialid");
                    if (supplier == null) continue;
                    String purEntryContent = supplierDetail.getString("purentrycontent");
                    if (StringUtils.isBlank((CharSequence)purEntryContent) || "null".equals(purEntryContent)) {
                        purEntryContent = "";
                    }
                    StringBuilder supplierDetailKey = new StringBuilder(clarifySectionName);
                    supplierDetailKey.append(supplier.getString("id"));
                    supplierDetailKey.append('_');
                    supplierDetailKey.append(purEntryContent);
                    supplierDetailKey.append('_');
                    supplierDetailKey.append(biddingDetailMaterial == null ? "" : biddingDetailMaterial.getPkValue().toString());
                    supplierDetailKey.append('_');
                    supplierDetailKey.append(supplierDetail.getDynamicObject("purentryproject") == null ? "" : supplierDetail.getDynamicObject("purentryproject").getString("id"));
                    supplierDetailKey.append('_');
                    supplierDetailKey.append(supplierDetail.getString("materialdes") == null ? "" : supplierDetail.getString("materialdes"));
                    if ("rebm".equals(this.getAppId())) {
                        supplierDetailKey.append('_');
                        supplierDetailKey.append(supplierDetail.getDynamicObject("resourceitem") == null ? "" : supplierDetail.getDynamicObject("resourceitem").getPkValue().toString());
                    }
                    supplierDetailMap.put(supplierDetailKey.toString(), supplierDetail);
                }
            }
        }
        for (DynamicObject evalTenderSection : evalTenderSectionCol) {
            String sectionName = evalTenderSection.getString("evalsectionname");
            DynamicObjectCollection supplierDetailList = evalTenderSection.getDynamicObjectCollection("supplierdetail");
            for (DynamicObject supplierDetail : supplierDetailList) {
                DynamicObject clarifySupplierDetail;
                DynamicObject supplier = supplierDetail.getDynamicObject("pursupplier");
                DynamicObject biddingDetailMaterial = supplierDetail.getDynamicObject("materialid");
                if (supplier == null) continue;
                String purEntryContent = supplierDetail.getString("purentrycontent");
                if (StringUtils.isBlank((CharSequence)purEntryContent) || "null".equals(purEntryContent)) {
                    purEntryContent = "";
                }
                StringBuilder supplierDetailKey = new StringBuilder(sectionName);
                supplierDetailKey.append(supplier.getString("id"));
                supplierDetailKey.append('_');
                supplierDetailKey.append(purEntryContent);
                supplierDetailKey.append('_');
                supplierDetailKey.append((biddingDetailMaterial == null ? "" : biddingDetailMaterial.getPkValue()).toString());
                supplierDetailKey.append('_');
                supplierDetailKey.append(supplierDetail.getDynamicObject("purentryproject") == null ? "" : supplierDetail.getDynamicObject("purentryproject").getString("id"));
                supplierDetailKey.append('_');
                supplierDetailKey.append(supplierDetail.getString("materialdes") == null ? "" : supplierDetail.getString("materialdes"));
                if ("rebm".equals(this.getAppId())) {
                    supplierDetailKey.append('_');
                    supplierDetailKey.append(supplierDetail.getDynamicObject("resourceitem") == null ? "" : supplierDetail.getDynamicObject("resourceitem").getPkValue().toString());
                }
                if ((clarifySupplierDetail = (DynamicObject)supplierDetailMap.get(supplierDetailKey.toString())) == null) continue;
                this.updateSupplierDetail(clarifySupplierDetail, supplierDetail);
            }
        }
    }

    public DynamicObject[] getQuestionClarify(Object bidEvaluationId, String appId, String openType) {
        QFilter clarifyTypeFilter = null;
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(openType)) {
            clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(openType)) {
            clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
        }
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
        QFilter reSubMissTendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        QFilter bidEvaluationFilter = new QFilter("bidevaluationid", "=", bidEvaluationId);
        StringBuilder selectProper = new StringBuilder("id,submitdate,tenderprice,pricevat,tax,notaxtenderprice,rate,bidsection,bidsection.sectionname,clarifysupplier,clarifytype,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate,supplierdetail.bd_taxrate");
        if ("rebm".equals(this.getAppId())) {
            selectProper.append(",supplierdetail.resourceitem");
        }
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)(appId + "_questionclarify"), (String)selectProper.toString(), (QFilter[])new QFilter[]{bidEvaluationFilter, billStatusFilter, clarifyTypeFilter, reSubMissTendersFilter}, (String)"submitdate asc");
        return dataArray;
    }

    public void updateSupplierDetail(DynamicObject clarifySupplierDetail, DynamicObject supplierDetail) {
        supplierDetail.set("inclutaxprice", (Object)clarifySupplierDetail.getBigDecimal("inclutaxprice"));
        supplierDetail.set("inclutaxamount", (Object)clarifySupplierDetail.getBigDecimal("inclutaxamount"));
        supplierDetail.set("taxrate", (Object)clarifySupplierDetail.getBigDecimal("taxrate").multiply(new BigDecimal(100)));
        supplierDetail.set("taxamount", clarifySupplierDetail.get("taxamount"));
        supplierDetail.set("excepttaxamount", (Object)clarifySupplierDetail.getBigDecimal("excepttaxamount"));
        supplierDetail.set("costrate", (Object)clarifySupplierDetail.getBigDecimal("costrate").multiply(new BigDecimal(100)));
        supplierDetail.set("bd_taxrate", clarifySupplierDetail.get("bd_taxrate"));
    }

    public void cellClick(CellClickEvent arg0) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void setQuestionClarifyBtnLook() {
        String billstatus = (String)this.getModel().getValue("billstatus");
        if ("X".equals(billstatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_QUESTION_CLARIFY});
        }
    }

    protected void setListPriceComparisonVisible() {
        int j;
        this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
        DynamicObject bideValuation = this.getModel().getDataEntity();
        String evalType = bideValuation.getString("evaltype");
        if (evalType.equals(TECHNICAL)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        RequestContext requestContext = RequestContext.get();
        String userName = requestContext.getUserName();
        DynamicObject bidProject = bideValuation.getDynamicObject("bidproject");
        Long bidProjectPk = (Long)bidProject.getPkValue();
        boolean isAdmin = CommonUtil.isBidAdmin((String)this.getAppId(), (Long)RequestContext.get().getCurrUserId());
        if (isAdmin) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
            return;
        }
        DynamicObject bidProjectColl = BusinessDataServiceHelper.loadSingle((Object)bidProjectPk, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"memberentity,user,respbusiness,isdirector,memberleaderentity,userleader,respbusinessleader");
        DynamicObjectCollection memberEntityColl = bidProjectColl.getDynamicObjectCollection("memberentity");
        for (int i = 0; i < memberEntityColl.size(); ++i) {
            DynamicObject memberEntity = (DynamicObject)memberEntityColl.get(i);
            DynamicObject user = memberEntity.getDynamicObject("user");
            Long userPk = (Long)user.getPkValue();
            String respBussiness = memberEntity.getString("respbusiness");
            String[] resupBussinessList = respBussiness.split(",");
            Boolean idDirector = memberEntity.getBoolean("isdirector");
            if (idDirector.booleanValue() && userPk.compareTo(userId) == 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                return;
            }
            for (j = 0; j < resupBussinessList.length; ++j) {
                if (!resupBussinessList[j].equals("07") && !resupBussinessList[j].equals("14") || userPk.compareTo(userId) != 0) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                return;
            }
        }
        DynamicObjectCollection memberleaderentityColl = bidProjectColl.getDynamicObjectCollection("memberleaderentity");
        for (int i = 0; i < memberleaderentityColl.size(); ++i) {
            DynamicObject memberleaderentity = (DynamicObject)memberleaderentityColl.get(i);
            DynamicObject user = memberleaderentity.getDynamicObject("userleader");
            Long userPk = (Long)user.getPkValue();
            String respbusinessleader = memberleaderentity.getString("respbusinessleader");
            String[] respbusinessleaderList = respbusinessleader.split(",");
            for (j = 0; j < respbusinessleaderList.length; ++j) {
                if (!respbusinessleaderList[j].equals("07") && !respbusinessleaderList[j].equals("14") || userPk.compareTo(userId) != 0) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                return;
            }
        }
        DynamicObject open = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"opentype,bidopen_proficient,proficient,proficient_commercial", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectPk), new QFilter("opentype", "=", (Object)evalType)});
        if (open == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
        } else {
            DynamicObjectCollection proFicientColl = open.getDynamicObjectCollection("bidopen_proficient");
            for (int i = 0; i < proFicientColl.size(); ++i) {
                DynamicObject proFicient = (DynamicObject)proFicientColl.get(i);
                DynamicObject proficient = (DynamicObject)proFicient.get("proficient");
                long proficientPk = (Long)proficient.getPkValue();
                DynamicObject bidProficient = BusinessDataServiceHelper.loadSingle((Object)proficientPk, (String)FormTypeConstants.getFormConstant((String)"proficient", ((Object)((Object)this)).getClass()), (String)"proficientname,name");
                if (bidProficient == null) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
                    return;
                }
                DynamicObject prficientName = bidProficient.getDynamicObject("proficientname");
                String name = bidProficient.getString("name");
                if (prficientName == null) {
                    if (StringUtils.equals((CharSequence)name, (CharSequence)userName)) {
                        Boolean idCommerical = proFicient.getBoolean("proficient_commercial");
                        if (idCommerical.booleanValue()) {
                            this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                        } else {
                            this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
                        }
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
                    }
                    return;
                }
                Long prificientPk = (Long)prficientName.getPkValue();
                if (prificientPk.compareTo(userId) != 0) continue;
                Boolean idCommerical = proFicient.getBoolean("proficient_commercial");
                if (idCommerical.booleanValue()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                    return;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setWeightVisible() {
        String nameCh;
        DynamicObject decide = (DynamicObject)this.getModel().getValue("evaluatedecideway");
        if (decide == null) return;
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang)) {
            if (!Lang.zh_TW.equals((Object)lang)) {
                String nameCh2 = decide.getLocaleString("name").getLocaleValue_en();
                if (StringUtils.equals((CharSequence)nameCh2, (CharSequence)"Comprehensive scoring method")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"techweight", "commweight"});
                    return;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"techweight", "commweight"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bidsection"});
                return;
            }
        }
        if (StringUtils.equals((CharSequence)(nameCh = decide.getLocaleString("name").getLocaleValue_zh_CN()), (CharSequence)ResManager.loadKDString((String)"\u7efc\u5408\u8bc4\u5206\u6cd5", (String)"BidEvaluationEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"techweight", "commweight"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"techweight", "commweight"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"bidsection"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean dataChanged;
        boolean exsitInval;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String billstatus = dataEntity.getString("billstatus");
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        if ((StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) && (exsitInval = SupplierInvalUtil.checkExsitUnAuditSuppleirInvalBill(this.getModel().getDataEntity().getDynamicObject("bidproject"), this.getAppId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidEvaluationEdit_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "save": {
                boolean scoreRight;
                this.saveExpertGradingDataInCache();
                if (!BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod) && !BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod) || (scoreRight = this.checkScope())) break;
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u51fa\u8303\u56f4\u7684\u8bc4\u5206", (String)"BidEvaluationEdit_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            case "submit": {
                boolean scoreRight;
                if (this.checkHaveUnClarifiedData().booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8d28\u7591\u5355\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidEvaluationEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if ((BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod) || BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) && !(scoreRight = this.checkScope())) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u51fa\u8303\u56f4\u7684\u8bc4\u5206", (String)"BidEvaluationEdit_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormOperate operate = (FormOperate)args.getSource();
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) break;
                this.saveExpertGradingDataInCache();
                boolean canSubmit = this.validateExpertGradingData();
                if (canSubmit) break;
                args.setCancel(true);
                break;
            }
            case "dosript": {
                this.toListPriceComparison();
                break;
            }
            case "delete": {
                boolean b = new QuestionClarifyServiceImpl().checkExistQuery(dataEntity);
                if (!this.questionClarifyService.checkExistQuery(dataEntity)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u8d28\u7591\u5355\uff0c\u65e0\u6cd5\u88ab\u5220\u9664\u3002", (String)"BidEvaluationEdit_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (QUESTIONCLARIFY.equals(operateKey) || "unaudit".equals(operateKey)) {
            DynamicObject bidEvaluation = this.getView().getModel().getDataEntity(true);
            DynamicObject bidProject = bidEvaluation.getDynamicObject("bidproject");
            String evaltype = bidEvaluation.getString("evaltype");
            boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkBackBidFinished(bidProject.getPkValue(), evaltype);
            if (exsitBackBid) {
                this.getView().showTipNotification(QUESTIONCLARIFY.equals(operateKey) ? ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u8d28\u7591\u6f84\u6e05\u3002", (String)"BidEvaluationEdit_20", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidEvaluationEdit_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ("newbidevaluationdoc".equals(operateKey) && ("A".equals(billstatus) || "D".equals(billstatus)) && (dataChanged = this.getModel().getDataChanged())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u5355\u636e\u3002", (String)"BidEvaluationEdit_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public boolean checkScope() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String scoremethod = dataEntity.getString("scoremethod");
        String evaltype = dataEntity.getString("evaltype");
        Map<Long, String> cacheExpertGradingData = this.getSupplierScoreDetailInCache();
        boolean scoreRight = this.bidEvaluationUtil.checkScopeBidEvalScoreData(cacheExpertGradingData, scoremethod, evaltype);
        return scoreRight;
    }

    public Boolean checkHaveUnClarifiedData() {
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (enable) {
            DynamicObject bidproject = (DynamicObject)this.getModel().getValue("bidproject");
            String evaltype = (String)this.getModel().getValue("evaltype");
            Boolean judgeFlag = this.questionClarifyService.judgeHaveUnClarifiedData(bidproject.getPkValue(), evaltype);
            return judgeFlag;
        }
        return Boolean.FALSE;
    }

    public void toListPriceComparison() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"listpricecomparison", ((Object)((Object)this)).getClass()));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        EntryGrid sectionEntryGrid = (EntryGrid)this.getView().getControl("bidsection");
        AbstractGrid.GridState sectionEntryState = sectionEntryGrid.getEntryState();
        int sectionEntryFocusRow = sectionEntryState.getFocusRow();
        Long opensrcsectionid = ((DynamicObject)this.getModel().getEntryEntity("bidsection").get(sectionEntryFocusRow)).getLong("opensrcsectionid");
        showParameter.setCustomParam("sectionid", (Object)opensrcsectionid);
        String sectionName = ((DynamicObject)this.getModel().getEntryEntity("bidsection").get(sectionEntryFocusRow)).getString("sectionname");
        showParameter.setCustomParam("sectionname", (Object)sectionName);
        DynamicObject bidEval = this.getModel().getDataEntity(true);
        DynamicObject bidProject = bidEval.getDynamicObject("bidproject");
        showParameter.setCustomParam("bidproject", bidProject.getPkValue());
        String evalType = bidEval.getString("evaltype");
        showParameter.setCustomParam("evaltype", (Object)evalType);
        showParameter.setCustomParam("isOnlineEval", (Object)Boolean.FALSE);
        boolean isDark = bidEval.getBoolean("is_dark");
        showParameter.setCustomParam("isDark", (Object)isDark);
        this.getView().showForm(showParameter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] datas = e.getChangeSet();
        Object newValue = datas[0].getNewValue();
        Object oldValue = datas[0].getOldValue();
        Boolean isTech = StringUtils.equals((CharSequence)fieldKey, (CharSequence)"techweight");
        Boolean isCom = StringUtils.equals((CharSequence)fieldKey, (CharSequence)"commweight");
        if (isTech.booleanValue() || isCom.booleanValue()) {
            String field = null;
            BigDecimal newValueBig = (BigDecimal)newValue;
            if (isTech.booleanValue()) {
                field = ResManager.loadKDString((String)"\u6280\u672f\u6807\u6743\u91cd", (String)"BidEvaluationEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            } else if (isCom.booleanValue()) {
                field = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u6743\u91cd", (String)"BidEvaluationEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            }
            if (newValueBig.floatValue() < 0.0f) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd<0\u3002", (String)"BidEvaluationEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]), field));
                return;
            }
            if (newValueBig.floatValue() > 1.0f) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd>1\u3002", (String)"BidEvaluationEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]), field));
                return;
            }
            BigDecimal another = BigDecimal.valueOf(1.0 - (double)newValueBig.floatValue());
            if (isTech.booleanValue()) {
                field = ResManager.loadKDString((String)"\u6280\u672f\u6807\u6743\u91cd", (String)"BidEvaluationEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                this.getModel().setValue("commweight", (Object)another.doubleValue());
            } else if (isCom.booleanValue()) {
                field = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u6743\u91cd", (String)"BidEvaluationEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                this.getModel().setValue("commweight", (Object)newValueBig.doubleValue());
                this.getModel().setValue("techweight", (Object)another.doubleValue());
            }
            if (newValueBig.floatValue() < 0.0f) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd<0\u3002", (String)"BidEvaluationEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]), field));
                return;
            }
            if (newValueBig.floatValue() > 1.0f) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd>100%\u3002", (String)"BidEvaluationEdit_6", (String)"scm-bid-formplugin", (Object[])new Object[0]), field));
                return;
            }
            this.getView().updateView("commweight");
            this.getView().updateView("techweight");
            try {
                this.saveExpertGradingDataInCache();
                this.getPageCache().put("sectionId", null);
                this.clickFristRows();
            }
            catch (Throwable throwable) {}
        } else if (StringUtils.equals((CharSequence)"scoremethod", (CharSequence)fieldKey)) {
            String scoreMethod = (String)newValue;
            if (ScoreMethod.TRUNC_AVG_SCORE.getVal().equals(scoreMethod) && !this.checkBeforeChangeScoreMethod()) {
                this.getPageCache().put("canNotChange", "true");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4e13\u5bb6\u6570\u91cf\u591a\u4e8e2\u4e2a\u65f6\u624d\u5141\u8bb8\u9009\u62e9\u622a\u5c3e\u5e73\u5747\u503c\u6cd5\u3002", (String)"BidEvaluationEdit_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().getDataEntity().set("scoremethod", datas[0].getOldValue());
                return;
            }
            if (null != this.getPageCache().get("canNotChange")) {
                this.getPageCache().remove("canNotChange");
                return;
            }
            if (ScoreMethod.SPECIAL.getVal().equals(scoreMethod)) {
                this.changeEvalCtlTipsBySpecial();
            }
            this.saveExpertGradingDataInCache();
            this.getPageCache().put("sectionId", null);
            this.clickFristRows();
        } else if (StringUtils.equals((CharSequence)"bd_taxrate", (CharSequence)fieldKey)) {
            int rowindex = datas[0].getRowIndex();
            Object newVal = datas[0].getNewValue();
            if (newVal == null) {
                this.getModel().setValue("taxrate", (Object)new BigDecimal(0), rowindex);
            } else {
                DynamicObject bd_taxrate = (DynamicObject)newVal;
                this.getModel().setValue("taxrate", (Object)bd_taxrate.getBigDecimal("taxrate"), rowindex);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validateExpertGradingData() {
        block21: {
            dataEntity = this.getView().getModel().getDataEntity(true);
            evaluatedMethod = dataEntity.getString("evaluatedmethod");
            if (!BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod) && !BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) break block21;
            expertGradingUtil = new ExpertGradingUtil();
            evalProject = this.getModel().getDataEntity();
            evalType = evalProject.getString("evaltype");
            cacheExpertGradingData = this.getSupplierScoreDetailInCache();
            sectionColl = this.getModel().getEntryEntity("bidsection");
            sectionIdSet = new HashSet<Long>(16);
            for (i = 0; i < sectionColl.size(); ++i) {
                section = (DynamicObject)sectionColl.get(i);
                sectionId = section.getLong("id");
                sectionIdSet.add(sectionId);
            }
            for (Map.Entry<Long, String> cacheExpertGradingDataMap : cacheExpertGradingData.entrySet()) {
                block22: {
                    sectionIdSet.remove(cacheExpertGradingDataMap.getKey());
                    supplierColumnKeyList = expertGradingUtil.getExpertGradingSupplierColumnKeys(cacheExpertGradingDataMap.getKey());
                    cacheExpertGradingCollStr = cacheExpertGradingDataMap.getValue();
                    bidEvalScoreDetailList = (List)SerializationUtils.fromJsonString((String)cacheExpertGradingCollStr, Object.class);
                    if (bidEvalScoreDetailList == null || bidEvalScoreDetailList.size() <= 0) break block22;
                    for (i = 0; i < bidEvalScoreDetailList.size() - 1; ++i) {
                        block23: {
                            rowData = (LinkedHashMap)bidEvalScoreDetailList.get(i);
                            isTechnical = (Boolean)rowData.get("istechnical");
                            isCommercial = (Boolean)rowData.get("iscommercial");
                            decide = (DynamicObject)this.getModel().getValue("evaluatedecideway");
                            if (decide == null) break block23;
                            lang = RequestContext.get().getLang();
                            if (Lang.zh_CN.equals((Object)lang)) ** GOTO lbl-1000
                            if (!Lang.zh_TW.equals((Object)lang)) {
                                nameCh = decide.getLocaleString("name").getLocaleValue_en();
                                if (!StringUtils.equals((CharSequence)nameCh, (CharSequence)"Comprehensive scoring method")) {
                                    return true;
                                }
                            } else if (!StringUtils.equals((CharSequence)(nameCh = decide.getLocaleString("name").getLocaleValue_zh_CN()), (CharSequence)ResManager.loadKDString((String)"\u7efc\u5408\u8bc4\u5206\u6cd5", (String)"BidEvaluationEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]))) {
                                return true;
                            }
                        }
                        for (j = 0; j < supplierColumnKeyList.size(); ++j) {
                            columnKey = supplierColumnKeyList.get(j);
                            if (columnKey.startsWith("technical_") && isTechnical.booleanValue() && (StringUtils.equals((CharSequence)"TECHNICAL", (CharSequence)evalType) || StringUtils.equals((CharSequence)"MULTI", (CharSequence)evalType))) {
                                value = rowData.get(columnKey);
                                technicalScore = BigDecimal.ZERO;
                                if (value != null) {
                                    if (value instanceof Double) {
                                        technicalScore = BigDecimal.valueOf((Double)value);
                                    } else if (value instanceof BigDecimal) {
                                        technicalScore = (BigDecimal)value;
                                    }
                                }
                                if (technicalScore != null && BigDecimal.ZERO.compareTo(technicalScore) < 0) continue;
                                confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"BidEvaluationEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                                return false;
                            }
                            if (!columnKey.startsWith("commercial_") || !isCommercial.booleanValue() || !StringUtils.equals((CharSequence)"BUSSINESS", (CharSequence)evalType) && !StringUtils.equals((CharSequence)"MULTI", (CharSequence)evalType)) continue;
                            value = rowData.get(columnKey);
                            commercialScore = BigDecimal.ZERO;
                            if (value != null) {
                                if (value instanceof Double) {
                                    commercialScore = BigDecimal.valueOf((Double)value);
                                } else if (value instanceof BigDecimal) {
                                    commercialScore = (BigDecimal)value;
                                }
                            }
                            if (commercialScore != null && BigDecimal.ZERO.compareTo(commercialScore) < 0) continue;
                            confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"BidEvaluationEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                            return false;
                        }
                    }
                    continue;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BidEvaluationEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (sectionIdSet.size() > 0) {
                for (Long sectionId : sectionIdSet) {
                    scoreDetailSelectFields = "id,entryseq,technical,commercial,commercialscore,technicalscore";
                    bidEvalScoreDetailColl = this.bidEvaluationService.listBidEvalScoreDetailBySections(sectionId, scoreDetailSelectFields);
                    for (i = 0; i < bidEvalScoreDetailColl.size(); ++i) {
                        bidEvalScoreDetail = (DynamicObject)bidEvalScoreDetailColl.get(i);
                        isTechnical = bidEvalScoreDetail.getBoolean("technical");
                        isCommercial = bidEvalScoreDetail.getBoolean("commercial");
                        technicalScore = bidEvalScoreDetail.getBigDecimal("technicalscore");
                        commercialScore = bidEvalScoreDetail.getBigDecimal("commercialscore");
                        if (isTechnical.booleanValue() && (technicalScore == null || BigDecimal.ZERO.compareTo(technicalScore) >= 0) && (StringUtils.equals((CharSequence)"TECHNICAL", (CharSequence)evalType) || StringUtils.equals((CharSequence)"MULTI", (CharSequence)evalType))) {
                            confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"BidEvaluationEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                            return false;
                        }
                        if (!isCommercial.booleanValue() || commercialScore != null && BigDecimal.ZERO.compareTo(commercialScore) < 0 || !StringUtils.equals((CharSequence)"BUSSINESS", (CharSequence)evalType) && !StringUtils.equals((CharSequence)"MULTI", (CharSequence)evalType)) continue;
                        confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"BidEvaluationEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void saveExpertGradingDataInCache() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        if (BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod) || BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) {
            EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("bidsection");
            sectionEntryGrid.getEntryState().getFocusRow();
            int[] selectRows = sectionEntryGrid.getSelectRows();
            if (selectRows.length > 0) {
                int selectRowIndex = selectRows[0];
                DynamicObject section = this.getModel().getEntryRowEntity("bidsection", selectRowIndex);
                Long sectionId = section.getLong("id");
                String childPageId = this.getPageCache().get("childPageId");
                IFormView childFormView = this.getView().getView(childPageId);
                DynamicObjectCollection expertGradingColl = childFormView.getModel().getEntryEntity("expertgrading");
                this.getPageCache().put(sectionId.toString(), SerializationUtils.toJsonString((Object)expertGradingColl));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String entityId;
        IFormView parentView;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        switch (operateKey) {
            case "save": {
                this.saveSupplierScoreDetail();
                this.saveSupplierTenderDetail();
                this.saveNoINChangeData();
                break;
            }
            case "submit": {
                this.saveSupplierScoreDetail();
                this.saveSupplierTenderDetail();
                this.saveNoINChangeData();
                this.getPageCache().put("sectionId", null);
                this.clickFristRows();
                break;
            }
            case "unsubmit": {
                this.getPageCache().put("sectionId", null);
                this.clickFristRows();
                break;
            }
            case "unaudit": {
                this.getPageCache().put("sectionId", null);
                this.clickFristRows();
                break;
            }
            case "viewhistory": {
                this.openHistoryview();
            }
        }
        this.controlListBtnStatus();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if (QUESTIONCLARIFY.equals(operateKey)) {
            this.getQueryBillForm(dataEntity, this.getView());
        } else if (QUESTIONCLARIFYLIST.equals(operateKey)) {
            ListShowParameter listShowParameter = new ListShowParameter();
            String evaltype = dataEntity.getString("evaltype");
            Object bidProjectId = dataEntity.getDynamicObject("bidproject").getPkValue();
            listShowParameter.setCustomParam("evaluation", dataEntity.getPkValue());
            listShowParameter.setCustomParam("bidProjectId", bidProjectId);
            listShowParameter.setCustomParam("evaltype", (Object)evaltype);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setBillFormId(this.getAppId() + "_multiquestclarify");
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("rebackbid".equals(operateKey) && (parentView = this.getView().getParentView()) != null && StringUtils.isNotBlank((CharSequence)(entityId = parentView.getEntityId())) && entityId.endsWith("bidcenter")) {
            this.getView().getParentView().getPageCache().put("reBackBid", "reBackBid");
            this.getView().close();
            this.getView().sendFormAction(parentView);
        }
        this.setTenderInfoEntry();
        if ("save".equals(operateKey) || "newbidevaluationdoc".equals(operateKey)) {
            this.getView().getModel().setDataChanged(false);
        }
    }

    public String getQueryBillForm(DynamicObject evalution, IFormView frame) {
        String billstatus = evalution.getString("billstatus");
        String billno = evalution.getDynamicObject("bidproject").getString("billno");
        if (!"D".equals(billstatus) && !"A".equals(billstatus)) {
            if (billstatus.equals("X") || billstatus.equals("XX")) {
                return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u80fd\u5bf9\u5df2\u6d41\u6807\u7684\u8bb0\u5f55\u8fdb\u884c\u8d28\u7591\u6f84\u6e05\u3002", (String)"BidEvaluationEdit_24", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno);
            }
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u80fd\u5bf9\u5df2\u5b8c\u6210\u7684\u8bb0\u5f55\u8fdb\u884c\u8d28\u7591\u6f84\u6e05\u3002", (String)"BidEvaluationEdit_25", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno);
        }
        DynamicObject bidProject = evalution.getDynamicObject("bidproject");
        String formId = this.getAppId() + "_supplierinvitation";
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProject.getPkValue());
        HashSet<String> statusSet = new HashSet<String>();
        statusSet.add("A");
        statusSet.add("B");
        statusSet.add("I");
        QFilter status = new QFilter("billstatus", "in", statusSet);
        boolean exists = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidProjectFilter, status});
        if (exists) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b58\u5728\u672a\u5b8c\u6210\u7684\u589e\u8865\u5165\u56f4\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u8d28\u7591\u3002", (String)"BidEvaluationEdit_26", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno);
        }
        formId = this.getAppId() + "_bidpublish";
        exists = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidProjectFilter, status});
        if (exists) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d1\u6807\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u8d28\u7591\u3002", (String)"BidEvaluationEdit_27", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno);
        }
        String evaltype = evalution.getString("evaltype");
        BillShowParameter billShowParameter = this.questionClarifyUtil.addNewMultiQuestionClarifyBill(this.getAppId(), bidProject.getPkValue(), evaltype);
        Object bidevaluationId = evalution.get("id");
        HashMap<String, Object> historyMap = new HashMap<String, Object>();
        historyMap.put("bidevaluationid", bidevaluationId);
        historyMap.put("supplierinvitationid", evalution.getLong("supplierinvitationid"));
        historyMap.put("bidpublishid", evalution.get("bidpublishid"));
        historyMap.put("bidopenid", evalution.get("bidopenid"));
        billShowParameter.setCustomParam("historyMap", historyMap);
        billShowParameter.setCustomParam("org", (Object)bidProject.getDynamicObject("org").getString("id"));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
        return "";
    }

    private void setHistoryData(BillShowParameter billShowParameter) {
        DynamicObject bidevaluation = this.getModel().getDataEntity(true);
        Object bidevaluationId = bidevaluation.get("id");
        HashMap<String, Object> historyMap = new HashMap<String, Object>();
        historyMap.put("bidevaluationid", bidevaluationId);
        historyMap.put("supplierinvitationid", bidevaluation.getLong("supplierinvitationid"));
        historyMap.put("bidpublishid", bidevaluation.get("bidpublishid"));
        historyMap.put("bidopenid", bidevaluation.get("bidopenid"));
        billShowParameter.setCustomParam("historyMap", historyMap);
    }

    private void openHistoryview() {
        Object bidProjectId = ((DynamicObject)this.getModel().getValue("bidproject")).getPkValue();
        String bidEvaluationType = FormTypeConstants.getFormConstant((String)"bidevaluation_his", ((Object)((Object)this)).getClass());
        Object evalType = this.getModel().getValue("evaltype");
        String appId = this.getModel().getDataEntityType().getAppId();
        if (BidHistoryUtil.haveEvaluationHistory(appId, bidProjectId).booleanValue()) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("bidProjectId", bidProjectId);
            listShowParameter.setCustomParam("viewhistory", (Object)"viewhistory");
            listShowParameter.setCustomParam("evalType", evalType);
            listShowParameter.setMultiSelect(false);
            listShowParameter.setHasRight(true);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setBillFormId(bidEvaluationType);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u8bc4\u6807\u8bb0\u5f55\u3002", (String)"BidEvaluationEdit_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    private void saveNoINChangeData() {
        Long primaryKeyValue = (Long)this.getModel().getValue("id");
        DynamicObject evalProject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bid_bidevaluation");
        BidEvaluationScoreList bidEvaluationScoreList = new BidEvaluationScoreList();
        ArrayList scoreDetailDataList = new ArrayList();
        ArrayList entryDataList = new ArrayList();
        DynamicObjectCollection sectionColl = evalProject.getDynamicObjectCollection("bidsection");
        sectionColl.stream().forEach(section -> {
            String cacheExpertGradingCollStr = this.getPageCache().get(String.valueOf((Long)section.get("id")));
            if (!StringUtils.isEmpty((CharSequence)cacheExpertGradingCollStr)) {
                return;
            }
            Object secondSectionId = bidEvaluationScoreList.getSecondSectionId(evalProject, (DynamicObject)section);
            List<HashMap<String, Object>> scoreDetailByDataBaseList = bidEvaluationScoreList.getScoreDetailByDataBase(secondSectionId, (DynamicObject)section);
            scoreDetailDataList.addAll(scoreDetailByDataBaseList);
            entryDataList.addAll(bidEvaluationScoreList.calcTotalRow(scoreDetailByDataBaseList, evalProject, (DynamicObject)section, secondSectionId));
        });
        if (scoreDetailDataList.size() > 0) {
            this.bidEvaluationService.saveSupplierScoreDetail(scoreDetailDataList, entryDataList);
        }
    }

    protected void saveSupplierScoreDetail() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        String scoremethod = dataEntity.getString("scoremethod");
        String evaltype = dataEntity.getString("evaltype");
        if (BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod) || BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) {
            Map<Long, String> cacheExpertGradingData = this.getSupplierScoreDetailInCache();
            this.bidEvaluationUtil.saveSupplierScoreDetail(cacheExpertGradingData, scoremethod, evaltype);
        }
    }

    protected Map<Long, String> getSupplierScoreDetailInCache() {
        IPageCache pageCache = this.getPageCache();
        DynamicObjectCollection sectionColl = this.getModel().getEntryEntity("bidsection");
        HashMap<Long, String> cacheExpertGradingData = new HashMap<Long, String>();
        for (int i = 0; i < sectionColl.size(); ++i) {
            DynamicObject section = (DynamicObject)sectionColl.get(i);
            Long sectionId = section.getLong("id");
            String cacheExpertGradingCollStr = pageCache.get(sectionId.toString());
            if (!StringUtils.isNotEmpty((CharSequence)cacheExpertGradingCollStr)) continue;
            cacheExpertGradingData.put(sectionId, cacheExpertGradingCollStr);
        }
        return cacheExpertGradingData;
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "expertgrading": {
                return "bid_expertgrading";
            }
        }
        return null;
    }

    protected boolean checkBeforeChangeScoreMethod() {
        String scoreDetailSelectFields = "id,entryseq,technical,commercial,commercialscore,technicalscore";
        DynamicObjectCollection sectionColl = this.getModel().getEntryEntity("bidsection");
        for (int i = 0; i < sectionColl.size(); ++i) {
            DynamicObject section = (DynamicObject)sectionColl.get(i);
            Long sectionId = section.getLong("id");
            DynamicObjectCollection bidEvalScoreDetailColl = this.bidEvaluationService.listBidEvalScoreDetailBySections(sectionId, scoreDetailSelectFields);
            int techEvalPersonQty = 0;
            int commEvalPersonQty = 0;
            int entrySeq = -1;
            for (int j = 0; j < bidEvalScoreDetailColl.size(); ++j) {
                DynamicObject bidEvalScoreDetail = (DynamicObject)bidEvalScoreDetailColl.get(j);
                if (entrySeq == bidEvalScoreDetail.getInt("entryseq")) continue;
                Boolean isTechnical = bidEvalScoreDetail.getBoolean("technical");
                Boolean isCommercial = bidEvalScoreDetail.getBoolean("commercial");
                if (isTechnical.booleanValue()) {
                    ++techEvalPersonQty;
                }
                if (isCommercial.booleanValue()) {
                    ++commEvalPersonQty;
                }
                entrySeq = bidEvalScoreDetail.getInt("entryseq");
            }
            if (techEvalPersonQty > 2 && commEvalPersonQty > 2) continue;
            return false;
        }
        return true;
    }

    protected void changeEvalCtlTipsBySpecial() {
        HashMap prop = new HashMap(1);
        HashMap<String, String> tips = new HashMap<String, String>(1);
        tips.put("title", "");
        tips.put("content", "");
        prop.put("tips", tips);
        this.getView().updateControlMetadata("advconap1", prop);
    }

    public void saveSupplierTenderDetail() {
        IPageCache pageCache = this.getPageCache();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String evalType = dataEntity.getString("evalType");
        long bidOpenId = dataEntity.getLong("bidopenid");
        boolean isOnlineEval = dataEntity.getBoolean("isOnlineEval");
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        if (BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod) || BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) {
            DynamicObject bidOpen;
            DynamicObject[] tenderGradingDetailLoadArray;
            String tenderGradingChildPageId = pageCache.get("tenderGradingChildPageId");
            IFormView tenderGradingChildView = this.getView().getView(tenderGradingChildPageId);
            DynamicObject childDataEntity = tenderGradingChildView.getModel().getDataEntity(true);
            DynamicObjectCollection tenderGradingCol = childDataEntity.getDynamicObjectCollection("tendergrading");
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_tendergradingdetail");
            HashMap<String, DynamicObject> tenderGradingDetailMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject tenderGradingDetailLoad : tenderGradingDetailLoadArray = BusinessDataServiceHelper.load((String)"bid_tendergradingdetail", (String)"evaluationid,opensectionid,sectionname,supplierid,techevalresult,busevalresult", (QFilter[])new QFilter[]{new QFilter("evaluationid", "=", dataEntity.getPkValue())})) {
                String key = tenderGradingDetailLoad.get("opensectionid") + "_" + tenderGradingDetailLoad.get("supplierid");
                tenderGradingDetailMap.put(key, tenderGradingDetailLoad);
            }
            ArrayList<DynamicObject> tenderGradingDetailList = new ArrayList<DynamicObject>(10);
            ArrayList<String> bidOpenSectionIdList = new ArrayList<String>(10);
            for (int i = 0; i < tenderGradingCol.size(); ++i) {
                DynamicObject tenderGrading = (DynamicObject)tenderGradingCol.get(i);
                String bidOpenSectionId = tenderGrading.getString("bidopensectionid");
                String key = tenderGrading.get("bidopensectionid") + "_" + tenderGrading.get("supplier");
                DynamicObject tenderGradingDetail = null;
                if (!CollectionUtils.isEmpty(tenderGradingDetailMap)) {
                    tenderGradingDetail = (DynamicObject)tenderGradingDetailMap.get(key);
                }
                if (tenderGradingDetail == null) {
                    tenderGradingDetail = new DynamicObject((DynamicObjectType)mainType);
                    tenderGradingDetail.set("id", (Object)ID.genLongId());
                }
                tenderGradingDetail.set("evaluationid", dataEntity.getPkValue());
                tenderGradingDetail.set("supplierid", tenderGrading.get("supplier"));
                tenderGradingDetail.set("sectionname", tenderGrading.get("sectionname"));
                tenderGradingDetail.set("opensectionid", tenderGrading.get("bidopensectionid"));
                if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.MULTI.getValue())) {
                    tenderGradingDetail.set("techevalresult", tenderGrading.get("techevalresult"));
                    tenderGradingDetail.set("busevalresult", tenderGrading.get("busevalresult"));
                } else if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.TECHNICAL.getValue())) {
                    tenderGradingDetail.set("techevalresult", tenderGrading.get("techevalresult"));
                } else if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.BUSSINESS.getValue())) {
                    tenderGradingDetail.set("busevalresult", tenderGrading.get("busevalresult"));
                }
                tenderGradingDetailList.add(tenderGradingDetail);
                bidOpenSectionIdList.add(bidOpenSectionId);
            }
            Map evalEvaluatorMap = new HashMap();
            if (isOnlineEval) {
                evalEvaluatorMap = this.bidEvaluationService.getOnlineEvalResult(this.getAppId(), new QFilter[]{new QFilter("bidopenid", "=", (Object)bidOpenId), new QFilter("billstatus", "=", (Object)"C")});
            }
            if ((bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)(this.getAppId() + "_bidopen"))) != null) {
                DynamicObjectCollection bidSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionCol) {
                    String bidSectionId = bidSection.getString("id");
                    if (CollectionUtils.isEmpty(bidOpenSectionIdList) || bidOpenSectionIdList.contains(bidSectionId)) continue;
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        String bsEvalResult;
                        boolean supplierInvalid = supplierEntry.getBoolean("supplier_isinvalid");
                        boolean isTender = supplierEntry.getBoolean("supplier_istender");
                        if (!isTender || supplierInvalid) continue;
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        String supplierId = supplier.getString("id");
                        String key = bidSectionId + "_" + supplierId;
                        DynamicObject tenderGradingDetail = null;
                        if (!CollectionUtils.isEmpty(tenderGradingDetailMap)) {
                            tenderGradingDetail = (DynamicObject)tenderGradingDetailMap.get(key);
                        }
                        if (tenderGradingDetail == null) {
                            tenderGradingDetail = new DynamicObject((DynamicObjectType)mainType);
                            tenderGradingDetail.set("id", (Object)ID.genLongId());
                        }
                        tenderGradingDetail.set("evaluationid", dataEntity.getPkValue());
                        tenderGradingDetail.set("supplierid", supplier.getPkValue());
                        tenderGradingDetail.set("sectionname", bidSection.get("sectionname"));
                        tenderGradingDetail.set("opensectionid", (Object)bidSectionId);
                        String techEvalResultKey = TenderGradingUtil.getEvalResultKey("proficient_tech_", bidSectionId, supplierId);
                        String bsEvalResultKey = TenderGradingUtil.getEvalResultKey("proficient_bus_", bidSectionId, supplierId);
                        String techEvalResult = pageCache.get(techEvalResultKey);
                        if (StringUtils.isEmpty((CharSequence)techEvalResult)) {
                            if (!CollectionUtils.isEmpty(tenderGradingDetailMap)) {
                                if (tenderGradingDetail.get("techevalresult") != null) {
                                    techEvalResult = tenderGradingDetail.get("techevalresult").toString();
                                }
                            } else if (!CollectionUtils.isEmpty(evalEvaluatorMap) && isOnlineEval && evalEvaluatorMap.get(techEvalResultKey) != null) {
                                techEvalResult = evalEvaluatorMap.get(techEvalResultKey).toString();
                            }
                        }
                        if (StringUtils.isEmpty((CharSequence)(bsEvalResult = pageCache.get(bsEvalResultKey)))) {
                            if (!CollectionUtils.isEmpty(tenderGradingDetailMap)) {
                                if (tenderGradingDetail.get("busevalresult") != null) {
                                    bsEvalResult = tenderGradingDetail.get("busevalresult").toString();
                                }
                            } else if (!CollectionUtils.isEmpty(evalEvaluatorMap) && isOnlineEval && evalEvaluatorMap.get(bsEvalResultKey) != null) {
                                bsEvalResult = evalEvaluatorMap.get(bsEvalResultKey).toString();
                            }
                        }
                        techEvalResult = StringUtils.isEmpty((CharSequence)techEvalResult) ? "1" : techEvalResult;
                        String string = bsEvalResult = StringUtils.isEmpty((CharSequence)bsEvalResult) ? "1" : bsEvalResult;
                        if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.MULTI.getValue())) {
                            tenderGradingDetail.set("techevalresult", (Object)techEvalResult);
                            tenderGradingDetail.set("busevalresult", (Object)bsEvalResult);
                        } else if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.TECHNICAL.getValue())) {
                            tenderGradingDetail.set("techevalresult", (Object)techEvalResult);
                        } else if (StringUtils.equals((CharSequence)evalType, (CharSequence)BidOpenTypeEnum.BUSSINESS.getValue())) {
                            tenderGradingDetail.set("busevalresult", (Object)bsEvalResult);
                        }
                        tenderGradingDetailList.add(tenderGradingDetail);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(tenderGradingDetailList)) {
                SaveServiceHelper.save((DynamicObject[])tenderGradingDetailList.toArray(new DynamicObject[tenderGradingDetailList.size()]));
            }
        }
    }

    public void setSectionEntryVisible() {
        DynamicObject bidProject = this.getModel().getDataEntity().getDynamicObject("bidproject");
        boolean enableMultiSec = bidProject.getBoolean(this.ENABLE_MULTI_SECTION);
        SplitContainer splitContainer = (SplitContainer)this.getControl("sectionsplitcontainer1");
        if (splitContainer != null) {
            if (enableMultiSec) {
                splitContainer.changeFlexStatus(SplitDirection.left, false);
            } else {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            }
        }
    }

    public DynamicObject getSourceBidOpen() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long bidOpenId = dataEntity.getLong("bidopenid");
        QFilter qFilter = null;
        if (bidOpenId == 0L) {
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            String bidOpenSelectType = bidProject.getString("bidopentype");
            String evalType = dataEntity.getString("evaltype");
            String docType = bidProject.getString("doctype");
            qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal());
            if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType)) {
                if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
                    qFilter = qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                } else if (BidOpenTypeEnum.MULTI.getValue().equals(docType)) {
                    qFilter = qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
                }
            } else {
                qFilter = qFilter.and(new QFilter("opentype", "=", (Object)evalType));
            }
            qFilter = qFilter.and(new QFilter("bidproject", "=", bidProject.getPkValue()));
        } else {
            qFilter = new QFilter("id", "=", (Object)bidOpenId);
        }
        ORM orm = ORM.create();
        DynamicObject obj = orm.queryOne(FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), "id,billstatus,opentype,bidproject.id,bidproject.ismaterialpur,bidproject.isratebidding,bidsection.id,bidsection.sectionname,bidsection.seq,bidsection.supplierentry.id,baseprice,evaluatedecideway.id,evaluatedecideway.name,techweight,comweight,needflagnewsupplier,isonlineeval,bidevaltemplate.id,bidevaltemplate.name,bidevaltemplate.billno,bidevaltemplate.scoremode,bidevaltemplate.scoretype,scoretype,scoremode,bidsection.supplierentry.supplier.id,bidsection.supplierentry.supplier.name,bidsection.supplierentry.supplier_istender,bidsection.supplierentry.supplier_isinvalid,bidsection.supplierentry.suppliercontact,bidsection.supplierentry.contactphone,bidsection.supplierentry.supplier_deposittype,bidsection.supplierentry.supplier_deposit,bidsection.supplierentry.supplier_tenderdate,bidsection.supplierentry.supplier_manager,bidsection.supplierentry.supplier_workday,bidsection.supplierentry.supplier_techfile,bidsection.supplierentry.supplier_comfile,bidsection.supplierentry.supplier_tenfile,bidsection.supplierentry.supplier_otherfile,bidsection.supplierentry.supplier_tenderprice,bidsection.supplierentry.supplier_taxrate,bidsection.supplierentry.supplier_pricevat,bidsection.supplierentry.supplier_exceptvat,bidsection.supplierentry.supplier_rate,bidsection.supplierentry.purdetail,bidsection.supplierentry.supplier_illustration,bidsection.supplierentry.supplier_invalidreason,bidsection.supplierentry.supplier_comment,bidsection.supplierentry.supplier_isfrombackbid,bidsection.supplierdetail.id,bidsection.supplierdetail.pursupplier.id,bidsection.supplierdetail.pursupplier.name,bidsection.supplierdetail.purentrycontent,bidsection.supplierdetail.purentryproject.id,bidsection.supplierdetail.purentryproject.name,bidsection.supplierdetail.materialid.id,bidsection.supplierdetail.materialid.name,bidsection.supplierdetail.materialid.number,bidsection.supplierdetail.materialid.baseunit.id,bidsection.supplierdetail.materialid.baseunit.name,bidsection.supplierdetail.materialid.baseunit.number,bidsection.supplierdetail.materialid.baseunit.precision,bidsection.supplierdetail.materialid.baseunit.precisionaccount,bidsection.supplierdetail.materialdes,bidsection.supplierdetail.materialid.modelnum,bidsection.supplierdetail.qty,bidsection.supplierdetail.inclutaxprice,bidsection.supplierdetail.inclutaxamount,bidsection.supplierdetail.taxrate,bidsection.supplierdetail.taxamount,bidsection.supplierdetail.excepttaxamount,bidsection.supplierdetail.costrate", new QFilter[]{qFilter});
        if (obj != null) {
            return obj;
        }
        return null;
    }
}

