/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.BidEvaluationUtil;
import kd.scm.bid.formplugin.bill.util.BidHistoryUtil;
import kd.scm.bid.formplugin.bill.util.InvalidBillUtil;
import kd.scm.bid.formplugin.bill.util.QuestionClarifyUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidEvaluationList
extends AbstractListPlugin {
    protected BidEvaluationUtil bidEvaluationUtil = new BidEvaluationUtil();
    protected IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    public static final String TECHNICAL = "TECHNICAL";
    public static final String BUSSINESS = "BUSSINESS";
    public static final String MULTI = "MULTI";
    protected QuestionClarifyUtil questionClarifyUtil = new QuestionClarifyUtil();
    private static String QUESTIONCLARIFY = "questionclarify";
    private static String QUESTIONCLARIFYLIST = "questionclarifylist";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)"bidproject_currentstep", (CharSequence)args.getFieldName())) {
            args.setCancel(true);
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object bidProjectId = BusinessDataServiceHelper.loadSingle((Object)sr.getPrimaryKeyValue(), (String)"bid_bidevaluation").getDynamicObject("bidproject").getPkValue();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getOpenFormId("projectprocess"));
            showParameter.setCustomParam("bidProjectId", bidProjectId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
        if ("bidprojectname".equals(args.getFieldName())) {
            BillList bidEvalList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = bidEvalList.getSelectedRows();
            ListSelectedRow selectedRow = selectedRows.get(0);
            Long bidEvalId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject bidEval = this.bidEvaluationService.getBidEvaluation(bidEvalId);
            DynamicObject bidProject = bidEval.getDynamicObject("bidproject");
            String evaltype = bidEval.getString("evaltype");
            boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkBackBidFinished(bidProject.getPkValue(), evaltype);
            if (exsitBackBid) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u4e0b\u4e00\u6b65\u64cd\u4f5c\u3002", (String)"BidEvaluationList_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection evalutions = super.getData(start, limit);
                evalutions.stream().forEach(item -> {
                    Object pkValue = item.getPkValue();
                    DynamicObject bidevaluation = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)(BidEvaluationList.this.getAppId() + "_bidevaluation"));
                    String listrounds = item.getString("listrounds");
                    if (StringUtils.isBlank((CharSequence)listrounds)) {
                        String format = "";
                        String billstatus = item.getString("billstatus");
                        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"XX")) {
                            format = item.getString("listrounds");
                        } else {
                            DynamicObject bidProject = bidevaluation.getDynamicObject("bidproject");
                            if (bidProject != null) {
                                QFilter pFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
                                QFilter eFilter = new QFilter("evaltype", "=", (Object)bidevaluation.getString("evaltype"));
                                QFilter sFilter = new QFilter("billstatus", "=", (Object)"XX");
                                DynamicObject[] ids = BusinessDataServiceHelper.load((String)(BidEvaluationList.this.getAppId() + "_bidevaluation"), (String)"id", (QFilter[])new QFilter[]{pFilter, eFilter, sFilter});
                                int rounds = 1;
                                if (ids != null && ids.length > 0) {
                                    rounds += ids.length;
                                }
                                format = String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u8bc4\u6807", (String)"BidEvaluationList_17", (String)"scm-bid-formplugin", (Object[])new Object[0]), InvalidBillUtil.toChinese(rounds + ""));
                            }
                        }
                        item.set("listrounds", (Object)format);
                    }
                });
                return evalutions;
            }
        });
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        IFormView view = this.getView();
        BillList proficientList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = proficientList.getSelectedRows();
        StringBuilder builder = new StringBuilder();
        if ("tblmodify".equals(key)) {
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BidEvaluationList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            RequestContext context = RequestContext.get();
            String userId = context.getUserId();
            if (selectedRows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u7f16\u5236\u591a\u6761\u6570\u636e\u3002", (String)"BidEvaluationList_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            Long bidEvaluationId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject bidEvaluation = this.bidEvaluationService.getBidEvaluation(bidEvaluationId);
            String billstatus = bidEvaluation.getString("billstatus");
            builder.append(bidEvaluation.getString("billno"));
            if (!BillStatusEnum.DISBEGIN.getVal().equals(billstatus) && !BillStatusEnum.SAVE.getVal().equals(billstatus)) {
                String str = String.format(ResManager.loadKDString((String)"%s\u53ea\u80fd\u7f16\u5236\u672a\u5f00\u59cb\u548c\u6682\u5b58\u72b6\u6001\u7684\u6570\u3002", (String)"BidEvaluationList_22", (String)"scm-bid-formplugin", (Object[])new Object[0]), "\uff1a");
                builder.append(str);
                view.showTipNotification(builder.toString());
                evt.setCancel(true);
                return;
            }
            String evaltype = bidEvaluation.getString("evaltype");
            DynamicObject bidProject = bidEvaluation.getDynamicObject("bidproject");
            boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkBackBidFinished(bidProject.getPkValue(), evaltype);
            if (exsitBackBid) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u5728\u7ebf\u8bc4\u6807\u3002", (String)"BidEvaluationList_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if ("tblsubmit".equals(key)) {
            if (selectedRows.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BidEvaluationList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (selectedRows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u63d0\u4ea4\u8bc4\u6807\u6570\u636e\u3002", (String)"BidEvaluationList_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            Long bidEvaluationId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject bidEvaluation = this.bidEvaluationService.getBidEvaluation(bidEvaluationId);
            String billstatus = bidEvaluation.getString("billstatus");
            builder.append(bidEvaluation.getString("billno"));
            if (!BillStatusEnum.SAVE.getVal().equals(billstatus) && !BillStatusEnum.DISBEGIN.getVal().equals(billstatus)) {
                String str = String.format(ResManager.loadKDString((String)"%s\u53ea\u6709\u672a\u5f00\u59cb\u6216\u8005\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidEvaluationList_23", (String)"scm-bid-formplugin", (Object[])new Object[0]), "\uff1a");
                builder.append(str);
                view.showTipNotification(builder.toString());
                evt.setCancel(true);
                return;
            }
        }
    }

    private String validateCanDoPriceClarify(Long bidEvaluationId) {
        DynamicObject bidEvaluation = this.bidEvaluationService.getBidEvaluation(bidEvaluationId);
        String billstatus = bidEvaluation.getString("billstatus");
        if (BillStatusEnum.INVALID.getVal().equals(billstatus)) {
            return ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u4ef7\u683c\u6f84\u6e05\u3002", (String)"BidEvaluationList_5", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        DynamicObject bidProject = bidEvaluation.getDynamicObject("bidproject");
        boolean flag = this.bidEvaluationService.checkNextStepUnStarted(bidProject, BidStepEnum.BidEvaluation);
        if (!flag) {
            return ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u505a\u4ef7\u683c\u6f84\u3002", (String)"BidEvaluationList_6", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRow selectedRow;
        Long bidEvaluationId;
        DynamicObject bidEvaluation;
        ListSelectedRowCollection listSelectedRows;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        BillList proficientList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = proficientList.getSelectedRows();
        ReBackBidUtil reBackBidUtil = new ReBackBidUtil(this.getAppId());
        if (reBackBidUtil.judgeOp(operateKey) && CollectionUtils.isEmpty((Collection)(listSelectedRows = this.getSelectedRows()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidEvaluationList_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("modify".equals(operateKey)) {
            String appId = this.getAppId();
            if (selectedRows != null) {
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidEvaluationList_35", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object pkValue = selectedRows.get(0).getPrimaryKeyValue();
                bidEvaluation = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()));
                boolean isOnlineEval = bidEvaluation.getBoolean("isonlineeval");
                if (isOnlineEval) {
                    DynamicObject bidProject = bidEvaluation.getDynamicObject("bidproject");
                    String evalType = bidEvaluation.getString("evaltype");
                    String bidOpenType = bidProject.getString("bidopentype");
                    QFilter[] qFilters = BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidOpenType) ? new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("evaltype", "=", (Object)evalType), new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.INVALID.getVal(), BillStatusEnum.AUDITED.getVal(), BillStatusEnum.INVALIDXX.getVal()})} : new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.INVALID.getVal(), BillStatusEnum.AUDITED.getVal(), BillStatusEnum.INVALIDXX.getVal()})};
                    DynamicObject[] onlineEvalArray = BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"bidevaluator", (QFilter[])qFilters);
                    if (onlineEvalArray != null && onlineEvalArray.length > 0) {
                        StringBuilder evaluatorName = new StringBuilder();
                        for (DynamicObject onlineEval : onlineEvalArray) {
                            DynamicObject evaluator = onlineEval.getDynamicObject("bidevaluator");
                            if (evaluator == null) continue;
                            String name = evaluator.getString("name") + "\u3001";
                            evaluatorName.append(name);
                        }
                        if (evaluatorName.length() > 0) {
                            String tip = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u8bc4\u6807\u4e13\u5bb6\uff1a%s\uff0c\u672a\u5b8c\u6210\u8bc4\u5ba1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidEvaluationList_36", (String)"scm-bid-formplugin", (Object[])new Object[0]), evaluatorName.substring(0, evaluatorName.length() - 1));
                            this.getView().showTipNotification(tip);
                            args.setCancel(true);
                            return;
                        }
                    }
                }
            }
        }
        if ("submit".equals(operateKey)) {
            boolean canSubmit;
            if (this.checkHaveUnClarifiedData().booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8d28\u7591\u5355\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidEvaluationList_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormOperate operate = (FormOperate)args.getSource();
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm) && !(canSubmit = this.validateExpertGradingData())) {
                args.setCancel(true);
            }
        }
        if (selectedRows != null && "delete".equals(operateKey) && this.questionClarifyService.checkExistQuery(bidEvaluation = BusinessDataServiceHelper.loadSingle((Object)(bidEvaluationId = (Long)(selectedRow = selectedRows.get(0)).getPrimaryKeyValue()), (String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass())))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u7684\u8d28\u7591\u5355\uff0c\u65e0\u6cd5\u88ab\u5220\u9664\u3002", (String)"BidEvaluationList_30", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public Boolean checkHaveUnClarifiedData() {
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (enable) {
            ListSelectedRow currentSelectedRow = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            DynamicObject bidevaluation = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRow.getPrimaryKeyValue(), (String)"bid_bidevaluation");
            DynamicObject bidproject = bidevaluation.getDynamicObject("bidproject");
            String evaltype = bidevaluation.getString("evaltype");
            Boolean judgeFlag = this.questionClarifyService.judgeHaveUnClarifiedData(bidproject.getPkValue(), evaltype);
            return judgeFlag;
        }
        return Boolean.FALSE;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        String operateKey = formOperate.getOperateKey();
        BillList proficientList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = proficientList.getSelectedRows();
        IFormView view = this.getView();
        if ("priceclarify".equals(operateKey)) {
            if (selectedRows == null) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BidEvaluationList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u6f84\u6e05\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidEvaluationList_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            Long bidEvaluationId = (Long)selectedRow.getPrimaryKeyValue();
            String selectFields = "id, billstatus";
            DynamicObject priceClarify = this.bidEvaluationService.getPriceClarify(bidEvaluationId, selectFields);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("formId", this.getOpenFormId("priceclarify"));
            String msg = this.validateCanDoPriceClarify(bidEvaluationId);
            OperationStatus status = OperationStatus.ADDNEW;
            if (priceClarify != null) {
                param.put("pkId", priceClarify.getString("id"));
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    if (!BillStatusEnum.DISBEGIN.getVal().equals(priceClarify.getString("billstatus"))) {
                        view.showTipNotification(msg);
                        return;
                    }
                    status = OperationStatus.VIEW;
                } else {
                    status = OperationStatus.EDIT;
                }
            } else {
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    view.showTipNotification(msg);
                    return;
                }
                Long priceClarifyId = this.bidEvaluationUtil.createPriceClarify(bidEvaluationId);
                param.put("pkId", priceClarifyId.toString());
                status = OperationStatus.EDIT;
            }
            FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(param);
            formShowParameter.setCustomParam("bidEvaluationId", (Object)bidEvaluationId);
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            formShowParameter.setStatus(status);
            view.showForm(formShowParameter);
        } else if (QUESTIONCLARIFY.equals(operateKey)) {
            ListSelectedRow currentSelectedRow = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            DynamicObject evaluation = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRow.getPrimaryKeyValue(), (String)"bid_bidevaluation");
            String result = this.getQueryBillForm(evaluation, this.getView());
            if (StringUtils.isNotBlank((CharSequence)result)) {
                this.getView().showConfirm(result, MessageBoxOptions.OK);
            }
        } else if (QUESTIONCLARIFYLIST.equals(operateKey)) {
            ListSelectedRow currentSelectedRow = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            DynamicObject evaluation = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRow.getPrimaryKeyValue(), (String)"bid_bidevaluation");
            Object bidProjectId = evaluation.getDynamicObject("bidproject").getPkValue();
            ListShowParameter listShowParameter = new ListShowParameter();
            String evaltype = evaluation.getString("evaltype");
            listShowParameter.setCustomParam("evaluation", (Object)evaluation.toString());
            listShowParameter.setCustomParam("bidProjectId", bidProjectId);
            listShowParameter.setCustomParam("evaltype", (Object)evaltype);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setBillFormId(this.getAppId() + "_multiquestclarify");
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("viewhistory".equals(operateKey)) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)String.join((CharSequence)",", "bidproject", "evaltype"), (QFilter[])new QFilter[]{new QFilter("id", "=", sr.getPrimaryKeyValue())});
            Object bidProjectId = bidEvaluation.get("bidproject");
            String evalType = bidEvaluation.getString("evaltype");
            String appId = this.getAppId();
            if (BidHistoryUtil.haveEvaluationHistory(appId, bidProjectId).booleanValue()) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("bidProjectId", bidProjectId);
                listShowParameter.setCustomParam("evalType", (Object)evalType);
                listShowParameter.setCustomParam("viewhistory", (Object)"viewhistory");
                listShowParameter.setMultiSelect(false);
                listShowParameter.setHasRight(true);
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setBillFormId(this.getAppId() + "_" + "bidevaluation_his");
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u8bc4\u6807\u8bb0\u5f55\u3002", (String)"BidEvaluationList_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setHistoryData(DynamicObject bidevaluation, BillShowParameter billShowParameter) {
        Object bidevaluationId = bidevaluation.get("id");
        HashMap<String, Object> historyMap = new HashMap<String, Object>();
        historyMap.put("bidevaluationid", bidevaluationId);
        historyMap.put("supplierinvitationid", bidevaluation.getLong("supplierinvitationid"));
        historyMap.put("bidpublishid", bidevaluation.get("bidpublishid"));
        historyMap.put("bidopenid", bidevaluation.get("bidopenid"));
        billShowParameter.setCustomParam("historyMap", historyMap);
    }

    private boolean validateExpertGradingData() {
        BillList proficientList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = proficientList.getSelectedRows();
        ListSelectedRow selectedRow = selectedRows.get(0);
        Long bidEvaluationId = (Long)selectedRow.getPrimaryKeyValue();
        String selectFields = "commercialscore,technicalscore,technical,commercial";
        DynamicObject bidEvaluation = BusinessDataServiceHelper.loadSingle((Object)bidEvaluationId, (String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"evaltype, evaluatedmethod");
        String evalType = bidEvaluation.getString("evaltype");
        String evaluatedMethod = bidEvaluation.getString("evaluatedmethod");
        if ("1".equals(evaluatedMethod)) {
            return true;
        }
        DynamicObjectCollection bidEvalScoreDetailColl = this.bidEvaluationService.listBidEvalScoreDetails(bidEvaluationId, selectFields);
        if (bidEvalScoreDetailColl != null && bidEvalScoreDetailColl.size() > 0) {
            for (int i = 0; i < bidEvalScoreDetailColl.size(); ++i) {
                BigDecimal commercialScore;
                BigDecimal technicalScore;
                DynamicObject bidEvalScoreDetail = (DynamicObject)bidEvalScoreDetailColl.get(i);
                Boolean isTechnical = bidEvalScoreDetail.getBoolean("technical");
                Boolean isCommercial = bidEvalScoreDetail.getBoolean("commercial");
                if (isTechnical.booleanValue() && (StringUtils.equals((CharSequence)TECHNICAL, (CharSequence)evalType) || StringUtils.equals((CharSequence)MULTI, (CharSequence)evalType)) && ((technicalScore = bidEvalScoreDetail.getBigDecimal("technicalscore")) == null || BigDecimal.ZERO.compareTo(technicalScore) >= 0)) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"BidEvaluationList_10", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    return false;
                }
                if (!isCommercial.booleanValue() || !StringUtils.equals((CharSequence)BUSSINESS, (CharSequence)evalType) && !StringUtils.equals((CharSequence)MULTI, (CharSequence)evalType) || (commercialScore = bidEvalScoreDetail.getBigDecimal("commercialscore")) != null && BigDecimal.ZERO.compareTo(commercialScore) < 0) continue;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"BidEvaluationList_10", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                return false;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BidEvaluationList_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    public String getAppId() {
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        return appName;
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "priceclarify": {
                return "bid_priceclarify";
            }
            case "projectprocess": {
                return "bid_projectprocess";
            }
        }
        return null;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FormShowParameter parameter;
        String viewhistory;
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewhistory"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"questionclarify"});
        }
        if (enable = StringUtils.isNotEmpty((CharSequence)(viewhistory = (String)(parameter = this.getView().getFormShowParameter()).getCustomParam("viewhistory")))) {
            List CommonFilter2 = args.getCommonFilterColumns();
            for (int i = 0; i < CommonFilter2.size(); ++i) {
                if (!"org.name".equals(((FilterColumn)CommonFilter2.get(i)).getFieldName())) continue;
                CommonFilter2.remove(i);
            }
            List SchemeFilterColumn = args.getSchemeFilterColumns();
            for (int i = 0; i < SchemeFilterColumn.size(); ++i) {
                if (!"org.name".equals(((FilterColumn)SchemeFilterColumn.get(i)).getFieldName())) continue;
                SchemeFilterColumn.remove(i);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        if (StringUtils.isEmpty((CharSequence)viewhistory)) {
            filters.add(BidHistoryUtil.getEvaluationListQFilter());
        } else {
            Object bidProjectId = parameter.getCustomParam("bidProjectId");
            filters.add(BidHistoryUtil.getEvaluationHistoryQFilter(bidProjectId));
            Object evalType = parameter.getCustomParam("evalType");
            filters.add(new QFilter("evaltype", "=", evalType));
        }
        super.setFilter(e);
    }

    public String getQueryBillForm(DynamicObject evalution, IFormView frame) {
        String billstatus = evalution.getString("billstatus");
        String billno = evalution.getDynamicObject("bidproject").getString("billno");
        StringBuilder builder = new StringBuilder();
        String pref = "\u3010" + billno;
        builder.append(pref);
        if (!"D".equals(billstatus) && !"A".equals(billstatus)) {
            if (billstatus.equals("X") || billstatus.equals("XX")) {
                String str = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u5bf9\u5df2\u6d41\u6807\u7684\u8bb0\u5f55\u8fdb\u884c\u8d28\u7591\u6f84\u6e05\u3002", (String)"BidEvaluationList_31", (String)"scm-bid-formplugin", (Object[])new Object[0]), "\u3011\uff1a");
                builder.append(str);
                return builder.toString();
            }
            String str = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u5bf9\u5df2\u5b8c\u6210\u7684\u8bb0\u5f55\u8fdb\u884c\u8d28\u7591\u6f84\u6e05\u3002", (String)"BidEvaluationList_32", (String)"scm-bid-formplugin", (Object[])new Object[0]), "\u3011\uff1a");
            builder.append(str);
            return builder.toString();
        }
        DynamicObject bidProject = evalution.getDynamicObject("bidproject");
        String formId = this.getAppId() + "_supplierinvitation";
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProject.getPkValue());
        HashSet<String> statusSet = new HashSet<String>();
        statusSet.add("A");
        statusSet.add("B");
        statusSet.add("I");
        QFilter status = new QFilter("billstatus", "in", statusSet);
        boolean exists = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidProjectFilter, status});
        if (exists) {
            String str = String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u672a\u5b8c\u6210\u7684\u589e\u8865\u5165\u56f4\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u8d28\u7591\u3002", (String)"BidEvaluationList_33", (String)"scm-bid-formplugin", (Object[])new Object[0]), "\u3011\uff1a");
            builder.append(str);
            return builder.toString();
        }
        formId = this.getAppId() + "_bidpublish";
        exists = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidProjectFilter, status});
        if (exists) {
            String str = String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d1\u6807\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u8d28\u7591\u3002", (String)"BidEvaluationList_34", (String)"scm-bid-formplugin", (Object[])new Object[0]), "\u3011\uff1a");
            builder.append(str);
            return builder.toString();
        }
        String evaltype = evalution.getString("evaltype");
        BillShowParameter billShowParameter = this.questionClarifyUtil.addNewMultiQuestionClarifyBill(this.getAppId(), bidProject.getPkValue(), evaltype);
        Object bidevaluationId = evalution.get("id");
        HashMap<String, Object> historyMap = new HashMap<String, Object>();
        historyMap.put("bidevaluationid", bidevaluationId);
        historyMap.put("supplierinvitationid", evalution.getLong("supplierinvitationid"));
        historyMap.put("bidpublishid", evalution.get("bidpublishid"));
        historyMap.put("bidopenid", evalution.get("bidopenid"));
        billShowParameter.setCustomParam("historyMap", historyMap);
        billShowParameter.setCustomParam("org", (Object)bidProject.getDynamicObject("org").getString("id"));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
        return "";
    }
}

