/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.RichTextEditorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.bill.BidTemplateConstant;
import kd.scm.bid.common.constant.bill.OptionalColumnConstant;
import kd.scm.bid.common.enums.BidProjectDateEnum;
import kd.scm.bid.common.enums.BidProjectEnum;
import kd.scm.bid.common.enums.TemplateModelTypeEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.formplugin.bill.helper.TemplateManageHelper;
import kd.scm.bid.formplugin.bill.util.DateUtils;
import kd.scm.bid.formplugin.bill.util.SendMessageUtil;
import kd.scm.bid.formplugin.bill.util.SupplierInvitationUtil;

public class BidInvitationEdit
extends AbstractFormPlugin
implements UploadListener,
BeforeF7SelectListener {
    protected IBidProjectService projectService = new BidProjectServiceImpl();
    protected ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();
    private static String ATTACHE_TAG = "atta";
    private static String RICHTEXT_TAG = "rich";
    private static String SEND_BUTTON = "send";
    private static String PREVIEW_BUTTON = "preview";
    private static String NEXT = "next";
    private static String PREVIOUS = "previous";
    private BidTemplateConstant bidTemplateConstant = new BidTemplateConstant();

    private Object getInvitataionPkId(FormShowParameter formShowParameter) {
        BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
        Object invitationId = billShowParameter.getPkId();
        return invitationId;
    }

    private DynamicObject getInvitation(FormShowParameter formShowParameter) {
        BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
        Object invitationId = billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        if (StringUtils.isEmpty((CharSequence)formId)) {
            formId = "bid_invitation";
        }
        if (invitationId != null) {
            return BusinessDataServiceHelper.loadSingle((Object)invitationId, (String)formId);
        }
        return null;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        DynamicObjectCollection coll;
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        OperationStatus status = formShowParameter.getStatus();
        DynamicObject bidInvitation = this.getInvitation(formShowParameter);
        Object invitationId = null;
        if (bidInvitation != null) {
            invitationId = bidInvitation.getPkValue();
        }
        List<Object> listSuppliers = new ArrayList(10);
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            listSuppliers = this.listSuppliers(formShowParameter);
        } else if (OperationStatus.EDIT.equals((Object)status)) {
            if (invitationId != null && bidInvitation != null) {
                coll = bidInvitation.getDynamicObjectCollection("supplierentry");
                for (int i = 0; i < coll.size(); ++i) {
                    listSuppliers.add(((DynamicObject)coll.get(i)).getDynamicObject("supplier"));
                }
            }
        } else if (OperationStatus.VIEW.equals((Object)status) && invitationId != null && bidInvitation != null) {
            coll = bidInvitation.getDynamicObjectCollection("supplierentry");
            for (int i = 0; i < coll.size(); ++i) {
                listSuppliers.add(((DynamicObject)coll.get(i)).getDynamicObject("supplier"));
            }
        }
        if (listSuppliers == null || listSuppliers.size() == 0) {
            return;
        }
        Map<String, Object> mapHead = this.getMapHead(listSuppliers);
        e.getItems().add(mapHead);
    }

    protected List<DynamicObject> listSuppliers(FormShowParameter formShowParameter) {
        if (null == formShowParameter) {
            formShowParameter = this.getView().getFormShowParameter();
        }
        List<Object> listSuppliers = new ArrayList();
        DynamicObject bidInvitation = this.getInvitation(formShowParameter);
        Object supplierInvitationId = this.getSupplierInvitationId(bidInvitation, formShowParameter);
        if (null != supplierInvitationId) {
            listSuppliers = this.getSupplierByInvitation(supplierInvitationId);
        } else {
            Object bidProjectId = this.getBidProjectId(bidInvitation, formShowParameter);
            listSuppliers = this.getSupplierByBidProject(bidProjectId);
        }
        if (CollectionUtils.isEmpty(listSuppliers) && bidInvitation != null) {
            DynamicObjectCollection supplierEntryCol = bidInvitation.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryCol) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                listSuppliers.add(supplier);
            }
        }
        return listSuppliers;
    }

    protected Map<String, DynamicObject> getPartUser(FormShowParameter formShowParameter) {
        if (null == formShowParameter) {
            formShowParameter = this.getView().getFormShowParameter();
        }
        DynamicObject bidInvitation = this.getInvitation(formShowParameter);
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        Object supplierInvitationId = this.getSupplierInvitationId(bidInvitation, formShowParameter);
        if (null != supplierInvitationId) {
            String appId = this.getModel().getDataEntityType().getAppId();
            String tableFlag = "bid_supplierinvitation";
            if ("rebm".equals(appId)) {
                tableFlag = "rebm_supplierinvitation";
            }
            DynamicObject supplierinvitation = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(supplierInvitationId.toString()), (String)tableFlag);
            DynamicObjectCollection bidrollsection = supplierinvitation.getDynamicObjectCollection("bidsection");
            this.getDateToMap(bidrollsection, result);
        } else {
            Object bidProjectId = this.getBidProjectId(bidInvitation, formShowParameter);
            String appId = this.getModel().getDataEntityType().getAppId();
            String tableFlag = "bid_project";
            if ("rebm".equals(appId)) {
                tableFlag = "rebm_project";
            }
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)tableFlag);
            DynamicObjectCollection bidrollsection = bidProject.getDynamicObjectCollection("bidrollsection");
            this.getDateToMap(bidrollsection, result);
        }
        return result;
    }

    public void getDateToMap(DynamicObjectCollection sections, Map<String, DynamicObject> result) {
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject parter = row.getDynamicObject("projectpartner");
                DynamicObject supplier = row.getDynamicObject("supplier");
                if (supplier == null || parter == null) continue;
                result.put(supplier.getPkValue().toString(), parter);
            }
        }
    }

    protected TreeMap<String, List<DynamicObject>> mapSuppliers() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DynamicObject bidInvitation = this.getInvitation(formShowParameter);
        Object supplierInvitationId = this.getSupplierInvitationId(bidInvitation, formShowParameter);
        if (supplierInvitationId != null) {
            return this.getSupplierMapByInvitation(supplierInvitationId);
        }
        Object bidProjectId = this.getBidProjectId(bidInvitation, formShowParameter);
        return this.getSupplierMapByBidProject(bidProjectId);
    }

    private TreeMap<String, List<DynamicObject>> mapSupplier(Object invitationId) {
        TreeMap<String, List<DynamicObject>> map = new TreeMap<String, List<DynamicObject>>();
        String formId = FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass());
        DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)((Long)invitationId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        boolean isAgainInvitation = SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation);
        DynamicObjectCollection bidsectionColl = supplierInvitation.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidsectionColl.size(); ++i) {
            DynamicObject section = (DynamicObject)bidsectionColl.get(i);
            String sectionName = section.getString("sectionname");
            DynamicObjectCollection supplierentryColl = section.getDynamicObjectCollection("supplierentry");
            ArrayList<DynamicObject> listSuppliers = new ArrayList<DynamicObject>();
            for (int j = 0; j < supplierentryColl.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierentryColl.get(j);
                boolean isNew = supplierentry.getBoolean("isnew");
                boolean unSend = "UNSEND".equals(supplierentry.getString("invitationstatus"));
                DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                if (isAgainInvitation) {
                    String tenderStatus;
                    if (isNew && unSend) {
                        listSuppliers.add(supplier);
                    }
                    if (isNew || !unSend || !StringUtils.isEmpty((CharSequence)(tenderStatus = supplierentry.getString("tenderstatus"))) && !tenderStatus.contains("-")) continue;
                    listSuppliers.add(supplier);
                    continue;
                }
                if (!unSend) continue;
                listSuppliers.add(supplier);
            }
            map.put(i + sectionName, listSuppliers);
        }
        return map;
    }

    private Map<String, Object> getMapHead(List<DynamicObject> listSuppliers) {
        TabAp tab = this.createDynamicTabAp(listSuppliers);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", "suppliertab");
        mapHead.put("items", tab.createControl().get("items"));
        return mapHead;
    }

    private TabAp createDynamicTabAp(List<DynamicObject> listSuppliers) {
        TabAp tab = new TabAp();
        for (int i = 0; i < listSuppliers.size(); ++i) {
            DynamicObject supplier = listSuppliers.get(i);
            tab.setKey("suppliertab" + i);
            TabPageAp tpa = this.createTabPageAp(supplier);
            tab.getItems().add(tpa);
        }
        return tab;
    }

    private TabPageAp createTabPageAp(DynamicObject supplier) {
        String supplierId = supplier.getString("id");
        String supplierName = supplier.getString("name");
        TabPageAp tpa = new TabPageAp();
        tpa.setKey(supplierId);
        tpa.setId(supplierId);
        tpa.setName(new LocaleString(supplierName));
        RichTextEditorAp richTextAp = new RichTextEditorAp();
        String richKey = RICHTEXT_TAG + supplierId;
        richTextAp.setId(richKey);
        richTextAp.setKey(richKey);
        richTextAp.setName(new LocaleString(supplierName));
        richTextAp.setLock("view");
        richTextAp.setHeight(new LocaleString("400px"));
        tpa.getItems().add(richTextAp);
        AttachmentPanelAp attaAp = new AttachmentPanelAp();
        String attaKey = ATTACHE_TAG + supplierId;
        attaAp.setId(attaKey);
        attaAp.setKey(attaKey);
        attaAp.setLock("view");
        attaAp.setCollapsible(true);
        attaAp.setName(new LocaleString(ResManager.loadKDString((String)"\u4e13\u5c5e\u9644\u4ef6", (String)"BidInvitationEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("50px");
        style.setMargin(margin);
        attaAp.setStyle(style);
        Tips ctlTips = new Tips();
        ctlTips.setContent(new LocaleString(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u540e\u4f1a\u663e\u793a\u5230\u9009\u4e2d\u4f9b\u5e94\u5546\u7684\u9080\u8bf7\u51fd\u4e2d\u3002", (String)"BidInvitationEdit_10", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        ctlTips.setTriggerType("hover");
        ctlTips.setType("text");
        ctlTips.setShowIcon(true);
        attaAp.setCtlTips(ctlTips);
        tpa.getItems().add(attaAp);
        return tpa;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BidInvitationEdit", exp.getMessage()), new Object[0]);
        }
        List<DynamicObject> listSuppliers = this.listSuppliers(null);
        this.registDynamicProps(newMainType, listSuppliers);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, List<DynamicObject> listSuppliers) {
        for (int i = 0; i < listSuppliers.size(); ++i) {
            String supplierId = listSuppliers.get(i).getString("id");
            String supplierName = listSuppliers.get(i).getString("name");
            TextProp richTextProp = new TextProp();
            richTextProp.setName(RICHTEXT_TAG + supplierId);
            richTextProp.setDisplayName(new LocaleString(supplierName));
            richTextProp.setDbIgnore(true);
            richTextProp.setAlias(supplierName);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)richTextProp);
        }
    }

    public void beforeBindData(EventObject e) {
        Object invitationId = this.getInvitataionPkId(this.getView().getFormShowParameter());
        if (invitationId != null) {
            DynamicObject bidInvitation = this.getInvitationById(invitationId);
            this.setSupplierEntry(bidInvitation);
        }
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"templatemanage"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"publishdate"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"name"});
        } else if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
    }

    private DynamicObject getInvitationById(Object invitationId) {
        DynamicObject bidInvitation = BusinessDataServiceHelper.loadSingle((Object)invitationId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass())));
        return bidInvitation;
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().startsWith(RICHTEXT_TAG)) {
            RichTextEditor rechText = new RichTextEditor();
            String richKey = e.getKey();
            rechText.setKey(richKey);
            rechText.setView(this.getView());
            e.setControl((Control)rechText);
        } else if (e.getKey().startsWith(ATTACHE_TAG)) {
            AttachmentPanel panel = new AttachmentPanel();
            String key = e.getKey();
            panel.setKey(key);
            panel.setDefaultCollapse(false);
            panel.setView(this.getView());
            e.setControl((Control)panel);
        }
    }

    public void afterBindData(EventObject e) {
        Object invitationId;
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SEND_BUTTON});
        }
        if ((invitationId = this.getInvitataionPkId(this.getView().getFormShowParameter())) == null || this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SEND_BUTTON});
            this.getView().setVisible(Boolean.FALSE, new String[]{PREVIEW_BUTTON});
            this.setNewBidProject();
            this.getNewContent(null);
        } else if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            // empty if block
        }
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        this.getModel().setValue("org", bidProject.get("org"));
        this.getModel().getDataEntity().set("deadlinedate", bidProject.get("invitationdeadline"));
        this.getView().updateView("org");
        this.getView().updateView("deadlinedate");
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            return;
        }
        IDataEntityProperty pro = e.getProperty();
        String filedName = pro.getName();
        DynamicObject model = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"templatemanage")) {
            ChangeData[] datas = e.getChangeSet();
            ChangeData data = datas[0];
            Object newValue = data.getNewValue();
            if (newValue == null) {
                return;
            }
            if (data.getOldValue() == null && this.getInvitataionPkId(this.getView().getFormShowParameter()) != null) {
                return;
            }
            DynamicObject template = (DynamicObject)newValue;
            String templateContent = template.getString("content");
            data = datas[0];
            StringBuilder buffer = new StringBuilder();
            buffer.append(templateContent);
            this.getNewContent(buffer);
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)"deadlinedate")) {
            ChangeData[] datas = e.getChangeSet();
            ChangeData data = datas[0];
            Object newValue = data.getNewValue();
            Object oldValue = data.getOldValue();
            if (newValue == null) {
                return;
            }
            Date publishDate = model.getDate("publishdate");
            if (publishDate != null && publishDate.after((Date)newValue)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u7b49\u4e8e\u53d1\u5e03\u65f6\u95f4\u3002", (String)"BidInvitationEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("deadlinedate", null);
                return;
            }
            if (this.compareDate("invitationdeadline", (Date)newValue)) {
                this.getModel().setValue("deadlinedate", null);
                return;
            }
            String deadLineDate = DateUtils.date2String((Date)newValue, DateUtils.DETAIL_FORMAT);
            String oldDeadLineDate = null;
            if (oldValue != null) {
                oldDeadLineDate = DateUtils.date2String((Date)oldValue, DateUtils.DETAIL_FORMAT);
            }
            List<DynamicObject> listSuppliers = this.listSuppliers(null);
            for (int i = 0; i < listSuppliers.size(); ++i) {
                DynamicObject supplier = listSuppliers.get(i);
                String supplierId = supplier.getString("id");
                String richContentKey = RICHTEXT_TAG + supplierId;
                RichTextEditor richContent = (RichTextEditor)this.getView().getControl(richContentKey);
                if (StringUtils.isEmpty((CharSequence)richContent.getText())) continue;
                String content = this.replaceDeadLineDate(richContent.getText(), oldDeadLineDate, deadLineDate);
                richContent.setText(content);
                this.getView().updateView(richContentKey);
                DynamicObjectCollection supplierentryColl = this.getModel().getEntryEntity("supplierentry");
                if (supplierentryColl.isEmpty()) continue;
                for (int j = 0; j < supplierentryColl.size(); ++j) {
                    DynamicObject supplierentry = (DynamicObject)supplierentryColl.get(j);
                    DynamicObject tempSupplier = supplierentry.getDynamicObject("supplier");
                    if (!supplierId.equals(tempSupplier.getString("id"))) continue;
                    this.getModel().setValue("content", (Object)content, j);
                }
            }
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)"publishdate")) {
            ChangeData[] datas = e.getChangeSet();
            ChangeData data = datas[0];
            Object newValue = data.getNewValue();
            if (newValue == null) {
                return;
            }
            Date invitationDeadline = model.getDate("deadlinedate");
            if (invitationDeadline != null && invitationDeadline.before((Date)newValue)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u7b49\u4e8e\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidInvitationEdit_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("publishdate", null);
                return;
            }
        }
    }

    public boolean compareDate(String dateType, Date date) {
        BidProjectDateEnum curDate = BidProjectDateEnum.valueOf((String)dateType);
        int index = curDate.getIndex();
        List dates4Early = Arrays.stream(BidProjectDateEnum.values()).filter(dateEnum -> dateEnum.getIndex() > index).collect(Collectors.toList());
        Collections.sort(dates4Early, (d1, d2) -> d1.getIndex() - d2.getIndex());
        DynamicObject bidProject = this.getModel().getDataEntity(true).getDynamicObject("bidproject");
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        for (BidProjectDateEnum date4Project : dates4Early) {
            Date compareDate = bidProject.getDate(date4Project.name());
            if ("technicaldocenddate".equals(date4Project.name()) || "commercialdocenddate".equals(date4Project.name()) || compareDate == null || !compareDate.before(date)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u987b\u65e9\u4e8e\u7b49\u4e8e%1$s\u3002", (String)"BidInvitationEdit_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), date4Project.getAlias()));
            return true;
        }
        return false;
    }

    protected void setNewBidProject() {
        Object supplierInvitationId = this.getView().getFormShowParameter().getCustomParam("supplierInvitationId");
        DynamicObject bidProject = null;
        if (null != supplierInvitationId) {
            DynamicObject supplierInvitation = this.supplierInvitationService.getSupplierInvitationById((Long)supplierInvitationId);
            this.getModel().setValue("supplierinvitation", (Object)supplierInvitation);
            bidProject = this.projectService.getBidProjectAllById(Long.valueOf(supplierInvitation.getDynamicObject("bidProject").getLong("id")));
        } else {
            Object bidProjectId = this.getView().getFormShowParameter().getCustomParam("bidProjectId");
            if (null == bidProjectId) {
                return;
            }
            bidProject = this.projectService.getBidProjectAllById((Long)bidProjectId);
        }
        String name = bidProject.getString("name");
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            name = name + " ";
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String billnosbid = CodeRuleServiceHelper.getNumber((String)"bid_invitation", (DynamicObject)dataEntity, (String)null);
        String billnosrebm = CodeRuleServiceHelper.getNumber((String)"rebm_invitation", (DynamicObject)dataEntity, (String)null);
        if (billnosbid == null && billnosrebm == null) {
            this.getModel().setValue("number", (Object)(name + new LocaleString(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd", (String)"BidInvitationEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]))));
        }
        this.getModel().setValue("name", (Object)(name + new LocaleString(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd", (String)"BidInvitationEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]))));
        this.getModel().setValue("bidproject", (Object)bidProject);
        this.getModel().setValue("deadlinedate", bidProject.get("invitationdeadline"));
        DynamicObject template = TemplateManageHelper.getDefaultByModelType(TemplateModelTypeEnum.INVITATION.getValue(), bidProject.getLong("org.id"));
        if (template != null) {
            this.getModel().setValue("templatemanage", (Object)template);
        }
    }

    private void setSupplierEntry(DynamicObject invitation) {
        DynamicObjectCollection coll = invitation.getDynamicObjectCollection("supplierentry");
        if (!coll.isEmpty()) {
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject supplierEntry = (DynamicObject)coll.get(i);
                String content = supplierEntry.getString("content");
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                String supplierId = supplier.getString("id");
                String richContentKey = RICHTEXT_TAG + supplierId;
                RichTextEditor richContent = (RichTextEditor)this.getView().getControl(richContentKey);
                richContent.setText(content);
                this.getView().updateView(richContentKey);
                String attaKey = ATTACHE_TAG + supplierId;
                AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(attaKey);
                panel.setKey(attaKey);
                panel.setDefaultCollapse(false);
                this.getView().updateView(attaKey);
            }
        }
    }

    private void getNewContent(StringBuilder content) {
        block11: {
            String deadlinedateStr;
            String annotitle;
            DynamicObject bidProject;
            List<DynamicObject> listSuppliers;
            block10: {
                IDataModel operate;
                DynamicObjectCollection coll;
                listSuppliers = this.listSuppliers(null);
                bidProject = (DynamicObject)this.getModel().getValue("bidproject");
                annotitle = "";
                QFilter filter = new QFilter("bidproject", "=", (Object)bidProject.getPkValue().toString());
                DynamicObject announcement = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()), (String)"annotitle", (QFilter[])new QFilter[]{filter});
                if (announcement != null) {
                    annotitle = announcement.getString("annotitle");
                }
                Object deadlinedate = this.getModel().getValue("deadlinedate");
                deadlinedateStr = "";
                if (deadlinedate != null) {
                    deadlinedateStr = DateUtils.date2String((Date)deadlinedate, DateUtils.DETAIL_FORMAT);
                }
                EntryGrid grid = (EntryGrid)this.getControl("supplierentry");
                boolean isAddNew = true;
                if (grid != null && !(coll = (operate = grid.getModel()).getEntryEntity("supplierentry")).isEmpty()) {
                    for (int i = 0; i < coll.size(); ++i) {
                        DynamicObject iSupplier = (DynamicObject)coll.get(i);
                        Object collSupplierId = iSupplier.getDynamicObject("supplier").getPkValue();
                        for (int j = 0; j < listSuppliers.size(); ++j) {
                            DynamicObject template;
                            DynamicObject jSupplier = listSuppliers.get(j);
                            if (!jSupplier.getPkValue().equals(collSupplierId)) continue;
                            if (StringUtils.isNotEmpty((CharSequence)content)) {
                                this.updateContent(bidProject, jSupplier, annotitle, content, deadlinedateStr, i);
                                continue;
                            }
                            StringBuilder supplierContent = new StringBuilder(iSupplier.getString("content"));
                            if (StringUtils.isEmpty((CharSequence)supplierContent) && (template = this.getModel().getDataEntity().getDynamicObject("templatemanage")) != null) {
                                String templateContent = template.getString("content");
                                supplierContent.append(templateContent);
                            }
                            this.updateContent(bidProject, jSupplier, annotitle, supplierContent, deadlinedateStr, i);
                        }
                    }
                    isAddNew = false;
                }
                if (!isAddNew || !this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) break block10;
                this.getModel().deleteEntryData("supplierentry");
                for (int i = 0; i < listSuppliers.size(); ++i) {
                    DynamicObject supplier = listSuppliers.get(i);
                    int row = this.getModel().createNewEntryRow("supplierentry");
                    this.getModel().setValue("supplier", (Object)supplier, row);
                    this.getModel().setValue("invitationstatus", (Object)"UNSEND", row);
                    this.updateContent(bidProject, supplier, annotitle, content, deadlinedateStr, row);
                }
                break block11;
            }
            if (!this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) break block11;
            DynamicObjectCollection curSupplierEntry = this.getModel().getEntryEntity("supplierentry");
            HashSet<Long> curSupplierSet = new HashSet<Long>();
            for (DynamicObject curSupplierEntryRow : curSupplierEntry) {
                curSupplierSet.add((Long)curSupplierEntryRow.getDynamicObject("supplier").getPkValue());
            }
            for (int i = 0; i < listSuppliers.size(); ++i) {
                if (curSupplierSet.contains((Long)listSuppliers.get(i).getPkValue())) continue;
                DynamicObject supplier = listSuppliers.get(i);
                int row = this.getModel().createNewEntryRow("supplierentry");
                this.getModel().setValue("supplier", (Object)supplier, row);
                this.getModel().setValue("invitationstatus", (Object)"UNSEND", row);
                this.updateContent(bidProject, supplier, annotitle, content, deadlinedateStr, row);
            }
        }
    }

    private void updateContent(DynamicObject bidProject, DynamicObject supplier, String annotitle, StringBuilder content, String deadlinedateStr, int row) {
        String richContentKey = RICHTEXT_TAG + supplier.getString("id");
        String purentrycontent = this.getProjectEntryValue(bidProject, supplier, "purentrycontent");
        String contentStr = "";
        if (!StringUtils.isEmpty((CharSequence)content)) {
            contentStr = this.replaceContent(bidProject, supplier, annotitle, purentrycontent, new String(content));
            contentStr = this.replaceDeadLineDate(contentStr, null, deadlinedateStr);
            if (this.getView().getControl(richContentKey) != null) {
                ((RichTextEditor)this.getView().getControl(richContentKey)).setText(contentStr);
                this.getView().updateView(richContentKey);
            }
        }
        this.getModel().setValue("content", (Object)contentStr, row);
    }

    private String getProjectEntryValue(DynamicObject bidProject, DynamicObject supplier, String key) {
        StringBuilder entryValueSb = new StringBuilder();
        DynamicObjectCollection bidSectionColl = bidProject.getDynamicObjectCollection("bidsection");
        TreeMap<String, List<DynamicObject>> map = this.mapSuppliers();
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        for (int i = 0; i < bidSectionColl.size(); ++i) {
            DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
            String sectionName = bidSection.getString("sectionname");
            List<DynamicObject> list = map.get(i + sectionName);
            boolean isContains = false;
            for (DynamicObject supplierObj : list) {
                if (!supplierObj.getPkValue().equals(supplier.getPkValue())) continue;
                isContains = true;
                break;
            }
            if (!isContains) continue;
            StringBuilder tempValueSb = new StringBuilder();
            DynamicObjectCollection projectEntryColl = bidSection.getDynamicObjectCollection("projectentry");
            for (int j = 0; j < projectEntryColl.size(); ++j) {
                DynamicObject projectEntry = (DynamicObject)projectEntryColl.get(j);
                String value = "";
                if ("purentrycontent".equals(key) && bidProject.getBoolean("ismaterialpur")) {
                    DynamicObject material = projectEntry.getDynamicObject("materialid");
                    if (material != null) {
                        value = material.getString("name");
                    }
                } else {
                    value = projectEntry.getString(key);
                }
                String tempValue = tempValueSb.toString();
                if (!StringUtils.isEmpty((CharSequence)tempValue)) {
                    String currentValue = "\uff0c" + value;
                    tempValueSb.append(currentValue);
                    continue;
                }
                tempValueSb.append(value);
            }
            if (!enablemultisection) {
                return tempValueSb.toString();
            }
            String entryValue = entryValueSb.toString();
            if (!StringUtils.isEmpty((CharSequence)entryValue)) {
                entryValueSb.append('\n');
                entryValueSb.append(sectionName);
                entryValueSb.append('\uff1a');
                entryValueSb.append((CharSequence)tempValueSb);
                continue;
            }
            entryValueSb.append(sectionName);
            entryValueSb.append('\uff1a');
            entryValueSb.append((CharSequence)tempValueSb);
        }
        return entryValueSb.toString();
    }

    private String replaceContent(DynamicObject bidProject, DynamicObject supplier, String annotitle, String purentrycontent, String content) {
        String supplierName = supplier.getString("name");
        String projectName = bidProject.getString("name");
        DynamicObject purType = bidProject.getDynamicObject("purtype");
        String purTypeName = purType == null ? "" : purType.getString("name");
        DynamicObject contact = bidProject.getDynamicObject("contact");
        String contactName = contact == null ? "" : contact.getString("name");
        String contacttel = bidProject.getString("contacttel");
        String email = bidProject.getString("proemail");
        String address = bidProject.getString("proaddress");
        String[] invitationList = this.bidTemplateConstant.getInvitationValues();
        String invitation0 = invitationList[0];
        String invitation1 = invitationList[1];
        String invitation3 = invitationList[3];
        String invitation4 = invitationList[4];
        String invitation5 = invitationList[5];
        String invitation6 = invitationList[6];
        String invitation7 = invitationList[7];
        String inviationSupplierName = this.bidTemplateConstant.getInviationSupplierName();
        String projectNameLabel = this.bidTemplateConstant.getProjectName();
        content = content.replace(TemplateManageHelper.getSpecialValue(inviationSupplierName), supplierName).replace(TemplateManageHelper.getSpecialValue(projectNameLabel), projectName).replace(TemplateManageHelper.getSpecialValue(invitation0), this.getModel().getDataEntity().getString("name")).replace(TemplateManageHelper.getSpecialValue(invitation1), purTypeName).replace(TemplateManageHelper.getSpecialValue(invitation3), purentrycontent).replace(TemplateManageHelper.getSpecialValue(invitation4), contactName).replace(TemplateManageHelper.getSpecialValue(invitation5), contacttel).replace(TemplateManageHelper.getSpecialValue(invitation6), email).replace(TemplateManageHelper.getSpecialValue(invitation7), address);
        OptionalColumnConstant aColumnConstant = new OptionalColumnConstant("invitation");
        List columns = aColumnConstant.getColumns();
        String tempValue = new BidTemplateConstant().getInvitationValues()[2];
        for (int i = 0; i < columns.size(); ++i) {
            Map map = (Map)columns.get(i);
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                if (value.equals(tempValue)) continue;
                content = this.replaceOtherContent(bidProject, content, value);
            }
        }
        return content;
    }

    private String replaceOtherContent(DynamicObject bidProject, String content, String value) {
        String valueStr = TemplateManageHelper.getSpecialValue(value);
        Lang lang = RequestContext.get().getLang();
        if (!content.contains(valueStr)) {
            return content;
        }
        if (BidProjectEnum.ENDTIME.getValue().equals(value)) {
            Date enrolldeadline = bidProject.getDate("enrolldeadline");
            content = content.replace(valueStr, DateUtils.date2String(enrolldeadline));
        } else if (BidProjectEnum.QUALIFICATIONREQUIRED.getValue().equals(value)) {
            String qualificationrequired = bidProject.getString("qualificationrequired");
            content = content.replace(valueStr, qualificationrequired);
        } else if (BidProjectEnum.ORG.getValue().equals(value)) {
            String orgName = bidProject.getString("org.name");
            content = content.replace(valueStr, orgName);
        } else if (BidProjectEnum.PURDESCRIPTION.getValue().equals(value)) {
            ILocaleString orgName = bidProject.getLocaleString("purdescription");
            content = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? content.replace(valueStr, orgName.getLocaleValue_en()) : content.replace(valueStr, orgName.getLocaleValue_zh_CN());
        } else if (BidProjectEnum.PURENTRYPROJECT.getValue().equals(value)) {
            ILocaleString purprojects = bidProject.getLocaleString("purprojectset");
            content = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? content.replace(valueStr, purprojects.getLocaleValue_en()) : content.replace(valueStr, purprojects.getLocaleValue_zh_CN());
        } else if (BidProjectEnum.FAX.getValue().equals(value)) {
            String fax = bidProject.getString("profax");
            content = content.replace(valueStr, fax);
        } else if (BidProjectEnum.BIDMODE.getValue().equals(value)) {
            String bidmode = bidProject.getDynamicObject("bidmode").getString("name");
            content = content.replace(valueStr, bidmode);
        } else {
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.SUPPLIERINVIENDDATE.getValue(), "supplierinvienddate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.TECHNICALDOCENDDTAE.getValue(), "technicaldocenddate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.COMMERCIALDOCENDDATE.getValue(), "commercialdocenddate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.BIDPUBLISHDATE.getValue(), "bidpublishdate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.ANSWERQUESTIONTIME.getValue(), "answerquestiontime", value, Boolean.FALSE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.APPROACHDATE.getValue(), "approachdate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.ANSWERCOMPLETE.getValue(), "answercomplete", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.BIDOPENDEADLINE.getValue(), "bidopendeadline", value, Boolean.FALSE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.BIDEVALUATIONDATE.getValue(), "bidevaluationdate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.BIDDECISIONDATE.getValue(), "biddecisiondate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.DESIGNDATE.getValue(), null, value, Boolean.TRUE);
        }
        return content;
    }

    private String replaceDateContent(DynamicObject bidProject, String content, String enumValue, String dateKey, String value, Boolean isSimple) {
        String valueStr = TemplateManageHelper.getSpecialValue(value);
        if (dateKey == null) {
            content = content.replace(valueStr, "");
        } else if (enumValue.equals(value)) {
            Date date = bidProject.getDate(dateKey);
            content = content.replace(valueStr, DateUtils.date2StringSimpleOrDetail(date, isSimple));
        }
        return content;
    }

    private String replaceDeadLineDate(String content, String oldValue, String deadLineDate) {
        if (deadLineDate.equals("")) {
            return content;
        }
        if (oldValue == null) {
            String[] invitationList = new BidTemplateConstant().getInvitationValues();
            oldValue = TemplateManageHelper.getSpecialValue(invitationList[2]);
        }
        content = content.replace(oldValue, deadLineDate);
        return content;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        Tab tab = (Tab)this.getView().getControl("suppliertab");
        String supplierId = tab.getCurrentTab();
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection supplierEntryColl = data.getDynamicObjectCollection("supplierentry");
        Object invitationId = this.getModel().getValue("id");
        if (PREVIEW_BUTTON.equals(operateKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation_preview", ((Object)((Object)this)).getClass()));
            showParameter.setStatus(OperationStatus.VIEW);
            if (supplierId == null && !supplierEntryColl.isEmpty()) {
                DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(0);
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                supplierId = supplier.getString("id");
            }
            if (invitationId != null) {
                List publicAttachs = this.supplierInvitationService.listAttach((Object)FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()), invitationId, "attachmentpanelap");
                for (int i = 0; i < supplierEntryColl.size(); ++i) {
                    DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(i);
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    String tempSupplierId = supplier.getString("id");
                    if (!tempSupplierId.equals(supplierId)) continue;
                    showParameter.setCustomParam("supplier", (Object)supplier);
                    RichTextEditor richText = (RichTextEditor)this.getView().getControl(RICHTEXT_TAG + tempSupplierId);
                    String contentStr = richText.getText();
                    showParameter.setCustomParam("content", (Object)this.setRichTextEditorapStr(contentStr, invitationId.toString(), tempSupplierId, publicAttachs));
                    String invitationstatus = supplierEntry.getString("invitationstatus");
                    showParameter.setCustomParam("invitationstatus", (Object)invitationstatus);
                    break;
                }
            }
            DynamicObject bidProject = data.getDynamicObject("bidproject");
            String title = data.getString("name");
            showParameter.setCustomParam("title", (Object)title);
            showParameter.setCustomParam("publishdate", (Object)data.getDate("publishdate"));
            showParameter.setCustomParam("org", (Object)bidProject.getLocaleString("org.name").toString());
            showParameter.setCustomParam("purtype", (Object)bidProject.getDynamicObject("purtype").getString("name"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "previewinvitation"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else if ((StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String appId = this.getModel().getDataEntityType().getAppId();
            for (DynamicObject item : supplierEntryColl) {
                DynamicObject supplier = item.getDynamicObject("supplier");
                String tempSupplierId = supplier.getString("id");
                RichTextEditor richText = (RichTextEditor)this.getView().getControl(RICHTEXT_TAG + tempSupplierId);
                String contentStr = richText.getText();
                item.set("content", (Object)contentStr);
                item.set("invitationstatus", (Object)"UNCONFIRM");
            }
            data.set("entitytypeid", (Object)(appId + "_invitation"));
            data.set("enable", (Object)1);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long supplierInvitationId = (Long)this.getView().getFormShowParameter().getCustomParam("supplierInvitationId");
            if (null != supplierInvitationId) {
                JSONArray unSendSupplierEntryList = (JSONArray)formShowParameter.getCustomParam("unsendSupplierEntryList");
                DynamicObject supplierInvitation = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)"rebm_supplierinvitation") : this.supplierInvitationService.getSupplierInvitationById(supplierInvitationId);
                DynamicObjectCollection bidsectionCollection = (DynamicObjectCollection)supplierInvitation.get("bidsection");
                for (DynamicObject bidsection : bidsectionCollection) {
                    supplierEntryColl = bidsection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject item : supplierEntryColl) {
                        String supplierEntryId = item.get("id").toString();
                        if (unSendSupplierEntryList == null || !unSendSupplierEntryList.contains((Object)supplierEntryId)) continue;
                        item.set("invitation", (Object)Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()));
                    }
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass())), (Object[])new DynamicObject[]{supplierInvitation});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{SEND_BUTTON, PREVIEW_BUTTON});
            this.holdRichContent();
        } else if (("send".equals(operateKey) || "unsend".equals(operateKey) || "unaudit".equals(operateKey)) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void click(EventObject evt) {
        DynamicObject[] invitationColl;
        Object previousInvitation;
        super.click(evt);
        DynamicObject bidProject = this.getModel().getDataEntity().getDynamicObject("bidproject");
        String itemKey = ((Button)evt.getSource()).getKey().toLowerCase();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"next")) {
            DynamicObject[] invitationColl2 = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()), (String)"id,publishdate,bidproject", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())}, (String)"publishdate desc");
            Object nextInvitation = this.genNextInvitation(invitationColl2);
            if (nextInvitation != null) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
                showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
                showParameter.setCustomParam("supplierInvitationId", this.getView().getFormShowParameter().getCustomParam("supplierInvitationId"));
                showParameter.setPkId(nextInvitation);
                showParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u67e5\u770b", (String)"BidInvitationEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"previous") && (previousInvitation = this.genPreviousInvitation(invitationColl = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()), (String)"id,publishdate,bidproject", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())}, (String)"publishdate desc"))) != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            showParameter.setCustomParam("supplierInvitationId", this.getView().getFormShowParameter().getCustomParam("supplierInvitationId"));
            showParameter.setPkId(previousInvitation);
            showParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u67e5\u770b", (String)"BidInvitationEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private Object genNextInvitation(DynamicObject[] invitationColl) {
        if (invitationColl != null) {
            for (int i = 0; i < invitationColl.length; ++i) {
                DynamicObject invitation = invitationColl[i];
                if (!this.getModel().getDataEntity().getPkValue().equals(invitation.getPkValue()) || i >= invitationColl.length - 1) continue;
                return invitationColl[i + 1].getPkValue();
            }
        }
        return null;
    }

    private Object genPreviousInvitation(DynamicObject[] invitationColl) {
        if (invitationColl != null) {
            for (int i = 0; i < invitationColl.length; ++i) {
                DynamicObject invitation = invitationColl[i];
                if (!this.getModel().getDataEntity().getPkValue().equals(invitation.getPkValue()) || i <= 0) continue;
                return invitationColl[i - 1].getPkValue();
            }
        }
        return null;
    }

    private void holdRichContent() {
        DynamicObject supplier;
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObject invitation = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)data.getDataEntityType().getName());
        HashMap<String, String> invitationMap = new HashMap<String, String>();
        if (invitation != null) {
            DynamicObjectCollection collList = invitation.getDynamicObjectCollection("supplierentry");
            for (DynamicObject coll : collList) {
                supplier = coll.getDynamicObject("supplier");
                if (supplier == null) continue;
                invitationMap.put(supplier.getPkValue().toString(), coll.getString("content"));
            }
        }
        DynamicObjectCollection coll = (DynamicObjectCollection)data.get("supplierentry");
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject supplierEntry = (DynamicObject)coll.get(i);
            supplier = supplierEntry.getDynamicObject("supplier");
            String content = supplierEntry.getString("content");
            if (StringUtils.isEmpty((CharSequence)content)) {
                content = (String)invitationMap.get(supplier.getPkValue().toString());
            }
            String richKey = RICHTEXT_TAG + supplier.get("id");
            ((RichTextEditor)this.getView().getControl(richKey)).setText(content);
        }
    }

    private String setRichTextEditorapStr(String content, String invitationId, Object pkValue, List<Map<String, Object>> publicAttachs) {
        ArrayList<Map<String, Object>> attachList = new ArrayList<Map<String, Object>>();
        String key = ATTACHE_TAG + String.valueOf(pkValue);
        List attachs = this.supplierInvitationService.listAttach((Object)FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()), (Object)invitationId, key);
        if (attachs != null) {
            attachList.addAll(attachs);
        }
        if (publicAttachs != null) {
            attachList.addAll(publicAttachs);
        }
        content = TemplateManageHelper.getRichContent(attachList, content, ResManager.loadKDString((String)"\u9644\u4ef6", (String)"BidInvitationEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        return content;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit template = (BasedataEdit)this.getView().getControl("templatemanage");
        template.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        List<DynamicObject> suppliers = this.listSuppliers(null);
        for (int i = 0; i < suppliers.size(); ++i) {
            DynamicObject supplier = suppliers.get(i);
            String attakey = ATTACHE_TAG + supplier.get("id");
            AttachmentPanel atta = (AttachmentPanel)this.getView().getControl(attakey);
            atta.addUploadListener((UploadListener)this);
        }
        AttachmentPanel atta = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        atta.addUploadListener((UploadListener)this);
        Vector vectorNext = (Vector)this.getView().getControl(NEXT);
        vectorNext.addClickListener((ClickListener)this);
        Vector vectorPrevious = (Vector)this.getView().getControl(PREVIOUS);
        vectorPrevious.addClickListener((ClickListener)this);
    }

    public void upload(UploadEvent evt) {
    }

    public void remove(UploadEvent evt) {
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String fieldKey = paramBeforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"templatemanage")) {
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            Set orgIds = OrgUnitHelper.getParentOrgUnitSet((Long)bidProject.getLong("org.id"));
            QFilter qFilter = new QFilter("org", "in", (Object)orgIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.setCustomParam("modelType", (Object)"invitation");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Map<String, DynamicObject> partUser = this.getPartUser(this.getView().getFormShowParameter());
        if ("save".equalsIgnoreCase(operateKey) || "submit".equalsIgnoreCase(operateKey)) {
            DynamicObject data = this.getModel().getDataEntity(true);
            DynamicObjectCollection coll = data.getDynamicObjectCollection("supplierentry");
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject supplierEntry = (DynamicObject)coll.get(i);
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                String richKey = RICHTEXT_TAG + supplier.get("id");
                String content = ((RichTextEditor)this.getView().getControl(richKey)).getText();
                supplierEntry.set("content", (Object)content);
                DynamicObject parter = partUser.get(supplier.getPkValue().toString());
                if (parter == null) continue;
                supplierEntry.set("projectpartner", (Object)parter);
            }
            this.getView().getModel().setValue("enable", (Object)1L);
            this.getView().updateView("supplierentry");
            String bidProjectId = data.getDynamicObject("bidproject").getPkValue().toString();
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidProjectId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass())));
            Date deadLineDate = data.getDate("deadlinedate");
            if (deadLineDate != null) {
                bidProject.set("invitationdeadline", (Object)deadLineDate);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
            }
        } else if (SEND_BUTTON.equals(operateKey.toLowerCase(Locale.getDefault()))) {
            if (this.getModel().getValue("deadlinedate") == null || this.getModel().getValue("deadlinedate") != null && StringUtils.isEmpty((CharSequence)this.getModel().getValue("deadlinedate").toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u201c\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u7acb\u9879\u8c03\u6574\u4e2d\u8bbe\u7f6e\u3002", (String)"BidInvitationEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("unaudit".equalsIgnoreCase(operateKey)) {
            this.getView().getModel().setValue("status", (Object)"A");
            this.getView().getModel().setValue("releasestatus", null);
        } else if ("audit".equalsIgnoreCase(operateKey)) {
            this.getView().getModel().setValue("releasestatus", (Object)"U");
        } else if ("submitaudit".equals(operateKey)) {
            this.getView().getModel().setValue("releasestatus", (Object)"U");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String status;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)"previewinvitation", (CharSequence)closedCallBackEvent.getActionId()) && (status = this.getModel().getDataEntity().getString("status")).equals("B")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    protected List<DynamicObject> getSupplierByInvitation(Object supplierInvitationId) {
        TreeMap<String, List<DynamicObject>> map = this.mapSupplier(supplierInvitationId);
        ArrayList<DynamicObject> listSuppliers = null;
        if (!map.isEmpty()) {
            listSuppliers = new ArrayList<DynamicObject>();
            for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
                List<DynamicObject> tempList = entry.getValue();
                for (int i = 0; i < tempList.size(); ++i) {
                    if (listSuppliers.contains(tempList.get(i))) continue;
                    listSuppliers.add(tempList.get(i));
                }
            }
        }
        return listSuppliers;
    }

    protected List<DynamicObject> getSupplierByBidProject(Object bidProjectId) {
        if (null == bidProjectId) {
            return null;
        }
        ArrayList<DynamicObject> supplierList = new ArrayList<DynamicObject>();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)String.join((CharSequence)",", "bidrollsection", "supplierentry", "supplier"));
        DynamicObjectCollection bidSectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        HashSet<Object> supplierIdSet = new HashSet<Object>();
        for (DynamicObject sectionEntry : bidSectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (null == supplier || supplierIdSet.contains(supplier.getPkValue())) continue;
                supplierList.add(supplier);
                supplierIdSet.add(supplier.getPkValue());
            }
        }
        return supplierList;
    }

    protected TreeMap<String, List<DynamicObject>> getSupplierMapByInvitation(Object supplierInvitationId) {
        TreeMap<String, List<DynamicObject>> map = new TreeMap<String, List<DynamicObject>>();
        DynamicObject supplierInvitation = this.supplierInvitationService.getSupplierInvitationById((Long)supplierInvitationId);
        DynamicObjectCollection bidsectionColl = supplierInvitation.getDynamicObjectCollection("bidsection");
        boolean isAgainInvitation = SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation);
        for (int i = 0; i < bidsectionColl.size(); ++i) {
            DynamicObject section = (DynamicObject)bidsectionColl.get(i);
            String sectionName = section.getString("sectionname");
            DynamicObjectCollection supplierentryColl = section.getDynamicObjectCollection("supplierentry");
            ArrayList<DynamicObject> listSuppliers = new ArrayList<DynamicObject>();
            for (int j = 0; j < supplierentryColl.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierentryColl.get(j);
                boolean isNew = supplierentry.getBoolean("isnew");
                boolean unSend = "UNSEND".equals(supplierentry.getString("invitationstatus"));
                DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                if (isAgainInvitation) {
                    String tenderStatus;
                    if (isNew && unSend) {
                        listSuppliers.add(supplier);
                    }
                    if (isNew || !unSend || !StringUtils.isEmpty((CharSequence)(tenderStatus = supplierentry.getString("tenderstatus"))) && !tenderStatus.contains("-")) continue;
                    listSuppliers.add(supplier);
                    continue;
                }
                if (!unSend) continue;
                listSuppliers.add(supplier);
            }
            map.put(i + sectionName, listSuppliers);
        }
        return map;
    }

    protected TreeMap<String, List<DynamicObject>> getSupplierMapByBidProject(Object bidProjectId) {
        if (null == bidProjectId) {
            return null;
        }
        TreeMap<String, List<DynamicObject>> map = new TreeMap<String, List<DynamicObject>>();
        DynamicObject bidProject = this.projectService.getBidProjectAllById((Long)bidProjectId);
        DynamicObjectCollection bidSectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        for (int i = 0; i < bidSectionEntryColl.size(); ++i) {
            DynamicObject sectionEntry = (DynamicObject)bidSectionEntryColl.get(i);
            ArrayList<DynamicObject> listSuppliers = new ArrayList<DynamicObject>();
            String sectionName = sectionEntry.getString("rollsectionname");
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (null == supplier) continue;
                listSuppliers.add(supplier);
            }
            map.put(i + sectionName, listSuppliers);
        }
        return map;
    }

    protected void updateSupplierInvitation(String appId, String operateKey, Object supplierInvitationId, Object invitationId, boolean isFromSupInv) {
        if (null == supplierInvitationId) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONArray unsendSupplierEntryList = (JSONArray)formShowParameter.getCustomParam("unsendSupplierEntryList");
        DynamicObject supplierInvitation = this.supplierInvitationService.getSupplierInvitationById((Long)supplierInvitationId);
        DynamicObjectCollection bidsectionCollection = (DynamicObjectCollection)supplierInvitation.get("bidsection");
        for (DynamicObject bidsection : bidsectionCollection) {
            DynamicObjectCollection supplierEntryColl = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                if (isFromSupInv) {
                    String supplierEntryId = supplierEntry.getPkValue().toString();
                    if (unsendSupplierEntryList == null || !unsendSupplierEntryList.contains((Object)supplierEntryId)) continue;
                    supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
                    supplierEntry.set("invitation", invitationId);
                    supplierEntry.set("isrecommend", (Object)Boolean.FALSE);
                    continue;
                }
                if (!"UNSEND".equals(supplierEntry.getString("invitationstatus"))) continue;
                supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
                supplierEntry.set("invitation", invitationId);
                supplierEntry.set("isrecommend", (Object)Boolean.FALSE);
            }
        }
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass())), (Object[])new DynamicObject[]{supplierInvitation});
        if (isFromSupInv) {
            this.getView().setReturnData((Object)supplierInvitation);
            new SendMessageUtil().sentInvitedMsg(appId, operateKey, invitationId, supplierInvitation);
        }
    }

    protected void updateBidProject(String appId, String operateKey, Object invitationId, Object bidProjectId, boolean isFromSupInv, Long supplierInvitationId) {
        DynamicObject supplierInvitation = this.supplierInvitationService.getSupplierInvitationById(supplierInvitationId);
        HashSet<Long> supplierInvation = new HashSet<Long>();
        DynamicObjectCollection bidsectionCollection = (DynamicObjectCollection)supplierInvitation.get("bidsection");
        for (DynamicObject bidsection : bidsectionCollection) {
            DynamicObjectCollection supplierEntryColl = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                supplierInvation.add(Long.parseLong(supplier.getPkValue().toString()));
            }
        }
        DynamicObject bidProject = this.projectService.getBidProjectAllById((Long)bidProjectId);
        String prefix = bidProject.getString("entitytypeid").split("_")[0];
        bidProject = "rebm".equals(prefix) ? BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"rebm_project") : BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        DynamicObjectCollection bidSectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        for (DynamicObject sectionEntry : bidSectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                boolean flag;
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                boolean bl = flag = !CollectionUtils.isEmpty(supplierInvation) || supplierInvation.contains(supplier.getLong("id"));
                if (supplier == null || !flag) continue;
                supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
            }
        }
        SaveServiceHelper.update((DynamicObject)bidProject);
        if (!isFromSupInv) {
            new SendMessageUtil().sendInvitationByBidProject(appId, operateKey, bidProjectId, invitationId);
        }
    }

    public Object getSupplierInvitationId(DynamicObject bidInvitation, FormShowParameter formShowParameter) {
        DynamicObject supplierInvitation;
        Object supplierInvitationId = null;
        supplierInvitationId = bidInvitation != null ? ((supplierInvitation = bidInvitation.getDynamicObject("supplierinvitation")) != null ? supplierInvitation.getPkValue() : formShowParameter.getCustomParam("supplierInvitationId")) : formShowParameter.getCustomParam("supplierInvitationId");
        return supplierInvitationId;
    }

    public Object getBidProjectId(DynamicObject bidInvitation, FormShowParameter formShowParameter) {
        Object bidProjectId = null;
        bidProjectId = bidInvitation != null ? bidInvitation.getDynamicObject("bidproject").getPkValue() : formShowParameter.getCustomParam("bidProjectId");
        return bidProjectId;
    }
}

