/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.bill.IBidPayFileService;
import kd.scm.bid.business.bill.IBidPayService;
import kd.scm.bid.business.bill.serviceImpl.BidPayFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidPayServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.paycomon.PaySendMsg;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidPayListUI
extends AbstractListPlugin {
    private IBidPayService bidPayService = new BidPayServiceImpl();
    private IBidPayFileService bidPayFileService = new BidPayFileServiceImpl();
    private static DBRoute DBROUTE = DBRoute.of((String)"scm");
    private static final String COMMA = ",";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void setFilter(SetFilterEvent e) {
        boolean flag;
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        List selectOrgs = ((ListView)this.getView()).getSelectedMainOrgIds();
        List filterList = e.getQFilters();
        String billFormId = FormTypeConstants.getFormConstant((String)"pay_list", ((Object)((Object)this)).getClass());
        String appId = "bid";
        if (!"bid_pay_list".equals(billFormId)) {
            appId = "rebm";
        }
        if (selectOrgs != null && selectOrgs.size() == 1) {
            Long aLong = (Long)selectOrgs.get(0);
            this.getView().getPageCache().put("selectorg", aLong.toString());
        } else {
            this.getView().getPageCache().put("selectorg", "-1");
        }
        if (selectOrgs != null && selectOrgs.size() == 0) {
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()), (String)"02", (String)appId, (String)billFormId, (String)"47150e89000000ac");
            if (allPermOrgs.hasAllOrgPerm()) {
                selectOrgs.addAll(OrgUnitServiceHelper.getAllOrgByViewNumber((String)"02", (boolean)true));
            } else {
                selectOrgs.addAll(allPermOrgs.getHasPermOrgs());
            }
        }
        if (flag = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId())) {
            DynamicObject[] bidProjects = BusinessDataServiceHelper.load((String)"bid_project", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)selectOrgs).or(new QFilter("entrustmentorgunit", "in", (Object)selectOrgs))});
            HashSet<Long> bidprojectIds = new HashSet<Long>(bidProjects.length);
            for (int i = 0; i < bidProjects.length; ++i) {
                bidprojectIds.add(bidProjects[i].getLong("id"));
            }
            filterList.add(new QFilter("bidproject.id", "in", bidprojectIds));
        } else {
            List<String> list;
            HashSet<String> set;
            String[] split;
            String respbusiness;
            String isdirector;
            DynamicObject temp;
            int i;
            DynamicObject[] bidProjects = BusinessDataServiceHelper.load((String)"bid_project", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)selectOrgs).or(new QFilter("entrustmentorgunit", "in", (Object)selectOrgs))});
            HashSet<Long> bidprojectIds1 = new HashSet<Long>(bidProjects.length);
            for (int i2 = 0; i2 < bidProjects.length; ++i2) {
                bidprojectIds1.add(bidProjects[i2].getLong("id"));
            }
            QFilter flter1 = new QFilter("user", "=", (Object)userId);
            DynamicObject[] members = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"bidproject,isdirector,respbusiness", (QFilter[])new QFilter[]{flter1});
            DynamicObject[] leaders = BusinessDataServiceHelper.load((String)"bid_leadermemberentity", (String)"bidproject,isdirector,respbusiness", (QFilter[])new QFilter[]{flter1});
            HashSet<Long> bidprojectIds2 = new HashSet<Long>();
            for (i = 0; i < members.length; ++i) {
                temp = members[i];
                isdirector = temp.getString("isdirector");
                if (StringUtils.equals((CharSequence)"true", (CharSequence)isdirector)) {
                    bidprojectIds2.add(!StringUtils.isEmpty((CharSequence)members[i].getString("bidproject")) ? Long.parseLong(members[i].getString("bidproject")) : 0L);
                    continue;
                }
                respbusiness = temp.getString("respbusiness");
                split = respbusiness.split(COMMA);
                if (split == null || split.length <= 0 || !(set = new HashSet<String>(list = Arrays.asList(split))).contains("16")) continue;
                bidprojectIds2.add(!StringUtils.isEmpty((CharSequence)members[i].getString("bidproject")) ? Long.parseLong(members[i].getString("bidproject")) : 0L);
            }
            for (i = 0; i < leaders.length; ++i) {
                temp = leaders[i];
                isdirector = temp.getString("isdirector");
                respbusiness = temp.getString("respbusiness");
                split = respbusiness.split(COMMA);
                if (split == null || split.length <= 0 || !(set = new HashSet<String>(list = Arrays.asList(split))).contains("16")) continue;
                bidprojectIds2.add(!StringUtils.isEmpty((CharSequence)leaders[i].getString("bidproject")) ? Long.parseLong(leaders[i].getString("bidproject")) : 0L);
            }
            HashSet<Long> bidprojectIds3 = new HashSet<Long>();
            DynamicObject[] reps = BusinessDataServiceHelper.load((String)"bid_pay_list", (String)"bidproject", (QFilter[])new QFilter[]{new QFilter("respbusiness", "like", (Object)("%" + userId + "%"))});
            for (int i3 = 0; i3 < reps.length; ++i3) {
                if (reps[i3].getDynamicObject("bidproject") == null) continue;
                bidprojectIds3.add(reps[i3].getDynamicObject("bidproject").getLong("id"));
            }
            HashSet<Long> f1 = new HashSet<Long>();
            f1.clear();
            f1.addAll(bidprojectIds1);
            f1.retainAll(bidprojectIds2);
            HashSet<Long> f2 = new HashSet<Long>();
            f2.clear();
            f2.addAll(bidprojectIds1);
            f2.retainAll(bidprojectIds3);
            filterList.add(new QFilter("bidproject.id", "in", f1).or(new QFilter("bidproject.id", "in", f2)));
        }
        e.setMainOrgQFilter(null);
        super.setFilter(e);
    }

    public void afterBindData(EventObject e) {
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_batch"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_surepay", "bar_repulse"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_batch"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_surepay", "bar_repulse"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection rows;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"bar_playcofirmcord") || StringUtils.equals((CharSequence)key, (CharSequence)"surepaylist")) {
            return;
        }
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (list.getSelectedRows().size() <= 0 && !StringUtils.equals((CharSequence)key, (CharSequence)"refresh") && !StringUtils.equals((CharSequence)key, (CharSequence)"close")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u5728\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidPayListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"refund")) {
            rows = list.getSelectedRows();
            HashSet<String> refunprojectPk = new HashSet<String>(16);
            HashSet<Long> tempIds = new HashSet<Long>(16);
            HashSet<String> typeStrSet = new HashSet<String>(16);
            if (rows != null && rows.size() > 0) {
                for (ListSelectedRow row : rows) {
                    Long id = (Long)row.getPrimaryKeyValue();
                    DynamicObject paylist = this.bidPayService.getPayListById(id);
                    Long projectId = (Long)paylist.getDynamicObject("bidproject").getPkValue();
                    String status = paylist.getString("status");
                    if ("0".equals(status) || "4".equals(status)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u662f\u5df2\u7f34\u8d39\u5df2\u786e\u8ba4\u7684\u624d\u80fd\u70b9\u51fb\u786e\u8ba4\u9000\u8d39\u3002", (String)"BidPayListUI_47", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if ("1".equals(status)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u662f\u5df2\u7f34\u8d39\u5df2\u786e\u8ba4\u7684\u624d\u80fd\u70b9\u51fb\u786e\u8ba4\u9000\u8d39\u3002", (String)"BidPayListUI_47", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if ("3".equals(status)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u662f\u5df2\u7f34\u8d39\u5df2\u786e\u8ba4\u7684\u624d\u80fd\u70b9\u51fb\u786e\u8ba4\u9000\u8d39\u3002", (String)"BidPayListUI_47", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    DynamicObject bidproject = paylist.getDynamicObject("bidproject");
                    if (refunprojectPk.size() == 0) {
                        refunprojectPk.add(bidproject.getPkValue().toString());
                    } else if (!refunprojectPk.contains(bidproject.getPkValue().toString())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u540c\u4e00\u62db\u6807\u9879\u7684\u591a\u6761\u8bb0\u5f55\u786e\u8ba4\u9000\u8d39\u3002", (String)"BidPayListUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    String typeStr = paylist.getString("type");
                    if (typeStrSet.size() == 0) {
                        typeStrSet.add(typeStr);
                    } else if (!typeStrSet.contains(typeStr)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5bf9\u540c\u4e00\u6b3e\u9879\u7c7b\u578b\u8fdb\u884c\u6279\u91cf\u64cd\u4f5c\u3002", (String)"BidPayListUI_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    tempIds.add(projectId);
                    String payListId = paylist.getPkValue().toString();
                    boolean checkFlag = this.checkHasRecord(payListId, "02");
                    if (!checkFlag) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u9000\u8d39\u8bb0\u5f55\u4e0d\u80fd\u6267\u884c\u64cd\u4f5c\u3002", (String)"BidPayListUI_50", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            ArrayList result = new ArrayList(tempIds);
            Long[] ids = new Long[result.size()];
            result.toArray(ids);
            QFilter qFilter = new QFilter("bidproject.id", "in", (Object)ids).and("billstatus", "!=", (Object)"XX");
            DynamicObjectCollection bidDecisions = QueryServiceHelper.query((String)"bid_decision", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter});
            if (null == bidDecisions || bidDecisions.size() == 0) {
                Iterator qFilter1 = new QFilter("id", "in", (Object)ids);
                DynamicObjectCollection bidProjects = QueryServiceHelper.query((String)"bid_project", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter1});
                for (DynamicObject bidProject : bidProjects) {
                    String billstatus = bidProject.getString("billstatus");
                    if (billstatus.equals(BillStatusEnum.INVALID.getVal())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u6d41\u6807\u6216\u8005\u5b9a\u6807\u5355\u5df2\u5ba1\u6838\u540e\u624d\u5141\u8bb8\u9000\u8d39\u3002", (String)"BidPayListUI_51", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else {
                for (DynamicObject bidDecision : bidDecisions) {
                    String billstatus = bidDecision.getString("billstatus");
                    if (!billstatus.equals(BillStatusEnum.DISBEGIN.getVal()) && !billstatus.equals(BillStatusEnum.SAVE.getVal()) && !billstatus.equals(BillStatusEnum.SUBMIT.getVal()) && !billstatus.equals(BillStatusEnum.AUDITING.getVal()) && !billstatus.equals(BillStatusEnum.INVALIDXX.getVal())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u6d41\u6807\u6216\u8005\u5b9a\u6807\u5355\u5df2\u5ba1\u6838\u540e\u624d\u5141\u8bb8\u9000\u8d39\u3002", (String)"BidPayListUI_51", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
        if ((StringUtils.equals((CharSequence)key, (CharSequence)"repulse") || StringUtils.equals((CharSequence)key, (CharSequence)"surepay") || StringUtils.equals((CharSequence)key, (CharSequence)"cancelpay")) && (rows = list.getSelectedRows()) != null && rows.size() > 0) {
            HashSet<String> projectPk = new HashSet<String>(16);
            HashSet<String> typeStrSet = new HashSet<String>(16);
            for (ListSelectedRow row : rows) {
                Object bidOpenTime;
                QFilter qFilter;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Boolean isDeadline = Boolean.TRUE;
                Long id = (Long)row.getPrimaryKeyValue();
                DynamicObject paylist = this.bidPayService.getPayListById(id);
                DynamicObject bidproject = paylist.getDynamicObject("bidproject");
                if (projectPk.size() == 0) {
                    projectPk.add(bidproject.getPkValue().toString());
                } else if (!projectPk.contains(bidproject.getPkValue().toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u540c\u4e00\u62db\u6807\u9879\u7684\u591a\u6761\u8bb0\u5f55\u786e\u8ba4\u7f34\u8d39\u3002", (String)"BidPayListUI_52", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean isopen = paylist.getBoolean("isOpen");
                if (!isopen) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u53d1\u6807\u65f6\u5173\u95ed\u95e8\u6237\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u6253\u56de\u3001\u786e\u5b9a\u7f34\u8d39\u548c\u53d6\u6d88\u7f34\u8d39\u64cd\u4f5c\u3002", (String)"BidPayListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String status = paylist.getString("status");
                if (StringUtils.equals((CharSequence)key, (CharSequence)"surepay") && !"1".equals(status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u662f\u5df2\u7f34\u8d39\u5f85\u786e\u8ba4\u7684\u624d\u80fd\u70b9\u51fb\u7f34\u8d39\u786e\u8ba4\u3002", (String)"BidPayListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"cancelpay") && !"2".equals(status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u662f\u5df2\u7f34\u8d39\u5df2\u786e\u8ba4\u7684\u624d\u80fd\u70b9\u51fb\u53d6\u6d88\u786e\u5b9a\u3002", (String)"BidPayListUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"repulse") && !"1".equals(status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u72b6\u6001\u662f\u5df2\u7f34\u8d39\u5f85\u786e\u8ba4\u7684\u624d\u80fd\u70b9\u51fb\u6253\u56de\u3002", (String)"BidPayListUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"surepay") || StringUtils.equals((CharSequence)key, (CharSequence)"repulse")) {
                    String typeStr = paylist.getString("type");
                    if (typeStrSet.size() == 0) {
                        typeStrSet.add(typeStr);
                    } else if (!typeStrSet.contains(typeStr)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5bf9\u540c\u4e00\u6b3e\u9879\u7c7b\u578b\u8fdb\u884c\u6279\u91cf\u64cd\u4f5c\u3002", (String)"BidPayListUI_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    String payListId = paylist.getPkValue().toString();
                    boolean checkFlag = this.checkHasRecord(payListId, "01");
                    if (checkFlag) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f34\u8d39\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728\u786e\u8ba4\u7f34\u8d39\u6216\u6253\u56de\u8bb0\u5f55\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidPayListUI_53", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                Long projectId = (Long)paylist.getDynamicObject("bidproject").getPkValue();
                QFilter qFilter1 = new QFilter("id", "=", (Object)projectId);
                DynamicObject bidProject = QueryServiceHelper.queryOne((String)"bid_project", (String)"id, billstatus, bidopendeadline, bidopentype", (QFilter[])new QFilter[]{qFilter1});
                String bidOpenType = bidProject.getString("bidopentype");
                DynamicObject bidOpen = null;
                if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                    qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                    qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                    bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter});
                } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
                    qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                    qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                    bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter});
                } else {
                    qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                    bidOpen = QueryServiceHelper.queryOne((String)"bid_bidopen", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter});
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"surepay") && bidOpen != null) {
                    String billstatus = bidOpen.getString("billstatus");
                    boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
                    if (enable) {
                        if (billstatus.equals("O")) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u7f34\u8d39\u3002", (String)"BidPayListUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        if (billstatus.equals("P")) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u6b63\u5728\u5f00\u6807\u4e2d\uff0c\u4e0d\u5141\u8bb8\u7f34\u8d39\u3002", (String)"BidPayListUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                    }
                    if (!enable && (billstatus.equals("B") || billstatus.equals("C") || billstatus.equals("O") || billstatus.equals("P") || billstatus.equals("I"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5f00\u6807\u5355\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u7f34\u8d39\u3002", (String)"BidPayListUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                if ((bidOpenTime = bidProject.get("bidopendeadline")) != null || null == bidOpen) continue;
                if ("P".equals(bidOpen.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u8bb0\u5f55\u5bf9\u5e94\u7684\u5f00\u6807\u5355\u6b63\u5728\u5f00\u6807\u4e2d\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidPayListUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!"O".equals(bidOpen.getString("billstatus"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u8bb0\u5f55\u5bf9\u5e94\u7684\u5f00\u6807\u5355\u5df2\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidPayListUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"cancelpay")) {
            String canclePay = this.getPageCache().get("canclePay");
            if (null == canclePay) {
                args.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("cancelpay", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u7f34\u8d39\uff1f", (String)"BidPayListUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
            this.getPageCache().put("canclePay", null);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"batch")) {
            rows = list.getSelectedRows();
            HashSet<Long> tempIds = new HashSet<Long>();
            HashSet<String> types = new HashSet<String>();
            if (rows != null && rows.size() > 0) {
                for (ListSelectedRow row : rows) {
                    Long id = (Long)row.getPrimaryKeyValue();
                    DynamicObject paylist = this.bidPayService.getPayListById(id);
                    Long projectId = (Long)paylist.getDynamicObject("bidproject").getPkValue();
                    String type = paylist.getString("type");
                    tempIds.add(projectId);
                    types.add(type);
                }
            }
            if (tempIds.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u540c\u65f6\u5bf9\u591a\u4e2a\u7f34\u8d39\u5355\u8fdb\u884c\u6279\u91cf\u767b\u8bb0\u3002", (String)"BidPayListUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (types.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u540c\u65f6\u5bf9\u6807\u4e66\u8d39\u548c\u6295\u6807\u4fdd\u8bc1\u91d1\u8fdb\u884c\u6279\u91cf\u767b\u8bb0\u3002", (String)"BidPayListUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public boolean checkHasRecord(String payListId, String entitytype) {
        HashSet payIdSet = new HashSet();
        String sql = String.format("select fplaylistid from t_bidpay_refrenentity where fcombofield = '%s' and fplaylistid = %s ", entitytype, payListId);
        DB.query((DBRoute)DBROUTE, (String)sql, null, rs -> {
            while (rs.next() && payIdSet.size() <= 0) {
                payIdSet.add(rs.getLong(1));
            }
            return 0;
        });
        return payIdSet.size() > 0;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("refund".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("agreeRefund", "yes");
                this.getView().invokeOperation("refund");
            } else {
                this.getPageCache().put("agreeRefund", null);
            }
        }
        if ("surepay".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("agreePay", "yes");
                this.getView().invokeOperation("surepay");
            } else {
                this.getPageCache().put("agreePay", null);
            }
        }
        if ("cancelpay".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("canclePay", "yes");
                this.getView().invokeOperation("cancelpay");
            } else {
                this.getPageCache().put("canclePay", null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("repulse".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            String backreason = (String)map.get("reason");
            DynamicObject backuser = (DynamicObject)map.get("backuser");
            Date backdate = (Date)map.get("backdate");
            List paylistids = (List)map.get("paylistid");
            this.bidPayService.updatePayListReason(paylistids, backreason, backuser, backdate);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6253\u56de\u6210\u529f\u3002", (String)"BidPayListUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            BillList x = (BillList)this.getView().getControl("billlistap");
            x.refresh();
            this.sendPaySureMessage(actionId);
            LogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6253\u56de", (String)"BidPayListUI_21", (String)"scm-bid-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7f34\u8d39\u5355\u6253\u56de\u6210\u529f\u3002", (String)"BidPayListUI_54", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        BillShowParameter showParameter;
        String typeStr;
        DynamicObject bidproject;
        DynamicObject paylist;
        Object aLong;
        Long id;
        ListSelectedRowCollection rows;
        BillList list;
        ArrayList<Long> paylistids;
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"repulse") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            ArrayList<Long> paylistids2 = new ArrayList<Long>();
            BillList list2 = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows2 = list2.getSelectedRows();
            if (rows2 != null && rows2.size() > 0) {
                for (ListSelectedRow row : rows2) {
                    Long id2 = (Long)row.getPrimaryKeyValue();
                    paylistids2.add(id2);
                }
            }
            Long aLong2 = (Long)paylistids2.get(0);
            DynamicObject paylist2 = this.bidPayService.getPayListById(aLong2);
            String typeStr2 = paylist2.getString("type");
            DynamicObject bidproject2 = paylist2.getDynamicObject("bidproject");
            FormShowParameter showParameter2 = new FormShowParameter();
            showParameter2.setFormId("bid_pay_back");
            showParameter2.setCustomParam("paylistid", paylistids2);
            showParameter2.setCustomParam("ishistory", (Object)"false");
            showParameter2.setCustomParam("bidproject", (Object)bidproject2.getPkValue().toString());
            showParameter2.setCustomParam("type", (Object)typeStr2);
            showParameter2.getOpenStyle().setShowType(ShowType.Modal);
            showParameter2.setStatus(OperationStatus.EDIT);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "repulse");
            showParameter2.setCloseCallBack(callBack);
            this.getView().showForm(showParameter2);
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"batch") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String type;
            Long id3;
            DynamicObject paylist3;
            Long projectId;
            DynamicObject pay;
            BillList list3 = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows3 = list3.getSelectedRows();
            if (rows3 != null && rows3.size() > 0 && null != (pay = this.bidPayService.getPayByBidProjectIdAndType(projectId = (Long)(paylist3 = this.bidPayService.getPayListById(id3 = (Long)rows3.get(0).getPrimaryKeyValue())).getDynamicObject("bidproject").getPkValue(), type = paylist3.getString("type")))) {
                BillShowParameter showParameter3 = new BillShowParameter();
                showParameter3.setFormId(this.getAppId() + "_pay");
                showParameter3.setPkId(pay.getPkValue());
                showParameter3.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter3.setStatus(OperationStatus.EDIT);
                this.getView().showForm((FormShowParameter)showParameter3);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"refund") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            paylistids = new ArrayList<Long>();
            list = (BillList)this.getView().getControl("billlistap");
            rows = list.getSelectedRows();
            if (rows != null && rows.size() > 0) {
                for (ListSelectedRow row : rows) {
                    id = (Long)row.getPrimaryKeyValue();
                    paylistids.add(id);
                }
            }
            aLong = (Long)paylistids.get(0);
            paylist = this.bidPayService.getPayListById((Long)aLong);
            bidproject = paylist.getDynamicObject("bidproject");
            typeStr = paylist.getString("type");
            showParameter = new BillShowParameter();
            showParameter.setFormId(this.getAppId() + "_refund_pay");
            showParameter.setCustomParam("paylistid", paylistids);
            showParameter.setCustomParam("type", (Object)typeStr);
            showParameter.setCustomParam("bidproject", (Object)bidproject.getPkValue().toString());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"surepay") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            paylistids = new ArrayList();
            list = (BillList)this.getView().getControl("billlistap");
            rows = list.getSelectedRows();
            if (rows != null && rows.size() > 0) {
                for (ListSelectedRow row : rows) {
                    id = (Long)row.getPrimaryKeyValue();
                    paylistids.add(id);
                }
            }
            aLong = (Long)paylistids.get(0);
            paylist = this.bidPayService.getPayListById((Long)aLong);
            bidproject = paylist.getDynamicObject("bidproject");
            typeStr = paylist.getString("type");
            showParameter = new BillShowParameter();
            showParameter.setFormId(this.getAppId() + "_pay");
            showParameter.setCustomParam("paylistid", paylistids);
            showParameter.setCustomParam("type", (Object)typeStr);
            showParameter.setCustomParam("bidproject", (Object)bidproject.getPkValue().toString());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"bar_playcofirmcord")) {
            if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                return;
            }
            this.jumpConfirmList();
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"surepaylist")) {
            if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                return;
            }
            this.jumpRefunmList();
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"cancelpay") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.updatePayListStatus("1");
        }
    }

    public void jumpConfirmList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setAppId(this.getAppId());
        showParameter.setBillFormId(this.getAppId() + "_pay");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        showParameter.setMultiSelect(true);
        String selectorg = this.getView().getPageCache().get("selectorg");
        showParameter.setCustomParam("selectorg", (Object)selectorg);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void jumpRefunmList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setAppId(this.getAppId());
        showParameter.setBillFormId(this.getAppId() + "_refund_pay");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        showParameter.setMultiSelect(true);
        String selectorg = this.getView().getPageCache().get("selectorg");
        showParameter.setCustomParam("selectorg", (Object)selectorg);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void jumpConfirmEdit(Object rowPk) {
        String sql = String.format("select fplaylistid,frecordid from t_bidpay_refrenentity where fplaylistid in ( %s ) and fcombofield = '01'", rowPk);
        ArrayList payConfirmRecordSet = new ArrayList();
        DB.query((DBRoute)DBROUTE, (String)sql, null, rs -> {
            while (rs.next()) {
                payConfirmRecordSet.add(Long.parseLong(rs.getString(2)));
            }
            return 0;
        });
        if (payConfirmRecordSet.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u751f\u6210\u7f34\u8d39\u786e\u8ba4\u8bb0\u5f55\uff0c\u8bf7\u8fdb\u884c\u7f34\u8d39\u786e\u8ba4\u3002", (String)"BidPayListUI_55", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setAppId(this.getAppId());
        showParameter.setFormId(this.getAppId() + "_pay");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        showParameter.setPkId(payConfirmRecordSet.get(0));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void jumpRefunmEdit(Object rowPk) {
        String sql = String.format("select fplaylistid,frecordid from t_bidpay_refrenentity where fplaylistid in ( %s ) and fcombofield = '02'", rowPk);
        ArrayList payConfirmRecordSet = new ArrayList();
        DB.query((DBRoute)DBROUTE, (String)sql, null, rs -> {
            while (rs.next()) {
                payConfirmRecordSet.add(Long.parseLong(rs.getString(2)));
            }
            return 0;
        });
        if (payConfirmRecordSet.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u751f\u6210\u9000\u8d39\u786e\u8ba4\u8bb0\u5f55\uff0c\u8bf7\u8fdb\u884c\u9000\u8d39\u786e\u8ba4\u751f\u6210\u9000\u8d39\u786e\u8ba4\u8bb0\u5f55\u3002", (String)"BidPayListUI_56", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setAppId(this.getAppId());
        showParameter.setFormId(this.getAppId() + "_refund_pay");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        showParameter.setPkId(payConfirmRecordSet.get(0));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void sendPaySureMessage(String key) {
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        if (rows != null && rows.size() > 0) {
            for (ListSelectedRow row : rows) {
                DynamicObject[] myTenderArr;
                HashSet<Long> sentSupplierIds = new HashSet<Long>();
                Long id = (Long)row.getPrimaryKeyValue();
                msgParam.put("id", id);
                DynamicObject payList = BusinessDataServiceHelper.loadSingle((Object)id, (String)(this.getAppId() + "_pay_list"));
                DynamicObject bidProject = payList.getDynamicObject("bidproject");
                Long projectId = (Long)bidProject.getPkValue();
                Long supplierId = (Long)payList.getDynamicObject("supplier").getPkValue();
                String notifyType = null;
                if ("0".equals(payList.getString("type"))) {
                    if ("repulse".equals(key)) {
                        msgParam.put("tplScene", "bidpayrepulse");
                        notifyType = MessageChannelUtil.getNotifyType((String)"bidpayrepulse", (String)"bid_pay_list");
                    } else if ("surepay".equals(key)) {
                        msgParam.put("tplScene", "bidpaysurepay");
                        notifyType = MessageChannelUtil.getNotifyType((String)"bidpaysurepay", (String)"bid_pay_list");
                    } else if ("refund".equals(key)) {
                        msgParam.put("tplScene", "refundenderfee");
                        return;
                    }
                } else if ("repulse".equals(key)) {
                    msgParam.put("tplScene", "bidpaybondrepulse");
                    notifyType = MessageChannelUtil.getNotifyType((String)"bidpaybondrepulse", (String)"bid_pay_list");
                } else if ("surepay".equals(key)) {
                    msgParam.put("tplScene", "bidpaybondsurepay");
                    notifyType = MessageChannelUtil.getNotifyType((String)"bidpaybondsurepay", (String)"bid_pay_list");
                } else if ("refund".equals(key)) {
                    msgParam.put("tplScene", "bidpayrefund");
                    notifyType = MessageChannelUtil.getNotifyType((String)"bidpayrefund", (String)"bid_pay_list");
                }
                sentSupplierIds.add(supplierId);
                String appId = this.getAppId();
                DynamicObject myTender = null;
                myTender = "bid".equals(appId) ? ((myTenderArr = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ten_mytender"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("supplier", "=", (Object)supplierId)}).values().toArray(new DynamicObject[0])).length > 0 ? myTenderArr[0] : null) : ((myTenderArr = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"resp_mytender"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("supplier", "=", (Object)supplierId)}).values().toArray(new DynamicObject[0])).length > 0 ? myTenderArr[0] : null);
                Long tenderPk = 0L;
                if (myTender != null) {
                    tenderPk = myTender.getLong("id");
                }
                msgParam.put("notifyType", notifyType);
                msgParam.put("pkId", tenderPk);
                msgParam.put("title", null);
                msgParam.put("content", null);
                msgParam.put("msgentity", "bid_pay_list");
                msgParam.put("operation", key);
                msgParam.put("targetButtonId", "button_bid_pay");
                msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
                msgParam.put("appId", appId);
                if ("bid".equals(appId)) {
                    msgParam.put("formId", "ten_mytender");
                } else {
                    msgParam.put("formId", "resp_mytender");
                }
                PaySendMsg.sendMessage(msgParam, (Object)projectId, sentSupplierIds, (String)appId);
            }
        }
    }

    private void updatePayListStatus(String status) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        if (rows != null && rows.size() > 0) {
            for (ListSelectedRow row : rows) {
                Long id = (Long)row.getPrimaryKeyValue();
                this.bidPayService.updatePayListStatus(id, status);
            }
        }
        BillList x = (BillList)this.getView().getControl("billlistap");
        x.refresh();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        ListSelectedRow data = ((IListView)this.getView()).getCurrentSelectedRowInfo();
        MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
        String key = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)"bidproject_name", (CharSequence)key)) {
            args.setCancel(true);
            Object rowPk = data.getPrimaryKeyValue();
            DynamicObject temp = BusinessDataServiceHelper.loadSingleFromCache((Object)data.getPrimaryKeyValue(), (DynamicObjectType)payListMainType);
            String status = temp.getString("status");
            if (StringUtils.equals((CharSequence)"3", (CharSequence)status)) {
                this.jumpRefunmEdit(rowPk);
            } else {
                this.jumpConfirmEdit(rowPk);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"certificate", (CharSequence)key)) {
            args.setCancel(true);
            DynamicObject file = this.bidPayFileService.getOneFileRecordByPaylistid((Long)data.getPrimaryKeyValue(), "id");
            if (null != file) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", this.getAppId() + "_pay_file");
                String pkId = file.getString("id");
                map.put("pkId", pkId);
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                showParameter.setCustomParam("paylistid", (Object)((Long)data.getPrimaryKeyValue()));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(showParameter);
            }
        }
        if (StringUtils.equals((CharSequence)"reason", (CharSequence)key)) {
            args.setCancel(true);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", this.getAppId() + "_pay_list");
            map.put("pkId", data.getPrimaryKeyValue().toString());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u6253\u56de\u539f\u56e0", (String)"BidPayListUI_35", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getView().showForm(showParameter);
        }
    }

    public String getAppId() {
        return "bid";
    }

    private static class MyListDataProvider
    extends ListDataProvider {
        private MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            for (DynamicObject row : rows) {
                DynamicObject bidproject;
                boolean enablemultisection;
                String reason = row.getString("reason");
                if (StringUtils.isNotEmpty((CharSequence)reason)) {
                    row.set("reason", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidPayListUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                if (enablemultisection = (bidproject = row.getDynamicObject("bidproject")).getBoolean("enablemultisection")) continue;
                row.set("sectionname", (Object)"");
            }
            return rows;
        }
    }
}

