/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.BidProjectAnnouncementsUtils;
import kd.scm.bid.common.util.ReWfUtil;
import kd.scm.bid.formplugin.bill.helper.PermissionHepler;

public class BidProjectAnnouncementListUI
extends AbstractListPlugin {
    private static final String DELDECISIONANNOUNCEMENT = "deldecisionannouncement";
    private static final String REVOKEANNO_DECI = "revokeanno_deci";
    private static final String DELETEOP = "deleteop";
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private IBidDecisionService bidDecisionService = new BidDecisionServiceImpl();
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        DynamicObject[] announcementList = BusinessDataServiceHelper.load((String)"bid_announcement", (String)"id", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"L")});
        if (announcementList != null && announcementList.length > 0) {
            this.annocumentService.update();
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object projectPkid = parameter.getCustomParam("projectPkid");
        String parentType = (String)parameter.getCustomParam("parentType");
        filters.add(new QFilter("bidproject", "=", (Object)projectPkid.toString()));
        filters.add(new QFilter("annotype", "=", (Object)parentType));
        e.setOrderBy("publishdate desc");
        super.setFilter(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object projectPkid = parameter.getCustomParam("projectPkid");
        String parentType = (String)parameter.getCustomParam("parentType");
        String billFormId = ((ListShowParameter)parameter).getBillFormId();
        String appId = "rebm";
        if (billFormId.startsWith("bid")) {
            appId = "bid";
        }
        boolean subAndAutiFlag = false;
        subAndAutiFlag = parentType.equals("bidproject") ? ReWfUtil.hasEableProcess((String)(appId + "_project_announcement")) : ReWfUtil.hasEableProcess((String)(appId + "_decisionannouncement"));
        if (subAndAutiFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitaudit"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"submitaudit"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection selectedRowColl = args.getListSelectedData();
        if (selectedRowColl != null && selectedRowColl.size() > 0) {
            String bidProjectId;
            boolean sendAnnouncementsFlag;
            boolean multipleSendProjectAnnouncementsFlag;
            Object pkId = selectedRowColl.getPrimaryKeyValues()[0];
            DynamicObject anno = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
            String appId = anno.getString("entitytypeid").split("_")[0];
            if (anno.getString("annotype").equals("bidproject") && (multipleSendProjectAnnouncementsFlag = BidProjectAnnouncementsUtils.multipleSendProjectAnnouncementsFlag((String)appId)) && !(sendAnnouncementsFlag = BidProjectAnnouncementsUtils.checkManyTimesSendAnnouncements((String)appId, (Long)Long.valueOf(bidProjectId = anno.getString("bidproject"))))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u9001\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementListUI_27", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            switch (operateKey) {
                case "deleteop": {
                    String billstatus = anno.getString("billstatus");
                    if (!StringUtils.equals((CharSequence)"A", (CharSequence)billstatus)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"BidProjectAnnouncementListUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DELDECISIONANNOUNCEMENT, (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"BidProjectAnnouncementListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                case "revokeanno_deci": 
                case "revokeanno": {
                    ConfirmCallBackListener revokeanno;
                    String annostatus = anno.getString("publishstatus");
                    Date signendtime = anno.getDate("signendtime");
                    Date nowdate = new Date();
                    if (anno.getString("annotype").equals("bidproject")) {
                        if (!StringUtils.equals((CharSequence)BillStatusEnum.RELEASED.getVal(), (CharSequence)annostatus)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidProjectAnnouncementListUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        if (signendtime != null && nowdate.compareTo(signendtime) >= 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u7684\u201d\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201c\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"BidProjectAnnouncementListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        QFilter filter1 = new QFilter("announcement", "=", anno.getPkValue());
                        DynamicObject[] supplierenrollentry = BusinessDataServiceHelper.load((String)"ten_supplierenrollentry", (String)"announcement", (QFilter[])new QFilter[]{filter1});
                        if (supplierenrollentry != null && supplierenrollentry.length != 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u62a5\u540d\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementListUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                    } else if (anno.getString("annotype").equals("decision") && !StringUtils.equals((CharSequence)BillStatusEnum.RELEASED.getVal(), (CharSequence)annostatus)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a\u5df2\u7ecf\u64a4\u9500\uff0c\u65e0\u9700\u91cd\u590d\u64a4\u9500\u3002", (String)"BidProjectAnnouncementListUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (StringUtils.equals((CharSequence)operateKey, (CharSequence)REVOKEANNO_DECI)) {
                        revokeanno = new ConfirmCallBackListener(REVOKEANNO_DECI, (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u9500\u540e\u4f9b\u5e94\u5546\u5c06\u65e0\u6cd5\u67e5\u770b\u4e2d\u6807\u516c\u544a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u64a4\u9500\uff1f", (String)"BidProjectAnnouncementListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, revokeanno);
                    } else {
                        revokeanno = new ConfirmCallBackListener(REVOKEANNO_DECI, (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u9500\u540e\u4f9b\u5e94\u5546\u5c06\u65e0\u6cd5\u67e5\u770b\u62db\u6807\u516c\u544a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u64a4\u9500\uff1f", (String)"BidProjectAnnouncementListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, revokeanno);
                    }
                    args.setCancel(true);
                    break;
                }
                case "release": 
                case "release_deci": {
                    this.beforeDoRelease(args, operateKey);
                    break;
                }
                case "audit": 
                case "submit": 
                case "submitaudit": {
                    String publishstatus = anno.getString("publishstatus");
                    if (StringUtils.equals((CharSequence)"L", (CharSequence)publishstatus)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidProjectAnnouncementListUI_30", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    this.beforeOp(args, operateKey);
                    break;
                }
                case "unsubmit": 
                case "unaudit": {
                    String publishstatus = anno.getString("publishstatus");
                    if (!StringUtils.equals((CharSequence)"L", (CharSequence)publishstatus)) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidProjectAnnouncementListUI_30", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    protected void checkRevoke() {
        ListSelectedRowCollection selectedRowColl = this.getSelectedRows();
        if (selectedRowColl == null || selectedRowColl.size() <= 0) {
            return;
        }
        Object pkId = selectedRowColl.getPrimaryKeyValues()[0];
        DynamicObject anno = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
        Date signendtime = anno.getDate("signendtime");
        Date nowdate = new Date();
        if (anno.getString("annotype").equals("bidproject")) {
            if (!StringUtils.equals((CharSequence)BillStatusEnum.RELEASED.getVal(), (CharSequence)anno.getString("publishstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidProjectAnnouncementListUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (signendtime != null && nowdate.compareTo(signendtime) >= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u7684\u201d\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201c\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"BidProjectAnnouncementListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter1 = new QFilter("announcement", "=", pkId);
            DynamicObject[] supplierenrollentry = BusinessDataServiceHelper.load((String)"ten_supplierenrollentry", (String)"announcement", (QFilter[])new QFilter[]{filter1});
            if (supplierenrollentry != null && supplierenrollentry.length != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u62a5\u540d\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementListUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (anno.getString("annotype").equals("decision") && !StringUtils.equals((CharSequence)BillStatusEnum.RELEASED.getVal(), (CharSequence)anno.getString("publishstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a\u5df2\u7ecf\u64a4\u9500\uff0c\u65e0\u9700\u91cd\u590d\u64a4\u9500\u3002", (String)"BidProjectAnnouncementListUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void beforeOp(BeforeDoOperationEventArgs args, String operateKey) {
        String publishstatus;
        ListSelectedRowCollection selectedRowColl = args.getListSelectedData();
        Object pkId = selectedRowColl.getPrimaryKeyValues()[0];
        DynamicObject anno = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
        String annotype = anno.getString("annotype");
        if (StringUtils.equals((CharSequence)annotype, (CharSequence)"decision")) {
            String dbid = anno.getString("decision");
            DynamicObject bidDecision = this.bidDecisionService.getBidDecisionSingle(Long.valueOf(Long.parseLong(dbid)));
            DynamicObject bidProject = bidDecision.getDynamicObject("bidproject");
            String projectName = bidProject.getString("name");
            String billstatus = (String)bidDecision.get("billstatus");
            if (billstatus == null || "".equals(billstatus) || "A".equals(billstatus) || "B".equals(billstatus) || "D".equals(billstatus) || "I".equals(billstatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e2d\u6807\u516c\u544a: \u5b9a\u6807\u5355\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u53d1\u9001\u4e2d\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementListUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
                args.setCancel(true);
                return;
            }
            if ("X".equals(billstatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e2d\u6807\u516c\u544a: \u5b9a\u6807\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u53d1\u9001\u4e2d\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementListUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)(publishstatus = anno.getString("publishstatus")), (CharSequence)BillStatusEnum.RELEASED.getVal())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u544a\u5df2\u7ecf\u53d1\u5e03\uff0c\u5982\u9700\u91cd\u65b0\u53d1\u5e03\u8bf7\u70b9\u51fb\u64a4\u9500\u53d1\u5e03\u3002", (String)"BidProjectAnnouncementListUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject announcement = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()), (String)"publishstatus,signendtime", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            if (announcement == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879\u5355\u636e\u672a\u5ba1\u6279\uff0c\u4e0d\u80fd\u53d1\u9001\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementListUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String annostatus = announcement.getString("publishstatus");
            String signEndTime = announcement.getString("signendtime");
            if (anno.getString("annotype").equals("bidproject")) {
                if (StringUtils.isEmpty((CharSequence)signEndTime)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u7acb\u9879\u8c03\u6574\u4e2d\u8bbe\u7f6e\u3002", (String)"BidProjectAnnouncementListUI_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date date = format.parse(signEndTime);
                    Date date1 = new Date();
                    int compareTo = date1.compareTo(date);
                    if (compareTo > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201d\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectAnnouncementListUI_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                catch (ParseException e) {
                    this.LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            if (anno.getString("annotype").equals("bidproject") && StringUtils.equals((CharSequence)annostatus, (CharSequence)BillStatusEnum.RELEASED.getVal())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4\u3002", (String)"BidProjectAnnouncementListUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (anno.getString("annotype").equals("decision") && StringUtils.equals((CharSequence)annostatus, (CharSequence)BillStatusEnum.RELEASED.getVal())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4\u3002", (String)"BidProjectAnnouncementListUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    protected void beforeDoRelease(BeforeDoOperationEventArgs args, String operateKey) {
        ListSelectedRowCollection selectedRowColl = args.getListSelectedData();
        Object pkId = selectedRowColl.getPrimaryKeyValues()[0];
        DynamicObject anno = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
        if (anno == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u516c\u544a\u4e0d\u5904\u4e8e\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u53d1\u5e03\u3002", (String)"BidProjectAnnouncementListUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String billstatus = anno.getString("billstatus");
        if (!StringUtils.equals((CharSequence)"C", (CharSequence)billstatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u516c\u544a\u4e0d\u5904\u4e8e\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u53d1\u5e03\u3002", (String)"BidProjectAnnouncementListUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String publishstatus = anno.getString("publishstatus");
        if (StringUtils.equals((CharSequence)publishstatus, (CharSequence)BillStatusEnum.RELEASED.getVal())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u544a\u5df2\u7ecf\u53d1\u5e03\uff0c\u5982\u9700\u91cd\u65b0\u53d1\u5e03\u8bf7\u70b9\u51fb\u64a4\u9500\u53d1\u5e03\u3002", (String)"BidProjectAnnouncementListUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "release": 
            case "release_deci": {
                this.afterDoRelease();
                this.getView().updateView();
                break;
            }
        }
    }

    protected void doRevoke() {
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        if (listSelectedRows == null || listSelectedRows.size() <= 0) {
            return;
        }
        Object pkId = this.getSelectedRows().getPrimaryKeyValues()[0];
        DynamicObject anno = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
        this.revokeAnnouncement(pkId);
        if (anno.getString("annotype").equals("bidproject")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u62db\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectAnnouncementListUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        } else if (anno.getString("annotype").equals("decision")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4e2d\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectAnnouncementListUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    protected void revokeAnnouncement(Object pkId) {
        this.annocumentService.changeBillStatusToA(pkId);
    }

    protected void afterDoRelease() {
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        if (listSelectedRows == null || listSelectedRows.size() <= 0) {
            return;
        }
        Object pkId = this.getSelectedRows().getPrimaryKeyValues()[0];
        DynamicObject anno = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
        this.releaseAnnouncement(pkId);
        if (anno.getString("annotype").equals("bidproject")) {
            DynamicObject announcement = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
            if (announcement != null) {
                String appId = announcement.getString("entitytypeid").split("_")[0];
                String bidProjectId = announcement.getString("bidproject");
                BidProjectAnnouncementsUtils.clearApplySupplierAndTenderData((Long)((Long)announcement.getPkValue()), (String)appId, (Long)Long.valueOf(bidProjectId));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u62db\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectAnnouncementListUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        } else if (anno.getString("annotype").equals("decision")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectAnnouncementListUI_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setDataChanged(false);
    }

    protected void releaseAnnouncement(Object pkId) {
        Date nowdate = new Date();
        this.annocumentService.changeBillStatusToL(pkId, nowdate);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (fieldKey = messageBoxClosedEvent.getCallBackId()) {
            case "deldecisionannouncement": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject anno = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()));
                if (anno.getString("annotype").equals("bidproject")) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_project_announcement"), (Object[])new Object[]{primaryKeyValue});
                    this.getView().invokeOperation("refresh");
                    break;
                }
                if (!anno.getString("annotype").equals("decision")) break;
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_decisionannouncement"), (Object[])new Object[]{primaryKeyValue});
                this.getView().invokeOperation("refresh");
                break;
            }
            case "revokeanno_deci": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                this.checkRevoke();
                this.doRevoke();
                this.getView().updateView();
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        DynamicObject announcement;
        ListSelectedRowCollection collList = ((IListView)this.getView()).getSelectedRows();
        if (!collList.isEmpty() && collList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectAnnouncementListUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        String operateKey = args.getFieldName();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String parentType = (String)parameter.getCustomParam("parentType");
        if (StringUtils.equals((CharSequence)"annotitle", (CharSequence)operateKey) && !collList.isEmpty() && (announcement = BusinessDataServiceHelper.loadSingle((Object)collList.get(0).getPrimaryKeyValue(), (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()))) != null) {
            String billstatus;
            String appId = announcement.getString("entitytypeid").split("_")[0];
            DynamicObject org = announcement.getDynamicObject("org");
            Long orgId = -1L;
            if (org != null) {
                orgId = org.getLong("id");
            }
            String entityNum = "";
            String messageTip = "";
            if (parentType.equals("bidproject")) {
                entityNum = appId + "_project_announcement";
                messageTip = ResManager.loadKDString((String)"\u6ca1\u6709\u62db\u6807\u516c\u544a\u67e5\u770b\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BidProjectAnnouncementListUI_32", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            } else {
                entityNum = appId + "_decisionannouncement";
                messageTip = ResManager.loadKDString((String)"\u6ca1\u6709\u4e2d\u6807\u516c\u544a\u67e5\u770b\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BidProjectAnnouncementListUI_33", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            }
            boolean hasPermission = PermissionHepler.checkPermission("QXX0001", orgId, appId, entityNum);
            if (!hasPermission) {
                this.getView().showTipNotification(messageTip);
                args.setCancel(true);
                return;
            }
            if (parentType.equals("bidproject") && StringUtils.equals((CharSequence)(billstatus = announcement.getString("billstatus")), (CharSequence)"X")) {
                parameter.setStatus(OperationStatus.VIEW);
            }
        }
    }
}

