/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.BizLog;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.DefaultOrgReg;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BidTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.BidProjectAnnouncementsUtils;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.common.util.DefaultOrgUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.helper.PermissionHepler;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;
import kd.scm.bid.formplugin.util.BidTransferUtil;
import kd.sdk.annotation.SdkDeprecated;

public class BidProjectListUI
extends AbstractListPlugin {
    private static final String FIELD_ENABLE_MULTI_SECTION = "enablemultisection";
    private static final String ITEM_ADJUSTPROMSG = "adjustpromsg";
    private static final String KEY_CURRENTSTEP = "currentstep";
    private static final String OPEN_BIDDING = "Open bidding";
    private IBidProjectService projectService = new BidProjectServiceImpl();
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private static final IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();

    public String getBidAdminRoleID() {
        return "/FFXFSRKI73+";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{ITEM_ADJUSTPROMSG});
    }

    @SdkDeprecated
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)ITEM_ADJUSTPROMSG, (CharSequence)evt.getItemKey())) {
            // empty if block
        }
    }

    /*
     * WARNING - void declaration
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean hasNewPermission;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String announcement_id = "bid_announcement";
        if ("rebm".equals(this.getView().getFormShowParameter().getServiceAppId())) {
            announcement_id = "rebm_announcement";
        }
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        String formId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
        DefaultOrgReg defaultOrgReg = new DefaultOrgReg(appId, "02", formId, this.getControlFilters(), "org.id");
        Long orgId = DefaultOrgUtil.getListUIDefaultOrg((DefaultOrgReg)defaultOrgReg);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"new")) {
            if (orgId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"BidProjectListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            hasNewPermission = PermissionUtils.checkPermission("QXX0002", orgId, appId, formId);
            if (!hasNewPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u62db\u6807\u7acb\u9879\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"BidProjectListUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delete") && !(hasNewPermission = PermissionUtils.checkPermission("QXX0004", orgId, appId, formId))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u62db\u6807\u7acb\u9879\u7684\u5220\u9664\u6743\u9650\u3002", (String)"BidProjectListUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delete") && !(hasNewPermission = PermissionUtils.checkPermission("QXX0001", orgId, appId, formId))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u62db\u6807\u7acb\u9879\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"BidProjectListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit")) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            if (rows != null && rows.size() > 0) {
                for (ListSelectedRow row : rows) {
                    Object pkValue = row.getPrimaryKeyValue();
                    String billStatus = this.annocumentService.getBillStatus(pkValue, (Object)"bidproject");
                    if (billStatus != null && billStatus.equals(BillStatusEnum.RELEASED.getVal())) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5df2\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidProjectListUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bid_project");
                    String name = bidProject.getString("name");
                    if (!QueryServiceHelper.exists((String)"bid_adjustmentrecord", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name), new QFilter("entitytypeid", "=", (Object)(appId + "_adjustmentrecord")), new QFilter("billstatus", "!=", (Object)"C")})) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7acb\u9879\u8c03\u6574\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidProjectListUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addnewannouncement")) {
            ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
            if (src != null && src.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u62db\u6807\u516c\u544a\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (sr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidProjectListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasPermission = PermissionHepler.checkPermission("QXX0114", orgId, appId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53d1\u5e03\u62db\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidProjectListUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"checkannouncement")) {
            ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
            if (src != null && src.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u62db\u6807\u516c\u544a\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (sr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidProjectListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasPermission = PermissionHepler.checkPermission("QXX0115", orgId, appId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u62db\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidProjectListUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokeannouncement")) {
            ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
            if (src != null && src.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64a4\u9500\u62db\u6807\u516c\u544a\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (sr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidProjectListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasPermission = PermissionHepler.checkPermission("QXX0116", orgId, appId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64a4\u9500\u62db\u6807\u516c\u544a\u7684\u6743\u9650\u3002", (String)"BidProjectListUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"invalid")) {
            args.setCancel(true);
            ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
            if (!CollectionUtils.isEmpty((Collection)src) && src.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u6807\u8bb0\u5f55\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_86", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)src)) {
                DynamicObject bidProject;
                Object orgPk;
                boolean hasPermission;
                BidDecisionServiceImpl decisionService = new BidDecisionServiceImpl();
                ListSelectedRow data = src.get(0);
                DynamicObject decision = decisionService.getBidDecisionByProjectId(Long.valueOf(Long.parseLong(data.getPrimaryKeyValue().toString())), "billstatus, datasource, synxkflag");
                if (decision != null && BillStatusEnum.AUDITED.getVal().equals(decision.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u62db\u6807\u9879\u5df2\u5b9a\u6807\uff0c\u4e0d\u5141\u8bb8\u6d41\u6807\u3002", (String)"BidProjectListUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (decision != null) {
                    String datasource = decision.getString("datasource");
                    Boolean synXkFlag = decision.getBoolean("synxkflag");
                    if (synXkFlag.booleanValue() && "1".equals(datasource)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5df2\u751f\u6210\u661f\u7a7a\u91c7\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6d41\u6807\u64cd\u4f5c\u3002", (String)"BidProjectListUI_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if (!(hasPermission = PermissionHepler.checkPermission("QXX0044", Long.parseLong((orgPk = (bidProject = BusinessDataServiceHelper.loadSingle((Object)data.getPrimaryKeyValue(), (String)(appId + "_project"))).getDynamicObject("org").getPkValue()).toString()), appId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass())))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6d41\u6807\u7684\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectListUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                String checkQueryIsProcess = questionClarifyService.checkQueryIsProcess(Long.valueOf(Long.parseLong(bidProject.getPkValue().toString())), appId);
                if (StringUtils.isNotBlank((CharSequence)checkQueryIsProcess)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)checkQueryIsProcess, (String)"BidProjectListUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("invalid", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6d41\u6807\u540e\u672c\u6b21\u7acb\u9879\u6240\u6709\u4e1a\u52a1\u5355\u636e\u90fd\u5c06\u53d8\u4e3a\u6d41\u6807\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BidProjectListUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        } else {
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"invalidcored")) {
                args.setCancel(true);
                ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
                if (!CollectionUtils.isEmpty((Collection)src) && src.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u6807\u8bb0\u5f55\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_86", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!CollectionUtils.isEmpty((Collection)src)) {
                    ListSelectedRow data = src.get(0);
                    ListShowParameter listShowParameter = new ListShowParameter();
                    listShowParameter.setCustomParam("bidproject", data.getPrimaryKeyValue());
                    listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    listShowParameter.setBillFormId(appId + "_projectcancel");
                    this.getView().showForm((FormShowParameter)listShowParameter);
                }
                return;
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
                DynamicObject bidMode;
                ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
                if (src != null && src.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (src == null) {
                    return;
                }
                ListSelectedRow data = src.get(0);
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)data.getPrimaryKeyValue(), (String)"bid_project");
                boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
                if (enable && (bidMode = bidProject.getDynamicObject("bidmode")) != null) {
                    boolean hasOpen = bidMode.getBoolean("bidopen");
                    boolean hasPublish = bidMode.getBoolean("bidpublish");
                    if (hasOpen && !hasPublish) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u65b9\u5f0f\u7f3a\u5c11\u53d1\u6807\u73af\u8282\uff0c\u4e0d\u652f\u6301\u7ebf\u4e0a\u5f00\u6807\u3002", (String)"BidProjectListUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                String bidType = bidProject.getString("bidtype");
                if (BidTypeEnum.MATERIAL.getValue().equals(bidType)) {
                    DynamicObjectCollection bidSections = bidProject.getDynamicObjectCollection("bidsection");
                    boolean enableMultiSec = (Boolean)bidProject.get(FIELD_ENABLE_MULTI_SECTION);
                    String HavingRepSection = "";
                    Boolean isHavingWeakRep = null;
                    Boolean isHavingStrongRep = null;
                    String agreeSubmit = this.getPageCache().get("agreeSubmit");
                    for (DynamicObject bidsection : bidSections) {
                        ArrayList materials = new ArrayList(10);
                        isHavingWeakRep = Boolean.FALSE;
                        isHavingStrongRep = Boolean.FALSE;
                        String sectionname = bidsection.getString("sectionname");
                        DynamicObjectCollection projectentrySections = bidsection.getDynamicObjectCollection("projectentry");
                        for (int j = 0; j < projectentrySections.size(); ++j) {
                            void var30_64;
                            DynamicObject purDetail = (DynamicObject)projectentrySections.get(j);
                            if (purDetail.getDynamicObject("materialid") == null) {
                                return;
                            }
                            String newMaterial = purDetail.getDynamicObject("materialid").get("number").toString();
                            String newDescription = purDetail.getString("materialdes");
                            if (newDescription == null) {
                                newDescription = "";
                            }
                            for (Map map : materials) {
                                String oldMaterial = map.get("material").toString();
                                String oldDescription = map.get("description").toString();
                                if (oldMaterial.equals(newMaterial) && oldDescription.equals(newDescription)) {
                                    if (!enableMultiSec) {
                                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u201d\u4ea7\u54c1\u7f16\u7801\u201c +\u201d\u4ea7\u54c1\u63cf\u8ff0\u201c,\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectListUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                    } else {
                                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s:\u5b58\u5728\u91cd\u590d\u7684\u201d\u4ea7\u54c1\u7f16\u7801\u201c +\u201d\u4ea7\u54c1\u63cf\u8ff0\u201c,\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectListUI_21", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionname));
                                    }
                                    args.setCancel(true);
                                    return;
                                }
                                if (oldMaterial.equals(newMaterial) && !oldDescription.equals(newDescription)) {
                                    isHavingWeakRep = Boolean.TRUE;
                                }
                                if (!oldMaterial.equals(newMaterial) || !oldDescription.equals(newDescription)) continue;
                                isHavingStrongRep = Boolean.TRUE;
                            }
                            HashMap<String, Object> material = new HashMap<String, Object>();
                            String string = purDetail.getString("materialdes");
                            if (string == null) {
                                String string2 = "";
                            }
                            material.put("material", purDetail.getDynamicObject("materialid").get("number").toString());
                            material.put("description", var30_64);
                            materials.add(material);
                        }
                        if (!isHavingStrongRep.booleanValue()) continue;
                        HavingRepSection = HavingRepSection.concat(sectionname).concat("\u3001");
                    }
                    if (HavingRepSection.length() > 0) {
                        HavingRepSection = HavingRepSection.substring(0, HavingRepSection.length() - 1);
                    }
                    if (isHavingWeakRep.booleanValue() && agreeSubmit == null) {
                        RefObject afterConfirm = new RefObject();
                        if (!formOperate.getOption().tryGetVariableValue("submit", afterConfirm)) {
                            args.setCancel(true);
                            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u201c\u4ea7\u54c1\u7f16\u7801 \u201d,\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4?", (String)"BidProjectListUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                        }
                    }
                }
            } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"publishinvitation") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"viewinvitation") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"undoinvitation")) {
                String operatorName = StringUtils.equals((CharSequence)operateKey, (CharSequence)"publishinvitation") ? ResManager.loadKDString((String)"\u53d1\u5e03\u9080\u8bf7\u51fd", (String)"BidProjectListUI_23", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u67e5\u770b\u9080\u8bf7\u51fd", (String)"BidProjectListUI_24", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
                if (src != null && src.size() > 1) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_25", (String)"scm-bid-formplugin", (Object[])new Object[0]), operatorName));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
                if (sr == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidProjectListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object bidProjectId = sr.getPrimaryKeyValue();
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"publishinvitation")) {
                    this.publishInvitation(appId, bidProjectId, args);
                } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"viewinvitation")) {
                    this.viewInvitation(appId, bidProjectId, args);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("submit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("submit", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
        if (StringUtils.equals((CharSequence)"invalid", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject queryDecision;
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            ListSelectedRow data = listSelectedRowCollection.get(0);
            data.getFormID();
            if ("bid".equals(appId) && (queryDecision = BusinessDataServiceHelper.loadSingle((String)"bid_decision", (String)"bidsection,supplierentry,xkpurorderbillno", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)data.getPrimaryKeyValue())), new QFilter("billstatus", "!=", (Object)"XX")})) != null) {
                boolean flag = false;
                DynamicObjectCollection bidsections = queryDecision.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidsection : bidsections) {
                    DynamicObjectCollection supplierEntry = bidsection.getDynamicObjectCollection("supplierentry");
                    for (int i = 0; i < supplierEntry.size(); ++i) {
                        DynamicObject supplierEntryRow = (DynamicObject)supplierEntry.get(i);
                        String xkPurOrderBillno = supplierEntryRow.getString("xkpurorderbillno");
                        if (xkPurOrderBillno == null || xkPurOrderBillno.isEmpty()) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    break;
                }
                if (flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5df2\u751f\u6210\u661f\u7a7a\u91c7\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6d41\u6807\u64cd\u4f5c\u3002", (String)"BidProjectListUI_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)data.getPrimaryKeyValue(), (String)(appId + "_project"));
            this.itemClick_cancelProMsg(appId, bidProject);
        }
    }

    public void itemClick_cancelProMsg(String appId, DynamicObject bidProject) {
        String billno = bidProject.getString("billno");
        String billStatus = bidProject.getString("billstatus");
        Long pkId = Long.parseLong(bidProject.getPkValue().toString());
        if (!BillStatusEnum.AUDITED.getVal().equals(billStatus) && !billStatus.equals("I")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s: \u53ea\u6709\u5df2\u5ba1\u6279\u7684\u6570\u636e\u624d\u5141\u8bb8\u6d41\u6807\u3002", (String)"BidProjectListUI_27", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
            return;
        }
        QFilter qFilter = new QFilter("bidproject", "=", (Object)pkId);
        qFilter.and("billstatus", "!=", (Object)"C");
        boolean exists = QueryServiceHelper.exists((String)(appId + "_projectcancel"), (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u672a\u5ba1\u6838\u6216\u5ba1\u6838\u4e2d\u7684\u4f5c\u5e9f\u5355\uff0c\u8bf7\u5148\u5ba1\u6838\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidProjectListUI_70", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        qFilter = new QFilter("bidproject", "=", (Object)pkId);
        qFilter.and("billstatus", "=", (Object)"C");
        exists = QueryServiceHelper.exists((String)(appId + "_projectcancel"), (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u5ba1\u6838\u7684\u4f5c\u5e9f\u5355\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\u3002", (String)"BidProjectListUI_71", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter[] decisionFilter = new QFilter[]{new QFilter("bidproject", "=", (Object)pkId), new QFilter("billstatus", "in", (Object)new String[]{"B", "I", "C", "S", "R"})};
        boolean decisionFlag = QueryServiceHelper.exists((String)(appId + "_decision"), (QFilter[])decisionFilter);
        if (decisionFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u4e1a\u52a1\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u62db\u6807\u4f5c\u5e9f\u3002", (String)"BidProjectListUI_72", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(appId + "_projectcancel");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setAppId(appId);
        showParameter.setCustomParam("bidProjectId", (Object)pkId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void itemClickCheckAnnouncement(ListSelectedRow sr) {
        Object id = sr.getPrimaryKeyValue();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        if (project != null && !BidModeHelper.isPublicBidding(project)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u516c\u5f00\u62db\u6807\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectListUI_35", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Map map = this.annocumentService.getAnnouncementPKIdMap(id, (Object)"bidproject", Boolean.FALSE);
        if (map != null) {
            DynamicObject purTypeObj;
            BillList view = (BillList)this.getView().getControl("billlistap");
            String appId = ((BillEntityType)view.getEntityType()).getAppId();
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setMultiSelect(false);
            showParameter.setBillFormId(appId + "_project_announcement");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("annomap", (Object)map);
            showParameter.setCustomParam("parentType", (Object)"bidproject");
            showParameter.setCustomParam("projectPkid", id);
            showParameter.setCustomParam("pkid", id);
            String purTypeName = "";
            if (project != null && (purTypeObj = project.getDynamicObject("purtype")) != null) {
                purTypeName = purTypeObj.getString("name");
            }
            showParameter.setCustomParam("purtype", (Object)purTypeName);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u7f16\u5236\u62db\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidProjectListUI_36", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClickAnnouncementProMsg(ListSelectedRow sr) {
        Object id = sr.getPrimaryKeyValue();
        long mainOrgId = sr.getMainOrgId();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        String entitytypeid = project.getString("entitytypeid");
        String appId = "bid";
        if (entitytypeid.startsWith("rebm")) {
            appId = "rebm";
        }
        if (BidModeHelper.isPublicBidding(project)) {
            if (!BillStatusEnum.AUDITED.getVal().equals(sr.getBillStatus())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u5df2\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectListUI_63", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("bidproject", "=", (Object)String.valueOf(id));
            QFilter filter2 = new QFilter("annotype", "=", (Object)"bidproject");
            boolean exists = QueryServiceHelper.exists((String)(appId + "_project_announcement"), (QFilter[])new QFilter[]{filter, filter2});
            boolean multipleSendProjectAnnouncementsFlag = BidProjectAnnouncementsUtils.multipleSendProjectAnnouncementsFlag((String)appId);
            if (multipleSendProjectAnnouncementsFlag) {
                boolean sendAnnouncementsFlag = BidProjectAnnouncementsUtils.checkManyTimesSendAnnouncements((String)appId, (Long)((Long)id));
                if (!sendAnnouncementsFlag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u9001\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectListUI_73", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u4e00\u6761\u516c\u544a\uff0c\u8bf7\u4e0d\u8981\u518d\u6b21\u53d1\u5e03\u3002", (String)"BidProjectListUI_74", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(appId + "_project_announcement");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            DynamicObject[] projectAnnouncementArray = BusinessDataServiceHelper.load((String)(appId + "_project_announcement"), (String)"billstatus,publishstatus", (QFilter[])new QFilter[]{filter, filter2}, (String)"createtime desc");
            if (projectAnnouncementArray != null && projectAnnouncementArray.length > 0) {
                DynamicObject lastProjectAnnouncement = projectAnnouncementArray[0];
                String billStatus = lastProjectAnnouncement.getString("billstatus");
                String publishStatus = lastProjectAnnouncement.getString("publishstatus");
                if (BillStatusEnum.INVALIDXX.getVal().equals(billStatus) || BillStatusEnum.AUDITED.getVal().equals(billStatus) && "L".equals(publishStatus)) {
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    showParameter.setCustomParam("pkid", id);
                    showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                    showParameter.setCustomParam("parentType", (Object)"bidproject");
                } else {
                    showParameter.setPkId(lastProjectAnnouncement.getPkValue());
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCustomParam("parentType", (Object)"bidproject");
                    showParameter.setCustomParam("pkid", id);
                    showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
                }
            } else {
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.setCustomParam("parentType", (Object)"bidproject");
                showParameter.setCustomParam("pkid", id);
                showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
            }
            showParameter.setCaption(ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a", (String)"BidProjectListUI_37", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u975e\u516c\u5f00\u62db\u6807\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectListUI_39", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        BillList view = (BillList)this.getView().getControl("billlistap");
        String appId = ((BillEntityType)view.getEntityType()).getAppId();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            if (rows == null) return;
            if (rows.size() <= 0) return;
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                ListSelectedRow row = (ListSelectedRow)iterator.next();
                Object pkvalue = row.getPrimaryKeyValue();
                this.annocumentService.deleteAnnouncementByProId(pkvalue, (Object)"bidproject");
            }
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"adjustprojects")) {
            ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
            if (src != null && src.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7acb\u9879\u4fe1\u606f\u8c03\u6574\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_40", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (sr != null) {
                this.itemClick_adjustProMsg(sr, appId);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidProjectListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addnewannouncement")) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            this.itemClickAnnouncementProMsg(sr);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokeannouncement")) {
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"checkannouncement")) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            this.itemClickCheckAnnouncement(sr);
            return;
        }
        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"record")) return;
        ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
        if (src != null && src.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u8bb0\u5f55\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"BidProjectListUI_41", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
        if (sr == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u884c\u3002", (String)"BidProjectListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Object openKeyValue = sr.getPrimaryKeyValue();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)openKeyValue, (String)"bid_project");
        long projectid = project.getLong("id");
        QFilter filter = new QFilter("projectid", "=", (Object)projectid);
        DynamicObjectCollection adjustmentrecordColl = QueryServiceHelper.query((String)(appId + "_adjustmentrecord"), (String)"id", (QFilter[])filter.toArray());
        if (adjustmentrecordColl.size() > 0) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("projectid", (Object)projectid);
            listShowParameter.setMultiSelect(false);
            listShowParameter.setHasRight(true);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setBillFormId(appId + "_adjustmentrecord");
            this.getView().showForm((FormShowParameter)listShowParameter);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u8c03\u6574\u8bb0\u5f55", (String)"BidProjectListUI_42", (String)"scm-bid-formplugin", (Object[])new Object[0]));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Boolean isCopy = (Boolean)e.getParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            e.getParameter().setCustomParam("sourceProjectId", id);
        }
    }

    private void itemClick_adjustProMsg(ListSelectedRow sr, String appId) {
        if (!BillStatusEnum.AUDITED.getVal().equals(sr.getBillStatus()) && !sr.getBillStatus().equals("I")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s: \u53ea\u6709\u5df2\u5ba1\u6279\u7684\u6570\u636e\u624d\u5141\u8bb8\u505a\u7acb\u9879\u8c03\u6574\u3002", (String)"BidProjectListUI_43", (String)"scm-bid-formplugin", (Object[])new Object[0]), sr.getBillNo()));
            return;
        }
        MainEntityType receiverbill = EntityMetadataCache.getDataEntityType((String)(appId + "_adjustmentrecord"));
        DynamicObject bill = new DynamicObject((DynamicObjectType)receiverbill);
        String billno = CodeRuleServiceHelper.getNumber((String)(appId + "_adjustmentrecord"), (DynamicObject)bill, (String)null);
        if (billno == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u8bb0\u5f55\u672a\u914d\u7f6e\u7f16\u7801\u89c4\u5219,\u8bf7\u5148\u914d\u7f6e\u3002", (String)"BidProjectListUI_75", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = (Long)sr.getPrimaryKeyValue();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)id, (String)(appId + "_project"));
        String name = project.getString("name");
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        qFilter.and("billstatus", "!=", (Object)"C");
        DynamicObjectCollection adjustmentrecord = QueryServiceHelper.query((String)(appId + "_adjustmentrecord"), (String)"id", (QFilter[])qFilter.toArray());
        if (adjustmentrecord.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u672a\u5ba1\u6838\u7684\u7acb\u9879\u8c03\u6574\u5355\uff0c\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"BidProjectListUI_76", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter[] decisionFilter = new QFilter[]{new QFilter("bidproject", "=", (Object)id), new QFilter("billstatus", "in", (Object)new String[]{"B", "I", "C", "S", "R"})};
        boolean decisionFlag = QueryServiceHelper.exists((String)(appId + "_decision"), (QFilter[])decisionFilter);
        if (decisionFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u4e1a\u52a1\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u7acb\u9879\u8c03\u6574\u3002", (String)"BidProjectListUI_77", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean hasUnfinishedbidTransfer = BidTransferUtil.isHasUnfinishedbidTransfer(id, appId);
        if (hasUnfinishedbidTransfer) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u6570\u636e\u6b63\u5728\u8f6c\u529e\u4e2d\uff0c\u65e0\u6cd5\u8fdb\u884c\u7acb\u9879\u8c03\u6574\u3002", (String)"BidProjectListUI_65", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(appId + "_projectadjust");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setPkId((Object)id);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)KEY_CURRENTSTEP, (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getOpenFormId("projectprocess"));
            showParameter.setCustomParam("bidProjectId", id);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
    }

    public void setFilter(SetFilterEvent e) {
        String appId;
        boolean isAdmin;
        Optional<QFilter> of;
        super.setFilter(e);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BizLog.log((String)(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"BidProjectListUI_78", (String)"scm-bid-formplugin", (Object[])new Object[0]) + df.format(new Date())));
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        QFilter filter4Org = null;
        boolean isOrg = false;
        List qFilters = e.getQFilters();
        if (qFilters != null && (of = qFilters.stream().filter(filter -> "org.name".equals(filter.getProperty())).findFirst()).isPresent()) {
            isOrg = true;
            QFilter f = of.get();
            qFilters.remove(f);
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", f.getCP(), f.getValue())});
            Set orgIds = orgs.stream().map(org -> org.get("id")).collect(Collectors.toSet());
            String cp = f.getCP();
            QFilter q1 = new QFilter("org", "in", orgIds);
            QFilter q2 = new QFilter("entrustmentorgunit", "in", orgIds);
            filter4Org = q1.or(q2);
        }
        long orgId = -1L;
        List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
        if (orgIds != null && orgIds.size() != 0 && !isOrg) {
            orgId = (Long)orgIds.get(0);
        }
        if (orgId != -1L) {
            filter4Org = new QFilter("org", "in", (Object)orgIds).or(new QFilter("entrustmentorgunit", "in", (Object)orgIds));
        }
        if (filter4Org != null && qFilters != null) {
            qFilters.add(filter4Org);
        }
        if (!(isAdmin = CommonUtil.isBidAdmin((String)(appId = this.getView().getFormShowParameter().getServiceAppId()), (Long)RequestContext.get().getCurrUserId())) && qFilters != null) {
            Set bidProIds = this.projectService.generatorPermissionFilter((Object)userId, "01");
            List collect = bidProIds.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", collect));
        }
        BaseDataServiceHelper helper = new BaseDataServiceHelper();
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (Long)orgId);
        if (qfilter != null && qFilters != null) {
            qFilters.add(qfilter);
        }
        e.setMainOrgQFilter(null);
        super.setFilter(e);
        BizLog.log((String)(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4", (String)"BidProjectListUI_79", (String)"scm-bid-formplugin", (Object[])new Object[0]) + df.format(new Date())));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                BizLog.log((String)(ResManager.loadKDString((String)"\u5217\u8868\u5f00\u59cb\u65f6\u95f4", (String)"BidProjectListUI_80", (String)"scm-bid-formplugin", (Object[])new Object[0]) + df.format(new Date())));
                ArrayList<Long> ids = new ArrayList<Long>();
                for (DynamicObject row : rows) {
                    ids.add(row.getLong("id"));
                }
                DynamicObject[] projects = BusinessDataServiceHelper.load((String)"bid_project", (String)"id,purprojectset,bidsection,bidsection.sectionname,bidsection.projectentry,projectentry.purentryproject", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                for (DynamicObject row : rows) {
                    for (DynamicObject obj : projects) {
                        String before;
                        String purProjectSet;
                        if (!row.getPkValue().toString().equals(obj.getPkValue().toString()) || (purProjectSet = obj.getDynamicObjectCollection("bidsection").stream().flatMap(section -> section.getDynamicObjectCollection("projectentry").stream()).map(purDetail -> purDetail.getDynamicObject("purentryproject")).filter(purProject -> purProject != null).map(purProject -> purProject.getString("fullname")).distinct().collect(Collectors.joining(","))).equals(before = (String)row.get("purprojectset"))) continue;
                        if (purProjectSet != null && purProjectSet.length() > 1999) {
                            purProjectSet = purProjectSet.substring(0, 1999);
                        }
                        row.set("purprojectset", (Object)purProjectSet);
                        obj.set("purprojectset", (Object)purProjectSet);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])projects);
                BizLog.log((String)(ResManager.loadKDString((String)"\u5217\u8868\u7ed3\u675f\u65f6\u95f4", (String)"BidProjectListUI_81", (String)"scm-bid-formplugin", (Object[])new Object[0]) + df.format(new Date())));
                return rows;
            }
        });
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "adjustpromsg": {
                return "bid_adjustpromsg";
            }
            case "projectprocess": {
                return "bid_projectprocess";
            }
            case "announcement": {
                return "bid_project_announcement";
            }
            case "announcement_preview": {
                return "bid_announcement_preview";
            }
        }
        return null;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList view = (BillList)this.getView().getControl("billlistap");
        String appId = ((BillEntityType)view.getEntityType()).getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"releaseannouncement"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"releaseannouncement"});
        }
    }

    protected void publishInvitation(String appId, Object bidProjectId, BeforeDoOperationEventArgs args) {
        QFilter statusFilter;
        boolean hasPermission;
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(appId + "_project"));
        if (!this.checkBeforePubInvitation(bidProject, args)) {
            return;
        }
        long orgId = -1L;
        List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
        if (orgIds != null && orgIds.size() != 0) {
            orgId = (Long)orgIds.get(0);
        }
        if (!(hasPermission = PermissionHepler.checkPermission("QXX0125", orgId, appId, appId + "_supplierinvitation"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9080\u8bf7\u51fd\u53d1\u5e03\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BidProjectListUI_66", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
        DynamicObjectCollection invitationColl = QueryServiceHelper.query((String)"bid_invitation", (String)"id,status,releasestatus", (QFilter[])new QFilter[]{qFilter, statusFilter = new QFilter("status", "not in", (Object)new String[]{"XX", "X"})}, (String)"createtime desc");
        if (invitationColl != null && invitationColl.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u9080\u8bf7\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidProjectListUI_67", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.showInvitationForm(appId, bidProjectId);
    }

    protected void viewInvitation(String appId, Object bidProjectId, BeforeDoOperationEventArgs args) {
        boolean hasPermission;
        long orgId = -1L;
        List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
        if (orgIds != null && orgIds.size() != 0) {
            orgId = (Long)orgIds.get(0);
        }
        if (!(hasPermission = PermissionHepler.checkPermission("BIDINVITE002", orgId, appId, appId + "_supplierinvitation"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u9080\u8bf7\u51fd\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BidProjectListUI_68", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParam("bidProjectPk", bidProjectId);
        listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
        listShowParameter.setHasRight(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u5217\u8868", (String)"BidProjectListUI_51", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    protected boolean checkBeforePubInvitation(DynamicObject bidProject, BeforeDoOperationEventArgs args) {
        String billStatus = bidProject.getString("billstatus");
        DynamicObject bidModel = bidProject.getDynamicObject("bidmode");
        boolean isOpenTender = false;
        if (null != bidModel) {
            isOpenTender = BidModeHelper.isPublicBidding(bidProject);
        }
        if (isOpenTender || !BillStatusEnum.AUDITED.getVal().equals(billStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u9488\u5bf9\u5df2\u5ba1\u6838\u4e14\u975e\u516c\u5f00\u62db\u6807\u7684\u7acb\u9879\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"BidProjectListUI_82", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        boolean isSupplierInvitation = bidProject.getBoolean("supplierinvitation");
        if (!isSupplierInvitation) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u7acb\u9879\u65e0\u5165\u56f4\u73af\u8282\uff0c\u4e0d\u9700\u8981\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"BidProjectListUI_83", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        boolean checkNextStepUnStarted = new BidProjectServiceImpl().checkNextStepUnStarted(bidProject, BidStepEnum.BidProject);
        if (!checkNextStepUnStarted) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"BidProjectListUI_84", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        boolean isNeedSend = false;
        DynamicObjectCollection sectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        block0: for (DynamicObject sectionEntry : sectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                String invitationStatus = supplierEntry.getString("invitationstatus");
                if (!"UNSEND".equals(invitationStatus)) continue;
                isNeedSend = true;
                continue block0;
            }
        }
        if (!isNeedSend) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"BidProjectListUI_85", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    protected void showInvitationForm(String appId, Object bidProjectId) {
        Object invitationId = null;
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"A");
        DynamicObject[] invitationCol = BusinessDataServiceHelper.load((String)(appId + "_invitation"), (String)"id,status", (QFilter[])new QFilter[]{qFilter, statusFilter}, (String)"createtime desc");
        if (invitationCol != null && invitationCol.length > 0) {
            invitationId = invitationCol[0].get("id");
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParameter.setOpenStyle(openStyle);
        showParameter.setCustomParam("bidProjectId", bidProjectId);
        showParameter.setPkId(invitationId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u53d1\u5e03", (String)"BidProjectListUI_59", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        showParameter.setStatus(invitationId == null ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "publishInvitation");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

