/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidProjectPatchSupplier
extends AbstractBillPlugIn {
    public static final String EXTRACTSUPPLIER = "extractsupplier";

    public List<Long> getExistSupplier() {
        ArrayList<Long> listSuppliers = new ArrayList<Long>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object sectionId = formShowParameter.getCustomParam("sectionId");
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObjectCollection sectionColl = dataEntity.getDynamicObjectCollection("bidrollsection");
        if (sectionColl != null && sectionColl.size() > 0) {
            for (int i = 0; i < sectionColl.size(); ++i) {
                DynamicObject section = (DynamicObject)sectionColl.get(i);
                if (!sectionId.equals(section.getPkValue())) continue;
                DynamicObjectCollection supplierentryColl = section.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierentryColl.size(); ++j) {
                    DynamicObject supplierentry = (DynamicObject)supplierentryColl.get(j);
                    Long supplier = (Long)supplierentry.getDynamicObject("supplier").getPkValue();
                    listSuppliers.add(supplier);
                }
            }
        }
        return listSuppliers;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object projectId = formShowParameter.getCustomParam("projectId");
        Object sectionId = formShowParameter.getCustomParam("sectionId");
        Object operation = formShowParameter.getCustomParam("operation");
        this.getModel().setValue("user", (Object)RequestContext.get().getUserId());
        if (EXTRACTSUPPLIER.equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billlistap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap11"});
        } else if ("extracthistory".equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"billlistap"});
        } else if (operation == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap11"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"billlistap"});
        }
        this.getModel().setValue("supplierid", projectId);
        this.getModel().setValue("sectionid", sectionId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject extractSupplier = this.getModel().getDataEntity(true);
            DynamicObjectCollection extractColl = extractSupplier.getDynamicObjectCollection("extractsupplierentry");
            if (extractColl == null || extractColl.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u6ca1\u6709\u7b26\u5408\u7684\u4f9b\u5e94\u5546\u3002", (String)"BidProjectPatchSupplier_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (EXTRACTSUPPLIER.equals(operateKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String orgId = formShowParameter.getCustomParam("orgId").toString();
            DynamicObject extractSupplier = this.getModel().getDataEntity(true);
            int extractnum = extractSupplier.getInt("extractnum");
            if (extractSupplier.getDynamicObject("suppliertype") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201d\u4f9b\u5e94\u5546\u5206\u7c7b\u201c\u3002", (String)"BidProjectPatchSupplier_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)extractSupplier.getString("extractnum")) || 0 == extractSupplier.getInt("extractnum")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201d\u62bd\u53d6\u6570\u91cf\u201c\u3002", (String)"BidProjectPatchSupplier_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<DynamicObject> extractList = this.extractSupplier(extractSupplier);
            if (extractList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u6ca1\u6709\u7b26\u5408\u7684\u4f9b\u5e94\u5546\u3002", (String)"BidProjectPatchSupplier_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (extractList != null && extractList.size() > 0) {
                String tip;
                if (extractnum == extractList.size()) {
                    tip = String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u62bd\u53d6%s\u5bb6\u4f9b\u5e94\u5546", (String)"BidProjectPatchSupplier_7", (String)"scm-bid-formplugin", (Object[])new Object[0]), extractnum);
                    this.getView().showSuccessNotification(tip);
                }
                if (extractnum > extractList.size()) {
                    tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u4e0b\u53ea\u6709%\u5bb6\u4f9b\u5e94\u5546\u6ee1\u8db3\u62bd\u53d6\u6761\u4ef6\uff0c\u5df2\u6210\u529f\u62bd\u53d6\u3002", (String)"BidProjectPatchSupplier_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), extractList);
                    this.getView().showSuccessNotification(tip);
                }
                DynamicObjectCollection extractSupplierColl = extractSupplier.getDynamicObjectCollection("extractsupplierentry");
                for (DynamicObject supplier : extractList) {
                    String name;
                    String supplierTypeAndEval;
                    String str;
                    DynamicObject supplierReg = BusinessDataServiceHelper.loadSingle((Object)supplier.getPkValue(), (String)"resm_official_supplier");
                    DynamicObject sysSupplier = supplierReg.getDynamicObject("syssupplier");
                    DynamicObject resmSupplier = BusinessDataServiceHelper.loadSingle((Object)sysSupplier.getPkValue(), (String)"bd_supplier");
                    DynamicObject supplierEntry = extractSupplierColl.addNew();
                    supplierEntry.set("supplier", (Object)resmSupplier);
                    StringBuilder supplierTypeAndEvalSb = new StringBuilder();
                    DynamicObjectCollection orgColl = supplierReg.getDynamicObjectCollection("entry_org");
                    if (orgColl != null && orgColl.size() > 0) {
                        for (int i = 0; i < orgColl.size(); ++i) {
                            DynamicObjectCollection orgGroupColl;
                            if (!orgId.equals(((DynamicObject)orgColl.get(i)).getDynamicObject("belongorg").getPkValue().toString()) || (orgGroupColl = ((DynamicObject)orgColl.get(i)).getDynamicObjectCollection("entry_org_group")) == null || orgGroupColl.size() <= 0) continue;
                            supplierEntry.set("supplierevalresult", (Object)((DynamicObject)orgGroupColl.get(0)).getDynamicObject("supplierlevel"));
                            supplierEntry.set("suppliergroup", (Object)((DynamicObject)orgGroupColl.get(0)).getDynamicObject("suppliergroup"));
                            for (int j = 0; j < orgGroupColl.size(); ++j) {
                                String type = ((DynamicObject)orgGroupColl.get(j)).getDynamicObject("suppliergroup").getString("name");
                                String eval = "";
                                if (((DynamicObject)orgGroupColl.get(j)).getDynamicObject("supplierlevel") != null) {
                                    eval = ((DynamicObject)orgGroupColl.get(j)).getDynamicObject("supplierlevel").getString("name");
                                }
                                str = type + "(" + eval + ");";
                                supplierTypeAndEvalSb.append(str);
                            }
                        }
                    }
                    if ((supplierTypeAndEval = supplierTypeAndEvalSb.toString()) != null && !"".equals(supplierTypeAndEval)) {
                        supplierEntry.set("supplierandevel", (Object)supplierTypeAndEval.substring(0, supplierTypeAndEval.length() - 1));
                    }
                    supplierEntry.set("tx_qualificationresult", supplierReg.get("tx_qualification"));
                    supplierEntry.set("enterprisepropertyr", supplierReg.get("enterprise_property"));
                    DynamicObjectCollection aptitudeColl = supplierReg.getDynamicObjectCollection("entry_otheraptitude");
                    StringBuilder nameSb = new StringBuilder();
                    if (aptitudeColl != null && aptitudeColl.size() > 0) {
                        for (int i = 0; i < aptitudeColl.size(); ++i) {
                            String evel = ((DynamicObject)aptitudeColl.get(i)).getString("otheraptitudelevel");
                            if (evel == null) continue;
                            str = ((DynamicObject)aptitudeColl.get(i)).getString("otheraptitudename") + "(" + evel + ");";
                            nameSb.append(str);
                        }
                    }
                    if ((name = nameSb.toString()) != null && !"".equals(name)) {
                        supplierEntry.set("otheraptitudenamer", (Object)name.substring(0, name.length() - 1));
                    }
                    supplierEntry.set("supplier_eval", (Object)extractSupplier.getDynamicObject("supplierlevel"));
                    supplierEntry.set("otheraptitudel_evel", (Object)extractSupplier.getString("otheraptitudelevel"));
                    supplierEntry.set("otheraptitude_name", (Object)extractSupplier.getString("otheraptitudename"));
                    supplierEntry.set("enterprise_property", extractSupplier.get("enterpriseproperty"));
                    supplierEntry.set("tx_qualification", extractSupplier.get("txqualification"));
                    supplierEntry.set("date", (Object)new Date());
                }
            }
            this.getView().updateView("extractsupplierentry");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null) {
            return;
        }
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        if ("save".equals(args.getOperateKey())) {
            DynamicObject extractSupplier = this.getModel().getDataEntity(true);
            DynamicObjectCollection extractColl = extractSupplier.getDynamicObjectCollection("extractsupplierentry");
            ArrayList<DynamicObject> extractList = new ArrayList<DynamicObject>();
            if (extractColl != null && extractColl.size() > 0) {
                for (DynamicObject supplier : extractColl) {
                    extractList.add(supplier);
                }
            }
            Object[] resultObject = new Object[]{extractList};
            this.getView().returnDataToParent((Object)resultObject);
            this.getView().close();
        }
    }

    public List<DynamicObject> extractSupplier(DynamicObject data) {
        List<Integer> randomNumList;
        ArrayList<DynamicObject> idList = new ArrayList<DynamicObject>();
        List<QFilter> filters = this.extracFilter(data);
        int extractnum = data.getInt("extractnum");
        QFilter[] filterArr = new QFilter[filters.size()];
        DynamicObject[] extractSupplier = BusinessDataServiceHelper.load((String)"resm_official_supplier", (String)"id,tx_qualification,enterprise_property,entry_otheraptitude,entry_otheraptitude.otheraptitudename,entry_otheraptitude.otheraptitudelevel,entry_org_group,entry_org_group.suppliergroup,entry_org_group.supplierlevel", (QFilter[])filters.toArray(filterArr));
        if (extractSupplier != null && extractSupplier.length > 0 && (randomNumList = this.randomSet(extractSupplier.length, extractnum)) != null && randomNumList.size() > 0) {
            for (int j = 0; j < randomNumList.size(); ++j) {
                idList.add(extractSupplier[randomNumList.get(j)]);
            }
        }
        return idList;
    }

    private List<Integer> randomSet(int max, int n) {
        int num;
        HashSet<Integer> numSet = new HashSet<Integer>(16);
        SecureRandom random = new SecureRandom();
        if (max > n) {
            while (numSet.size() < n) {
                num = random.nextInt(max);
                numSet.add(num);
            }
        } else {
            while (numSet.size() < max) {
                num = random.nextInt(max);
                numSet.add(num);
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(numSet);
        return arrayList;
    }

    public List<QFilter> extracFilter(DynamicObject data) {
        DynamicObjectCollection supplierColl;
        String rapLeval;
        String rapName;
        String enterprise_property;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String orgId = formShowParameter.getCustomParam("orgId").toString();
        List<Long> existSupplier = this.getExistSupplier();
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        QFilter billstatusFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDITED.getVal());
        String qualification = data.getString("txqualification");
        if (qualification != null && !qualification.equals(" ") && !qualification.isEmpty()) {
            QFilter qualificationFilter = new QFilter("tx_qualification", "=", (Object)qualification);
            filters.add(qualificationFilter);
        }
        Long suppliertype = (Long)data.getDynamicObject("suppliertype").getPkValue();
        QFilter supplierFilter = new QFilter("entry_org.entry_org_group.suppliergroup.id", "=", (Object)suppliertype);
        if (data.getDynamicObject("supplierlevel") != null) {
            Long supplierlevel = (Long)data.getDynamicObject("supplierlevel").getPkValue();
            QFilter supplierlevelFilter = new QFilter("entry_org.entry_org_group.supplierlevel.id", "=", (Object)supplierlevel);
            filters.add(supplierlevelFilter);
        }
        if ((enterprise_property = data.getString("enterpriseproperty")) != null && !enterprise_property.equals(" ") && !enterprise_property.isEmpty()) {
            QFilter enterpriseFilter = new QFilter("enterprise_property", "=", (Object)enterprise_property);
            filters.add(enterpriseFilter);
        }
        if ((rapName = data.getString("otheraptitudename")) != null && !rapName.equals(" ") && !rapName.isEmpty()) {
            QFilter rapNameFilter = new QFilter("entry_otheraptitude.otheraptitudename", "like", (Object)rapName);
            filters.add(rapNameFilter);
        }
        if ((rapLeval = data.getString("otheraptitudelevel")) != null && !rapLeval.equals(" ") && !rapLeval.isEmpty()) {
            QFilter rapLevalFilter = new QFilter("entry_otheraptitude.otheraptitudelevel", "=", (Object)rapLeval);
            filters.add(rapLevalFilter);
        }
        if ((supplierColl = data.getDynamicObjectCollection("extractsupplierentry")) != null && supplierColl.size() > 0) {
            for (DynamicObject supplier : supplierColl) {
                existSupplier.add((Long)supplier.getDynamicObject("supplier").getPkValue());
            }
        }
        if (existSupplier != null && existSupplier.size() > 0) {
            QFilter existFilter = new QFilter("id", "not in", existSupplier);
            filters.add(filter.and(billstatusFilter).and(existFilter).and(supplierFilter));
        } else {
            filters.add(filter.and(billstatusFilter).and(supplierFilter));
        }
        return filters;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }
}

