/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidPurdetailShow
extends AbstractBillPlugIn {
    String[] supbackDetails = new String[]{"purentrycontent", "purentryproject", "materialid", "materialdes", "baseunit", "qty", "inclutaxprice", "inclutaxamount", "bd_taxrate", "taxrate", "taxamount", "excepttaxamount", "costrate"};
    String[] rebmbackDetails = new String[]{"purentrycontent", "purentryproject", "resourceitem", "materialid", "materialdes", "baseunit", "qty", "inclutaxprice", "inclutaxamount", "taxrate", "taxamount", "excepttaxamount", "costrate", "bd_taxrate"};

    public void afterCreateNewData(EventObject e) {
        DynamicObject bidPro;
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection supbackdetail = dataEntity.getDynamicObjectCollection("supbackdetail");
        supbackdetail.clear();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object projectID = showParameter.getCustomParam("pkId");
        DynamicObject decipurdetailshow = BusinessDataServiceHelper.loadSingle((Object)projectID, (String)(this.getBidAppId() + "_decipurdetailshow"));
        DynamicObject bidproject = decipurdetailshow.getDynamicObject("bidproject");
        if (bidproject != null && (bidPro = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)(this.getBidAppId() + "_project"), (String)"currency")) != null) {
            dataEntity.set("currency", bidPro.get("currency"));
        }
        String sourceid = decipurdetailshow.getString("sourceid");
        String quotesource = decipurdetailshow.getString("quotesource");
        String sectionname = decipurdetailshow.getLocaleString("sectionname").getLocaleValue();
        String entitytype = decipurdetailshow.getString("entitytype");
        Long idSupplier = decipurdetailshow.getDynamicObject("supplier").getLong("id");
        String[] details = !StringUtils.equals((CharSequence)"bid", (CharSequence)this.getAppId()) ? this.rebmbackDetails : this.supbackDetails;
        this.createEntry(quotesource, supbackdetail, sectionname, details, sourceid, idSupplier, entitytype);
    }

    public String getAppId() {
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        return appName;
    }

    public String getBidAppId() {
        return this.getAppId().equals("bid") ? "bid" : "rebm";
    }

    public String getTenAppId() {
        return this.getAppId().equals("bid") ? "ten" : "resp";
    }

    public void createEntry(String quotesource, DynamicObjectCollection supbackdetail, String sectionname, String[] details, String sourceid, Long idSupplier, String entitytype) {
        switch (quotesource) {
            case "tenonline": {
                boolean enable = SystemParamHelper.getSystemParameter((String)this.getBidAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
                this.createBackPurDetailEntryByTen(supbackdetail, details, sourceid);
                break;
            }
            case "questionclarify": {
                this.createBackPurDetailEntryByQue(supbackdetail, sectionname, details, sourceid);
                break;
            }
            case "bustalk": {
                if ("rebm".equals(entitytype) || "bid".equals(entitytype)) {
                    this.createCloseBackPurDetailEntryByBus(supbackdetail, sectionname, details, sourceid, idSupplier, entitytype);
                    break;
                }
                this.createBackPurDetailEntryByBus(supbackdetail, sectionname, details, sourceid);
            }
        }
    }

    public void createBackPurDetailEntryByTen(DynamicObjectCollection supbackdetail, String[] details, String sourceid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(sourceid), (String)(this.getTenAppId() + "_online_bid_detail"));
        if (dynamicObject != null) {
            DynamicObjectCollection supplierdetails = dynamicObject.getDynamicObjectCollection("supplierdetail");
            for (DynamicObject supplierdetail : supplierdetails) {
                DynamicObject backFinalDetailModel = supbackdetail.addNew();
                for (String key : details) {
                    if ("taxrate".equals(key) || "costrate".equals(key)) {
                        backFinalDetailModel.set(key, (Object)supplierdetail.getBigDecimal(key).multiply(new BigDecimal("100")));
                        continue;
                    }
                    backFinalDetailModel.set(key, supplierdetail.get(key));
                }
            }
        }
    }

    public void createBackPurDetailEntryByQue(DynamicObjectCollection supbackdetail, String sectionname, String[] details, String sourceid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(sourceid), (String)(this.getTenAppId() + "_questionclarify"));
        if (dynamicObject != null) {
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("bidsection");
            for (DynamicObject dynamicObject1 : entry) {
                String sectionname1 = dynamicObject1.getLocaleString("sectionname").getLocaleValue();
                if (sectionname == null || !sectionname.equals(sectionname1)) continue;
                DynamicObjectCollection supplierdetails = dynamicObject1.getDynamicObjectCollection("supplierdetail");
                for (DynamicObject supplierdetail : supplierdetails) {
                    DynamicObject backFinalDetailModel = supbackdetail.addNew();
                    for (String key : details) {
                        if ("taxrate".equals(key) || "costrate".equals(key)) {
                            backFinalDetailModel.set(key, (Object)supplierdetail.getBigDecimal(key).multiply(new BigDecimal("100")));
                            continue;
                        }
                        backFinalDetailModel.set(key, supplierdetail.get(key));
                    }
                }
            }
        }
    }

    public void createBackPurDetailEntryByBus(DynamicObjectCollection supbackdetail, String sectionname, String[] details, String sourceid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(sourceid), (String)(this.getTenAppId() + "_onlie_bustalk"));
        if (dynamicObject != null) {
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject1 : entry) {
                String sectionname1 = dynamicObject1.getString("sectionname");
                if (sectionname == null || !sectionname.equals(sectionname1)) continue;
                DynamicObjectCollection supplierdetails = dynamicObject1.getDynamicObjectCollection("supplierdetail");
                for (DynamicObject supplierdetail : supplierdetails) {
                    DynamicObject backFinalDetailModel = supbackdetail.addNew();
                    for (String key : details) {
                        backFinalDetailModel.set(key, supplierdetail.get(key));
                    }
                }
            }
        }
    }

    public void createCloseBackPurDetailEntryByBus(DynamicObjectCollection supbackdetail, String sectionname, String[] details, String sourceid, Long idSupplier, String entitytype) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(sourceid), (String)(entitytype + "_bustalk"));
        if (dynamicObject != null) {
            DynamicObjectCollection bidsectionCol = dynamicObject.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidsection : bidsectionCol) {
                String bussectionname = bidsection.getString("sectionname");
                if (!bussectionname.equals(sectionname)) continue;
                DynamicObjectCollection ssupplierdetailCol = bidsection.getDynamicObjectCollection("supplierdetail");
                for (DynamicObject supplierdetail : ssupplierdetailCol) {
                    DynamicObject supplier = supplierdetail.getDynamicObject("pursupplier");
                    Long idsup = supplier.getLong("id");
                    if (!idsup.equals(idSupplier)) continue;
                    DynamicObject backFinalDetailModel = supbackdetail.addNew();
                    for (String key : details) {
                        if ("taxrate".equals(key)) {
                            backFinalDetailModel.set(key, (Object)supplierdetail.getBigDecimal("staxrate").multiply(new BigDecimal("100")));
                            continue;
                        }
                        if ("costrate".equals(key)) {
                            DynamicObjectCollection supplierentryCol = bidsection.getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplierentry : supplierentryCol) {
                                DynamicObject supplierEn = supplierentry.getDynamicObject("supplier");
                                Long idsupEn = supplierEn.getLong("id");
                                if (!idsupEn.equals(idSupplier)) continue;
                                backFinalDetailModel.set("costrate", (Object)supplierentry.getBigDecimal("newrate").multiply(new BigDecimal("100")));
                            }
                            continue;
                        }
                        backFinalDetailModel.set(key, supplierdetail.get(key));
                    }
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPurTypeModelStatus();
    }

    private void setPurTypeModelStatus() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object projectID = showParameter.getCustomParam("pkId");
        DynamicObject decipurdetailshow = BusinessDataServiceHelper.loadSingle((Object)projectID, (String)(this.getBidAppId() + "_decipurdetailshow"));
        DynamicObject bidproject = decipurdetailshow.getDynamicObject("bidproject");
        Object pkValue = bidproject.getPkValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)(this.getBidAppId() + "_project"));
        boolean isMaterialpur = dynamicObject.getBoolean("ismaterialpur");
        boolean isratebidding = dynamicObject.getBoolean("isratebidding");
        int bidType = dynamicObject.getInt("bidtype");
        if (bidType != 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent", "costrate"});
            EntryGrid supbackdetailGrid = (EntryGrid)this.getControl("supbackdetail");
            supbackdetailGrid.setColumnProperty("inclutaxamount", "l", (Object)55);
            supbackdetailGrid.setColumnProperty("taxrate", "l", (Object)55);
            if (StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getBidAppId())) {
                if (bidType == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem", "resitemname", "resourcemodel", "resourceunit"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialname", "materialid", "model", "unit"});
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "materialdes", "model", "unit", "baseunit", "qty", "inclutaxprice", "bd_taxrate"});
            if (StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getBidAppId())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem", "resitemname", "resourcemodel", "resourceunit"});
            }
            if (!isratebidding) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"costrate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxamount", "taxrate", "taxamount", "excepttaxamount"});
            }
        }
    }
}

