/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.bid.business.bill.IBidDarkService;
import kd.scm.bid.business.bill.serviceImpl.BidDarkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.formplugin.bill.util.NumberUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidReBackBidEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
CellClickListener,
RowClickEventListener {
    private IBidDarkService bidDarkService = new BidDarkServiceImpl();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplierCon = (BasedataEdit)this.getView().getControl("supplier");
        supplierCon.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid supplierEntry = (EntryGrid)this.getView().getControl("supplierentry");
        supplierEntry.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject bidopen = this.getBidOpenData();
        if (bidopen == null) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.setBillHeadFields(bidopen, dataEntity);
        this.setEntryFields(bidopen, dataEntity);
        this.setSplitContainerVisiable(dataEntity);
    }

    public DynamicObject getBidOpenData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter == null) {
            return null;
        }
        Object bidOpenId = formShowParameter.getCustomParam("bidOpenId");
        if (bidOpenId == null) {
            bidOpenId = this.getModel().getValue("sourceid");
        }
        if (bidOpenId == null) {
            return null;
        }
        return this.getBidOpenById(bidOpenId);
    }

    protected void setSplitContainerVisiable(DynamicObject dataEntity) {
        SplitContainer splitcontainerap = (SplitContainer)this.getView().getControl("splitcontainerap");
        boolean mulSection = dataEntity.getBoolean("bidproject.enablemultisection");
        if (!mulSection) {
            splitcontainerap.hidePanel(SplitDirection.left, true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Object bidproject = dataEntity.getDynamicObject("bidproject").getPkValue();
            String tips = new ReBackBidUtil(this.getAppId()).checkOtherBidProcessFinished(bidproject);
            if (tips != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u91cd\u65b0\u56de\u6807\u3002", (String)"BidReBackBidEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                sb.append('\n');
                sb.append(tips);
                this.getView().showMessage(sb.toString());
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.getView().updateView();
        }
    }

    protected void setEntryFields(DynamicObject bidopen, DynamicObject dataEntity) {
        DynamicObjectCollection openSections = bidopen.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection sections = dataEntity.getDynamicObjectCollection("bidsection");
        sections.clear();
        openSections.forEach(openSection -> {
            DynamicObject section = sections.addNew();
            section.set("sectionname", openSection.get("sectionname"));
            section.set("srcsectionid", openSection.getPkValue());
            DynamicObjectCollection openSupplierEntry = openSection.getDynamicObjectCollection("supplierentry");
            this.setSubEntryFields(section, openSupplierEntry);
        });
        sections.forEach(entry -> entry.getDataEntityState().setPushChanged(true));
    }

    protected void setSubEntryFields(DynamicObject section, DynamicObjectCollection openSupplierEntry) {
        DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
        supplierEntry.clear();
        openSupplierEntry.forEach(entry -> {
            boolean untenderFlag = entry.getBoolean("untenderflag");
            if (untenderFlag) {
                return;
            }
            DynamicObject newSupplierEntry = supplierEntry.addNew();
            this.setSupplierEntryData((DynamicObject)entry, newSupplierEntry);
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject bidopen = this.getBidOpenData();
        if (bidopen == null) {
            return;
        }
        Map<Object, Map<Object, DynamicObject>> openEntryDataMap = this.getBidOpenEntryData(bidopen);
        this.addNotExsitSubEntryFromBidOpen(openEntryDataMap);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.setDarkSupplierName(dataEntity);
    }

    public void setDarkSupplierName(DynamicObject dataEntity) {
        boolean isDark = dataEntity.getBoolean("isdark");
        if (isDark) {
            Long sourceId = dataEntity.getLong("sourceid");
            this.bidDarkService.setEntryDarkSupplierName((Object)sourceId, dataEntity, this.getServiceAppId());
        }
    }

    public String getServiceAppId() {
        return this.getView().getFormShowParameter().getServiceAppId();
    }

    public void addNotExsitSubEntryFromBidOpen(Map<Object, Map<Object, DynamicObject>> openEntryDataMap) {
        if (openEntryDataMap.isEmpty()) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSection = dataEntity.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            Object srcSectionId = section.get("srcsectionid");
            Map subEntryMap = (Map)openEntryDataMap.get(srcSectionId);
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                Object srcEntryId = entry.get("srcentryid");
                subEntryMap.remove(srcEntryId);
            });
            subEntryMap.forEach((key, value) -> {
                DynamicObject newEntry = supplierEntry.addNew();
                this.setSupplierEntryData((DynamicObject)value, newEntry);
            });
        });
    }

    public Map<Object, Map<Object, DynamicObject>> getBidOpenEntryData(DynamicObject bidopen) {
        HashMap<Object, Map<Object, DynamicObject>> openEntryDataMap = new HashMap<Object, Map<Object, DynamicObject>>(16);
        DynamicObjectCollection bidSection = bidopen.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            Object sectionId = section.getPkValue();
            Map subEntryDataMap = openEntryDataMap.computeIfAbsent(sectionId, k -> new HashMap(16));
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                boolean unTerderFlag = entry.getBoolean("untenderflag");
                if (unTerderFlag) {
                    return;
                }
                Object detailId = entry.getPkValue();
                subEntryDataMap.put(detailId, entry);
            });
        });
        return openEntryDataMap;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid sectionEntryGrid = (EntryGrid)this.getView().getControl("bidsection");
        sectionEntryGrid.addRowClickListener((RowClickEventListener)this);
        sectionEntryGrid.selectRows(0, true);
        sectionEntryGrid.entryRowClick(Integer.valueOf(0));
        this.setFieldVisiableAndEnable();
        this.setSplitContainerVisiable(this.getModel().getDataEntity());
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String type = dataEntity.getString("type");
        this.setFileEntryVisible(type);
    }

    protected void setFieldVisiableAndEnable() {
        DynamicObject bidopen = this.getBidOpenData();
        if (bidopen == null) {
            return;
        }
        String type = bidopen.getString("opentype");
        if ("MULTI".equals(type)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"type"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"type"});
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean bidAnswerQuestionFlag = dataEntity.getBoolean("bidproject.bidanswerquestion");
        this.getView().setVisible(Boolean.valueOf(bidAnswerQuestionFlag), new String[]{"answerquestionflag"});
        DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
        bidproject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)(this.getAppId() + "_project"), (String)"is_enc_enable");
        boolean isEncEnable = bidproject.getBoolean("is_enc_enable");
        this.getView().setVisible(Boolean.valueOf(isEncEnable), new String[]{"shuffleorderflag"});
    }

    protected void setBillHeadFields(DynamicObject bidopen, DynamicObject dataEntity) {
        DynamicObject decision;
        DynamicObjectCollection onlinebideval;
        dataEntity.set("billno", (Object)this.getBillno(dataEntity));
        String opentype = bidopen.getString("opentype");
        dataEntity.set("type", (Object)opentype);
        dataEntity.set("isdark", bidopen.get("isdark"));
        DynamicObject bidProject = bidopen.getDynamicObject("bidproject");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(this.getAppId() + "_project"), (String)"bidopendeadline,techbackbidtime,busbackbidtime,currentstep,currency");
        dataEntity.set("bidopendeadline", project.get("bidopendeadline"));
        dataEntity.set("techbackbidtime", project.get("techbackbidtime"));
        dataEntity.set("busbackbidtime", project.get("busbackbidtime"));
        dataEntity.set("currency", project.get("currency"));
        String bidProjectF7Name = "bid".equalsIgnoreCase(this.getAppId()) ? "bidproject_f7" : "rebm_bidproject_f7";
        dataEntity.set("bidproject", (Object)BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)bidProjectF7Name));
        dataEntity.set("sourceid", bidopen.getPkValue());
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        dataEntity.set("source", source);
        dataEntity.set("org", bidopen.get("org"));
        DynamicObjectCollection bills = QueryServiceHelper.query((String)this.getBillId(), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue())});
        dataEntity.set("round", (Object)(bills.size() + 1));
        dataEntity.set("rounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e", (String)"BidReBackBidEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), BidOpenServiceImpl.toChinese((String)String.valueOf(bills.size() + 1))));
        dataEntity.set("bidpublishid", bidopen.get("bidpublishid"));
        boolean isOnlineEval = bidopen.getBoolean("isonlineeval");
        dataEntity.set("isonlineeval", (Object)isOnlineEval);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("bidproject", "=", bidProject.getPkValue()));
        qFilters.add(new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"}));
        if (!"MULTI".equals(opentype)) {
            qFilters.add(new QFilter("evaltype", "=", (Object)opentype));
        }
        List<Object> evaluationIds = new ArrayList(16);
        DynamicObjectCollection bidevaltion = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)String.join((CharSequence)",", "id", "billstatus"), (QFilter[])qFilters.toArray(new QFilter[0]));
        if (bidevaltion != null && bidevaltion.size() > 0) {
            dataEntity.set("evaltioninfo", (Object)this.getIdAndBillstatus(bidevaltion));
            evaluationIds = bidevaltion.stream().map(eval -> eval.getLong("id")).collect(Collectors.toList());
        }
        if (isOnlineEval && (onlinebideval = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()), (String)String.join((CharSequence)",", "id", "billstatus"), (QFilter[])qFilters.toArray(new QFilter[0]))) != null && onlinebideval.size() > 0) {
            dataEntity.set("onlineevalinfo", (Object)this.getIdAndBillstatus(onlinebideval));
        }
        if (!evaluationIds.isEmpty()) {
            DynamicObjectCollection questclarifys;
            DynamicObjectCollection multiquestclarifys = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"multiquestclarify", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidevaluationid", "in", evaluationIds), new QFilter("billstatus", "not in", (Object)new String[]{"INVALIDXX", "INVALID"})});
            if (multiquestclarifys.size() != 0) {
                StringBuilder sb = new StringBuilder();
                multiquestclarifys.forEach(clarify -> {
                    sb.append(clarify.getLong("id"));
                    sb.append("@@@");
                });
                dataEntity.set("mulqusclarifyids", (Object)sb.toString());
            }
            if ((questclarifys = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidevaluationid", "in", evaluationIds), new QFilter("billstatus", "not in", (Object)new String[]{"INVALIDXX", "INVALID"})})).size() != 0) {
                StringBuilder sb = new StringBuilder();
                questclarifys.forEach(clarify -> {
                    sb.append(clarify.getLong("id"));
                    sb.append("@@@");
                });
                dataEntity.set("qusclarifyids", (Object)sb.toString());
            }
        }
        if ((decision = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"})})) != null) {
            dataEntity.set("decisionid", (Object)decision.getLong("id"));
        }
        dataEntity.set("laststep", project.get("currentstep"));
    }

    protected String getIdAndBillstatus(DynamicObjectCollection bidevaltion) {
        StringBuilder sb = new StringBuilder();
        bidevaltion.forEach(eval -> {
            long id = eval.getLong("id");
            String billstatus = eval.getString("billstatus");
            sb.append(id);
            sb.append("@@@");
            sb.append(billstatus);
            sb.append("###");
        });
        return sb.toString();
    }

    public String getBillno(DynamicObject dataEntity) {
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)this.getBillId(), (DynamicObject)dataEntity, null);
        String code = null;
        if (null != codeRule) {
            code = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dataEntity);
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            Calendar calendar = Calendar.getInstance();
            code = df.format(calendar.getTime());
        }
        return code;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        Object oldValue;
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        if (newValue == (oldValue = changeSet.getOldValue())) {
            return;
        }
        switch (name = e.getProperty().getName()) {
            case "endtime": {
                this.endTimeChanged((Date)newValue);
                break;
            }
            case "openendtime": {
                this.openTimeChanged((Date)newValue);
                break;
            }
            case "type": {
                if (null == newValue) {
                    this.getModel().setValue("type", oldValue);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u8f6e\u56de\u6807\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidReBackBidEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.setFileEntryVisible((String)newValue);
                break;
            }
        }
    }

    public void setFileEntryVisible(String type) {
        if ("TECHNICAL".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_comattach"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "purdetail", "supplier_illustration"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"supplier_techattach", "supplier_tenattach", "supplier_otherattach"});
        } else if ("BUSSINESS".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_techattach"});
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(this.getAppId() + "_project"), (String)"doctype,bidopentype");
            String doctype = bidProject.getString("doctype");
            String bidopentype = bidProject.getString("bidopentype");
            if ("MULTI".equals(doctype) && "TECHBUSINESS".equals(bidopentype)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_tenattach", "supplier_otherattach"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"supplier_comattach"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "purdetail", "supplier_illustration"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"supplier_techattach", "supplier_tenattach", "supplier_otherattach", "supplier_comattach"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "purdetail", "supplier_illustration"});
        }
    }

    public void openTimeChanged(Date newValue) {
        if (newValue == null) {
            return;
        }
        Date endTime = (Date)this.getModel().getValue("endtime");
        if (endTime != null && endTime.after(newValue)) {
            this.getModel().setValue("openendtime", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u8f6e\u5f00\u6807\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u56de\u6807\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidReBackBidEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Date curDate = new Date();
        if (endTime == null && curDate.after(newValue)) {
            this.getModel().setValue("openendtime", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u8f6e\u5f00\u6807\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BidReBackBidEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void endTimeChanged(Date newValue) {
        Date curDate = new Date();
        if (newValue == null) {
            return;
        }
        if (curDate.after(newValue)) {
            this.getModel().setValue("endtime", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56de\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BidReBackBidEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Date openendtime = (Date)this.getModel().getValue("openendtime");
        if (openendtime != null && newValue.after(openendtime)) {
            this.getModel().setValue("endtime", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56de\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u5f97\u665a\u4e8e\u672c\u8f6e\u5f00\u6807\u65f6\u95f4\u3002", (String)"BidReBackBidEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    protected DynamicObject getBidOpenById(Object bidOpenId) {
        return BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
    }

    protected String getAppId() {
        return ((Object)((Object)this)).getClass().getName().split("\\.")[2];
    }

    protected String getBillId() {
        return this.getView().getFormShowParameter().getFormId();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public DynamicObject getFocusBidSectionData() {
        EntryGrid bidSectionGrid = (EntryGrid)this.getView().getControl("bidsection");
        int focusRow = bidSectionGrid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            return null;
        }
        return this.getModel().getEntryRowEntity("bidsection", focusRow);
    }

    public void setSupplierEntryData(DynamicObject bidOpenSupplierEntry, DynamicObject newSupplierEntry) {
        newSupplierEntry.set("supplier", bidOpenSupplierEntry.get("supplier"));
        newSupplierEntry.set("suppliercontact", bidOpenSupplierEntry.get("suppliercontact"));
        newSupplierEntry.set("contactphone", bidOpenSupplierEntry.get("contactphone"));
        newSupplierEntry.set("supplier_deposittype", bidOpenSupplierEntry.get("supplier_deposittype"));
        newSupplierEntry.set("supplier_deposit", bidOpenSupplierEntry.get("supplier_deposit"));
        newSupplierEntry.set("supplier_tenderdate", bidOpenSupplierEntry.get("supplier_tenderdate"));
        newSupplierEntry.set("supplier_isinvalid", bidOpenSupplierEntry.get("supplier_isinvalid"));
        newSupplierEntry.set("supplier_invalidreason", bidOpenSupplierEntry.get("supplier_invalidreason"));
        newSupplierEntry.set("supplier_manager", bidOpenSupplierEntry.get("supplier_manager"));
        newSupplierEntry.set("supplier_workday", bidOpenSupplierEntry.get("supplier_workday"));
        this.copyAttach(newSupplierEntry.getDynamicObjectCollection("supplier_techattach"), bidOpenSupplierEntry.getDynamicObjectCollection("supplier_techattach"));
        this.copyAttach(newSupplierEntry.getDynamicObjectCollection("supplier_comattach"), bidOpenSupplierEntry.getDynamicObjectCollection("supplier_comattach"));
        this.copyAttach(newSupplierEntry.getDynamicObjectCollection("supplier_tenattach"), bidOpenSupplierEntry.getDynamicObjectCollection("supplier_tenattach"));
        this.copyAttach(newSupplierEntry.getDynamicObjectCollection("supplier_otherattach"), bidOpenSupplierEntry.getDynamicObjectCollection("supplier_otherattach"));
        newSupplierEntry.set("supplier_tenderprice", bidOpenSupplierEntry.get("supplier_tenderprice"));
        newSupplierEntry.set("supplier_taxrate", bidOpenSupplierEntry.getBigDecimal("supplier_taxrate") == null ? null : NumberUtil.multiply(bidOpenSupplierEntry.getBigDecimal("supplier_taxrate"), 100));
        newSupplierEntry.set("supplier_pricevat", bidOpenSupplierEntry.get("supplier_pricevat"));
        newSupplierEntry.set("supplier_exceptvat", bidOpenSupplierEntry.get("supplier_exceptvat"));
        newSupplierEntry.set("purdetail", bidOpenSupplierEntry.get("purdetail"));
        newSupplierEntry.set("supplier_illustration", bidOpenSupplierEntry.get("supplier_illustration"));
        newSupplierEntry.set("supplier_comment", bidOpenSupplierEntry.get("supplier_comment"));
        newSupplierEntry.set("srcentryid", bidOpenSupplierEntry.getPkValue());
        newSupplierEntry.set("supplier_istender", bidOpenSupplierEntry.get("supplier_istender"));
    }

    protected void copyAttach(DynamicObjectCollection newAttachFiles, DynamicObjectCollection oldAttachFiles) {
        oldAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = newAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("purdetail".equals(fieldKey)) {
            this.clickPurDetailFieldKey();
        }
    }

    protected void clickPurDetailFieldKey() {
        DynamicObject focusBidSectionData = this.getFocusBidSectionData();
        EntryGrid supplierEntryGrid = (EntryGrid)this.getView().getControl("supplierentry");
        int focusRow = supplierEntryGrid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            return;
        }
        if (focusBidSectionData == null) {
            return;
        }
        DynamicObjectCollection supplierEntry = focusBidSectionData.getDynamicObjectCollection("supplierentry");
        DynamicObject entry = (DynamicObject)supplierEntry.get(focusRow);
        DynamicObject supplier = entry.getDynamicObject("supplier");
        if (supplier == null) {
            return;
        }
        long supplierId = (Long)supplier.getPkValue();
        String focusSectioName = focusBidSectionData.getString("sectionname");
        DynamicObject bidOpenData = this.getBidOpenData();
        if (bidOpenData == null) {
            return;
        }
        Optional<DynamicObject> first = bidOpenData.getDynamicObjectCollection("bidsection").stream().filter(section -> StringUtils.equalsIgnoreCase((CharSequence)focusSectioName, (CharSequence)section.getString("sectionname"))).findAny();
        if (!first.isPresent()) {
            return;
        }
        DynamicObject section2 = first.get();
        Set purDetails = section2.getDynamicObjectCollection("supplierdetail").stream().filter(supdetail -> supdetail.getDynamicObject("pursupplier") != null && supplierId == (Long)supdetail.getDynamicObject("pursupplier").getPkValue()).collect(Collectors.toSet());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getAppId() + "_bidopen_purdetail");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParam("entryCurrentRowIndex", (Object)0);
        formShowParameter.setCustomParam("billStatus", (Object)"O");
        formShowParameter.setCustomParam("supplierid", (Object)String.valueOf(supplierId));
        formShowParameter.setCustomParam("sectionId", (Object)String.valueOf(focusBidSectionData.get("srcsectionid")));
        formShowParameter.setCustomParam("purDetails", purDetails);
        formShowParameter.setCustomParam("isMaterialpur", (Object)dataEntity.getBoolean("bidproject.ismaterialpur"));
        formShowParameter.setCustomParam("isratebidding", (Object)dataEntity.getBoolean("bidproject.isratebidding"));
        formShowParameter.setCustomParam("bidType", dataEntity.get("bidproject.bidtype"));
        formShowParameter.setCustomParam("currentSupplierIndex", (Object)0);
        formShowParameter.setCustomParam("sectionName", (Object)focusSectioName);
        formShowParameter.setCustomParam("bidOpenId", dataEntity.get("sourceid"));
        this.getView().showForm(formShowParameter);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

