/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidSupplierFileService;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidSupplierFileServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidSupplierInvalEdit
extends AbstractBillPlugIn
implements CellClickListener {
    private static final String ADDSUPPLIER_BTN = "addsupplier";
    private static final String BD_SUPPLIER = "bd_supplier";
    private final IBidOpenService bidOpenService = new BidOpenServiceImpl();
    private final IBidSupplierFileService bidSupplierFileService = new BidSupplierFileServiceImpl();
    private static final String REBM = "rebm";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)this.getCurEntityName(), (DynamicObject)dataEntity, null);
        if (null != codeRule) {
            String code = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dataEntity);
            dataEntity.set("billno", (Object)code);
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            Calendar calendar = Calendar.getInstance();
            String dateName = df.format(calendar.getTime());
            dataEntity.set("billno", (Object)dateName);
        }
    }

    protected String getCurEntityName() {
        return this.getAppId() + "_supplierinvalid";
    }

    protected String getOpenEntityName() {
        return this.getAppId() + "_bidopen";
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidOpenId = null;
        if (StringUtils.equals((CharSequence)OperationStatus.ADDNEW.toString(), (CharSequence)formShowParameter.getStatus().toString())) {
            bidOpenId = formShowParameter.getCustomParam("bidopenid");
            this.getModel().setValue("bidopenid", (Object)((Long)bidOpenId));
            this.getModel().setValue("bidproject", (Object)((Long)formShowParameter.getCustomParam("bidproject")));
            this.getModel().setValue("isonlineeval", (Object)((Boolean)formShowParameter.getCustomParam("isonlineeval")));
            this.getModel().setValue("entitytypeid", (Object)this.getAppId());
            this.createEntryData(bidOpenId, true);
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            bidOpenId = dataEntity.getLong("bidopenid");
        }
        String openBillstatus = (String)formShowParameter.getCustomParam("billstatus");
        if ("XX".equals(openBillstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save,bar_submit,bar_audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"addsupplier,deletesupplier"});
        }
        this.setFileVisible(bidOpenId);
        this.setDarkStatus(bidOpenId);
    }

    public void setDarkStatus(Object bidOpenId) {
        DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)(this.getAppId() + "_bidopen"), (String)"isdark");
        this.getModel().setValue("is_dark", (Object)bidopen.getBoolean("isdark"));
    }

    public void setFileVisible(Object bidOpenId) {
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)this.getOpenEntityName(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)bidOpenId))});
        if (bidOpen != null) {
            String openType = bidOpen.getString("opentype");
            if ("TECHNICAL".equals(openType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_comattach"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "purdetail", "supplier_illustration"});
            } else if ("BUSSINESS".equals(openType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_techattach"});
                DynamicObject bidproject = bidOpen.getDynamicObject("bidproject");
                String doctype = bidproject.getString("doctype");
                String bidopentype = bidproject.getString("bidopentype");
                if ("MULTI".equals(doctype) && "TECHBUSINESS".equals(bidopentype)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_tenattach", "supplier_otherattach"});
                }
            }
        }
    }

    protected Map<String, List<DynamicObject>> createEntryData(Object bidOpenId, boolean flag) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String selectedProperties = String.join((CharSequence)",", "bidsection", "sectionname", "supplierentry", "supplier", "supplier_comment", "suppliercontact", "contactphone", "supplier_deposittype", "supplier_deposit", "supplier_isinvalid", "supplier_istender", "supplier_tenderdate", "supplier_pricevat", "supplier_illustration", "supplier_invalidreason", "supplier_manager", "supplier_workday", "supplier_techattach", "supplier_comattach", "supplier_tenattach", "supplier_otherattach", "supplier_tenderprice", "supplier_taxrate", "supplier_exceptvat", "supplier_rate", "purdetail", "org", "supplier_revokebidnumber", "supplier_isfrombackbid", "isnew", "currency", "darksuppliername");
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)this.getOpenEntityName(), (String)selectedProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)bidOpenId)), new QFilter("billstatus", "=", (Object)"O")});
        if (bidOpen == null) {
            return null;
        }
        this.getModel().setValue("currency", bidOpen.get("currency"));
        dataEntity.set("org", bidOpen.get("org"));
        HashMap<String, List<DynamicObject>> supplierIds = new HashMap<String, List<DynamicObject>>();
        DynamicObjectCollection bidSection = bidOpen.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection sectionEntry = dataEntity.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidSection.size(); ++i) {
            DynamicObject section = (DynamicObject)bidSection.get(i);
            String sectionName = section.getString("sectionname");
            if (flag) {
                DynamicObject sectionRow = sectionEntry.addNew();
                sectionRow.set("sectionname", (Object)sectionName);
                continue;
            }
            this.createSubEntry(section, null, sectionName, supplierIds);
        }
        return supplierIds;
    }

    protected void createSubEntry(DynamicObject section, DynamicObject sectionRow, String sectionName, Map<String, List<DynamicObject>> supplierIds) {
        DynamicObjectCollection openSupplierEntry = section.getDynamicObjectCollection("supplierentry");
        DynamicObjectCollection supplierEntry = null;
        if (sectionRow != null) {
            supplierEntry = sectionRow.getDynamicObjectCollection("supplierentry");
        }
        for (int i = 0; i < openSupplierEntry.size(); ++i) {
            DynamicObject openSupplier = (DynamicObject)openSupplierEntry.get(i);
            boolean isTender = false;
            if (openSupplier != null) {
                isTender = openSupplier.getBoolean("supplier_istender");
            }
            boolean isInvalid = false;
            if (openSupplier != null) {
                isInvalid = openSupplier.getBoolean("supplier_isinvalid");
            }
            if (!isTender || isInvalid) continue;
            if (supplierIds.get(sectionName) == null) {
                ArrayList<DynamicObject> suppliers = new ArrayList<DynamicObject>();
                suppliers.add(openSupplier);
                supplierIds.put(sectionName, suppliers);
            } else {
                supplierIds.get(sectionName).add(openSupplier);
            }
            if (sectionRow == null || supplierEntry == null) continue;
            DynamicObject supplier = supplierEntry.addNew();
            if (openSupplier == null || supplier == null) continue;
            this.setEntryRowData(openSupplier, supplier);
        }
    }

    protected void setEntryRowData(DynamicObject openSupplier, DynamicObject supplier) {
        supplier.set("supplier", openSupplier.get("supplier"));
        supplier.set("supplier_dark", openSupplier.get("darksuppliername"));
        supplier.set("suppliercontact", openSupplier.get("suppliercontact"));
        supplier.set("contactphone", openSupplier.get("contactphone"));
        supplier.set("supplier_deposittype", openSupplier.get("supplier_deposittype"));
        supplier.set("supplier_deposit", openSupplier.get("supplier_deposit"));
        supplier.set("supplier_istender", openSupplier.get("supplier_istender"));
        supplier.set("supplier_tenderdate", openSupplier.get("supplier_tenderdate"));
        supplier.set("supplier_isinvalid", (Object)Boolean.TRUE);
        supplier.set("supplier_invalidreason", openSupplier.get("supplier_invalidreason"));
        supplier.set("supplier_manager", openSupplier.get("supplier_manager"));
        supplier.set("supplier_workday", openSupplier.get("supplier_workday"));
        this.copyAttach(supplier.getDynamicObjectCollection("supplier_techattach"), openSupplier.getDynamicObjectCollection("supplier_techattach"));
        this.copyAttach(supplier.getDynamicObjectCollection("supplier_comattach"), openSupplier.getDynamicObjectCollection("supplier_comattach"));
        this.copyAttach(supplier.getDynamicObjectCollection("supplier_tenattach"), openSupplier.getDynamicObjectCollection("supplier_tenattach"));
        this.copyAttach(supplier.getDynamicObjectCollection("supplier_otherattach"), openSupplier.getDynamicObjectCollection("supplier_otherattach"));
        supplier.set("supplier_tenderprice", openSupplier.get("supplier_tenderprice"));
        BigDecimal taxtRate = openSupplier.getBigDecimal("supplier_taxrate");
        supplier.set("supplier_taxrate", (Object)(taxtRate == null ? BigDecimal.ZERO : taxtRate.multiply(new BigDecimal(100))));
        supplier.set("supplier_pricevat", openSupplier.get("supplier_pricevat"));
        supplier.set("supplier_exceptvat", openSupplier.get("supplier_exceptvat"));
        supplier.set("purdetail", openSupplier.get("purdetail"));
        supplier.set("supplier_illustration", openSupplier.get("supplier_illustration"));
        supplier.set("supplier_comment", openSupplier.get("supplier_comment"));
        supplier.set("supplier_revokebidnumber", openSupplier.get("supplier_revokebidnumber"));
        supplier.set("supplier_isfrombackbid", openSupplier.get("supplier_isfrombackbid"));
        supplier.set("isnew", openSupplier.get("isnew"));
    }

    protected void copyAttach(DynamicObjectCollection newAttachFiles, DynamicObjectCollection oldAttachFiles) {
        oldAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = newAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Map<String, List<DynamicObject>> supplierIdMap = this.createEntryData(dataEntity.getLong("bidopenid"), Boolean.FALSE);
            this.checkIsInvalidAllSupplier(dataEntity, supplierIdMap, args);
        }
        super.beforeDoOperation(args);
    }

    protected void checkIsInvalidAllSupplier(DynamicObject dataEntity, Map<String, List<DynamicObject>> supplierIdMap, BeforeDoOperationEventArgs args) {
        ArrayList curInvalidSupplier = new ArrayList(16);
        DynamicObjectCollection sectionEntry = dataEntity.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < sectionEntry.size(); ++i) {
            DynamicObject section = (DynamicObject)sectionEntry.get(i);
            String sectionName = section.getString("sectionname");
            List<DynamicObject> suppliers = supplierIdMap.get(sectionName);
            if (suppliers == null) continue;
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(s -> {
                DynamicObject supplier = s.getDynamicObject("supplier");
                long supplierId = (Long)supplier.getPkValue();
                suppliers.forEach(u -> {
                    DynamicObject openSupplier = u.getDynamicObject("supplier");
                    long openSupplierId = (Long)openSupplier.getPkValue();
                    if (supplierId == openSupplierId) {
                        curInvalidSupplier.add(u);
                    }
                });
            });
            if (curInvalidSupplier.size() == 0) {
                return;
            }
            for (DynamicObject cur : curInvalidSupplier) {
                suppliers.remove(cur);
            }
            if (suppliers.size() != 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s: \u4e0d\u5141\u8bb8\u6dd8\u6c70\u5168\u90e8\u4f9b\u5e94\u5546\u3002", (String)"BidSupplierInvalEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), sectionName));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (ADDSUPPLIER_BTN.equals(operateKey)) {
            if (this.checkFocusRow()) {
                this.openBdSupplerF7List();
            }
        } else if ("addsupplier_dark".equals(operateKey) && this.checkFocusRow()) {
            this.openDarkSupplierF7List();
        }
    }

    public boolean checkFocusRow() {
        EntryGrid grid = (EntryGrid)this.getControl("bidsection");
        int focusRow = grid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6807\u6bb5\u3002", (String)"BidSupplierInvalEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void openDarkSupplierF7List() {
        EntryGrid grid = (EntryGrid)this.getControl("bidsection");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection sectionEntry = dataEntity.getDynamicObjectCollection("bidsection");
        String sectionName = this.getSectionName(grid, sectionEntry);
        Long openId = dataEntity.getLong("bidopenid");
        Map<String, List<DynamicObject>> supplierIdMap = this.createEntryData(dataEntity.getLong("bidopenid"), Boolean.FALSE);
        List<Object> suppliers = sectionName == null ? new ArrayList() : supplierIdMap.get(sectionName);
        String supplierIds = suppliers == null ? "" : suppliers.stream().map(e -> e.getString("supplier.id")).collect(Collectors.joining(","));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bid_selectsupplier_dark");
        showParameter.setCustomParam("sectionName", (Object)sectionName);
        showParameter.setCustomParam("supplierIds", (Object)supplierIds);
        showParameter.setCustomParam("openId", (Object)openId);
        showParameter.setCustomParam("appId", (Object)this.getAppId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dark"));
        this.getView().showForm(showParameter);
    }

    protected String getSupplierBaseBill() {
        return "bid".equals(this.getAppId()) ? BD_SUPPLIER : "resm_supplier_f7";
    }

    protected void openBdSupplerF7List() {
        EntryGrid grid = (EntryGrid)this.getControl("bidsection");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection sectionEntry = dataEntity.getDynamicObjectCollection("bidsection");
        String sectionName = this.getSectionName(grid, sectionEntry);
        List<Long> exsitSupplier = this.curExsitSupplier(sectionName);
        ListShowParameter supplierList = ShowFormHelper.createShowListForm((String)this.getSupplierBaseBill(), (boolean)true);
        supplierList.setShowUsed(true);
        supplierList.setShowQuickFilter(false);
        supplierList.setShowFilter(false);
        List listFilterParameter = supplierList.getListFilterParameter().getQFilters();
        Map<String, List<DynamicObject>> supplierIdMap = this.createEntryData(dataEntity.getLong("bidopenid"), Boolean.FALSE);
        List<Object> suppliers = sectionName == null ? new ArrayList() : supplierIdMap.get(sectionName);
        ArrayList supplierId = suppliers == null ? new ArrayList() : suppliers.stream().map(e -> (Long)e.getDynamicObject("supplier").getPkValue()).collect(Collectors.toList());
        listFilterParameter.add(new QFilter("id", "in", supplierId));
        listFilterParameter.add(new QFilter("id", "not in", exsitSupplier));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BD_SUPPLIER);
        supplierList.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)supplierList);
    }

    protected String getSectionName(EntryGrid grid, DynamicObjectCollection sectionEntry) {
        String sectionName = null;
        if (sectionEntry.size() == 1) {
            sectionName = ((DynamicObject)sectionEntry.get(0)).getString("sectionname");
        } else {
            int focusRow = grid.getEntryState().getFocusRow();
            sectionName = ((DynamicObject)sectionEntry.get(focusRow)).getString("sectionname");
        }
        return sectionName;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object[] selectedRowIds;
        List selectedRowList;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if (BD_SUPPLIER.equals(actionId)) {
            Object[] selectedRowIds2;
            ListSelectedRowCollection selectedRowColl = (ListSelectedRowCollection)returnData;
            if (selectedRowColl != null && selectedRowColl.size() > 0 && (selectedRowIds2 = selectedRowColl.getPrimaryKeyValues()) != null) {
                this.updateSupplierEntry(selectedRowIds2);
            }
        } else if ("dark".equals(actionId) && (selectedRowList = (List)returnData) != null && selectedRowList.size() > 0 && (selectedRowIds = selectedRowList.stream().map(row -> row.getLong("supplierid")).toArray()) != null) {
            this.updateSupplierEntry(selectedRowIds);
        }
    }

    protected void updateSupplierEntry(Object[] selectedRowIds) {
        DynamicObject[] bdSuppliers = BusinessDataServiceHelper.load((String)this.getSupplierBaseBill(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRowIds)});
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Long openId = dataEntity.getLong("bidopenid");
        DynamicObjectCollection sectionEntry = dataEntity.getDynamicObjectCollection("bidsection");
        EntryGrid grid = (EntryGrid)this.getControl("bidsection");
        int focusRow = grid.getEntryState().getFocusRow();
        DynamicObjectCollection supplierEntry = ((DynamicObject)sectionEntry.get(focusRow)).getDynamicObjectCollection("supplierentry");
        String sectionName = this.getSectionName(grid, sectionEntry);
        HashMap<Object, DynamicObject> supplierMap = new HashMap<Object, DynamicObject>(16);
        Map<String, List<DynamicObject>> supplierIdMap = this.createEntryData(openId, false);
        List<Object> suppliers = sectionName == null ? new ArrayList() : supplierIdMap.get(sectionName);
        for (DynamicObject dynamicObject : suppliers) {
            supplierMap.put(dynamicObject.getDynamicObject("supplier").getPkValue(), dynamicObject);
        }
        for (int i = 0; i < bdSuppliers.length; ++i) {
            Object object = bdSuppliers[i].getPkValue();
            DynamicObject entry = (DynamicObject)supplierMap.get(object);
            if (entry == null) continue;
            DynamicObject supplierEntryRow = supplierEntry.addNew();
            this.setEntryRowData(entry, supplierEntryRow);
        }
        this.getView().updateView("supplierentry");
    }

    protected List<Long> curExsitSupplier(String sectionName) {
        DynamicObjectCollection sectionEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        ArrayList<Long> ids = new ArrayList<Long>();
        sectionEntry.forEach(e -> {
            String sectionname = e.getString("sectionname");
            if (!sectionName.equals(sectionname)) {
                return;
            }
            DynamicObjectCollection supplierEntry = e.getDynamicObjectCollection("supplierentry");
            List id = supplierEntry.stream().map(r -> (Long)r.getDynamicObject("supplier").getPkValue()).collect(Collectors.toList());
            ids.addAll(id);
        });
        return ids;
    }

    public void cellClick(CellClickEvent paramCellClickEvent) {
        String itemName = paramCellClickEvent.getFieldKey();
        if ("purdetail".equals(itemName)) {
            Long id = (Long)this.getModel().getValue("bidopenid");
            DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((Object)id, (String)(this.getAppId() + "_bidopen"));
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidopen.getDynamicObject("bidproject").getPkValue(), (String)(this.getAppId() + "_project"));
            int bidType = bidProject.getInt("bidtype");
            boolean isratebidding = bidProject.getBoolean("isratebidding");
            EntryGrid grid = (EntryGrid)paramCellClickEvent.getSource();
            IDataModel operate = grid.getModel();
            int row = paramCellClickEvent.getRow();
            DynamicObject supplierEntry = operate.getEntryRowEntity(grid.getKey(), row);
            String supplierid = "";
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            supplierid = supplier.getString("id");
            Object isNew = supplierEntry.get("isnew");
            IDataModel operation = this.getModel();
            operation.setEntryCurrentRowIndex("bidsection", this.getModel().getEntryCurrentRowIndex("bidsection"));
            int currentSupplierIndex = operation.getEntryCurrentRowIndex("supplierentry");
            EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsection");
            IDataModel sectionOperate = sectionGrid.getModel();
            String sectionId = "";
            int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsection");
            DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsection", sectionRow);
            String name = sectionEntry.getString("sectionname");
            DynamicObjectCollection openSection = bidopen.getDynamicObjectCollection("bidsection");
            DynamicObject openSectionRow = null;
            for (DynamicObject section : openSection) {
                String openName = section.getString("sectionname");
                if (!openName.equals(name)) continue;
                sectionId = String.valueOf(section.getPkValue());
                openSectionRow = section;
            }
            DynamicObjectCollection purAllDetails = new DynamicObjectCollection();
            if (openSectionRow != null) {
                purAllDetails = openSectionRow.getDynamicObjectCollection("supplierdetail");
            }
            MainEntityType bidOpenType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
            EntityType supplierDetailType = (EntityType)bidOpenType.getAllEntities().get("supplierdetail");
            DynamicObjectCollection purDetails = new DynamicObjectCollection((DynamicObjectType)supplierDetailType, (Object)openSectionRow);
            for (DynamicObject purDetail : purAllDetails) {
                DynamicObject pursupplierOb = purDetail.getDynamicObject("pursupplier");
                if (pursupplierOb == null || !StringUtils.equals((CharSequence)supplierid, (CharSequence)pursupplierOb.getString("id"))) continue;
                purDetails.add((Object)purDetail);
            }
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String appId = this.getAppId();
            boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
            if (enable) {
                para.setStatus(OperationStatus.VIEW);
            } else {
                String billStatus = bidopen.getString("billStatus");
                if (!billStatus.equals("A") && !billStatus.equals("D")) {
                    para.setStatus(OperationStatus.VIEW);
                } else {
                    para.setStatus(this.getView().getFormShowParameter().getStatus());
                }
            }
            para.setFormId(this.getAppId() + "_bidopen_purdetail");
            para.setCustomParam("entryCurrentRowIndex", (Object)this.getModel().getEntryCurrentRowIndex("bidsection"));
            para.setCustomParam("billStatus", (Object)bidopen.getString("billstatus"));
            para.setCustomParam("supplierid", (Object)supplierid);
            para.setCustomParam("sectionId", (Object)sectionId);
            para.setCustomParam("purDetails", (Object)purDetails);
            para.setCustomParam("bidType", (Object)bidType);
            para.setCustomParam("isratebidding", (Object)isratebidding);
            para.setCustomParam("currentSupplierIndex", (Object)currentSupplierIndex);
            para.setCustomParam("isNew", isNew);
            para.setCustomParam("bidOpenId", (Object)id);
            para.setCustomParam("sectionName", (Object)name);
            this.getView().showForm(para);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private String getAppId() {
        return this.getModel().getDataEntityType().getAppId();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("supplierentry");
        entryGrid.addCellClickListener((CellClickListener)this);
    }
}

