/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.formplugin.bill.BidInvitationUI;

public class BidWindBidUI
extends BidInvitationUI {
    private static final String WINBIDORG = "winbidorg";
    private static final String NAME = "name";
    private static final String PUBLISHDATE = "publishdate";
    private static final String ROWID = "rowid";

    @Override
    public String getAnnoType() {
        return "decision";
    }

    @Override
    public void addMessage(List<Map<String, String>> messes, String searchText, QFilter qFilter) {
        QFilter qFilter2 = new QFilter("annotype", "=", (Object)this.getAnnoType());
        QFilter qFilter3 = new QFilter("billstatus", "=", (Object)"L");
        DynamicObjectCollection coll = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()), (String)"id,annotitle,publishdate,winorgname,bidproject,section", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3}, (String)"publishdate desc");
        if (coll != null && coll.size() > 0) {
            for (DynamicObject temp : coll) {
                HashMap<String, String> mess = new HashMap<String, String>();
                StringBuilder displayName = new StringBuilder();
                Long bidProjectId = temp.getLong("bidproject");
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project");
                if (bidProject != null) {
                    DynamicObjectCollection sections;
                    displayName.append(bidProject.getString(NAME));
                    boolean enablemultisection = bidProject.getBoolean("enablemultisection");
                    if (enablemultisection && (sections = bidProject.getDynamicObjectCollection("bidsection")) != null && sections.size() != 0) {
                        Long projectSectionId = temp.getLong("section");
                        for (DynamicObject section : sections) {
                            Long sectionId = (Long)section.getPkValue();
                            if (!projectSectionId.equals(sectionId)) continue;
                            displayName.append(section.getString("sectionname"));
                            break;
                        }
                    }
                }
                mess.put(NAME, displayName.toString());
                mess.put(PUBLISHDATE, temp.getString(PUBLISHDATE));
                mess.put(ROWID, temp.getString("id"));
                String winBidOrg = temp.getString("winorgname");
                mess.put(WINBIDORG, winBidOrg);
                messes.add(mess);
            }
        }
    }

    @Override
    public void createEntryRow(String searchText) {
        List<Map<String, String>> messes = this.doSearchList(searchText);
        this.getModel().deleteEntryData("entryentity");
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>();
        for (Map<String, String> mess : messes) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue(ROWID, (Object)mess.get(ROWID), index);
            this.getModel().setValue(NAME, (Object)mess.get(NAME), index);
            this.getModel().setValue(PUBLISHDATE, (Object)mess.get(PUBLISHDATE), index);
            this.getModel().setValue(WINBIDORG, (Object)mess.get(WINBIDORG), index);
            CellStyle namestyle = this.setEntryNameColor(index, NAME, mess.get(NAME), false, null, "#2b87f3");
            if (namestyle == null) continue;
            styles.add(namestyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.setPageIndex(1);
        grid.setCellStyle(styles);
    }

    @Override
    public void changeEntryFieldColor(List<CellStyle> styles, DynamicObjectCollection colls) {
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject row = (DynamicObject)colls.get(i);
            CellStyle namestyle = this.setEntryNameColor(i, NAME, row.getString(NAME), false, null, "#2b87f3");
            if (namestyle == null) continue;
            styles.add(namestyle);
        }
    }

    @Override
    public String getAnnotitle() {
        return ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a\u8be6\u60c5", (String)"BidWindBidUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    }
}

