/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.formplugin.bill.DutyFilter;

public class DutyFilterList
extends AbstractListPlugin {
    private static final String CACHE_FORMID = "cacheFormId";

    public String getBidAdminRoleID() {
        return "/FFXFSRKI73+";
    }

    public boolean isBidAdmin() {
        return CommonUtil.isBidAdmin((String)"bid", (Long)RequestContext.get().getCurrUserId());
    }

    public String getRespBusinessNo(String formId) {
        String bizNo = "null";
        switch (formId) {
            case "bid_project": {
                bizNo = "01";
                break;
            }
            case "bid_supplierinvitation": {
                bizNo = "02";
                break;
            }
            case "bid_biddocument_edit": 
            case "bid_biddocument_history": {
                bizNo = "09";
                break;
            }
            case "bid_bidpublish": 
            case "bid_bidpublish_history": {
                bizNo = "05";
                break;
            }
            case "bid_answerquestion": {
                bizNo = "10";
                break;
            }
            case "bid_bidopen": {
                bizNo = "06";
                break;
            }
            case "bid_bidevaluation": {
                bizNo = "07";
                break;
            }
            case "bid_decision": {
                bizNo = "08";
                break;
            }
            case "bid_bustalk": {
                bizNo = "15";
                break;
            }
            case "bid_clarificaiton": {
                bizNo = "18";
                break;
            }
            case "bid_bottom_make": {
                bizNo = "19";
                break;
            }
        }
        return bizNo;
    }

    public void setFilter(SetFilterEvent e) {
        String formId;
        Optional<QFilter> of;
        super.setFilter(e);
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        QFilter filter4Org = null;
        List qFilters = e.getQFilters();
        boolean isOrg = false;
        if (qFilters != null && (of = qFilters.stream().filter(filter -> "org.name".equals(filter.getProperty())).findFirst()).isPresent()) {
            isOrg = true;
            QFilter f = of.get();
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", f.getCP(), f.getValue())});
            Set orgIds = orgs.stream().map(org -> org.get("id")).collect(Collectors.toSet());
            QFilter q1 = new QFilter("bidproject.org", "in", orgIds);
            QFilter q2 = new QFilter("bidproject.entrustmentorgunit", "in", orgIds);
            filter4Org = q1.or(q2);
        }
        long orgId = -1L;
        List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
        if (orgIds != null && orgIds.size() != 0 && !isOrg) {
            orgId = (Long)orgIds.get(0);
            filter4Org = new QFilter("bidproject.org", "in", (Object)orgIds).or(new QFilter("bidproject.entrustmentorgunit", "in", (Object)orgIds));
        }
        if (filter4Org != null) {
            qFilters.add(filter4Org);
        }
        if ("bid_openquerycla".equals(formId = ((BillList)e.getSource()).getBillFormId()) || "rebm_openquerycla".equals(formId)) {
            formId = formId.startsWith("bid") ? "bid_bidevaluation" : "rebm_bidevaluation";
        }
        this.getPageCache().put(CACHE_FORMID, formId);
        if (!this.isBidAdmin()) {
            QFilter qFilter;
            BidProjectServiceImpl projectService = new BidProjectServiceImpl();
            if (FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()).equals(formId)) {
                qFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
                QFilter f = new QFilter("respbusiness", "like", (Object)("%" + this.getRespBusinessNo(formId) + "%")).or(new QFilter("isdirector", "=", (Object)"1")).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalOpen.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessOpen.getVal() + "%")));
                qFilter.and(f);
                DynamicObject[] members = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter});
                DynamicObject[] leaders = BusinessDataServiceHelper.load((String)"bid_leadermemberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter});
                QFilter qFilter_open_member = this.openMemberAndLeaderQfilter(members, "member");
                QFilter qFilter_open_leader = this.openMemberAndLeaderQfilter(leaders, "leader");
                qFilters.add(qFilter_open_member.or(qFilter_open_leader));
            } else if (FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()).equals(formId)) {
                qFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
                DynamicObject[] members = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])qFilter.toArray());
                String respBusinessNo = this.getRespBusinessNo(formId);
                members = (DynamicObject[])Arrays.stream(members).filter(item -> {
                    if (item.getBoolean("isdirector")) {
                        return true;
                    }
                    String respbusiness = item.getString("respbusiness");
                    return respbusiness.contains(respBusinessNo) || respbusiness.contains(RespBusiness.TechnicalEval.getVal()) || respbusiness.contains(RespBusiness.BusinessEval.getVal());
                }).toArray(DynamicObject[]::new);
                DynamicObject[] leaders = BusinessDataServiceHelper.load((String)"bid_leadermemberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])qFilter.toArray());
                leaders = (DynamicObject[])Arrays.stream(leaders).filter(item -> {
                    String respbusiness = item.getString("respbusiness");
                    return respbusiness.contains(respBusinessNo) || respbusiness.contains(RespBusiness.TechnicalEval.getVal()) || respbusiness.contains(RespBusiness.BusinessEval.getVal());
                }).toArray(DynamicObject[]::new);
                List<Object> idList = new ArrayList<Object>();
                this.evaluationQFilterMember(members, idList);
                this.evaluationQFilterLeader(leaders, idList);
                idList = idList.stream().distinct().collect(Collectors.toList());
                qFilters.add(new QFilter("id", "in", idList));
            } else {
                Set bidProIds = projectService.generatorPermissionFilter((Object)userId, this.getRespBusinessNo(formId));
                List collect = bidProIds.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
                qFilters.add(new QFilter("bidproject.id", "in", collect));
            }
        }
        BaseDataServiceHelper helper = new BaseDataServiceHelper();
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)formId, (Long)orgId);
        if (qfilter != null) {
            qFilters.add(qfilter);
        }
        e.setMainOrgQFilter(null);
        super.setFilter(e);
    }

    public QFilter openMemberAndLeaderQfilter(DynamicObject[] members, String fromEntry) {
        HashMap<String, DutyFilter> mainAllQfilterMap = new HashMap<String, DutyFilter>(16);
        for (DynamicObject member : members) {
            Set<Object> bidProjectIdSet;
            DutyFilter dutyFilter;
            boolean isdirector;
            long bidprojectId = Long.parseLong(member.getString("bidproject"));
            if ("member".equals(fromEntry) && (isdirector = member.getBoolean("isdirector"))) {
                dutyFilter = mainAllQfilterMap.computeIfAbsent("director", k -> new DutyFilter());
                bidProjectIdSet = dutyFilter.getBidProjectIdSet();
                bidProjectIdSet.add(bidprojectId);
                continue;
            }
            String respbusiness = member.getString("respbusiness");
            if (respbusiness.contains("06")) {
                dutyFilter = mainAllQfilterMap.computeIfAbsent("union", k -> new DutyFilter());
                dutyFilter.setDocType(BidOpenTypeEnum.BUSSINESS.getValue());
                dutyFilter.getOpenTypeSet().add(BidOpenTypeEnum.MULTI.getValue());
                bidProjectIdSet = dutyFilter.getBidProjectIdSet();
                bidProjectIdSet.add(bidprojectId);
                continue;
            }
            if (respbusiness.contains(RespBusiness.TechnicalOpen.getVal())) {
                dutyFilter = mainAllQfilterMap.computeIfAbsent("technicalOpen", k -> new DutyFilter());
                dutyFilter.getOpenTypeSet().add(BidOpenTypeEnum.TECHNICAL.getValue());
                bidProjectIdSet = dutyFilter.getBidProjectIdSet();
                bidProjectIdSet.add(bidprojectId);
                continue;
            }
            if (respbusiness.contains(RespBusiness.BusinessOpen.getVal())) {
                dutyFilter = mainAllQfilterMap.computeIfAbsent("businessOpen", k -> new DutyFilter());
                dutyFilter.getOpenTypeSet().add(BidOpenTypeEnum.BUSSINESS.getValue());
                bidProjectIdSet = dutyFilter.getBidProjectIdSet();
                bidProjectIdSet.add(bidprojectId);
                continue;
            }
            if (!respbusiness.contains(RespBusiness.TechnicalOpen.getVal()) || !respbusiness.contains(RespBusiness.BusinessOpen.getVal())) continue;
            dutyFilter = mainAllQfilterMap.computeIfAbsent("both", k -> new DutyFilter());
            dutyFilter.getOpenTypeSet().add(BidOpenTypeEnum.BUSSINESS.getValue());
            dutyFilter.getOpenTypeSet().add(BidOpenTypeEnum.TECHNICAL.getValue());
            bidProjectIdSet = dutyFilter.getBidProjectIdSet();
            bidProjectIdSet.add(bidprojectId);
        }
        return this.jointAllFilter(mainAllQfilterMap);
    }

    public QFilter jointAllFilter(Map<String, DutyFilter> mainAllQfilterMap) {
        if (mainAllQfilterMap.size() == 0) {
            return new QFilter("bidproject.id", "in", new ArrayList());
        }
        ArrayList qFilterList = new ArrayList(16);
        mainAllQfilterMap.forEach((key, value) -> {
            Set<Object> bidProjectIdSet = value.getBidProjectIdSet();
            QFilter bidProjectFilter = new QFilter(value.getBidProjectIdFilterName(), "in", bidProjectIdSet);
            Set<String> openTypeSet = value.getOpenTypeSet();
            QFilter opentypeFilter = null;
            if (!openTypeSet.isEmpty()) {
                opentypeFilter = new QFilter(value.getOpenTypeFilterName(), "in", openTypeSet);
            }
            String docType = value.getDocType();
            QFilter docTypeFilter = null;
            if (docType != null) {
                docTypeFilter = new QFilter(value.getDocTypeFilterName(), "=", (Object)value.getDocType());
            }
            QFilter result = bidProjectFilter;
            if (opentypeFilter != null && docTypeFilter != null) {
                result = bidProjectFilter.and(opentypeFilter.or(docTypeFilter));
            }
            qFilterList.add(result);
        });
        QFilter finalFilter = null;
        for (QFilter qFilter : qFilterList) {
            if (finalFilter == null) {
                finalFilter = qFilter;
                continue;
            }
            finalFilter.or(qFilter);
        }
        return finalFilter;
    }

    public QFilter evaluationQFilterMember(DynamicObject[] members, List<Object> idList) {
        List<String> busList = Arrays.asList(RespBusiness.TechnicalEval.getVal(), RespBusiness.BusinessEval.getVal(), RespBusiness.BidEvaluation.getVal());
        List memberList = Arrays.stream(members).filter(member -> {
            boolean isdirector = member.getBoolean("isdirector");
            boolean respbusiness = Arrays.stream(member.getString("respbusiness").split(",")).filter(item -> StringUtils.isNotEmpty((String)item)).anyMatch(item -> busList.contains(item));
            return isdirector || respbusiness;
        }).collect(Collectors.toList());
        Lists.partition(memberList, (int)300).forEach(list -> this.queryEvaluationId((List<DynamicObject>)list, idList));
        if (idList.isEmpty()) {
            idList.add(0L);
        }
        return new QFilter("id", "in", idList);
    }

    public void queryEvaluationId(List<DynamicObject> list, List<Object> evaluationIdList) {
        QFilter qFilter_eval = null;
        QFilter qFilterTemp = null;
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject member = list.get(i);
            String respbusiness = member.getString("respbusiness");
            qFilterTemp = new QFilter("bidproject.id", "=", (Object)Long.parseLong(member.getString("bidproject")));
            if (!member.getBoolean("isdirector")) {
                if (respbusiness.contains(RespBusiness.TechnicalEval.getVal()) && respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                    qFilterTemp.and(new QFilter("evaltype", "in", Arrays.asList(BidOpenTypeEnum.TECHNICAL.getValue(), BidOpenTypeEnum.BUSSINESS.getValue())));
                } else if (respbusiness.contains(RespBusiness.TechnicalEval.getVal())) {
                    qFilterTemp.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                } else if (respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                    qFilterTemp.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                } else if (respbusiness.contains(RespBusiness.BidEvaluation.getVal())) {
                    qFilterTemp.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()).or(new QFilter("bidproject.doctype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())));
                }
            }
            if (qFilter_eval == null) {
                qFilter_eval = qFilterTemp;
                continue;
            }
            qFilter_eval.or(qFilterTemp);
        }
        if (qFilter_eval != null) {
            DynamicObject[] bidEvaluationArr = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)"id", (QFilter[])qFilter_eval.toArray());
            Arrays.stream(bidEvaluationArr).forEach(row -> evaluationIdList.add(row.getPkValue()));
        }
    }

    public QFilter evaluationQFilterLeader(DynamicObject[] leaders, List<Object> idList) {
        List<String> busList = Arrays.asList(RespBusiness.TechnicalEval.getVal(), RespBusiness.BusinessEval.getVal(), RespBusiness.BidEvaluation.getVal());
        List memberList = Arrays.stream(leaders).filter(member -> {
            boolean respbusiness = Arrays.stream(member.getString("respbusiness").split(",")).filter(item -> StringUtils.isNotEmpty((String)item)).anyMatch(item -> busList.contains(item));
            return respbusiness;
        }).collect(Collectors.toList());
        Lists.partition(memberList, (int)300).forEach(list -> this.queryEvaluationLeaderId((List<DynamicObject>)list, idList));
        if (idList.isEmpty()) {
            idList.add(0L);
        }
        return new QFilter("id", "in", idList);
    }

    public void queryEvaluationLeaderId(List<DynamicObject> list, List<Object> idList) {
        QFilter qFilter_eval = null;
        QFilter qFilterTemp = null;
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject member = list.get(i);
            String respbusiness = member.getString("respbusiness");
            qFilterTemp = new QFilter("bidproject.id", "=", (Object)Long.parseLong(member.getString("bidproject")));
            if (respbusiness.contains(RespBusiness.TechnicalEval.getVal()) && respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                qFilterTemp.and(new QFilter("evaltype", "in", Arrays.asList(BidOpenTypeEnum.TECHNICAL.getValue(), BidOpenTypeEnum.BUSSINESS.getValue())));
            } else if (respbusiness.contains(RespBusiness.TechnicalEval.getVal())) {
                qFilterTemp.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
            } else if (respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                qFilterTemp.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
            } else if (respbusiness.contains(RespBusiness.BidEvaluation.getVal())) {
                qFilterTemp.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()).or(new QFilter("bidproject.doctype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())));
            }
            if (qFilter_eval == null) {
                qFilter_eval = qFilterTemp;
                continue;
            }
            qFilter_eval.or(qFilterTemp);
        }
        if (qFilter_eval != null) {
            DynamicObject[] bidEvaluationArr = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)"id", (QFilter[])qFilter_eval.toArray());
            Arrays.stream(bidEvaluationArr).forEach(row -> idList.add(row.getPkValue()));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bidproject.name".equals(args.getFieldName()) || "bidproject.billno".equals(args.getFieldName()) || "bidproject.purprojectset".equals(args.getFieldName())) {
            String formId = this.getPageCache().get(CACHE_FORMID);
            if (formId == null) {
                return;
            }
            RequestContext context = RequestContext.get();
            String userId = context.getUserId();
            BidProjectServiceImpl projectService = new BidProjectServiceImpl();
            Set bidProIds = projectService.generatorPermissionFilter((Object)userId, this.getRespBusinessNo(formId));
            String entityName = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
            DynamicObject[] ps = BusinessDataServiceHelper.load((String)entityName, (String)"id,org,entrustmentorgunit", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bidProIds)});
            List orgIds = PermissionServiceHelper.getAllPermissionOrgs((Long)Long.valueOf(userId), (String)formId, (String)"47150e89000000ac");
            args.getQfilters().add(new QFilter("org", "in", (Object)orgIds).or(new QFilter("entrustmentorgunit", "in", (Object)orgIds)));
            args.getQfilters().add(new QFilter("id", "in", (Object)bidProIds));
        }
    }
}

