/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.util.BigDecimalUtil;
import kd.scm.bid.common.util.QuotationScoreSchUtil;

public class OnlineBidEvalAutoScoreUtil {
    IDataModel dataModel;
    String appId;
    IFormView formView;
    private final Log LOG = LogFactory.getLog(this.getClass());

    public OnlineBidEvalAutoScoreUtil(IFormView formView, IDataModel dataModel, String appId) {
        this.formView = formView;
        this.dataModel = dataModel;
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void lockAutoCalScoreRowColumn(List<String> autoScoreItemList, List<String> columnKeys) {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        if (OperationStatus.EDIT.getValue() != formShowParameter.getStatus().getValue()) {
            return;
        }
        boolean iscaneditautoscore = (Boolean)formShowParameter.getCustomParam("iscaneditautoscore");
        if (iscaneditautoscore) {
            return;
        }
        if (autoScoreItemList == null || autoScoreItemList.size() == 0) {
            return;
        }
        DynamicObjectCollection onlinebidevalscoreEntries = this.dataModel.getEntryEntity("onlinebidevalscore");
        if (onlinebidevalscoreEntries != null && onlinebidevalscoreEntries.size() != 0) {
            ArrayList<String> totalRowTypeList = new ArrayList<String>();
            totalRowTypeList.add(ResManager.loadKDString((String)"\u6280\u672f\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalAutoScoreUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            totalRowTypeList.add(ResManager.loadKDString((String)"\u5546\u52a1\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalAutoScoreUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            totalRowTypeList.add(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"OnlineBidEvalAutoScoreUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            for (int i = 0; i < onlinebidevalscoreEntries.size(); ++i) {
                String item;
                DynamicObject onlinebidevalscore = (DynamicObject)onlinebidevalscoreEntries.get(i);
                String type = onlinebidevalscore.getString("type");
                if (totalRowTypeList.contains(type) || (item = onlinebidevalscore.getString("item")) == null || !autoScoreItemList.contains(item)) continue;
                for (String lockKey : columnKeys) {
                    if (lockKey == null || !lockKey.startsWith("suppscore_") || !lockKey.endsWith("new")) continue;
                    try {
                        this.formView.setEnable(Boolean.FALSE, i, new String[]{lockKey});
                    }
                    catch (Exception e) {
                        this.LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public List<String> autoCalScore() {
        FormShowParameter formShowParameter = this.formView.getFormShowParameter();
        if (OperationStatus.EDIT.getValue() != formShowParameter.getStatus().getValue()) {
            return null;
        }
        String sectionName = (String)formShowParameter.getCustomParam("sectionName");
        long currBidOpenId = (Long)formShowParameter.getCustomParam("currBidOpenId");
        boolean iscaneditautoscore = (Boolean)formShowParameter.getCustomParam("iscaneditautoscore");
        boolean isscorecalculatedauto = (Boolean)formShowParameter.getCustomParam("isscorecalculatedauto");
        if (iscaneditautoscore && isscorecalculatedauto) {
            return null;
        }
        String bidOpenEntityName = FormTypeConstants.getFormConstant((String)"bidopen", this.getClass());
        DynamicObject currBidOpen = BusinessDataServiceHelper.loadSingle((Object)currBidOpenId, (String)bidOpenEntityName);
        DynamicObject quotationscoresch = currBidOpen.getDynamicObject("quotationscoresch");
        if (quotationscoresch == null) {
            return null;
        }
        List<String> autoScoreItemList = OnlineBidEvalAutoScoreUtil.getAutoScoreItemList(currBidOpen);
        if (autoScoreItemList.size() == 0) {
            return null;
        }
        Object quotationScoreSchId = currBidOpen.get("quotationscoresch.id");
        Map supplierCalScoreItemMap = QuotationScoreSchUtil.getSupplierCalScoreItem((String)this.getAppId(), (Object)currBidOpenId, (Object)quotationScoreSchId);
        String key = "0_" + sectionName;
        List supplierCalScoreItemList = (List)supplierCalScoreItemMap.get(key);
        DynamicObjectCollection onlinebidevalscoreEntries = this.dataModel.getEntryEntity("onlinebidevalscore");
        if (onlinebidevalscoreEntries != null && onlinebidevalscoreEntries.size() != 0) {
            ArrayList<String> totalRowTypeList = new ArrayList<String>();
            totalRowTypeList.add(ResManager.loadKDString((String)"\u6280\u672f\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalAutoScoreUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            totalRowTypeList.add(ResManager.loadKDString((String)"\u5546\u52a1\u90e8\u5206\u5408\u8ba1", (String)"OnlineBidEvalAutoScoreUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            totalRowTypeList.add(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"OnlineBidEvalAutoScoreUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            EntryType entryEntityType = (EntryType)((DynamicObject)onlinebidevalscoreEntries.get(0)).getDynamicObjectType();
            Map entryFields = entryEntityType.getFields();
            for (DynamicObject onlinebidevalscore : onlinebidevalscoreEntries) {
                String type = onlinebidevalscore.getString("type");
                if (totalRowTypeList.contains(type)) continue;
                String item = onlinebidevalscore.getString("item");
                BigDecimal standardScore = BigDecimal.ZERO;
                String scoremode = currBidOpen.getString("scoremode");
                standardScore = scoremode != null && scoremode.equals("weight") ? new BigDecimal(100) : onlinebidevalscore.getBigDecimal("score");
                if (!autoScoreItemList.contains(item)) continue;
                for (Map supplierData : supplierCalScoreItemList) {
                    String suppliernumber = (String)supplierData.get("suppliernumber");
                    BigDecimal baseScoreRations = (BigDecimal)supplierData.get("baseScoreRations");
                    suppliernumber = suppliernumber.toLowerCase();
                    suppliernumber = suppliernumber.replace('.', '_');
                    String newSuppScoreKey = "suppscore_" + suppliernumber + "new";
                    if (!entryFields.containsKey(newSuppScoreKey)) continue;
                    BigDecimal score = BigDecimalUtil.multiplyBigDecimal((BigDecimal)standardScore, (BigDecimal)baseScoreRations);
                    if (score.compareTo(BigDecimal.ZERO) < 0) {
                        score = BigDecimal.ZERO;
                    }
                    score = score.divide(BigDecimal.ONE, 2, 4);
                    onlinebidevalscore.set(newSuppScoreKey, (Object)score);
                }
            }
        }
        this.formView.getParentView().getModel().setValue("isscorecalculatedauto", (Object)Boolean.TRUE);
        this.formView.sendFormAction(this.formView.getParentView());
        return autoScoreItemList;
    }

    public static List<String> getAutoScoreItemList(DynamicObject currBidOpen) {
        ArrayList<String> itemList = new ArrayList<String>();
        DynamicObjectCollection entryentityCol = currBidOpen.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryentity : entryentityCol) {
            DynamicObjectCollection bidopen_evalitementryCol = entryentity.getDynamicObjectCollection("bidopen_evalitementry");
            for (DynamicObject bidopen_evalitementry : bidopen_evalitementryCol) {
                String item = bidopen_evalitementry.getString("item");
                boolean quotationindex = bidopen_evalitementry.getBoolean("quotationindex");
                if (!quotationindex) continue;
                itemList.add(item);
            }
        }
        return itemList;
    }
}

