/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class SupplierInvitationHistoryList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        String bidProjectPk;
        List filters = e.getCustomQFilters();
        QFilter mainFilters = e.getMainOrgQFilter();
        if (mainFilters != null) {
            e.setMainOrgQFilter(null);
        }
        if (!StringUtils.isEmpty((CharSequence)(bidProjectPk = (String)this.getView().getFormShowParameter().getCustomParam("bidProjectPk")))) {
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal());
            QFilter bidProjectFilter = new QFilter("bidproject", "=", (Object)Long.valueOf(bidProjectPk));
            filters.add(billStatusFilter);
            filters.add(bidProjectFilter);
        } else {
            QFilter filter = new QFilter("1", "!=", (Object)"1");
            filters.add(filter);
        }
        e.setOrderBy("rounds desc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columnList = args.getListColumns();
        BillList view = (BillList)this.getView().getControl("billlistap");
        String appId = ((BillEntityType)view.getEntityType()).getAppId();
        for (IListColumn item : columnList) {
            String fieldName = item.getListFieldKey();
            if ("rounds".equals(fieldName)) {
                item.setVisible(0);
                continue;
            }
            if (!"sourcebillid".equals(fieldName)) continue;
            item.setVisible(0);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    private static String toChinese(String str) {
        String[] s1 = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"SupplierInvitationHistoryList_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"SupplierInvitationHistoryList_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"SupplierInvitationHistoryList_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"SupplierInvitationHistoryList_5", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"SupplierInvitationHistoryList_6", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"SupplierInvitationHistoryList_7", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"SupplierInvitationHistoryList_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"SupplierInvitationHistoryList_9", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"SupplierInvitationHistoryList_10", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"SupplierInvitationHistoryList_11", (String)"scm-bid-formplugin", (Object[])new Object[0])};
        String[] s2 = new String[]{ResManager.loadKDString((String)"\u5341", (String)"SupplierInvitationHistoryList_12", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"SupplierInvitationHistoryList_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"SupplierInvitationHistoryList_14", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"SupplierInvitationHistoryList_15", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"SupplierInvitationHistoryList_12", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"SupplierInvitationHistoryList_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"SupplierInvitationHistoryList_14", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"SupplierInvitationHistoryList_16", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"SupplierInvitationHistoryList_12", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"SupplierInvitationHistoryList_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"SupplierInvitationHistoryList_14", (String)"scm-bid-formplugin", (Object[])new Object[0])};
        StringBuilder result = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                result.append(s1[num]);
                result.append(s2[n - 2 - i]);
                continue;
            }
            result.append(s1[num]);
        }
        return result.toString();
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            HashMap<String, String> sourceNewBillMap = new HashMap<String, String>();
            for (DynamicObject row : rows) {
                String sourceBillId = row.getString("sourcebillid");
                if (StringUtils.isEmpty((CharSequence)sourceBillId) || "0".equals(sourceBillId)) continue;
                String pkValue = row.getString("sourcebillid");
                String bidStep = row.getString("bidstep");
                String sourceBillStatus = row.getString("sourcebillstatus");
                sourceNewBillMap.put(pkValue + "bidStep", bidStep);
                sourceNewBillMap.put(pkValue + "sourceBillStatus", sourceBillStatus);
            }
            for (DynamicObject row : rows) {
                String pkValue = row.getPkValue().toString();
                String bidStep = (String)sourceNewBillMap.get(pkValue + "bidStep");
                String sourceBillStatus = (String)sourceNewBillMap.get(pkValue + "sourceBillStatus");
                if (!StringUtils.isEmpty((CharSequence)bidStep) && !StringUtils.isEmpty((CharSequence)sourceBillStatus)) {
                    row.set("bidstep", (Object)bidStep);
                    row.set("sourcebillstatus", (Object)sourceBillStatus);
                } else {
                    DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id,bidstep,sourcebillstatus", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", row.getPkValue())});
                    if (supplierInvitation != null) {
                        row.set("bidstep", (Object)supplierInvitation.getString("bidstep"));
                        row.set("sourcebillstatus", (Object)supplierInvitation.getString("sourcebillstatus"));
                    }
                }
                row.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21\u5165\u56f4", (String)"SupplierInvitationHistoryList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), SupplierInvitationHistoryList.toChinese(row.getInt("rounds") + "")));
            }
            return rows;
        }
    }
}

