/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.announcement;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidProjectDateEnum;
import kd.scm.bid.formplugin.bill.BidProjectAnnouncementEditUI;

public class NewBidProjectAnnouncementEditUI
extends BidProjectAnnouncementEditUI {
    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.visiableAnn();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Date signendtime;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject model = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"saveproject") && (signendtime = model.getDate("signendtime")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"NewBidProjectAnnouncementEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject model = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"saveproject") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            String bidProjectId = model.getString("bidproject");
            Date signendtime = model.getDate("signendtime");
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidProjectId), (String)(this.getAppId() + "_project"));
            bidProject.set("enrolldeadline", (Object)signendtime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submitaudit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            String bidProjectId = model.getString("bidproject");
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidProjectId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass())));
            Date signendTime = model.getDate("signendtime");
            if (signendTime != null) {
                bidProject.set("enrolldeadline", (Object)signendTime);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
            }
        }
        this.visiableAnn();
    }

    public void visiableAnn() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String billstatus = this.getView().getModel().getDataEntity(true).getString("billstatus");
        String publishstatus = dataEntity.getString("publishstatus");
        if (StringUtils.equals((CharSequence)"C", (CharSequence)billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "revokeanno"});
            if (StringUtils.equals((CharSequence)"L", (CharSequence)publishstatus)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"revokeanno"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"revokeanno"});
            }
        }
        if (StringUtils.equals((CharSequence)"A", (CharSequence)billstatus)) {
            Boolean isModifiable;
            this.getView().setEnable(Boolean.TRUE, new String[]{"richtexteditorap", "annotitle", "bidanntemplate", "attachmentpanel"});
            CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)(this.getAppId() + "_project_announcement"), (DynamicObject)dataEntity, null);
            if (codeRule != null && !(isModifiable = codeRule.getIsModifiable()).booleanValue()) {
                this.getView().setEnable(isModifiable, new String[]{"billno"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"richtexteditorap", "billno", "annotitle", "bidanntemplate", "attachmentpanel"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Date signendTime;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        IDataEntityProperty pro = e.getProperty();
        String filedName = pro.getName();
        DynamicObject model = this.getModel().getDataEntity(true);
        if (newVal == null || newVal != null && newVal.equals(oldVal)) {
            return;
        }
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"signendtime")) {
            Date publishDate = model.getDate("publishdate");
            if (publishDate != null && publishDate.after((Date)newVal)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u7b49\u4e8e\u53d1\u5e03\u65f6\u95f4\u3002", (String)"NewBidProjectAnnouncementEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("signendtime", null);
                return;
            }
            String bidProjectId = model.getString("bidproject");
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidProjectId), (String)(this.getAppId() + "_project"));
            if (this.compareDate("enrolldeadline", (Date)newVal, bidProject)) {
                this.getModel().setValue("signendtime", null);
                return;
            }
            DynamicObject template = model.getDynamicObject("bidanntemplate");
            String content = model.getString("content");
            if (StringUtils.isEmpty((CharSequence)content) && template != null) {
                content = template.getString("content");
            }
            String newDate = "";
            String oldDate = "";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (oldVal != null) {
                oldDate = simpleDateFormat.format((Date)oldVal);
            }
            if (newVal != null) {
                newDate = simpleDateFormat.format((Date)newVal);
            }
            if (StringUtils.isNotEmpty((CharSequence)oldDate)) {
                content = content.replace(oldDate, newDate);
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(content);
            this.setProjectAnnocument(bidProject.getPkValue(), null, buffer.toString(), (Date)newVal);
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)"publishdate") && (signendTime = model.getDate("signendtime")) != null && signendTime.before((Date)newVal)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u7b49\u4e8e\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u3002", (String)"NewBidProjectAnnouncementEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("publishdate", null);
            return;
        }
    }

    public boolean compareDate(String dateType, Date date, DynamicObject bidProject) {
        BidProjectDateEnum curDate = BidProjectDateEnum.valueOf((String)dateType);
        int index = curDate.getIndex();
        List dates4Early = Arrays.stream(BidProjectDateEnum.values()).filter(dateEnum -> dateEnum.getIndex() > index).collect(Collectors.toList());
        Collections.sort(dates4Early, (d1, d2) -> d1.getIndex() - d2.getIndex());
        for (BidProjectDateEnum date4Project : dates4Early) {
            Date compareDate = bidProject.getDate(date4Project.name());
            if ("technicaldocenddate".equals(date4Project.name()) || "commercialdocenddate".equals(date4Project.name()) || compareDate == null || !compareDate.before(date)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u987b\u65e9\u4e8e\u7b49\u4e8e%s\u3002", (String)"NewBidProjectAnnouncementEditUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]), date4Project.getAlias()));
            return true;
        }
        return false;
    }

    @Override
    public String getAppId() {
        return "bid";
    }
}

